/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.swing.DecimalFormatEx;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.INationalPlan;
import com.kingdee.eas.base.param.INationalPlanForLanguage;
import com.kingdee.eas.base.param.IPersonalNantionalPlan;
import com.kingdee.eas.base.param.NationalPlanFactory;
import com.kingdee.eas.base.param.NationalPlanForLanguageFactory;
import com.kingdee.eas.base.param.NationalPlanForLanguageInfo;
import com.kingdee.eas.base.param.NationalPlanInfo;
import com.kingdee.eas.base.param.PersonalNantionalPlanFactory;
import com.kingdee.eas.base.param.PersonalNantionalPlanInfo;
import com.kingdee.eas.base.param.app.AbstractNantionalServiceFacadeControllerBean;
import com.kingdee.eas.base.param.app.NationalPlanServerCache;
import com.kingdee.eas.base.param.util.INationalPlanUtil;
import com.kingdee.eas.base.param.util.NationalPlanUtilFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ITimeZone;
import com.kingdee.eas.basedata.assistant.TimeZoneFactory;
import com.kingdee.eas.basedata.assistant.TimeZoneInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class NantionalServiceFacadeControllerBean
extends AbstractNantionalServiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.param.app.NantionalServiceFacadeControllerBean");
    public final String NUMBERFORMAT = "numberFormat";
    public final String CURRENCYFORMAT = "currencyFormat";
    public final String DATEFORMAT = "dateFormat";
    public final String TIMEFORMAT = "timeFormat";
    public final String DATEFORMATSYMBOLS = "dateFormatSymbols";
    public static NationalPlanServerCache cacheServer = new NationalPlanServerCache();
    public static INationalPlanUtil npUtil = NationalPlanUtilFactory.getInstance();

    @Override
    protected IObjectValue _getAllNationalConfigByUserid(Context ctx, String userid) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _getNationalConfigByName(Context ctx, String planname) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectValue _getNantionalConfigByLanguageName(Context ctx, String languagename) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean _synClearCache(Context ctx) throws BOSException, EASBizException {
        NantionalServiceFacadeControllerBean.clearCache(null);
        return false;
    }

    @Override
    protected boolean _synClearCache(Context ctx, String userID) throws BOSException, EASBizException {
        NantionalServiceFacadeControllerBean.clearCache(userID);
        return false;
    }

    @Override
    protected boolean _clearNationPlanCache(Context ctx) throws BOSException, EASBizException {
        NantionalServiceFacadeControllerBean.clearCache(null);
        npUtil.synClearNationPlanCache();
        return true;
    }

    @Override
    protected boolean _clearNationPlanCache(Context ctx, String userID) throws BOSException, EASBizException {
        NantionalServiceFacadeControllerBean.clearCache(userID);
        npUtil.synCclearNationPlanCache(userID);
        return true;
    }

    private static boolean clearCache(String userID) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)userID)) {
            cacheServer.clearCache();
        } else {
            cacheServer.clearCache(userID);
        }
        return true;
    }

    @Override
    protected HashMap _getNationalConfig(Context ctx, String userid, String planfororg, String languagename) throws BOSException, EASBizException {
        HashMap hp = new HashMap();
        NationalPlanInfo ninfo = null;
        PersonalNantionalPlanInfo info = null;
        INationalPlan inplan = NationalPlanFactory.getLocalInstance(ctx);
        IPersonalNantionalPlan ipnp = PersonalNantionalPlanFactory.getLocalInstance(ctx);
        ITimeZone iTimeZone = TimeZoneFactory.getLocalInstance((Context)ctx);
        if (null != userid && !"".equals(userid)) {
            if (cacheServer.contains(userid)) {
                return (HashMap)cacheServer.get(userid);
            }
            if (ipnp.checkPersonalNationalPlanInfo(userid) && (info = (PersonalNantionalPlanInfo)ipnp.getPersonalNationalPlanInfo(userid)).getNationalplan().getId() != null) {
                ninfo = inplan.getNationalPlanInfo((IObjectPK)new ObjectUuidPK(info.getNationalplan().getId().toString()));
                Object tz = null;
                if (info.getPersonalTimeZoneID() != null) {
                    ninfo.setTimeZoneID(info.getPersonalTimeZoneID());
                }
                hp = this.setPlanConfig(ctx, ninfo);
                cacheServer.put(userid, hp);
                return hp;
            }
        }
        if (null != planfororg && !planfororg.equals("")) {
            if (cacheServer.contains(planfororg)) {
                return (HashMap)cacheServer.get(planfororg);
            }
            String nationparam = "OrgDefaultNationalSolution";
            String orgid = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.ControlUnit).getId().toString();
            OrgUnitInfo planorg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(planfororg));
            String cuid = planorg.getCU().getId().toString();
            ObjectUuidPK orgpk = new ObjectUuidPK(cuid);
            String perplanid = ParamManager.getParamValue(ctx, (IObjectPK)orgpk, nationparam);
            if (null != perplanid && !perplanid.equals("") && inplan.exists((IObjectPK)new ObjectUuidPK(perplanid))) {
                ninfo = inplan.getNationalPlanInfo((IObjectPK)new ObjectUuidPK(perplanid));
                hp = this.setPlanConfig(ctx, ninfo);
                cacheServer.put(planfororg, hp);
                return hp;
            }
        }
        if (null != languagename && !languagename.equals("")) {
            if (cacheServer.contains(languagename)) {
                return (HashMap)cacheServer.get(languagename);
            }
            INationalPlanForLanguage inflang = null;
            NationalPlanForLanguageInfo langinfo = null;
            inflang = NationalPlanForLanguageFactory.getLocalInstance(ctx);
            if (inflang.isExistLanguagePlan(languagename)) {
                langinfo = inflang.getLanguagePlanBylanguageName(languagename);
                ninfo = inplan.getNationalPlanInfo((IObjectPK)new ObjectUuidPK(langinfo.getPlanid()));
                hp = this.setPlanConfig(ctx, ninfo);
                cacheServer.put(languagename, hp);
                return hp;
            }
        }
        if ((ninfo = inplan.getSysDefaultPlan()) != null) {
            String key = ninfo.getId().toString();
            logger.error((Object)("\u7f3a\u7701\u65b9\u6848" + key));
            if (cacheServer.contains(key)) {
                return (HashMap)cacheServer.get(key);
            }
            hp = this.setPlanConfig(ctx, ninfo);
            cacheServer.put(key, hp);
            return hp;
        }
        return hp;
    }

    private HashMap setPlanConfig(Context ctx, NationalPlanInfo ninfo) throws EASBizException, BOSException {
        HashMap<String, Object> hp = new HashMap<String, Object>();
        Locale locale = ContextUtils.getOriginalLocaleFromEnv();
        DateFormatSymbols dfs = new DateFormatSymbols(locale);
        char dateseprator = ninfo.getDatesperator().trim().charAt(0);
        String formatType = ninfo.getShortdateformat();
        formatType = formatType.replace('-', dateseprator);
        SimpleDateFormat dateformat = new SimpleDateFormat(formatType);
        dateformat.setDateFormatSymbols(dfs);
        SimpleDateFormat timeformat = new SimpleDateFormat();
        timeformat.setDateFormatSymbols(dfs);
        timeformat.applyPattern(ninfo.getTimeformat().trim());
        SimpleDateFormat datetimeformat = new SimpleDateFormat();
        datetimeformat.setDateFormatSymbols(dfs);
        datetimeformat.applyPattern(formatType + " " + ninfo.getTimeformat().trim());
        DecimalFormat currencyformat = new DecimalFormat();
        DecimalFormatSymbols dfsbl2 = new DecimalFormatSymbols();
        dfsbl2.setCurrencySymbol(ninfo.getCurrencysymbol());
        if (StringUtils.isEmpty((String)ninfo.getThousandseparator()) && !" ".equals(ninfo.getThousandseparator())) {
            dfsbl2.setGroupingSeparator('\u0000');
            currencyformat.setGroupingUsed(false);
        } else {
            dfsbl2.setGroupingSeparator(ninfo.getThousandseparator().charAt(0));
        }
        dfsbl2.setMonetaryDecimalSeparator(ninfo.getCurrencypoint().charAt(0));
        currencyformat.setDecimalFormatSymbols(dfsbl2);
        currencyformat.applyPattern("\u00a4###,###,###.00");
        DecimalFormat numberformat = new DecimalFormat();
        DecimalFormatSymbols dfsbl = new DecimalFormatSymbols();
        if (StringUtils.isEmpty((String)ninfo.getNumthousandseparator()) && !" ".equals(ninfo.getNumthousandseparator())) {
            dfsbl.setGroupingSeparator('\u0000');
            numberformat.setGroupingUsed(false);
        } else {
            dfsbl.setGroupingSeparator(ninfo.getNumthousandseparator().charAt(0));
        }
        dfsbl.setDecimalSeparator(ninfo.getNumberpoint().charAt(0));
        numberformat.setDecimalFormatSymbols(dfsbl);
        DecimalFormatEx ex1 = new DecimalFormatEx();
        ex1.setDecimalFormatSymbols(dfsbl);
        DecimalFormatEx ex2 = new DecimalFormatEx();
        ex2.setDecimalFormatSymbols(dfsbl);
        String timezonestr = ninfo.getTimezone();
        timezonestr = timezonestr.substring(0, timezonestr.indexOf("--"));
        ITimeZone iTimeZone = TimeZoneFactory.getLocalInstance((Context)ctx);
        TimeZoneInfo timeZoneInfo = null;
        timeZoneInfo = iTimeZone.getTimeZoneInfo((IObjectPK)new ObjectUuidPK(ninfo.getTimeZoneID().getId()));
        hp.put("numberFormat", numberformat);
        hp.put("currencyFormat", currencyformat);
        hp.put("dateFormat", dateformat);
        hp.put("timeFormat", timeformat);
        hp.put("dateTimeFormat", datetimeformat);
        hp.put("ex1", ex1);
        hp.put("ex2", ex1);
        hp.put("timezone", timezonestr);
        hp.put("timezoneInfo", timeZoneInfo);
        if (timeZoneInfo != null) {
            hp.put("timeZoneInfoMap", (Serializable)((Object)timeZoneInfo.getMap()));
        }
        return hp;
    }

    @Override
    protected IObjectValue _getShowUsingPlan(Context ctx, String userid, String orgid, String languageid) throws BOSException, EASBizException {
        NationalPlanInfo ninfo = null;
        PersonalNantionalPlanInfo info = null;
        INationalPlan inplan = NationalPlanFactory.getLocalInstance(ctx);
        IPersonalNantionalPlan ipnp = PersonalNantionalPlanFactory.getLocalInstance(ctx);
        if (null != userid && !"".equals(userid) && ipnp.checkPersonalNationalPlanInfo(userid) && (info = (PersonalNantionalPlanInfo)ipnp.getPersonalNationalPlanInfo(userid)).getNationalplan().getId() != null) {
            ninfo = inplan.getNationalPlanInfo((IObjectPK)new ObjectUuidPK(info.getNationalplan().getId().toString()));
            return ninfo;
        }
        if (null != orgid && !orgid.equals("")) {
            String nationparam = "OrgDefaultNationalSolution";
            String ogid = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.ControlUnit).getId().toString();
            ObjectUuidPK orgpk = new ObjectUuidPK(ogid);
            String perplanid = ParamManager.getParamValue(ctx, (IObjectPK)orgpk, nationparam);
            if (null != perplanid && perplanid.equals("") && inplan.exists((IObjectPK)new ObjectUuidPK(perplanid))) {
                ninfo = inplan.getNationalPlanInfo((IObjectPK)new ObjectUuidPK(perplanid));
                return ninfo;
            }
        }
        if (null != languageid && !languageid.equals("")) {
            INationalPlanForLanguage inflang = null;
            NationalPlanForLanguageInfo langinfo = null;
            inflang = NationalPlanForLanguageFactory.getLocalInstance(ctx);
            if (inflang.isExistLanguagePlan(languageid)) {
                langinfo = inflang.getLanguagePlanBylanguageName(languageid);
                ninfo = inplan.getNationalPlanInfo((IObjectPK)new ObjectUuidPK(langinfo.getPlanid()));
                return ninfo;
            }
        }
        if ((ninfo = inplan.getSysDefaultPlan()) != null) {
            return ninfo;
        }
        return ninfo;
    }
}

