/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.eas.base.param.ParamMutiLangFieldInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class ParamCacheManager {
    Logger logger = Logger.getLogger((String)ParamCacheManager.class.getName());
    private static ParamCacheManager manager = null;
    private Map dcs = null;
    private static CustomCacheService cache = null;
    private static CustomCacheService ignoreGroupControlCache = null;
    private static CustomCacheService updIgnGroControlParamMarkerCache = new CustomCacheService("param.updIgnGroControlParamMarker");
    private static CustomCacheService isGroupControlCache = new CustomCacheService("param.isGroupControl");
    private static final String PARAM_MARKER = "PARAM_MARKER";

    private ParamCacheManager() {
        cache = new CustomCacheService("param.groupControlParam");
        ignoreGroupControlCache = new CustomCacheService("param.ignoreGroupControlParam");
        this.dcs = new Hashtable(5);
    }

    public static synchronized ParamCacheManager getInstance() {
        if (manager == null) {
            manager = new ParamCacheManager();
        }
        return manager;
    }

    public void removeAll() {
        cache.removeAll();
        ignoreGroupControlCache.removeAll();
    }

    public void removeIgGroupControlCacheAll() {
        ignoreGroupControlCache.removeAll();
    }

    public void remove(String key, boolean isGroupControl) {
        if (isGroupControl) {
            cache.remove(key);
        } else {
            ignoreGroupControlCache.remove(key);
        }
    }

    public String cacheAllGrpCtrlParams(Context ctx, String paramNumber) throws BOSException {
        boolean isEmptyNumber;
        String paramValue = "";
        ParamMutiLangFieldInfo fieldInfo = new ParamMutiLangFieldInfo(ctx.getLocale());
        StringBuffer sql = new StringBuffer("select param.fnumber paramnumber, param." + fieldInfo.getParamDefValue() + " defaultval, param.fuseredit useredit, item." + fieldInfo.getParamItemValue() + " itemvalue");
        sql.append(" from T_BAS_Param param left outer join T_BAS_ParamItem item on param.fid = item.fkeyid ");
        sql.append("where param.FIsGroupControl=1");
        boolean bl = isEmptyNumber = !StringUtils.isEmpty((String)paramNumber);
        if (isEmptyNumber) {
            sql.append(" and param.fnumber='").append(paramNumber).append("'");
        }
        sql.append(" and item.forgunitid is null");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String number = rs.getString(1).trim();
                String defaultVal = rs.getString(2);
                String value = rs.getString(4);
                String newValue = "";
                if (value != null) {
                    newValue = value;
                    if (isEmptyNumber) {
                        paramValue = value;
                    }
                } else if (defaultVal != null) {
                    newValue = defaultVal;
                    if (isEmptyNumber) {
                        paramValue = defaultVal;
                    }
                } else {
                    this.logger.info((Object)("param init data is not right,default is nul ,param number is:" + number));
                }
                if (!StringUtils.isEmpty((String)newValue)) {
                    Object valueObj = cache.get(number);
                    if (valueObj != null && !newValue.equals(valueObj.toString())) {
                        cache.remove(number);
                        this.logger.error((Object)("method:cacheAllGrpCtrlParams,cache.remove(" + number + ")"));
                    }
                    cache.put(number, (Object)newValue);
                }
                this.setIsGroupControl(number, "true");
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        return paramValue;
    }

    public void cacheAllGrpCtrlParams(Context ctx) throws BOSException {
        this.cacheAllGrpCtrlParams(ctx, null);
    }

    public void setParamValue(Context ctx, String paramNumber, String value) {
        if (StringUtils.isEmpty((String)paramNumber)) {
            return;
        }
        String number = paramNumber.trim();
        Object paramValue = cache.get(number);
        if (paramValue != null && !paramValue.toString().equals(value)) {
            cache.remove(number);
            this.logger.error((Object)("method:setParamValue,cache.remove(" + number + ")"));
        }
        this.logger.error((Object)("method:setParamValue,cache.put(" + number + "," + value + ")"));
        cache.put(number, (Object)value);
    }

    public void setParamValue(Context ctx, String paramNumber, IObjectPK orgUnitID, boolean isGroupControl, String value) {
        if (isGroupControl) {
            this.setParamValue(ctx, paramNumber, value);
        } else {
            String key = this.getIgnoreGroupControlKey(paramNumber, orgUnitID);
            if (StringUtils.isEmpty((String)key)) {
                return;
            }
            ignoreGroupControlCache.put(key, (Object)value);
        }
    }

    public String getParamValue(Context ctx, String paramNumber) throws BOSException {
        String value = null;
        Object obj = null;
        if (!StringUtils.isEmpty((String)paramNumber)) {
            String dc = ctx.getAIS().trim();
            if (this.dcs.get(dc) == null) {
                this.dcs.put(dc, dc);
                this.cacheAllGrpCtrlParams(ctx);
            }
            value = (obj = cache.get(paramNumber.trim())) != null ? obj.toString() : this.cacheAllGrpCtrlParams(ctx, paramNumber.trim());
        }
        return value;
    }

    public String getParamValue(Context ctx, String paramNumber, IObjectPK orgUnitID, boolean isGroupControl) throws BOSException {
        String value = null;
        if (StringUtils.isEmpty((String)paramNumber)) {
            return value;
        }
        if (isGroupControl) {
            value = this.getParamValue(ctx, paramNumber);
        } else {
            String key = this.getIgnoreGroupControlKey(paramNumber, orgUnitID);
            if (StringUtils.isEmpty((String)key)) {
                return value;
            }
            Object obj = ignoreGroupControlCache.get(key);
            if (obj != null) {
                value = obj.toString();
            }
        }
        return value;
    }

    public void setIsGroupControl(String paramNumber, String isGroupControl) {
        if (StringUtils.isEmpty((String)paramNumber)) {
            return;
        }
        String number = paramNumber.trim();
        Object obj = isGroupControlCache.get(number);
        if (obj != null && !obj.toString().equals(isGroupControl)) {
            isGroupControlCache.remove(number);
            this.logger.error((Object)("method:setIsGroupControl,isGroupControlCache.remove(" + number + ")"));
        }
        isGroupControlCache.put(number, (Object)isGroupControl);
    }

    public void removeIsGroupControl(String paramNumber) {
        isGroupControlCache.remove(paramNumber);
    }

    public String isIsGroupControl(String paramNumber) {
        String isGroupControl = "";
        if (StringUtils.isEmpty((String)paramNumber)) {
            return null;
        }
        Object obj = isGroupControlCache.get(paramNumber.trim());
        if (obj != null) {
            isGroupControl = obj.toString();
        }
        return isGroupControl;
    }

    private String getIgnoreGroupControlKey(String paramNumber, IObjectPK orgUnitID) {
        if (paramNumber == null || orgUnitID == null) {
            return "";
        }
        return paramNumber.trim() + orgUnitID.toString();
    }
}

