/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.EgoExibitParamCollection;
import com.kingdee.eas.base.param.EgoExibitParamFactory;
import com.kingdee.eas.base.param.IEgoExibitParam;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.IParamCacheManage;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamCacheManageFactory;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamDataType;
import com.kingdee.eas.base.param.ParamException;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.ParamMutiLangFieldInfo;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.param.ParamValueRangeInfo;
import com.kingdee.eas.base.param.app.AbstractParamControlControlBean;
import com.kingdee.eas.base.param.app.ParamConfigInfo;
import com.kingdee.eas.base.param.app.ParamSetModify;
import com.kingdee.eas.base.param.app.config.ParamConfig;
import com.kingdee.eas.base.param.app.service.IParamHanderService;
import com.kingdee.eas.base.param.app.service.IParamQueryService;
import com.kingdee.eas.base.param.app.service.impl.ParamHanderServiceImpl;
import com.kingdee.eas.base.param.app.service.impl.ParamQueryServiceImpl;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamExInfo;
import com.kingdee.eas.base.param.util.ParamUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ParamControlControlBean
extends AbstractParamControlControlBean {
    Logger logger = Logger.getLogger((String)ParamControlControlBean.class.getName());
    private static IParamQueryService paramQueryService = new ParamQueryServiceImpl();
    private static IParamHanderService paramHanderService = new ParamHanderServiceImpl(paramQueryService);

    @Override
    protected void _deleteParamItem(Context ctx, IObjectPK paramItemPK) throws BOSException, EASBizException, ParamException {
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        if (iParamItem.exists(paramItemPK)) {
            iParamItem.delete(paramItemPK);
        }
    }

    @Override
    protected void _deleteParam(Context ctx, IObjectPK paramPK) throws BOSException, EASBizException, ParamException {
        IParam iParam = ParamFactory.getLocalInstance(ctx);
        if (iParam.exists(paramPK)) {
            iParam.delete(paramPK);
        }
    }

    @Override
    protected void _updateParam(Context ctx, IObjectPK pk, IObjectValue paramVO) throws BOSException, EASBizException, ParamException {
        ParamInfo paramInfo = (ParamInfo)paramVO;
        IParam iParam = ParamFactory.getLocalInstance(ctx);
        iParam.update(pk, (CoreBaseInfo)paramInfo);
        ParamCacheManageFactory.getLocalInstance(ctx).remove(paramInfo.getNumber().trim(), true);
    }

    @Override
    protected IObjectPK _addParam(Context ctx, IObjectValue paramVO) throws BOSException, EASBizException, ParamException {
        IParam iParam = ParamFactory.getLocalInstance(ctx);
        return iParam.addnew((CoreBaseInfo)((ParamInfo)paramVO));
    }

    @Override
    protected IObjectPK _addParamItem(Context ctx, IObjectValue paramItem, IObjectValue param) throws BOSException, EASBizException, ParamException {
        ParamInfo paramInfo = (ParamInfo)param;
        ParamItemInfo paramItemVO = (ParamItemInfo)paramItem;
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        return iParamItem.addnew(paramItemVO, paramInfo);
    }

    @Override
    protected IObjectCollection _getParamsBySubSys(Context ctx, String subSysID) throws BOSException {
        IParam iParam = ParamFactory.getLocalInstance(ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("subSysID", (Object)subSysID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("theValueRange"));
        ParamCollection pc = iParam.getParamCollection(evi);
        return pc;
    }

    @Override
    protected IObjectCollection _getParamItemByOrgUnitID(Context ctx, String orgUnitID) throws BOSException {
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("keyID"));
        evi.getSelector().add(new SelectorItemInfo("orgUnitID"));
        return iParamItem.getParamItemCollection(evi);
    }

    @Override
    protected String _getParamValueIgnoreGroupControl(Context ctx, String paramNumber, IObjectPK orgUnitId, boolean setReference) throws EASBizException, BOSException {
        return paramQueryService.getParamValueIgnoreGroupControl(ctx, paramNumber, orgUnitId, setReference);
    }

    @Override
    protected String _getParamValue(Context ctx, IObjectPK orgUnitPK, String paramNumber) throws EASBizException, BOSException {
        return this._getParamValueIgnoreGroupControl(ctx, paramNumber, orgUnitPK, false);
    }

    @Override
    protected String _getParamValue(Context ctx, IObjectPK orgUnitID, String paramNumber, boolean setRefence) throws BOSException, EASBizException {
        return this._getParamValueIgnoreGroupControl(ctx, paramNumber, orgUnitID, setRefence);
    }

    @Override
    protected void _updateParamItem(Context ctx, IObjectPK pk, IObjectValue model, IObjectValue paramVO) throws ParamException, EASBizException, BOSException {
        ParamItemInfo paramItemInfo = (ParamItemInfo)model;
        ParamInfo paramInfo = (ParamInfo)paramVO;
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        iParamItem.update(pk, paramItemInfo, paramInfo);
        FullOrgUnitInfo orgUnitInfo = paramItemInfo.getOrgUnitID();
        ObjectUuidPK orgUnitID = null;
        if (orgUnitInfo != null) {
            orgUnitID = new ObjectUuidPK(orgUnitInfo.getId());
        }
        ParamCacheManageFactory.getLocalInstance(ctx).setParamValue(ctx, paramInfo.getNumber(), (IObjectPK)orgUnitID, paramInfo.isIsGroupControl(), paramItemInfo.getValue());
    }

    @Override
    protected IObjectCollection _getParamsByOrgType(Context ctx, int orgType) throws BOSException {
        IParam iParam = ParamFactory.getLocalInstance(ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("orgType", (Object)new Integer(orgType), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("theValueRange"));
        ParamCollection paramCo = iParam.getParamCollection(evi);
        return paramCo;
    }

    @Override
    protected IObjectValue _getParamByNumber(Context ctx, String paramNumber) throws BOSException, EASBizException {
        if (paramNumber == null || paramNumber.equals("")) {
            return null;
        }
        IParam iParam = ParamFactory.getLocalInstance(ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("number", (Object)paramNumber, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.setSelector(ParamUtil.getParamSelect());
        ParamCollection paramCo = iParam.getParamCollection(evi);
        if (paramCo.size() == 1) {
            return paramCo.get(0);
        }
        if (paramCo.size() == 0) {
            return null;
        }
        this.logger.info((Object)("have muti param use same paramNumber! paramNumber is:" + paramNumber));
        throw new ParamException(ParamException.PARAM_DUPLICATE);
    }

    @Override
    protected String _getEgoExibitUI(Context ctx, String subSysID) throws BOSException {
        IEgoExibitParam iEgoExibitParam = EgoExibitParamFactory.getLocalInstance(ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("subSysID", (Object)subSysID, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("*"));
        EgoExibitParamCollection egoParamCo = iEgoExibitParam.getEgoExibitParamCollection(evi);
        if (egoParamCo.size() > 0) {
            return egoParamCo.get(0).getUiClass();
        }
        return null;
    }

    @Override
    protected IObjectValue _getItemByOrgUnitIDKeyID(Context ctx, String orgUnitID, String keyID) throws BOSException {
        ParamItemCollection paramItemCO;
        IParam iParam = ParamFactory.getLocalInstance(ctx);
        ParamInfo pi = null;
        try {
            pi = iParam.getParamInfo((IObjectPK)new ObjectUuidPK(keyID));
        }
        catch (EASBizException e) {
            throw new BOSException();
        }
        if (pi == null) {
            return null;
        }
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("keyID", (Object)keyID, CompareType.EQUALS));
        String s = null;
        if (orgUnitID != null && !orgUnitID.equals("") && !orgUnitID.equalsIgnoreCase("null")) {
            s = orgUnitID;
        }
        if (pi.isIsGroupControl()) {
            s = null;
        }
        if (!OrgCommonUtils.isBasicOrgType((OrgType)pi.getOrgType())) {
            i.getFilterItems().add(new FilterItemInfo("orgTreeID", (Object)s, CompareType.EQUALS));
        } else {
            i.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)s, CompareType.EQUALS));
        }
        i.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("keyID.number"));
        sic.add(new SelectorItemInfo("*"));
        evi.setSelector(sic);
        if (evi != null) {
            this.logger.debug((Object)(".......... debug:" + evi.toString()));
        }
        if ((paramItemCO = iParamItem.getParamItemCollection(evi)) != null) {
            if (paramItemCO.size() == 1) {
                return paramItemCO.get(0);
            }
            if (paramItemCO.size() == 0) {
                return null;
            }
            throw new BOSException("param setting is not right, paramitem have muti value , condition is: select * from t_bas_paramitem " + evi.toString());
        }
        return null;
    }

    @Override
    protected IObjectCollection _getParamsBySubSysAndOrgType(Context ctx, String subsys, int orgtype, OrgUnitInfo orgUnitId, String orgTreeId) throws BOSException, ParamException {
        return paramHanderService.getParamsBySubSysAndOrgType(ctx, subsys, orgtype, orgUnitId, orgTreeId);
    }

    protected synchronized Collection _getParamHashMapDeal(Context ctx, HashMap paramKeyMap) throws BOSException, EASBizException {
        if (paramKeyMap.isEmpty()) {
            return new ArrayList();
        }
        HashSet<String> needRetParamInfoSet = new HashSet<String>();
        HashSet<String> notDealParmNumberSet = new HashSet<String>();
        for (Object paramObj : paramKeyMap.keySet()) {
            Object orgObj = paramKeyMap.get(paramObj);
            String key = paramObj.toString() + StringUtils.cnulls(orgObj);
            needRetParamInfoSet.add(key);
            notDealParmNumberSet.add(paramObj.toString());
        }
        Collection paramInfoCol = this._getParamHashMapDealMutiParamNumber(ctx, paramKeyMap.keySet(), paramKeyMap.values());
        if (paramInfoCol == null || paramInfoCol.isEmpty()) {
            return new ArrayList();
        }
        Iterator paramSimpleIt = paramInfoCol.iterator();
        ArrayList<ParamSimpleInfo> retCol = new ArrayList<ParamSimpleInfo>();
        HashMap<String, ParamSimpleInfo> orgIsNullMap = new HashMap<String, ParamSimpleInfo>();
        while (paramSimpleIt.hasNext()) {
            ParamSimpleInfo paramSimpleInfo = (ParamSimpleInfo)paramSimpleIt.next();
            if (paramSimpleInfo == null) continue;
            String retKey = StringUtils.cnulls((String)paramSimpleInfo.getParamNumber()) + StringUtils.cnulls((Object)paramSimpleInfo.getOrgUnitPK());
            if (needRetParamInfoSet.contains(retKey)) {
                retCol.add(paramSimpleInfo);
                notDealParmNumberSet.remove(paramSimpleInfo.getParamNumber());
            }
            if (!StringUtils.isEmpty((String)StringUtils.cnulls((Object)paramSimpleInfo.getOrgUnitPK()))) continue;
            orgIsNullMap.put(paramSimpleInfo.getParamNumber(), paramSimpleInfo);
        }
        if (notDealParmNumberSet.isEmpty()) {
            return retCol;
        }
        Iterator notDealIt = notDealParmNumberSet.iterator();
        while (notDealIt.hasNext()) {
            String paramNumber = notDealIt.next().toString();
            if (!orgIsNullMap.containsKey(paramNumber)) continue;
            retCol.add((ParamSimpleInfo)orgIsNullMap.get(paramNumber));
        }
        return retCol;
    }

    protected synchronized Collection _getParamHashMapDealMutiParamNumber(Context ctx, Collection paramNumberList, Collection orgList) throws BOSException, EASBizException {
        return paramQueryService.getParamHashMapDealMutiParamNumber(ctx, paramNumberList, orgList);
    }

    @Override
    protected HashMap _getParamHashMap(Context ctx, HashMap paramKeyMap) throws BOSException, EASBizException {
        return paramQueryService.getParamHashMap(ctx, paramKeyMap);
    }

    @Override
    protected void _deleteParam(Context ctx, String paramNumber) throws BOSException, ParamException, EASBizException {
        IObjectValue iv = this._getParamByNumber(ctx, paramNumber);
        if (iv == null) {
            throw new ParamException(ParamException.PARAMNUMBERNOTEXIST);
        }
        ParamInfo pi = (ParamInfo)iv;
        this._deleteParam(ctx, (IObjectPK)new ObjectUuidPK(pi.getId()));
    }

    @Override
    protected void _deleteParamItem(Context ctx, String paramNumber, String orgUnitID) throws BOSException, ParamException, EASBizException {
        IObjectValue iv = this._getParamByNumber(ctx, paramNumber);
        if (iv == null) {
            throw new ParamException(ParamException.PARAMNUMBERNOTEXIST);
        }
        ParamInfo pi = (ParamInfo)iv;
        IObjectValue iov = this._getItemByOrgUnitIDKeyID(ctx, orgUnitID, pi.getId().toString());
        if (iov == null) {
            throw new ParamException(ParamException.PARAMITEMNOTEXIST);
        }
        ParamItemInfo pii = (ParamItemInfo)iov;
        this._deleteParamItem(ctx, (IObjectPK)new ObjectUuidPK(pii.getId()));
    }

    @Override
    protected IObjectPK _addParam(Context ctx, ParamExInfo paramExInfo) throws BOSException, ParamException, EASBizException {
        if (paramExInfo == null) {
            return null;
        }
        ParamInfo pi = new ParamInfo();
        pi.setCanBeModified(true);
        pi.setDefaultValue(paramExInfo.getValue());
        pi.setDesc(paramExInfo.getDescription());
        pi.setName(paramExInfo.getName());
        pi.setNumber(paramExInfo.getNumber());
        pi.setDataType(paramExInfo.getDataType());
        pi.setIsGroupControl(false);
        pi.setIsUserDefine(false);
        pi.setSubSysID(paramExInfo.getSubSysId());
        pi.setUserEdit(paramExInfo.getUserEdit());
        pi.setUserClass(paramExInfo.getUserClass());
        pi.setOrgType(paramExInfo.getOrgType());
        pi.setTheValueRange(new ParamValueRangeInfo());
        IObjectPK ipk = this._addParam(ctx, (IObjectValue)pi);
        return ipk;
    }

    @Override
    protected IObjectPK _addParamItem(Context ctx, String paramNumber, String orgUnitID, String paramItemValue) throws BOSException, ParamException, EASBizException {
        if (paramNumber == null || paramNumber.equals("")) {
            throw new ParamException(ParamException.PARAMNUMBERCANNOTBENULL);
        }
        IObjectValue iv = this._getParamByNumber(ctx, paramNumber);
        if (iv == null) {
            throw new ParamException(ParamException.PARAMNUMBERNOTEXIST);
        }
        ParamInfo pi = (ParamInfo)iv;
        FullOrgUnitInfo oui = null;
        ParamItemInfo pii = new ParamItemInfo();
        if (!OrgCommonUtils.isBasicOrgType((OrgType)pi.getOrgType())) {
            pii.setOrgTreeID(orgUnitID);
        } else if (orgUnitID != null && !orgUnitID.equals("") && !orgUnitID.equalsIgnoreCase("null")) {
            IFullOrgUnit org = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            oui = (FullOrgUnitInfo)org.getValue((IObjectPK)new ObjectUuidPK(orgUnitID));
        }
        pii.setIsControlSub(false);
        pii.setOrgUnitID(oui);
        pii.setValue(paramItemValue);
        ParamSetModify paramSetModify = new ParamSetModify(ctx);
        pii.setIsModify(paramSetModify.isModify(pi));
        IObjectPK pk = this._addParamItem(ctx, (IObjectValue)pii, (IObjectValue)pi);
        return pk;
    }

    @Override
    protected IObjectCollection _getParamItemByOrgUnitID(Context ctx, String orgUnitID, int userFlag) throws BOSException, ParamException, EASBizException {
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitID, CompareType.EQUALS));
        i.getFilterItems().add(new FilterItemInfo("keyID.userEdit", (Object)new Integer(userFlag), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        return iParamItem.getParamItemCollection(evi);
    }

    @Override
    protected HashMap _getParamByView(Context ctx, EntityViewInfo view) throws BOSException, ParamException, EASBizException {
        HashMap<String, ParamInfo> returnMap = new HashMap<String, ParamInfo>();
        if (view == null) {
            return returnMap;
        }
        IParam iparam = ParamFactory.getLocalInstance(ctx);
        ParamCollection pct = iparam.getParamCollection(view);
        for (int i = 0; i < pct.size(); ++i) {
            ParamInfo pi = pct.get(i);
            returnMap.put(pi.getNumber(), pi);
        }
        return returnMap;
    }

    @Override
    protected void _updateParamByNumber(Context ctx, String paramNumber, String defValue) throws BOSException, ParamException, EASBizException {
        if (StringUtils.isEmpty((String)paramNumber)) {
            throw new ParamException(ParamException.PARAMNUMBERCANNOTBENULL);
        }
        IObjectValue iv = this._getParamByNumber(ctx, paramNumber);
        if (iv == null) {
            throw new ParamException(ParamException.PARAMNUMBERNOTEXIST);
        }
        ParamInfo pi = (ParamInfo)iv;
        pi.setDefaultValue(defValue);
        String value = pi.getDefaultValue();
        MutilLangeToolForParam.muti2Obj(value, (IObjectValue)pi, "defaultValue", ctx);
        this._updateParam(ctx, (IObjectPK)new ObjectUuidPK(pi.getId()), (IObjectValue)pi);
    }

    @Override
    protected void _updateParamItemByNumberAndOrg(Context ctx, String paramNumber, String orgUnitID, String value) throws BOSException, ParamException, EASBizException {
        if (StringUtils.isEmpty((String)paramNumber)) {
            throw new ParamException(ParamException.PARAMNUMBERCANNOTBENULL);
        }
        IObjectValue iv = this._getParamByNumber(ctx, paramNumber);
        if (iv == null) {
            throw new ParamException(ParamException.PARAMNUMBERNOTEXIST);
        }
        ParamInfo pi = (ParamInfo)iv;
        IObjectValue iov = this._getItemByOrgUnitIDKeyID(ctx, orgUnitID, pi.getId().toString());
        if (iov == null) {
            throw new ParamException(ParamException.PARAMITEMNOTEXIST);
        }
        ParamItemInfo pii = (ParamItemInfo)iov;
        pii.setValue(value);
        if (!pi.isIsGroupControl()) {
            this.setParamItemOrgTreeID(pii, pii.getKeyID().getOrgType());
        }
        String valueStr = pii.getValue();
        MutilLangeToolForParam.muti2Obj(valueStr, (IObjectValue)pii, "Value", ctx);
        this._updateParamItem(ctx, (IObjectPK)new ObjectUuidPK(pii.getId()), (IObjectValue)pii, (IObjectValue)pi);
    }

    public void setParamItemOrgTreeID(ParamItemInfo paramItem, OrgType type) {
        paramItem.setOrgTreeID(OrgCommonUtils.getOrgTreeId((OrgType)type));
    }

    @Override
    protected HashMap _getParamHashMap(Context ctx, String[] numbers, String orgId) throws BOSException, EASBizException {
        return paramQueryService.getParamHashMap(ctx, numbers, orgId);
    }

    @Override
    protected void _paramReferenced(Context ctx, String paramNumber, String orgUnitId) throws BOSException, EASBizException {
        IObjectValue iv;
        if (paramNumber == null || paramNumber.equals("")) {
            throw new ParamException(ParamException.PARAMNUMBERCANNOTBENULL);
        }
        String org = null;
        if (orgUnitId != null && !orgUnitId.equals("") && !orgUnitId.equalsIgnoreCase("null")) {
            org = orgUnitId;
        }
        if ((iv = this._getParamByNumber(ctx, paramNumber)) == null) {
            throw new ParamException(ParamException.PARAMNUMBERNOTEXIST);
        }
        ParamInfo pi = (ParamInfo)iv;
        if (pi.getUserEdit() != 0) {
            return;
        }
        IParamItem ipi = ParamItemFactory.getLocalInstance(ctx);
        IObjectValue iov = this._getItemByOrgUnitIDKeyID(ctx, orgUnitId, pi.getId().toString());
        if (iov == null) {
            this.logger.error((Object)".......... debug: iov is null");
            ParamItemInfo pInfo = new ParamItemInfo();
            if (!OrgCommonUtils.isBasicOrgType((OrgType)pi.getOrgType())) {
                pInfo.setOrgTreeID(org);
            } else {
                FullOrgUnitInfo oui = null;
                if (org != null && !org.equals("") && !org.equalsIgnoreCase("null")) {
                    IFullOrgUnit orgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                    oui = (FullOrgUnitInfo)orgUnit.getValue((IObjectPK)new ObjectUuidPK(org));
                }
                pInfo.setOrgUnitID(oui);
            }
            pInfo.setIsControlSub(false);
            pInfo.setIsModify(true);
            MutilLangeToolForParam.muti2Obj((IObjectValue)pi, "defaultValue", (IObjectValue)pInfo, "Value", ctx);
            MutilLangeToolForParam.muti2Obj((IObjectValue)pi, "valueAlias", (IObjectValue)pInfo, "valueAlias", ctx);
            pInfo.setKeyID(pi);
            ipi.addnew((CoreBaseInfo)pInfo);
            return;
        }
        ParamItemInfo pii = (ParamItemInfo)iov;
        pii.setIsModify(true);
        ipi.updateNoVerify(pii);
    }

    @Override
    protected HashMap _getParamHashMap(Context ctx, String orgId, String subSysId) throws BOSException, EASBizException {
        ParamMutiLangFieldInfo fieldInfo = new ParamMutiLangFieldInfo(ctx.getLocale());
        String sql = " select param.fid paramid,param.fnumber fnumber,param.fdatatype fdatatype,param." + fieldInfo.getParamDefValue() + " defaultvalue,item.fid itemid,item." + fieldInfo.getParamItemValue() + " fvalue,item.forgunitid orgunitid,item.fiscontrolsub iscontrolsub,item.fismodify ismodify from t_bas_param param left join t_bas_paramitem item on param.fid=item.fkeyid and item.forgunitid=?where param.fsubsysid=? ";
        Connection con = null;
        HashMap<String, ParamItemInfo> prop = new HashMap<String, ParamItemInfo>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            ps = con.prepareStatement(sql);
            ps.setString(1, orgId);
            ps.setString(2, subSysId);
            rs = ps.executeQuery();
            while (rs.next()) {
                ParamItemInfo info = new ParamItemInfo();
                String id = rs.getString("itemid");
                String value = null;
                if (id != null) {
                    info.setId(BOSUuid.read((String)id));
                    value = rs.getString("fvalue");
                } else {
                    value = rs.getString("defaultvalue");
                }
                info.setValue(value);
                ParamInfo paraminfo = new ParamInfo();
                paraminfo.setId(BOSUuid.read((String)rs.getString("paramid")));
                int datatype = rs.getInt("fdatatype");
                paraminfo.setDataType(ParamDataType.getEnum(datatype));
                String number = rs.getString("fnumber");
                paraminfo.setNumber(number);
                info.setKeyID(paraminfo);
                prop.put(number, info);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLAccessException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return prop;
    }

    @Override
    protected void _initParam(Context ctx) throws BOSException, EASBizException {
        IParamCacheManage cacheManager = ParamCacheManageFactory.getLocalInstance(ctx);
        cacheManager.cacheAllGrpCtrlParams(ctx);
    }

    @Override
    protected IObjectValue _getParamItemByNumberAndOrg(Context ctx, String number, String orgId) throws BOSException, EASBizException {
        IObjectValue iv;
        if (number == null || number.equals("")) {
            throw new ParamException(ParamException.PARAMNUMBERCANNOTBENULL);
        }
        String org = null;
        if (orgId != null && !orgId.equals("") && !orgId.equalsIgnoreCase("null")) {
            org = orgId;
        }
        if ((iv = this._getParamByNumber(ctx, number)) == null) {
            throw new ParamException(ParamException.PARAMNUMBERNOTEXIST);
        }
        ParamInfo pi = (ParamInfo)iv;
        if (pi.getUserEdit() != 0) {
            return null;
        }
        return this._getItemByOrgUnitIDKeyID(ctx, orgId, pi.getId().toString());
    }

    @Override
    protected String _getSpecialParamValue(Context ctx, String paramNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)paramNumber)) {
            return null;
        }
        Map specialMap = ParamConfig.getInstance().getConfig("specialParam");
        if (specialMap == null || specialMap.isEmpty()) {
            return null;
        }
        String fileValue = ParamConfigInfo.readParamValueFromFile(paramNumber);
        if (fileValue == null) {
            this.logger.info((Object)"  not find value from file:paramvalue.properties, return default value!");
            return (String)specialMap.get(paramNumber);
        }
        return fileValue;
    }

    @Override
    protected IObjectCollection _getParamModifiedOrgUnitList(Context ctx, IObjectValue paramItem) throws BOSException, EASBizException {
        if (paramItem == null) {
            return null;
        }
        ParamItemInfo paramItemInfo = (ParamItemInfo)paramItem;
        ParamInfo paramInfo = paramItemInfo.getKeyID();
        if (paramInfo == null || paramInfo.getId() == null) {
            return null;
        }
        FullOrgUnitCollection orgUnitCollection = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("keyID", (Object)paramInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("IsModify", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)paramInfo.getDefaultValue(), CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("orgUnitID.id"));
        ParamItemCollection paramItemCol = ParamItemFactory.getLocalInstance(ctx).getParamItemCollection(viewInfo);
        if (paramItemCol != null && paramItemCol.size() > 0) {
            Iterator iterator = paramItemCol.iterator();
            ParamItemInfo tempParamItemInfo = null;
            StringBuffer orgUnitIdSet = new StringBuffer();
            while (iterator.hasNext()) {
                tempParamItemInfo = (ParamItemInfo)iterator.next();
                if (tempParamItemInfo.getOrgUnitID() == null) continue;
                orgUnitIdSet.append(tempParamItemInfo.getOrgUnitID().getId()).append(",");
            }
            orgUnitIdSet.deleteCharAt(orgUnitIdSet.lastIndexOf(","));
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgUnitIdSet.toString(), CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            orgUnitCollection = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(viewInfo);
        }
        return orgUnitCollection;
    }

    @Override
    protected IObjectCollection _copyParam(Context ctx, IObjectValue originalOrgUnit, IObjectCollection destinationOrgUnit) throws BOSException, EASBizException {
        return paramHanderService.copyParam(ctx, originalOrgUnit, destinationOrgUnit);
    }

    @Override
    protected IObjectCollection _deleteOrgUnitParam(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        return paramHanderService.deleteOrgUnitParam(ctx, orgUnitId);
    }

    protected ArrayList _getParamHashMapBatch(Context ctx, HashMap paramKeyMap) throws BOSException, EASBizException {
        return paramQueryService.getParamHashMapBatch(ctx, paramKeyMap);
    }

    @Override
    protected ArrayList _getParamHashMapBatch(Context ctx, ArrayList paramNumberList, ArrayList orgIdStrList) throws BOSException, EASBizException {
        return paramQueryService.getParamSimpleInfoBatch(ctx, paramNumberList, orgIdStrList);
    }

    @Override
    protected ArrayList _getParamListPatch(Context ctx, ArrayList paramNumberList, ArrayList orgIdStrList) throws BOSException, EASBizException {
        return paramQueryService.getParamSimpleInfoBatch(ctx, paramNumberList, orgIdStrList);
    }
}

