/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.DumpliParamCollection;
import com.kingdee.eas.base.param.DumpliParamInfo;
import com.kingdee.eas.base.param.IParamCacheManage;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamCacheManageFactory;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamDataType;
import com.kingdee.eas.base.param.ParamException;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.app.AbstractParamControllerBean;
import com.kingdee.eas.base.param.app.ParamSetModify;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ParamControllerBean
extends AbstractParamControllerBean {
    Logger logger = Logger.getLogger(ParamControllerBean.class);

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ParamInfo model1 = (ParamInfo)model;
        if (this.addCheckValue(ctx, model1)) {
            IObjectPK pk = super._addnew(ctx, (IObjectValue)model1);
            if (pk != null && model1.isIsGroupControl()) {
                this.initParamItem(ctx, model1);
            }
            return pk;
        }
        return null;
    }

    private void initParamItem(Context ctx, ParamInfo model) throws EASBizException, BOSException, ParamException {
        IParamItem ipi = ParamItemFactory.getLocalInstance(ctx);
        ParamItemInfo pi = new ParamItemInfo();
        pi.setIsControlSub(false);
        ParamSetModify paramSetModify = new ParamSetModify(ctx);
        pi.setIsModify(paramSetModify.isModify(model));
        pi.setOrgTreeID(null);
        pi.setValue(model.getDefaultValue());
        MutilLangeToolForParam.muti2Obj(model.getDefaultValue(), (IObjectValue)pi, "value", ctx);
        MutilLangeToolForParam.muti2Obj(model.getValueAlias(), (IObjectValue)pi, "valueAlias", ctx);
        IObjectPK ipk = ipi.addnewNoVerify(pi, model);
    }

    private void updateCacheValue(Context ctx, ParamInfo model) throws EASBizException {
        if (model != null && model.isIsGroupControl() && !StringUtils.isEmpty((String)model.getDefaultValue()) && !StringUtils.isEmpty((String)model.getNumber())) {
            IParamCacheManage paramCacheManage = ParamCacheManageFactory.getLocalInstance(ctx);
            paramCacheManage.setParamValue(ctx, model.getNumber(), model.getDefaultValue());
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model1) throws EASBizException, BOSException {
        ParamItemCollection paramItemVOCO;
        ParamInfo model = (ParamInfo)model1;
        if (model.getUserEdit() != 0) {
            super._update(ctx, pk, (IObjectValue)model);
            this.updateCacheValue(ctx, model);
            return;
        }
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        ParamInfo paramVO = (ParamInfo)this.getValue(ctx, pk);
        if (this.checkImportanceValues(paramVO, model) && (paramItemVOCO = iParamItem.getItemByKeyID(paramVO.getId().toString())) != null && !paramItemVOCO.isEmpty() && paramItemVOCO.size() != 0) {
            if (paramVO.isIsGroupControl()) {
                throw new ParamException(ParamException.PARAMGROUPCONTROLERROR);
            }
            throw new ParamException(ParamException.PARAMCANNOTBEMODIFY);
        }
        if (this.updateCheckValue(ctx, model)) {
            super._update(ctx, pk, (IObjectValue)model);
            this.updateCacheValue(ctx, model);
        }
    }

    private boolean checkImportanceValues(ParamInfo oldData, ParamInfo newData) throws EASBizException, BOSException {
        ParamInfo old = oldData;
        if (old == null) {
            return false;
        }
        ParamInfo now = newData;
        if (now == null) {
            return false;
        }
        if (!old.isIsGroupControl() && now.isIsGroupControl()) {
            return true;
        }
        if (!old.getDataType().equals((Object)now.getDataType())) {
            return true;
        }
        if (!old.getOrgType().equals((Object)now.getOrgType())) {
            return true;
        }
        if (old.getDefaultValue() == null && now.getDefaultValue() != null) {
            return true;
        }
        if (old.getDefaultValue() != null && now.getDefaultValue() == null) {
            return true;
        }
        if (old.getDefaultValue() != null && now.getDefaultValue() != null && !old.getDefaultValue().equals(now.getDefaultValue())) {
            return true;
        }
        if (!old.getNumber().equals(now.getNumber())) {
            return true;
        }
        if (!(old.getBaseType() == null ? "" : old.getBaseType()).equals(now.getBaseType() == null ? "" : now.getBaseType())) {
            return true;
        }
        if (old.getTheValueRange() != null && now.getTheValueRange() != null) {
            if (!(now.getTheValueRange().getMaxValue() == null ? "" : now.getTheValueRange().getMaxValue()).equals(old.getTheValueRange().getMaxValue() == null ? "" : old.getTheValueRange().getMaxValue())) {
                return true;
            }
            if (!(now.getTheValueRange().getMinValue() == null ? "" : now.getTheValueRange().getMinValue()).equals(old.getTheValueRange().getMinValue() == null ? "" : old.getTheValueRange().getMinValue())) {
                return true;
            }
            if (!(now.getTheValueRange().getExclusValue() == null ? "" : now.getTheValueRange().getExclusValue()).equals(old.getTheValueRange().getExclusValue() == null ? "" : old.getTheValueRange().getExclusValue())) {
                return true;
            }
            if (!(now.getTheValueRange().getValueEnum() == null ? "" : now.getTheValueRange().getValueEnum()).equals(old.getTheValueRange().getValueEnum() == null ? "" : old.getTheValueRange().getValueEnum())) {
                return true;
            }
        }
        return false;
    }

    private boolean checkValueRange(ParamInfo model) throws BOSException, ParamException {
        if (model.getDataType() == ParamDataType.String) {
            return ParamUtil.checkString(model.getDefaultValue(), model.getTheValueRange());
        }
        if (model.getDataType() == ParamDataType.Int) {
            return ParamUtil.checkInt(model.getDefaultValue(), model.getTheValueRange());
        }
        if (model.getDataType() == ParamDataType.Date) {
            return ParamUtil.checkDate(model.getDefaultValue(), model.getTheValueRange());
        }
        if (model.getDataType() == ParamDataType.Enum) {
            return ParamUtil.checkEnum(model.getDefaultValue(), model.getTheValueRange());
        }
        if (model.getDataType() == ParamDataType.Double) {
            return ParamUtil.checkDouble(model.getDefaultValue(), model.getTheValueRange());
        }
        if (model.getDataType() == ParamDataType.BaseInformation) {
            return true;
        }
        if (model.getDataType() == ParamDataType.Boolean) {
            return true;
        }
        if (model.getDataType() == ParamDataType.Color) {
            return true;
        }
        throw new BOSException();
    }

    private boolean modelNameAndNumberNotNull(ParamInfo model) throws BOSException, ParamException {
        if (model.getName() == null || model.getName().trim().equals("")) {
            throw new ParamException(ParamException.PARAMNAMECANNOTBENULL);
        }
        if (model.getNumber() == null || model.getNumber().trim().equals("")) {
            throw new ParamException(ParamException.PARAMNUMBERCANNOTBENULL);
        }
        if (model.getSubSysID() == null || model.getSubSysID().trim().equals("")) {
            throw new ParamException(ParamException.SUBSYSTEMNOTSELECT);
        }
        return true;
    }

    private boolean addCheckValue(Context ctx, ParamInfo model) throws ParamException, EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getLocalInstance(ctx);
        this.modelNameAndNumberNotNull(model);
        if (iParamControl.getParamByNumber(model.getNumber()) != null) {
            throw new ParamException(ParamException.PARAMNUMBERMUSTBEUNIQE);
        }
        this.checkOhter(model);
        return this.checkValueRange(model);
    }

    private void checkDefaultValueNotNull(ParamInfo model) throws BOSException, ParamException {
        if (model.getDefaultValue() == null || model.getDefaultValue().trim().equals("")) {
            throw new ParamException(ParamException.PARAMDEFAULTVALUEMUSTNOTNULL);
        }
    }

    private void checkOhter(ParamInfo model) throws BOSException, ParamException {
        if (model.getOrgType() == null) {
            throw new ParamException(ParamException.PARAMORGTYPENOTNULL);
        }
        if (model.getDataType() == null) {
            throw new ParamException(ParamException.PARAMDATATYPENOTNULL);
        }
        if (model.getDataType().equals((Object)ParamDataType.BaseInformation) && (model.getBaseType() == null || model.getBaseType().equalsIgnoreCase("") || model.getBaseType().equalsIgnoreCase("null"))) {
            throw new ParamException(ParamException.PARAMBASETYPENOTNULL);
        }
    }

    private boolean updateCheckValue(Context ctx, ParamInfo model) throws ParamException, EASBizException, BOSException {
        IParamControl iParamControl = ParamControlFactory.getLocalInstance(ctx);
        this.modelNameAndNumberNotNull(model);
        ParamInfo paramVO = iParamControl.getParamByNumber(model.getNumber());
        if (paramVO != null && !paramVO.getId().toString().equals(model.getId().toString())) {
            throw new ParamException(ParamException.PARAMNUMBERMUSTBEUNIQE);
        }
        this.checkOhter(model);
        return this.checkValueRange(model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        ParamInfo paramVO = (ParamInfo)this.getValue(ctx, pk);
        if (this.checkParamShareRange(ctx, paramVO)) {
            throw new ParamException(ParamException.PARAMSHARERANGE);
        }
        ParamItemCollection paramItemVOCO = iParamItem.getItemByKeyID(paramVO.getId().toString());
        if (paramItemVOCO != null) {
            for (int j = 0; j < paramItemVOCO.size(); ++j) {
                ParamItemInfo pii = paramItemVOCO.get(j);
                if (!pii.isIsModify()) continue;
                throw new ParamException(ParamException.PARAMCANNOTBEDELETED);
            }
            for (int i = 0; i < paramItemVOCO.size(); ++i) {
                iParamItem.delete((IObjectPK)new ObjectUuidPK(paramItemVOCO.get(i).getId()));
            }
        }
        super._delete(ctx, pk);
    }

    private boolean checkParamShareRange(Context ctx, ParamInfo paramVO) throws BOSException {
        boolean isShare = false;
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("theValueRange", (Object)paramVO.getTheValueRange().getId(), CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("theValueRange"));
        ParamCollection pc = this.getParamCollection(ctx, evi);
        if (pc.size() > 1) {
            isShare = true;
        }
        return isShare;
    }

    public String getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ParamInfo info = this.getParamInfo(ctx, pk);
        if (info != null) {
            return StringUtils.cnulls((String)info.getNumber()) + "  " + StringUtils.cnulls((String)info.getName());
        }
        return "";
    }

    @Override
    protected DumpliParamCollection _getDumpliParams(Context ctx) throws BOSException, ParamException, EASBizException {
        DumpliParamCollection col = new DumpliParamCollection();
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String number = null;
        Object oql = null;
        try {
            cn = this.getConnection(ctx);
            String sql = "select fnumber from t_bas_param group by fnumber having count(fnumber)>1";
            stmt = cn.prepareStatement(sql);
            rs = stmt.executeQuery();
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                number = rs.getString("fnumber");
                list.add(number);
            }
            String currentLocale = ctx.getLocale().toString();
            StringBuffer sb = new StringBuffer();
            sb.append("SELECT fid,fnumber as number,").append("fname_").append(currentLocale).append(" as name,");
            sb.append("fdefaultval_").append(currentLocale).append(" as value,fvaluealias_").append(currentLocale).append(" as valueAlias,forgtype as orgType,flastUpdateTime from t_bas_param where fnumber in(").append(ParamUtil.aryToStr(list, true)).append(")");
            stmt = cn.prepareStatement(sb.toString());
            rs = stmt.executeQuery();
            while (rs.next()) {
                DumpliParamInfo info = new DumpliParamInfo();
                info.setId(rs.getString("fid"));
                info.setParamNumber(rs.getString("number"));
                info.setParamName(rs.getString("name"));
                info.setParamValue(rs.getString("value"));
                info.setParamValueAlias(rs.getString("valueAlias"));
                info.setOrgType(OrgType.getEnum((int)rs.getInt("orgType")).getAlias());
                info.setLastUpdateTime(rs.getTimestamp("flastUpdateTime"));
                col.add(info);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)("_getDumpliParams err!" + e));
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _deleteParamAndItems(Context ctx, String id) throws BOSException {
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            String deleteParamItemSql = "delete from t_bas_paramitem where fkeyid ='" + id + "'";
            String deleteParamSql = "delete from t_bas_param where fid='" + id + "'";
            SQLUtils.execute((Connection)con, (String)deleteParamItemSql);
            SQLUtils.execute((Connection)con, (String)deleteParamSql);
        }
        catch (SQLException e) {
            this.logger.info((Object)"_deleteParamAndItems err!", (Throwable)e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    this.logger.info((Object)"", (Throwable)e);
                }
            }
        }
    }
}

