/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.AbstractParamAfterDeal;
import com.kingdee.eas.base.param.INewParamAfterDeal;
import com.kingdee.eas.base.param.INewParamCheck;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamCacheManageFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamDataType;
import com.kingdee.eas.base.param.ParamException;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.ParamManagerControl;
import com.kingdee.eas.base.param.ParamManagerControlCollection;
import com.kingdee.eas.base.param.ParamManagerControlFactory;
import com.kingdee.eas.base.param.ParamManagerControlInfo;
import com.kingdee.eas.base.param.app.AbstractParamManagerControlControllerBean;
import com.kingdee.eas.base.param.app.config.ParamConfig;
import com.kingdee.eas.base.param.util.MutilLangeToolForParam;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.param.util.ParamManagerControlUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.util.IObjectCol2List;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.app.helper.OrgTypeAppCenter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ParamManagerControlControllerBean
extends AbstractParamManagerControlControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.param.app.ParamManagerControlControllerBean");
    private static final String resource = "com.kingdee.eas.base.param.ParamResource";
    private String metaFilter = "com_kingdee_eas_base_paramBaseDataType";
    private String treeId = "";

    @Override
    protected IObjectValue _getValue(Context ctx, String paramItemId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected List _getParamManagerControlInfo(Context ctx, List paramItemIdList) throws BOSException {
        ArrayList<ParamManagerControlInfo> paramManagerControlInfoList = new ArrayList<ParamManagerControlInfo>();
        int j = paramItemIdList.size();
        for (int i = 0; i < j; ++i) {
            String id = (String)paramItemIdList.get(i);
            ParamManagerControlInfo pmcInfo = ParamManagerControlUtil.getParamManagerCotrolInfoByParamItemID(ctx, id);
            paramManagerControlInfoList.add(pmcInfo);
        }
        return paramManagerControlInfoList;
    }

    @Override
    protected ParamItemInfo _getSuperOrgUnitParamValue(Context ctx, String paramNumber, IObjectPK orgId) throws BOSException, EASBizException {
        try {
            ParamItemCollection paramItemCol;
            if (orgId == null) {
                return null;
            }
            IParamControl iParamControl = ParamControlFactory.getLocalInstance(ctx);
            ParamInfo paramInfo = iParamControl.getParamByNumber(paramNumber);
            if (paramInfo == null) {
                logger.info((Object)("paramNumber is not exist,paramNumber is:" + paramNumber));
                return null;
            }
            if (OrgType.UnionDebt.equals((Object)paramInfo.getOrgType())) {
                return null;
            }
            IOrgUnit iOrgUnit = ParamManagerControlUtil.getOrgUnitByOrgIDAndOrgType(ctx, paramInfo.getOrgType());
            List longNumberList = this.getFullParentUnitLongNumber(ctx, iOrgUnit, orgId.toString());
            String tableName = OrgTypeAppCenter.getInstance().getHelper(paramInfo.getOrgType()).getOrgTypeSelfInfo().getViewTableName();
            String osql = "select orgTbl.fid from T_BAS_ParamItem item inner join T_BAS_PARAMMANAGERCONTROL manager on item.fid = manager.fparamitemid and manager.fisincludesub = 1 inner join " + tableName + " orgTbl on orgTbl.fid = item.forgunitid where item.fkeyid = '" + paramInfo.getId().toString() + "' and orgTbl.flongnumber in (" + ToolUtils.aryToStr((List)longNumberList, (boolean)true) + ") order by orgTbl.FLongNumber";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)osql);
            ParamItemInfo paramItem = null;
            HashSet<String> orgIdSet = new HashSet<String>();
            if (rs.next()) {
                orgIdSet.add(rs.getString(1));
            }
            if ((paramItemCol = this.getParamItemCollection(ctx, paramInfo.getId().toString(), orgIdSet)).size() > 0) {
                paramItem = paramItemCol.get(0);
            }
            return paramItem;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private ParamItemCollection getParamItemCollection(Context ctx, String keyId, Set orgIds) throws BOSException {
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("keyID", (Object)(keyId + ""), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgIds, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("keyID"));
        evi.getSelector().add(new SelectorItemInfo("orgUnitID.id"));
        ParamItemCollection paramItemCo = iParamItem.getParamItemCollection(evi);
        return paramItemCo;
    }

    private List getFullParentUnitLongNumber(Context ctx, IOrgUnit iOrgUnit, String orgId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longnumber"));
        OrgUnitInfo orgUnitInfo = iOrgUnit.getOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), sic);
        if (orgUnitInfo != null) {
            String orgNumber = orgUnitInfo.getLongNumber();
            List orgLongNubmerList = this.parseLongNumber(orgNumber);
            return orgLongNubmerList;
        }
        return null;
    }

    private List parseLongNumber(String longNumber) {
        ArrayList<String> numberList = new ArrayList<String>();
        String[] tempNumber = longNumber.split("!");
        for (int i = 1; i <= tempNumber.length; ++i) {
            numberList.add(this.contructStr(i, tempNumber));
        }
        return numberList;
    }

    private String contructStr(int length, String[] strs) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(strs[0]);
        for (int i = 1; i < length && i < strs.length; ++i) {
            strBuffer.append("!").append(strs[i]);
        }
        return strBuffer.toString();
    }

    @Override
    protected void _saveParamManagerControls(Context ctx, Map changedMap) throws BOSException, EASBizException {
        ParamManagerControlCollection includeCol = new ParamManagerControlCollection();
        ParamManagerControlCollection notIncludeCol = new ParamManagerControlCollection();
        Map oldParamValueMap = (Map)changedMap.get("oldUpdateParamValueMap");
        changedMap.remove("oldUpdateParamValueMap");
        if (changedMap.size() == 0) {
            return;
        }
        Iterator keyIt = changedMap.keySet().iterator();
        ParamInfo paramInfo = null;
        String paramItemNewValue = null;
        String paramNumber = null;
        Boolean isGroupControl = null;
        ParamItemCollection paramItemCol = new ParamItemCollection();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            ParamManagerControlInfo info = (ParamManagerControlInfo)changedMap.get(key);
            if (paramInfo == null && info.getParamItem() != null) {
                paramInfo = info.getParamItem().getKeyID();
                paramNumber = paramInfo.getNumber();
                isGroupControl = paramInfo.isIsGroupControl();
            }
            paramItemNewValue = info.getParamItem().getValue();
            if (info.isIsIncludeSub()) {
                includeCol.add(info);
                continue;
            }
            notIncludeCol.add(info);
            if (info == null || info.getParamItem() == null) continue;
            ParamItemInfo paramItemInfo = info.getParamItem();
            String oldParamValue = (String)oldParamValueMap.get(key);
            String newParamValue = paramItemInfo.getValue();
            if (oldParamValue == null || oldParamValue.equals(newParamValue)) continue;
            paramItemCol.add(paramItemInfo);
        }
        this.businessCheck(ctx, oldParamValueMap, includeCol, paramInfo, paramItemCol);
        IObjectPK logPK = null;
        try {
            String logMsg = this.buildLogMsg(ctx, notIncludeCol, includeCol);
            logPK = LogUtil.beginLog((Context)ctx, (String)"update", (BOSObjectType)BOSObjectType.create((String)"ED2A979A"), null, (String)logMsg, (String)"bs_paramitem_update");
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        this.saveNotIncludeSubParamManagerControls(ctx, notIncludeCol);
        this.saveIncludeSubParamManagerControls(ctx, includeCol);
        if (logPK != null) {
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
    }

    private String buildLogMsg(Context ctx, ParamManagerControlCollection notIncludeCol, ParamManagerControlCollection includeCol) throws BOSException, EASBizException {
        if (notIncludeCol.size() < 1 && includeCol.size() < 1) {
            return "";
        }
        return this.getNotGroupPramUpdateLog(ctx, notIncludeCol) + this.getNotGroupPramUpdateLog(ctx, includeCol);
    }

    private String getNotGroupPramUpdateLog(Context ctx, ParamManagerControlCollection pmcc) throws BOSException, EASBizException {
        if (pmcc.size() < 1) {
            return "";
        }
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        String notGroupParamInitLogRes = ResourceBase.getString((String)resource, (String)"NotGroupParamInitLog", (Locale)ctx.getLocale());
        String notGroupParamUpdateLogRes = ResourceBase.getString((String)resource, (String)"NotGroupParamUpdateLog", (Locale)ctx.getLocale());
        StringBuilder msg = new StringBuilder();
        for (int i = 0; i < pmcc.size(); ++i) {
            MessageFormat mf;
            String paramNumber = pmcc.get(0).getParamItem().getKeyID().getNumber();
            ParamManagerControlInfo newPMInfo = pmcc.get(i);
            ParamItemInfo newPiInfo = newPMInfo.getParamItem();
            boolean isIncludeSub = newPMInfo.isIsIncludeSub();
            String value = newPiInfo.getValue();
            String orgName = newPiInfo.getOrgUnitID().getName();
            if (newPiInfo.getId() == null) {
                mf = new MessageFormat(notGroupParamInitLogRes);
                msg.append(mf.format(new Object[]{orgName, paramNumber, isIncludeSub, value}));
                continue;
            }
            mf = new MessageFormat(notGroupParamUpdateLogRes);
            ParamItemInfo oldPiInfo = iParamItem.getParamItemInfo((IObjectPK)new ObjectUuidPK(newPMInfo.getParamItem().getId()));
            boolean oldIsIncludeSub = false;
            if (newPMInfo.getId() != null) {
                ParamManagerControlInfo oldPMInfo = this.getParamManagerControlInfo(ctx, (IObjectPK)new ObjectUuidPK(newPMInfo.getId()));
                oldIsIncludeSub = oldPMInfo.isIsIncludeSub();
            }
            msg.append(mf.format(new Object[]{orgName, paramNumber, oldIsIncludeSub, oldPiInfo.getValue(), isIncludeSub, value}));
        }
        return msg.toString();
    }

    private void businessCheck(Context ctx, Map oldParamValueMap, ParamManagerControlCollection includeCol, ParamInfo paramInfo, ParamItemCollection paramItemCol) throws BOSException, EASBizException {
        Map afterDealMap;
        String afterDealKey;
        if (paramInfo == null || StringUtils.isEmpty((String)paramInfo.getNumber())) {
            return;
        }
        if (paramItemCol == null) {
            paramItemCol = new ParamItemCollection();
        }
        ParamItemCollection piCol = null;
        Map checkRelMap = ParamConfig.getInstance().getConfig("param");
        String checkRelKey = (String)checkRelMap.get(paramInfo.getNumber());
        if (!StringUtils.isEmpty((String)checkRelKey)) {
            piCol = this.getParamItemColByParamValueModify(ctx, oldParamValueMap, includeCol);
            paramItemCol.addCollection(piCol);
            this.checkRel(ctx, paramItemCol, checkRelKey);
        }
        if (!StringUtils.isEmpty((String)(afterDealKey = (String)(afterDealMap = ParamConfig.getInstance().getConfig("paramafter")).get(paramInfo.getNumber())))) {
            if (piCol == null || piCol.isEmpty()) {
                piCol = this.getParamItemColByParamValueModify(ctx, oldParamValueMap, includeCol);
                paramItemCol.addCollection(piCol);
            }
            this.afterDeal(ctx, paramItemCol, afterDealKey);
        }
    }

    private ParamItemCollection getParamItemColByParamValueModify(Context ctx, Map oldParamValueMap, ParamManagerControlCollection includeCol) throws BOSException {
        ParamItemCollection paramItemCol = new ParamItemCollection();
        ParamItemCollection includeParamItemCol = this.getIncludeParamItemCol(ctx, includeCol, oldParamValueMap);
        paramItemCol.addCollection(includeParamItemCol);
        return paramItemCol;
    }

    private ParamItemCollection getNotIncludeParamItemCol(Context ctx, Map notIncludeParamItemMap) throws BOSException {
        ParamItemCollection paramItemCol = new ParamItemCollection();
        if (notIncludeParamItemMap == null || notIncludeParamItemMap.isEmpty()) {
            return paramItemCol;
        }
        Locale locale = ctx.getLocale();
        String paramValueSql = " select fid,fvalue_" + locale + " paramValue from t_bas_paramItem where fid in(" + ToolUtils.aryToStr(notIncludeParamItemMap.keySet()) + ")";
        IRowSet paramValueSet = DbUtil.executeQuery((Context)ctx, (String)paramValueSql);
        try {
            while (paramValueSet.next()) {
                String fid = paramValueSet.getString("fid");
                String paramValue = paramValueSet.getString("paramValue");
                Object paramObj = notIncludeParamItemMap.get(fid);
                if (paramObj == null || !(paramObj instanceof ParamItemInfo)) continue;
                ParamItemInfo paramItemInfo = (ParamItemInfo)paramObj;
                if (paramValue == null || paramValue.equals(paramItemInfo.getValue())) continue;
                paramItemCol.add(paramItemInfo);
            }
        }
        catch (SQLException e) {
            String message = e.getMessage() + paramValueSql;
            logger.error((Object)message);
            throw new BOSException(message);
        }
        return paramItemCol;
    }

    private ParamItemCollection getIncludeParamItemCol(Context ctx, ParamManagerControlCollection includeCol, Map oldParamValueMap) throws BOSException {
        ParamItemCollection paramItemCol = new ParamItemCollection();
        if (includeCol == null || includeCol.size() == 0 || includeCol.get(0).getParamItem() == null) {
            return paramItemCol;
        }
        ParamInfo paramInfo = includeCol.get(0).getParamItem().getKeyID();
        IRowSet rs = this.getIncludeModifyValueParamItem(ctx, includeCol);
        try {
            while (rs.next()) {
                String paramValue = rs.getString("paramItemValue");
                String orgUnitId = rs.getString("orgUnitId");
                String oldParamValue = (String)oldParamValueMap.get(orgUnitId);
                if (oldParamValue != null && oldParamValue.equals(paramValue)) continue;
                ParamItemInfo paramItemInfo = null;
                try {
                    String paramNumber = paramInfo.getNumber();
                    paramItemInfo = ParamManager.getParamItemInfoByNumberAndOrg(ctx, paramNumber, orgUnitId);
                    if (paramItemInfo == null) {
                        paramItemInfo = new ParamItemInfo();
                        FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                        orgUnitInfo.setId(BOSUuid.read((String)orgUnitId));
                        paramItemInfo.setOrgUnitID(orgUnitInfo);
                        paramItemInfo.setKeyID(paramInfo);
                        paramItemInfo.setValue(paramValue);
                        paramItemInfo.setIsControlSub(false);
                        ParamItemFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)paramItemInfo);
                    }
                }
                catch (EASBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)orgUnitId));
                paramItemInfo.setOrgUnitID(orgUnitInfo);
                paramItemInfo.setKeyID(paramInfo);
                paramItemInfo.setValue(paramValue);
                paramItemCol.add(paramItemInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return paramItemCol;
    }

    private IRowSet getIncludeModifyValueParamItem(Context ctx, ParamManagerControlCollection includeCol) throws BOSException {
        Locale locale = ctx.getLocale();
        ParamInfo paramInfo = includeCol.get(0).getParamItem().getKeyID();
        String paramId = paramInfo.getId().toString();
        OrgType orgType = paramInfo.getOrgType();
        String orgTableName = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getViewTableName();
        StringBuffer selectSubOrgSql = new StringBuffer();
        selectSubOrgSql.append("select orgUnitId,paramItemValue,paramId from (");
        int size = includeCol.size();
        for (int k = 0; k < size; ++k) {
            ParamItemInfo paramItemInfo = includeCol.get(k).getParamItem();
            String longNumber = paramItemInfo.getOrgUnitID().getLongNumber();
            selectSubOrgSql.append("select fid orgUnitId,'").append(paramItemInfo.getValue()).append("' paramItemValue, '").append(paramId).append("' paramId ").append(" from ").append(orgTableName).append(" where flongNumber = '").append(longNumber).append("' ").append(" or flongNumber like '").append(longNumber).append("!%' ");
            if (k >= size - 1) continue;
            selectSubOrgSql.append(" union all ");
        }
        selectSubOrgSql.append(") ou ").append(" left join t_bas_paramItem pi on ou.orgUnitId=pi.fOrgUnitId and ou.paramId=pi.fkeyId").append(" where (ou.paramItemValue!=pi.fvalue_" + locale).append(" or pi.fvalue_" + locale + " is null)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSubOrgSql.toString());
        return rs;
    }

    private void checkRel(Context ctx, ParamItemCollection paramItemCol, String modelKey) throws BOSException, EASBizException {
        if (paramItemCol == null || paramItemCol.size() == 0) {
            return;
        }
        try {
            Class<?> checkClass = Class.forName(modelKey);
            if (!INewParamCheck.class.isAssignableFrom(checkClass)) {
                StringBuffer msg = new StringBuffer();
                msg.append(modelKey).append(ResourceBase.getString((String)"com.kingdee.eas.base.param.PARAMAutoGenerateResource", (String)"3_ParamManagerControlControllerBean", (Locale)ctx.getLocale())).append(INewParamCheck.class.getPackage()).append(INewParamCheck.class.getName()).append(ResourceBase.getString((String)"com.kingdee.eas.base.param.PARAMAutoGenerateResource", (String)"4_ParamManagerControlControllerBean", (Locale)ctx.getLocale()));
                NumericExceptionSubItem item = new NumericExceptionSubItem("test", msg.toString());
                throw new ParamException(item);
            }
            INewParamCheck iParamCheck = (INewParamCheck)checkClass.newInstance();
            iParamCheck.check(ctx, paramItemCol);
        }
        catch (ClassNotFoundException e1) {
            logger.info((Object)"", (Throwable)e1);
            throw new ParamException(ParamException.CLASSNOTFOUND);
        }
        catch (InstantiationException e2) {
            logger.info((Object)"", (Throwable)e2);
            throw new ParamException(ParamException.CLASSNOTFOUND);
        }
        catch (IllegalAccessException e2) {
            logger.info((Object)"", (Throwable)e2);
            throw new ParamException(ParamException.CLASSNOTFOUND);
        }
    }

    public void afterDeal(Context ctx, ParamItemCollection modelCol, String modelKey) throws BOSException, EASBizException {
        block7: {
            if (modelCol == null || modelCol.size() == 0) {
                return;
            }
            try {
                Class<?> dealClass = Class.forName(modelKey);
                if (AbstractParamAfterDeal.class.isAssignableFrom(dealClass)) {
                    AbstractParamAfterDeal abstractDeal = (AbstractParamAfterDeal)dealClass.newInstance();
                    abstractDeal.afterDeal(ctx, modelCol);
                    break block7;
                }
                if (INewParamAfterDeal.class.isAssignableFrom(dealClass)) {
                    logger.info((Object)"implements IParamAfterDeal!");
                    INewParamAfterDeal ideal = (INewParamAfterDeal)dealClass.newInstance();
                    ideal.afterDeal(ctx, modelCol);
                    break block7;
                }
                StringBuffer msg = new StringBuffer();
                msg.append(modelKey).append(ResourceBase.getString((String)"com.kingdee.eas.base.param.PARAMAutoGenerateResource", (String)"3_ParamManagerControlControllerBean", (Locale)ctx.getLocale())).append(INewParamAfterDeal.class.getPackage()).append(INewParamAfterDeal.class.getName()).append(ResourceBase.getString((String)"com.kingdee.eas.base.param.PARAMAutoGenerateResource", (String)"5_ParamManagerControlControllerBean", (Locale)ctx.getLocale()));
                NumericExceptionSubItem item = new NumericExceptionSubItem("test", msg.toString());
                throw new ParamException(item);
            }
            catch (ClassNotFoundException e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
                throw new ParamException(ParamException.CLASSNOTFOUND);
            }
            catch (InstantiationException e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
                throw new ParamException(ParamException.CLASSNOTFOUND);
            }
            catch (IllegalAccessException e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
                throw new ParamException(ParamException.CLASSNOTFOUND);
            }
        }
    }

    private void saveNotIncludeSubParamManagerControls(Context ctx, ParamManagerControlCollection notIncludeCol) throws BOSException, EASBizException {
        if (notIncludeCol.size() < 1) {
            return;
        }
        List orgIdList = this.getOrgIdList(notIncludeCol);
        String paramId = notIncludeCol.get(0).getParamItem().getKeyID().getId().toString();
        String paramNumber = notIncludeCol.get(0).getParamItem().getKeyID().getNumber();
        this.handlerOldIncludeSubControl(ctx, paramId, orgIdList);
        this.deleteOldParamManagerControls(ctx, paramId, orgIdList);
        for (String orgId : orgIdList) {
            ParamCacheManageFactory.getLocalInstance(ctx).remove(paramNumber + orgId, false);
        }
        this.deleteOldParamItems(ctx, paramId, orgIdList);
        IObjectPK[] pks = this.saveParamItems(ctx, notIncludeCol);
        this.saveParamManagerControls(ctx, notIncludeCol, pks);
    }

    private IObjectPK[] saveParamItems(Context ctx, ParamManagerControlCollection controlCol) throws BOSException, EASBizException {
        ParamItemCollection paramItemCol = this.getParamItemCol(ctx, controlCol);
        CoreBaseCollection coreBaseCol = this.getCoreBaseCol((IObjectCollection)paramItemCol);
        return ParamItemFactory.getLocalInstance(ctx).addnewBatchData(coreBaseCol);
    }

    private IObjectPK[] saveParamManagerControls(Context ctx, ParamManagerControlCollection controlCol, IObjectPK[] paramItemPks) throws BOSException, EASBizException {
        int size = paramItemPks.length;
        for (int i = 0; i < size; ++i) {
            controlCol.get(i).getParamItem().setId(BOSUuid.read((String)paramItemPks[i].toString()));
        }
        return ParamManagerControlFactory.getLocalInstance(ctx).addnewBatchData(this.getCoreBaseCol((IObjectCollection)controlCol));
    }

    private void deleteOldParamManagerControls(Context ctx, String paramId, List orgIdList) throws BOSException, EASBizException {
        this.deleteParamManagerControls(ctx, paramId, ToolUtils.aryToStr((List)orgIdList));
    }

    private void deleteOldParamItems(Context ctx, String paramId, List orgIdList) throws BOSException, EASBizException {
        this.deleteParamItems(ctx, paramId, ToolUtils.aryToStr((List)orgIdList));
    }

    private void handlerOldIncludeSubControl(Context ctx, String paramId, List orgIdList) throws BOSException, EASBizException {
        StringBuffer getOldIncludsSubSql = new StringBuffer();
        getOldIncludsSubSql.append("select fid from t_bas_parammanagercontrol where FIsIncludeSub=1 and FParamItemID in ").append(" (select fid from t_bas_paramitem where FKeyID='").append(paramId).append("' and FOrgUnitID in (").append(ToolUtils.aryToStr((List)orgIdList)).append("))");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getOldIncludsSubSql.toString());
        ArrayList<String> controlIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                controlIdList.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer deleteSubSql = new StringBuffer();
        deleteSubSql.append("delete from t_bas_parammanagercontrol where FSuperiorControlID in (").append(ToolUtils.aryToStr(controlIdList)).append(")");
        DbUtil.execute((Context)ctx, (String)deleteSubSql.toString());
        ORMValueCacheService.getInstance().discardType(ctx, new ParamManagerControl().getType());
    }

    private void saveIncludeSubParamManagerControls(Context ctx, ParamManagerControlCollection includeCol) throws BOSException, EASBizException {
        if (includeCol.size() < 1) {
            return;
        }
        this.saveIncludeParamItems(ctx, includeCol);
        this.saveIncludeParamManagerControls(ctx, includeCol);
    }

    private void saveIncludeParamItems(Context ctx, ParamManagerControlCollection controlCol) throws BOSException, EASBizException {
        String paramId = controlCol.get(0).getParamItem().getKeyID().getId().toString();
        String paramNumber = controlCol.get(0).getParamItem().getKeyID().getNumber();
        OrgType orgType = controlCol.get(0).getParamItem().getKeyID().getOrgType();
        String orgTableName = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getViewTableName();
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        ParamItemCollection updateParamItemCol = new ParamItemCollection();
        ParamItemCollection addParamItemCol = new ParamItemCollection();
        for (int i = 0; i < controlCol.size(); ++i) {
            ParamManagerControlInfo pmColInfo = controlCol.get(i);
            ParamItemInfo paramItemInfo = pmColInfo.getParamItem();
            String orgLongNumber = paramItemInfo.getOrgUnitID().getLongNumber();
            ArrayList<BOSUuid> paramItemIdList = new ArrayList<BOSUuid>();
            ParamManagerControlCollection addControlCol = new ParamManagerControlCollection();
            StringBuffer oql = new StringBuffer(" where keyID='").append(paramId).append("'");
            oql.append(" and orgUnitID.id in(").append(" select fid from ").append(orgTableName).append(" where flongNumber='").append(orgLongNumber).append("'").append(" or flongNumber like '").append(orgLongNumber).append("!%')");
            ParamItemCollection paramItemCol = iParamItem.getParamItemCollection(oql.toString());
            for (int k = 0; k < paramItemCol.size(); ++k) {
                ParamItemInfo piInfo = paramItemCol.get(k);
                ParamCacheManageFactory.getLocalInstance(ctx).remove(paramNumber + piInfo.getOrgUnitID().getId().toString(), false);
                MutilLangeToolForParam.muti2Obj((IObjectValue)paramItemInfo, "Value", (IObjectValue)piInfo, "Value", ctx);
                MutilLangeToolForParam.muti2Obj((IObjectValue)paramItemInfo, "valueAlias", (IObjectValue)piInfo, "valueAlias", ctx);
                piInfo.setIsModify(paramItemInfo.isIsModify());
                this.updateModelInfo(ctx, (IObjectValue)piInfo);
                updateParamItemCol.add(piInfo);
                if (paramItemInfo == null || paramItemInfo.getId() == null || paramItemInfo.getId().equals((Object)piInfo.getId())) continue;
                paramItemIdList.add(piInfo.getId());
            }
            if (paramItemIdList.size() >= 1) {
                StringBuffer updateParamManagerCanModifySql = new StringBuffer();
                updateParamManagerCanModifySql.append("update T_BAS_ParamManagerControl ").append("set FCanModify=").append(pmColInfo.isCanModify() ? 1 : 0).append(",").append("fisIncludeSub=0").append(",").append("fisControlled=").append(pmColInfo.isIsControlled() ? 1 : 0).append(" where FParamItemID in(").append(ToolUtils.aryToStr(paramItemIdList)).append(")");
                DbUtil.execute((Context)ctx, (String)updateParamManagerCanModifySql.toString());
            }
            if (paramItemInfo.getId() != null) continue;
            paramItemInfo.setIsControlSub(false);
            this.updateModelInfo(ctx, (IObjectValue)paramItemInfo);
            addParamItemCol.add(paramItemInfo);
        }
        if (!updateParamItemCol.isEmpty()) {
            iParamItem.updateBatchData(this.getCoreBaseCol((IObjectCollection)updateParamItemCol));
        }
        if (!addParamItemCol.isEmpty()) {
            iParamItem.addnewBatchData(this.getCoreBaseCol((IObjectCollection)addParamItemCol));
        }
    }

    private void updateModelInfo(Context ctx, IObjectValue model) {
        if (!(model instanceof ObjectBaseInfo)) {
            return;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectBaseInfo objectBaseInfo = null;
        objectBaseInfo = (ObjectBaseInfo)model;
        if (objectBaseInfo.getCreator() == null) {
            objectBaseInfo.setCreator(userInfo);
        }
        Timestamp createtime = new Timestamp(new Date().getTime());
        if (objectBaseInfo.getCreateTime() == null) {
            objectBaseInfo.setCreateTime(createtime);
        }
        objectBaseInfo.setLastUpdateUser(userInfo);
        objectBaseInfo.setLastUpdateTime(createtime);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private void saveIncludeParamManagerControls(Context ctx, ParamManagerControlCollection controlCol) throws BOSException, EASBizException {
        ParamManagerControlCollection updateControlCol = new ParamManagerControlCollection();
        ParamManagerControlCollection addControlCol = new ParamManagerControlCollection();
        for (int k = 0; k < controlCol.size(); ++k) {
            ParamManagerControlInfo pmcInfo = controlCol.get(k);
            this.updateModelInfo(ctx, (IObjectValue)pmcInfo);
            if (pmcInfo.getId() != null) {
                updateControlCol.add(pmcInfo);
                continue;
            }
            addControlCol.add(pmcInfo);
        }
        if (!addControlCol.isEmpty()) {
            ParamManagerControlFactory.getLocalInstance(ctx).addnewBatchData(this.getCoreBaseCol((IObjectCollection)addControlCol));
        }
        if (!updateControlCol.isEmpty()) {
            ParamManagerControlFactory.getLocalInstance(ctx).updateBatchData(this.getCoreBaseCol((IObjectCollection)updateControlCol));
        }
    }

    private String getSelectSubOrgSql(ParamManagerControlCollection includeCol) {
        List longNumberList = this.getLongNumberList(includeCol);
        OrgType orgType = includeCol.get(0).getParamItem().getKeyID().getOrgType();
        String orgTableName = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getViewTableName();
        StringBuffer selectSubOrgSql = new StringBuffer();
        selectSubOrgSql.append("select fid from ").append(orgTableName).append(" where ");
        int size = longNumberList.size();
        for (int i = 0; i < size; ++i) {
            String longNumber = longNumberList.get(i).toString();
            selectSubOrgSql.append(" flongnumber like '").append(longNumber).append("!%' ").append(" or flongnumber = '").append(longNumber).append("' ");
            if (i >= size - 1) continue;
            selectSubOrgSql.append(" or ");
        }
        return selectSubOrgSql.toString();
    }

    private void deleteParamManagerControls(Context ctx, String paramId, String orgSql) throws BOSException, EASBizException {
        StringBuffer deleteControlSql = new StringBuffer();
        deleteControlSql.append("delete from t_bas_parammanagercontrol where FParamItemID in ").append(" (select fid from t_bas_paramitem where FKeyID='").append(paramId).append("' and FOrgUnitID in (").append(orgSql).append("))");
        DbUtil.execute((Context)ctx, (String)deleteControlSql.toString());
        ORMValueCacheService.getInstance().discardType(ctx, new ParamManagerControl().getType());
    }

    private void deleteParamItems(Context ctx, String paramId, String orgSql) throws BOSException, EASBizException {
        ParamInfo paramInfo = ParamFactory.getLocalInstance(ctx).getParamInfo((IObjectPK)new ObjectStringPK(paramId));
        StringBuffer deleteParamItemSql = new StringBuffer();
        deleteParamItemSql.append("delete from t_bas_paramitem where FKeyID='").append(paramId).append("' and FOrgUnitID in (").append(orgSql).append(")");
        if (!paramInfo.isCanBeModified()) {
            deleteParamItemSql.append(" and fismodify=0");
        }
        DbUtil.execute((Context)ctx, (String)deleteParamItemSql.toString());
        ORMValueCacheService.getInstance().discardType(ctx, new ParamItem().getType());
    }

    private List getLongNumberList(ParamManagerControlCollection includeCol) {
        return ToolUtils.transCol2ListByPeroperty((AbstractObjectCollection)includeCol, (IObjectCol2List)new IObjectCol2List(){

            public String getList(Object obj) {
                return ((ParamManagerControlInfo)obj).getParamItem().getOrgUnitID().getLongNumber();
            }
        });
    }

    private List getOrgIdList(ParamManagerControlCollection col) {
        return ToolUtils.transCol2ListByPeroperty((AbstractObjectCollection)col, (IObjectCol2List)new IObjectCol2List(){

            public String getList(Object obj) {
                return ((ParamManagerControlInfo)obj).getParamItem().getOrgUnitID().getId().toString();
            }
        });
    }

    private CoreBaseCollection getCoreBaseCol(IObjectCollection col) {
        CoreBaseCollection ret = new CoreBaseCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue value = col.getObject(i);
            if (!(value instanceof CoreBaseInfo)) continue;
            ret.add((CoreBaseInfo)value);
        }
        return ret;
    }

    private ParamItemCollection getParamItemCol(Context ctx, ParamManagerControlCollection col) {
        ParamItemCollection ret = new ParamItemCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            ParamItemInfo temp = col.get(i).getParamItem();
            temp.setIsControlSub(false);
            this.updateModelInfo(ctx, (IObjectValue)temp);
            ret.add(temp);
        }
        return ret;
    }

    @Override
    protected Map _getOrgAndParamControlMap(Context ctx, ParamItemInfo paramItemInfo, int level) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        OrgType orgType = paramItemInfo.getKeyID().getOrgType();
        FullOrgUnitInfo rootOrgUnit = paramItemInfo.getOrgUnitID();
        String longNumber = "";
        String longNumberSub = "";
        String paramId = paramItemInfo.getKeyID().getId().toString();
        String orgTable = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getViewTableName();
        String viewTableSql = "select FLevel,flongnumber from " + orgTable + " where fid=?";
        Object[] unitId = new String[]{rootOrgUnit.getId().toString()};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)viewTableSql, (Object[])unitId);
        try {
            int orgUnitLevel = 0;
            while (rowSet.next()) {
                orgUnitLevel = rowSet.getInt("FLevel");
                longNumber = rowSet.getString("flongnumber");
                longNumberSub = longNumber + "!%";
            }
            level = orgUnitLevel + level;
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        Locale l = ctx.getLocale();
        sql.append("select ou.fid ouid,ou.fparentid ouparentid,ou.fname_").append(l.toString()).append(" ouname,ou.FNumber ounum,ou.FLongNumber oulongnum,pi.FValue pivalue,pi.FId piid,pi.FIsModify pimodify,").append("pc.FIsControlled,pc.FCanModify,pc.FSuperiorControlID,pc.FIsIncludeSub,pc.FID pcid").append(" from ").append(orgTable).append(" ou left join (select FValue_").append(l.toString()).append(" FValue,FId,FOrgUnitID,FIsModify from  t_bas_paramitem where fkeyid=?) pi on ou.Fid=pi.FOrgUnitID ").append(" left join T_BAS_ParamManagerControl pc on pi.fid=pc.FParamItemID ").append(" where ou.FLevel<? and (ou.FLongNumber like ? or ou.FLongNumber=?)").append(" order by ou.FLongNumber");
        Object[] params = new Object[]{paramId, level, longNumberSub, longNumber};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        LinkedHashMap<FullOrgUnitInfo, ParamManagerControlInfo> ret = new LinkedHashMap<FullOrgUnitInfo, ParamManagerControlInfo>();
        HashSet<String> paramValueSet = new HashSet<String>();
        try {
            while (rs.next()) {
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)rs.getString("ouid")));
                String ouParentId = rs.getString("ouparentid");
                if (!StringUtils.isEmpty((String)ouParentId)) {
                    FullOrgUnitInfo parentOrg = new FullOrgUnitInfo();
                    parentOrg.setId(BOSUuid.read((String)ouParentId));
                    org.setParent(parentOrg);
                }
                org.setName(rs.getString("ouname"));
                org.setNumber(rs.getString("ounum"));
                String curLongNumber = rs.getString("oulongnum");
                org.setLongNumber(curLongNumber);
                String tempParamItemId = rs.getString("piid");
                if (StringUtils.isEmpty((String)tempParamItemId)) {
                    ret.put(org, null);
                    continue;
                }
                ParamItemInfo tempParamItemInfo = new ParamItemInfo();
                String paramValue = rs.getString("pivalue");
                tempParamItemInfo.setValue(paramValue);
                paramValueSet.add(paramValue);
                tempParamItemInfo.setId(BOSUuid.read((String)tempParamItemId));
                tempParamItemInfo.setIsModify(rs.getBoolean("pimodify"));
                tempParamItemInfo.setKeyID(paramItemInfo.getKeyID());
                ParamManagerControlInfo paramControlInfo = new ParamManagerControlInfo();
                String paramControId = rs.getString("pcid");
                if (StringUtils.isEmpty((String)paramControId)) {
                    paramControlInfo.setIsControlled(false);
                    paramControlInfo.setCanModify(true);
                    paramControlInfo.setIsIncludeSub(false);
                } else {
                    paramControlInfo.setId(BOSUuid.read((String)paramControId));
                    paramControlInfo.setIsControlled(rs.getBoolean("FIsControlled"));
                    paramControlInfo.setCanModify(rs.getBoolean("FCanModify"));
                    paramControlInfo.setSuperiorControlID(rs.getString("FSuperiorControlID"));
                    paramControlInfo.setIsIncludeSub(rs.getBoolean("FIsIncludeSub"));
                }
                if (paramControlInfo.isIsControlled() && longNumber.startsWith(curLongNumber + "!")) {
                    paramControlInfo.setSuperControled(true);
                }
                paramControlInfo.setParamItem(tempParamItemInfo);
                ret.put(org, paramControlInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String paramBaseType = paramItemInfo.getKeyID().getBaseType();
        if (ParamDataType.BaseInformation.equals((Object)paramItemInfo.getKeyID().getDataType())) {
            this.handleResultForBaseData(ctx, ret, paramValueSet, paramBaseType);
        }
        return ret;
    }

    private void handlerSuperControled(Context ctx, FullOrgUnitInfo curOrg, OrgType orgType, Map orgAndParamControlMap) throws BOSException {
        Iterator valueItr = orgAndParamControlMap.values().iterator();
        ArrayList<String> superiorControlIdList = new ArrayList<String>();
        while (valueItr.hasNext()) {
            ParamManagerControlInfo controlInfo = (ParamManagerControlInfo)valueItr.next();
            if (controlInfo == null || !controlInfo.isIsControlled() || StringUtils.isEmpty((String)controlInfo.getSuperiorControlID())) continue;
            superiorControlIdList.add(controlInfo.getSuperiorControlID());
        }
        if (superiorControlIdList.size() < 1) {
            return;
        }
        String orgTable = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getViewTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId,FLongNumber from ").append(orgTable).append(" where FId in (").append(ToolUtils.aryToStr(superiorControlIdList)).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, String> controlIdAndLongNumberMap = new HashMap<String, String>();
        try {
            while (rs.next()) {
                String id = rs.getString("FId");
                String longNumber = rs.getString("FLongNumber");
                controlIdAndLongNumberMap.put(id, longNumber);
            }
        }
        catch (SQLException se) {
            logger.error((Object)"", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        valueItr = orgAndParamControlMap.values().iterator();
        String curLongNumber = curOrg.getLongNumber();
        while (valueItr.hasNext()) {
            ParamManagerControlInfo controlInfo = (ParamManagerControlInfo)valueItr.next();
            if (controlInfo == null) continue;
            String superControlId = controlInfo.getSuperiorControlID();
            String longNumber = (String)controlIdAndLongNumberMap.get(superControlId);
            if (controlInfo == null || !controlInfo.isIsControlled() || !curLongNumber.startsWith(longNumber + "!")) continue;
            controlInfo.setSuperControled(true);
        }
    }

    private void handleResultForBaseData(Context ctx, Map orgParamControlMap, Set paramValueSet, String paramBaseType) throws BOSException {
        IObjectCollection baseDataCol = this.getBaseDataInfoList(ctx, paramValueSet, paramBaseType);
        HashMap<String, IObjectValue> idAndBaseDataMap = new HashMap<String, IObjectValue>();
        if (baseDataCol != null) {
            int size = baseDataCol.size();
            for (int i = 0; i < size; ++i) {
                IObjectValue baseData = baseDataCol.getObject(i);
                String str = baseData.get("id").toString();
                idAndBaseDataMap.put(str, baseData);
            }
        }
        for (Object key : orgParamControlMap.keySet()) {
            ParamManagerControlInfo controlInfo;
            ParamItemInfo paramItemInfo;
            String paramItemValue;
            Object value = orgParamControlMap.get(key);
            if (value == null || !(value instanceof ParamManagerControlInfo) || StringUtils.isEmpty((String)(paramItemValue = (paramItemInfo = (controlInfo = (ParamManagerControlInfo)value).getParamItem()).getValue()))) continue;
            IObjectValue baseData = (IObjectValue)idAndBaseDataMap.get(paramItemValue);
            paramItemInfo.setBaseData(baseData);
        }
    }

    private IObjectCollection getBaseDataInfoList(Context ctx, Set paramValueSet, String paramBaseType) throws BOSException {
        if (paramValueSet == null || paramValueSet.size() < 1 || StringUtils.isEmpty((String)paramBaseType)) {
            return null;
        }
        MetaDataBriefInfo md = SubSystemUtils.getMetaDataBriefInfoByFullName((String)paramBaseType, (String)this.metaFilter);
        BOSObjectType bostype = SubSystemUtils.getEntityObjectInfo((MetaDataBriefInfo)md).getType();
        IDynamicObject dyn = DynamicObjectFactory.getLocalInstance((Context)ctx);
        return dyn.getCollection(bostype, "where id in (" + ToolUtils.aryToStr((Collection)paramValueSet) + ")");
    }

    @Override
    protected ParamManagerControlCollection _getParamManagerControlsOfIncludeSub(Context ctx, String paramId) throws BOSException, EASBizException {
        Locale l = ctx.getLocale();
        ParamInfo paramInfo = ParamFactory.getLocalInstance(ctx).getParamInfo((IObjectPK)new ObjectStringPK(paramId));
        OrgType orgType = paramInfo.getOrgType();
        ParamManagerControlCollection ret = new ParamManagerControlCollection();
        ret = (ParamManagerControlCollection)((Object)this._getLongNumberAndIncludeSubParamControlMap(ctx, paramId, orgType).values());
        return ret;
    }

    @Override
    protected Map _getLongNumberAndIncludeSubParamControlMap(Context ctx, String paramId, OrgType orgType) throws BOSException, EASBizException {
        Locale l = ctx.getLocale();
        String orgTable = OrgTypeAppCenter.getInstance().getHelper(orgType).getOrgTypeSelfInfo().getViewTableName();
        StringBuffer sql = new StringBuffer();
        sql.append("select pc.FIsControlled,pc.FCanModify,pc.FSuperiorControlID,pc.FIsIncludeSub,pc.FID pcid,").append("org.FLongNumber,org.FId orgId,pi.FValue piValue,pi.Fid piId ").append(" from t_bas_ParamManagerControl pc ").append(" join (select FId,FValue_").append(l.toString()).append(" FValue,FOrgUnitID from t_bas_ParamItem where FKeyId=?) pi ").append(" on pc.FParamItemId = pi.FId ").append(" join ").append(orgTable).append(" org on pi.FOrgUnitID=org.FId ").append(" where pc.FIsIncludeSub=1").append(" order by org.FLongNumber");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{paramId});
        LinkedHashMap<String, ParamManagerControlInfo> map = new LinkedHashMap<String, ParamManagerControlInfo>();
        try {
            while (rs.next()) {
                FullOrgUnitInfo org = new FullOrgUnitInfo();
                org.setId(BOSUuid.read((String)rs.getString("orgId")));
                String longNumber = rs.getString("FLongNumber");
                org.setLongNumber(longNumber);
                ParamItemInfo paramItem = new ParamItemInfo();
                paramItem.setId(BOSUuid.read((String)rs.getString("piId")));
                paramItem.setValue(rs.getString("piValue"));
                paramItem.setOrgUnitID(org);
                ParamInfo paramInfo = new ParamInfo();
                paramInfo.setId(BOSUuid.read((String)paramId));
                paramItem.setKeyID(paramInfo);
                ParamManagerControlInfo paramControlInfo = new ParamManagerControlInfo();
                paramControlInfo.setId(BOSUuid.read((String)rs.getString("pcid")));
                paramControlInfo.setIsControlled(rs.getBoolean("FIsControlled"));
                paramControlInfo.setCanModify(rs.getBoolean("FCanModify"));
                paramControlInfo.setIsControlled(rs.getBoolean("FIsControlled"));
                paramControlInfo.setSuperiorControlID(rs.getString("FSuperiorControlID"));
                paramControlInfo.setParamItem(paramItem);
                map.put(longNumber, paramControlInfo);
            }
        }
        catch (SQLException se) {
            logger.error((Object)"", (Throwable)se);
            throw new BOSException((Throwable)se);
        }
        return map;
    }
}

