/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.app.config;

import com.kingdee.eas.base.param.app.config.ParamConfigUtil;
import com.kingdee.util.ConfigurationException;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.XMLConfiguration;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ParamConfig {
    private static String[] paramRelfileNames = new String[]{"EAS_ParamRel.xml", "BOS_ParamRel.xml"};
    private static ParamConfig instance = null;
    private Map paramItemConfig = new ConcurrentHashMap();
    private Map paramAfterItemConfig = new ConcurrentHashMap();
    private Map setModifyItemConfig = new ConcurrentHashMap();
    private Map specialParamItemConfig = new ConcurrentHashMap();
    private static String ParamName = "param";
    private static String paramAfterName = "paramafter";
    private static String setModifyName = "setModify";
    private static String specialParamName = "specialParam";
    private boolean initOver = false;

    private ParamConfig() {
    }

    private void init() {
        String[] filePaths = ParamConfigUtil.getConfiguationFilePath(paramRelfileNames);
        this.loadParamConfig(filePaths);
        this.loadParamAfterConfig(filePaths);
        this.loadSetModifyConfig(filePaths);
        this.loadSpecialParamConfig(filePaths);
        this.initOver = true;
    }

    public static ParamConfig getInstance() {
        if (instance == null) {
            instance = new ParamConfig();
        }
        return instance;
    }

    private void loadParamRel(String configItemName, String[] filePaths, Map configMap) {
        for (int i = 0; i < filePaths.length; ++i) {
            try {
                URL url = new URL("file", "", filePaths[i]);
                XMLConfiguration xmlReaderBos = XMLConfiguration.getInstance((URL)url);
                ConfigurationItem item = xmlReaderBos.getConfigItem(configItemName);
                Map config = item.getProperties();
                for (String key : config.keySet()) {
                    configMap.put(key, config.get(key));
                }
                continue;
            }
            catch (MalformedURLException e) {
                System.out.println("new URL err");
                continue;
            }
            catch (ConfigurationException ee) {
                System.out.println(filePaths[i] + " not found!");
            }
        }
    }

    private void loadParamConfig(String[] filePaths) {
        this.loadParamRel(ParamName, filePaths, this.paramItemConfig);
    }

    private void loadParamAfterConfig(String[] filePaths) {
        this.loadParamRel(paramAfterName, filePaths, this.paramAfterItemConfig);
    }

    private void loadSetModifyConfig(String[] filePaths) {
        this.loadParamRel(setModifyName, filePaths, this.setModifyItemConfig);
    }

    private void loadSpecialParamConfig(String[] filePaths) {
        this.loadParamRel(specialParamName, filePaths, this.specialParamItemConfig);
    }

    public Map getConfig(String configType) {
        if (!this.initOver) {
            this.init();
        }
        if (setModifyName.equals(configType)) {
            return this.getsetModifyItemConfig();
        }
        if (ParamName.equals(configType)) {
            return this.getParamItemConfig();
        }
        if (paramAfterName.equals(configType)) {
            return this.getParamAfterItemConfig();
        }
        if (specialParamName.equals(configType)) {
            return this.getSpecialParamConfig();
        }
        System.out.println("don't have this configType:" + configType);
        return new HashMap();
    }

    private Map getsetModifyItemConfig() {
        return this.setModifyItemConfig;
    }

    private Map getParamItemConfig() {
        return this.paramItemConfig;
    }

    private Map getParamAfterItemConfig() {
        return this.paramAfterItemConfig;
    }

    private Map getSpecialParamConfig() {
        return this.specialParamItemConfig;
    }
}

