/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.app.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.IParamCacheManage;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamCacheManageFactory;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamException;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.ParamMutiLangFieldInfo;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.param.app.service.IParamQueryService;
import com.kingdee.eas.base.param.app.service.framework.BaseService;
import com.kingdee.eas.base.param.app.service.framework.ParamUtils;
import com.kingdee.eas.base.param.util.ParamUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ParamQueryServiceImpl
extends BaseService
implements IParamQueryService {
    Logger logger = Logger.getLogger((String)ParamQueryServiceImpl.class.getName());

    @Override
    public boolean isGroupControl(Context ctx, String paramNumber) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)paramNumber)) {
            NumericExceptionSubItem item = new NumericExceptionSubItem("hint", "paramNumber is null");
            throw new ParamException(item);
        }
        boolean isGroupControl = false;
        IParamCacheManage cacheService = ParamCacheManageFactory.getLocalInstance(ctx);
        String groupControl = cacheService.isIsGroupControl(paramNumber);
        if (StringUtils.isEmpty((String)groupControl)) {
            IParam iParam = ParamFactory.getLocalInstance(ctx);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)paramNumber, CompareType.EQUALS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fi);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isGroupControl"));
            evi.setSelector(sic);
            ParamCollection paramCo = iParam.getParamCollection(evi);
            if (paramCo != null && paramCo.size() > 0) {
                isGroupControl = paramCo.get(0).isIsGroupControl();
            }
            groupControl = isGroupControl ? "true" : "false";
            cacheService.setIsGroupControl(paramNumber, groupControl);
        }
        if ("true".equals(groupControl)) {
            isGroupControl = true;
        }
        return isGroupControl;
    }

    @Override
    public String getParamValueIgnoreGroupControl(Context ctx, String paramNumber, IObjectPK orgUnitId, boolean setReference) throws EASBizException, BOSException {
        String paramValue = null;
        boolean isGroupControl = this.isGroupControl(ctx, paramNumber);
        IParamCacheManage cacheService = ParamCacheManageFactory.getLocalInstance(ctx);
        paramValue = cacheService.getParamValue(ctx, paramNumber, orgUnitId, isGroupControl);
        if (!isGroupControl && StringUtils.isEmpty((String)paramValue)) {
            paramValue = this.getParamValueHandler(ctx, orgUnitId, paramNumber, setReference);
            cacheService.setParamValue(ctx, paramNumber, orgUnitId, false, paramValue);
        }
        return paramValue;
    }

    private String getParamValueHandler(Context ctx, IObjectPK orgUnitID, String paramNumber, boolean setRefence) throws BOSException, EASBizException {
        ParamItemCollection paramItemCo;
        String value = null;
        ParamItemInfo paramItemInfo = null;
        if (StringUtils.isEmpty((String)paramNumber)) {
            return value;
        }
        ParamInfo paramInfo = ParamControlFactory.getLocalInstance(ctx).getParamByNumber(paramNumber.trim());
        if (paramInfo == null) {
            return value;
        }
        String orgUnitIDStr = null;
        if (orgUnitID != null) {
            orgUnitIDStr = orgUnitID.toString();
        }
        if ((paramItemCo = !OrgCommonUtils.isBasicOrgType((OrgType)paramInfo.getOrgType()) ? this.getParamItemByKeyIDAndOrgTree(orgUnitIDStr, paramInfo.getId().toString(), ctx) : this.getParamItemByKeyIDAndOrgUnit(orgUnitIDStr, paramInfo.getId().toString(), ctx, true)) != null && paramItemCo.size() > 0) {
            if (paramItemCo.size() > 1) {
                this.logger.info((Object)("paramitem dumplicate ! ParamNumber is:" + paramNumber + " orgID is:" + orgUnitIDStr));
                this.logger.info((Object)("select * from t_bas_paramitem where fkeyid = '" + paramNumber + "' and fortunitID = '" + orgUnitIDStr + "';will get multi paramitem"));
            }
            paramItemInfo = paramItemCo.get(0);
            value = paramItemInfo.getValue();
        } else {
            value = orgUnitID == null || StringUtils.isEmpty((String)orgUnitID.toString()) ? paramInfo.getDefaultValue() : this.generateParamItem(ctx, orgUnitID, paramInfo);
        }
        this.logger.debug((Object)"...... query param value is over ..");
        if (setRefence) {
            if (orgUnitID != null && paramItemInfo != null) {
                if (!paramItemInfo.isIsModify()) {
                    IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
                    paramItemInfo.setIsModify(true);
                    iParamItem.updateNoVerify(paramItemInfo);
                    this.logger.debug((Object)("........ update paramitem modify ,paramitem id is:" + paramItemInfo.getId().toString()));
                }
            } else {
                this.logger.debug((Object)"........ orgUnitID is null , don't set param refence!");
            }
        }
        return value;
    }

    private String generateParamItem(Context ctx, IObjectPK orgUnitID, ParamInfo param) throws BOSException, EASBizException {
        String paramValue = null;
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        ParamItemInfo paramItemInfo = null;
        OrgUnitInfo orgUnit = new OrgUnitInfo();
        orgUnit.setId(BOSUuid.read((String)orgUnitID.toString()));
        String orgTreeId = null;
        if (!OrgCommonUtils.isBasicOrgType((OrgType)param.getOrgType())) {
            orgTreeId = orgUnitID.toString();
        }
        paramItemInfo = this.getParamItemByParamInfo(ctx, param, orgUnit, orgTreeId);
        IObjectPK pk = iParamItem.addnewNoVerify(paramItemInfo, param);
        this.updateParamItemTimeAndUser(ctx, pk.toString());
        paramValue = paramItemInfo.getValue();
        return paramValue;
    }

    @Override
    public ParamItemCollection getParamItemByKeyIDAndOrgTree(String orgTreeID, String KeyID, Context ctx) throws BOSException {
        return this.getParamItemByKeyIDAndOrgTree(orgTreeID, KeyID, null, ctx);
    }

    @Override
    public ParamItemCollection getParamItemByKeyIDAndOrgUnit(String orgUnitID, String KeyID, Context ctx) throws BOSException {
        return this.getParamItemByKeyIDAndOrgUnit(orgUnitID, KeyID, ctx, false);
    }

    private ParamItemCollection getParamItemByKeyIDAndOrgUnit(String orgUnitID, String KeyID, Context ctx, boolean isMayNull) throws BOSException {
        return this.getParamItemByKeyIDAndOrgUnit(orgUnitID, KeyID, null, ctx, isMayNull);
    }

    @Override
    public ParamItemCollection getParamItemByKeyIDAndOrgUnit(String orgUnitID, String KeyID, SelectorItemCollection selCol, Context ctx, boolean isMayNull) throws BOSException {
        if (StringUtils.isEmpty((String)KeyID) || "null".equalsIgnoreCase(KeyID)) {
            throw new BOSException("KeyID is null");
        }
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("keyID", (Object)KeyID, CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)orgUnitID) && !"null".equalsIgnoreCase(orgUnitID)) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitID, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
        } else {
            filter.setMaskString("#0");
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        if (selCol != null && !selCol.isEmpty()) {
            evi.setSelector(selCol);
        } else {
            evi.setSelector(ParamUtil.getParamItemSelect());
        }
        ParamItemCollection paramItemCo = iParamItem.getParamItemCollection(evi);
        return paramItemCo;
    }

    @Override
    public ParamItemCollection getParamItemByKeyIDAndOrgTree(String orgTreeID, String KeyID, SelectorItemCollection coll, Context ctx) throws BOSException {
        IParamItem iParamItem = ParamItemFactory.getLocalInstance(ctx);
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("keyID", (Object)KeyID, CompareType.EQUALS));
        String treeId = null;
        if (!StringUtils.isEmpty((String)orgTreeID) && !"null".equalsIgnoreCase(orgTreeID)) {
            treeId = orgTreeID;
        }
        i.getFilterItems().add(new FilterItemInfo("orgTreeID", (Object)treeId, CompareType.EQUALS));
        i.setMaskString("#0 and #1");
        EntityViewInfo evi = new EntityViewInfo();
        if (coll != null && !coll.isEmpty()) {
            evi.setSelector(coll);
        }
        evi.setFilter(i);
        ParamItemCollection paramItemCo = iParamItem.getParamItemCollection(evi);
        return paramItemCo;
    }

    @Override
    public Collection getParamHashMapDealMutiParamNumber(Context ctx, Collection paramNumberList, Collection orgList) throws BOSException, EASBizException {
        HashMap retMap = new HashMap();
        if (paramNumberList.isEmpty()) {
            return new ArrayList();
        }
        IParam iParam = ParamFactory.getLocalInstance(ctx);
        String oql = "select isGroupControl,number,orgtype,defaultValue where number in (" + ToolUtils.aryToStr((Collection)paramNumberList) + ")";
        ParamCollection paramCol = iParam.getParamCollection(oql);
        HashMap<String, String> notUnionParamSet = new HashMap<String, String>();
        HashMap<String, String> unionParamMap = new HashMap<String, String>();
        for (int i = 0; i < paramCol.size(); ++i) {
            ParamInfo paramInfo = paramCol.get(i);
            if (paramInfo.getOrgType().getValue() == 8) {
                unionParamMap.put(paramInfo.getNumber(), paramInfo.getDefaultValue());
                continue;
            }
            notUnionParamSet.put(paramInfo.getNumber(), paramInfo.getDefaultValue());
        }
        ParamMutiLangFieldInfo mutiFieldInfo = new ParamMutiLangFieldInfo(ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append("select param.fnumber paramnumber, item.forgunitid forgid, item." + mutiFieldInfo.getParamItemValue() + " itemvalue");
        sql.append(" from T_BAS_Param param inner join T_BAS_ParamItem item on param.fid = item.fkeyid where ");
        sql.append("fnumber in (").append(ToolUtils.aryToStr((Collection)paramNumberList, (boolean)true)).append(")");
        sql.append(" and item.forgunitid in (").append(ToolUtils.aryToStr((Collection)orgList, (boolean)true)).append(")");
        retMap = this.getParamOrgValue(ctx, sql.toString());
        StringBuffer nullOrgSql = new StringBuffer("");
        nullOrgSql.append("select param.fnumber paramnumber, item.forgunitid forgid, item." + mutiFieldInfo.getParamItemValue() + " itemvalue");
        nullOrgSql.append(" from T_BAS_Param param inner join T_BAS_ParamItem item on param.fid = item.fkeyid where ");
        nullOrgSql.append("fnumber in (").append(ToolUtils.aryToStr((Collection)paramNumberList, (boolean)true)).append(")");
        nullOrgSql.append(" and item.forgunitid  is null");
        retMap.putAll(this.getParamOrgValue(ctx, nullOrgSql.toString()));
        retMap.putAll(this.getNotDealParam(notUnionParamSet, retMap));
        if (unionParamMap.isEmpty()) {
            return retMap.values();
        }
        StringBuffer unionSql = new StringBuffer();
        unionSql.append("select param.fnumber paramnumber, item.forgtreeid forgid, item." + mutiFieldInfo.getParamItemValue() + " itemvalue");
        unionSql.append(" from T_BAS_Param param inner join T_BAS_ParamItem item on param.fid = item.fkeyid where ");
        unionSql.append("fnumber in (").append(ToolUtils.aryToStr((Collection)paramNumberList, (boolean)true)).append(")");
        unionSql.append("and item.forgtreeid in (").append(ToolUtils.aryToStr((Collection)orgList, (boolean)true)).append(")");
        retMap.putAll(this.getParamOrgValue(ctx, unionSql.toString()));
        StringBuffer nullUnionOrgSql = new StringBuffer("");
        nullUnionOrgSql.append("select param.fnumber paramnumber, item.forgtreeid forgid, item." + mutiFieldInfo.getParamItemValue() + " itemvalue");
        nullUnionOrgSql.append(" from T_BAS_Param param inner join T_BAS_ParamItem item on param.fid = item.fkeyid where ");
        nullUnionOrgSql.append("fnumber in (").append(ToolUtils.aryToStr((Collection)paramNumberList, (boolean)true)).append(")");
        nullUnionOrgSql.append("and item.forgtreeid  is null");
        retMap.putAll(this.getParamOrgValue(ctx, nullUnionOrgSql.toString()));
        retMap.putAll(this.getNotDealParam(unionParamMap, retMap));
        return retMap.values();
    }

    private HashMap getParamOrgValue(Context ctx, String sql) throws BOSException {
        HashMap<String, ParamSimpleInfo> retMap = new HashMap<String, ParamSimpleInfo>();
        this.logger.info((Object)(".....query sql is:" + sql.toString()));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                String paramNumber = rowSet.getString("paramnumber");
                String orgUnitId = StringUtils.cnulls((String)rowSet.getString("forgid"));
                ParamSimpleInfo paramInfo = new ParamSimpleInfo();
                paramInfo.setParamNumber(paramNumber);
                if (!StringUtils.isEmpty((String)orgUnitId)) {
                    paramInfo.setOrgUnitPK((IObjectPK)new ObjectStringPK(orgUnitId));
                }
                paramInfo.setParamValue(rowSet.getString("itemvalue"));
                retMap.put(paramNumber + orgUnitId, paramInfo);
            }
        }
        catch (SQLException e) {
            this.logger.info((Object)"sql error!", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return retMap;
    }

    private Map getNotDealParam(Map notdealParamMap, Map allDealMap) {
        HashMap<String, ParamSimpleInfo> retMap = new HashMap<String, ParamSimpleInfo>();
        for (Object paramObj : notdealParamMap.keySet()) {
            if (paramObj == null || allDealMap.containsKey(paramObj.toString())) continue;
            ParamSimpleInfo paramSimpleInfo = new ParamSimpleInfo();
            paramSimpleInfo.setParamNumber(paramObj.toString());
            paramSimpleInfo.setParamValue(StringUtils.cnulls(notdealParamMap.get(paramObj)));
            retMap.put(paramSimpleInfo.toString(), paramSimpleInfo);
        }
        return retMap;
    }

    @Override
    public HashMap getParamHashMap(Context ctx, HashMap paramKeyMap) throws BOSException, EASBizException {
        HashMap paramValueMap = new HashMap();
        if (paramKeyMap == null || paramKeyMap.isEmpty()) {
            return paramValueMap;
        }
        paramValueMap = this.getParamValueBatch(ctx, paramKeyMap);
        return paramValueMap;
    }

    @Override
    public HashMap getParamHashMap(Context ctx, String[] numbers, String orgId) throws BOSException, EASBizException {
        HashMap hmResult = new HashMap();
        if (numbers == null || numbers.length == 0) {
            return hmResult;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < numbers.length; ++i) {
            String paramNumber = numbers[i];
            paramMap.put(paramNumber, orgId);
        }
        hmResult = this.getParamValueBatch(ctx, paramMap);
        return hmResult;
    }

    @Override
    public ArrayList getParamHashMapBatch(Context ctx, HashMap paramKeyMap) throws BOSException, EASBizException {
        ArrayList<ParamSimpleInfo> retList = new ArrayList<ParamSimpleInfo>();
        if (paramKeyMap == null || paramKeyMap.isEmpty()) {
            return retList;
        }
        HashMap paramValueMap = this.getParamValueBatch(ctx, paramKeyMap);
        ParamSimpleInfo paramSimpleInfo = null;
        for (Object paramObj : paramKeyMap.keySet()) {
            Object orgObj = paramKeyMap.get(paramObj);
            String paramNumber = StringUtils.cnulls(paramObj);
            String orgUnitId = StringUtils.cnulls(orgObj);
            ObjectStringPK orgUnitPK = new ObjectStringPK(orgUnitId);
            String paramValue = StringUtils.cnulls(paramValueMap.get(paramNumber));
            paramSimpleInfo = ParamUtils.newParamSimpleInfo(paramNumber, (IObjectPK)orgUnitPK, paramValue);
            retList.add(paramSimpleInfo);
        }
        return retList;
    }

    @Override
    public ArrayList getParamSimpleInfoBatch(Context ctx, ArrayList paramNumberList, ArrayList orgIdStrList) throws BOSException, EASBizException {
        if (paramNumberList == null || paramNumberList.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<ParamSimpleInfo> retList = new ArrayList<ParamSimpleInfo>();
        if (orgIdStrList == null || orgIdStrList.isEmpty()) {
            for (int numberIndex = 0; numberIndex < paramNumberList.size(); ++numberIndex) {
                Object paramNumberObj = paramNumberList.get(numberIndex);
                String paramNumber = StringUtils.cnulls(paramNumberObj);
                String paramValue = ParamCacheManageFactory.getLocalInstance(ctx).getParamValue(ctx, paramNumber, null, true);
                ParamSimpleInfo paramSimpleInfo = ParamUtils.newParamSimpleInfo(paramNumber, null, paramValue);
                retList.add(paramSimpleInfo);
            }
        } else {
            for (int orgIdIndex = 0; orgIdIndex < orgIdStrList.size(); ++orgIdIndex) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                Object orgObj = orgIdStrList.get(orgIdIndex);
                String orgId = StringUtils.cnulls(orgObj);
                for (int numberIndex = 0; numberIndex < paramNumberList.size(); ++numberIndex) {
                    Object paramNumberObj = paramNumberList.get(numberIndex);
                    String paramNumber = StringUtils.cnulls(paramNumberObj);
                    paramMap.put(paramNumber, orgId);
                }
                HashMap paramValueMap = this.getParamValueBatch(ctx, paramMap);
                for (Object paramNumberObj : paramValueMap.keySet()) {
                    Object paramValueObj = paramValueMap.get(paramNumberObj);
                    ObjectStringPK orgUnitPK = new ObjectStringPK(orgId);
                    ParamSimpleInfo paramSimpleInfo = ParamUtils.newParamSimpleInfo(StringUtils.cnulls(paramNumberObj), (IObjectPK)orgUnitPK, StringUtils.cnulls(paramValueObj));
                    retList.add(paramSimpleInfo);
                }
            }
        }
        return retList;
    }

    private HashMap getParamValueBatch(Context ctx, HashMap paramMap) throws EASBizException, BOSException {
        HashMap valueMap;
        HashMap paramValueMap = new HashMap();
        if (paramMap == null || paramMap.isEmpty()) {
            return paramValueMap;
        }
        if (ParamUtils.isMemcacheServerConn()) {
            HashMap ignoreGroupControlParamValueMap;
            HashMap groupControlParamValueMap = this.getGroupControlParamValueByCache(ctx, paramMap);
            if (!ParamUtils.isEmptyMap(groupControlParamValueMap)) {
                paramValueMap.putAll(groupControlParamValueMap);
                paramMap.keySet().removeAll(groupControlParamValueMap.keySet());
                if (paramMap.isEmpty()) {
                    return paramValueMap;
                }
            }
            if (!ParamUtils.isEmptyMap(ignoreGroupControlParamValueMap = this.getIgnoreGroupControlParamValueByDB(ctx, paramMap))) {
                paramValueMap.putAll(ignoreGroupControlParamValueMap);
                paramMap.keySet().removeAll(ignoreGroupControlParamValueMap.keySet());
                if (paramMap.isEmpty()) {
                    return paramValueMap;
                }
            }
        }
        if (!ParamUtils.isEmptyMap(valueMap = this.getParamValueByCache(ctx, paramMap))) {
            paramValueMap.putAll(valueMap);
        }
        return paramValueMap;
    }

    private HashMap getGroupControlParamValueByCache(Context ctx, HashMap paramMap) throws EASBizException, BOSException {
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        if (ParamUtils.isEmptyMap(paramMap)) {
            return paramValueMap;
        }
        boolean isGroupControl = false;
        for (Object paramNumberObj : paramMap.keySet()) {
            String paramNumber = StringUtils.cnulls(paramNumberObj);
            isGroupControl = this.isGroupControl(ctx, paramNumber);
            if (!isGroupControl) continue;
            String paramValue = ParamCacheManageFactory.getLocalInstance(ctx).getParamValue(ctx, paramNumber, null, true);
            paramValueMap.put(paramNumber, paramValue);
        }
        return paramValueMap;
    }

    private HashMap getIgnoreGroupControlParamValueByDB(Context ctx, HashMap paramMap) throws EASBizException, BOSException {
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        if (ParamUtils.isEmptyMap(paramMap)) {
            return paramValueMap;
        }
        Locale locale = ctx.getLocale();
        StringBuffer ignGroCtrSql = new StringBuffer();
        ignGroCtrSql.append("select p.fnumber paraNumber,pi.fvalue_").append(locale).append(" paramValue from t_bas_param p ").append(" inner join t_bas_paramItem pi").append(" on p.fid=pi.fkeyid ");
        boolean isAddWhere = false;
        int marker = 1;
        Iterator it = paramMap.keySet().iterator();
        int ignoreGroupControlMapSize = paramMap.size();
        ArrayList<String> param = new ArrayList<String>();
        while (it.hasNext()) {
            Object paramNumberObj = it.next();
            String paramNumber = StringUtils.cnulls(paramNumberObj);
            Object orgUnitObj = paramMap.get(paramNumber);
            String orgUnitId = StringUtils.cnulls(orgUnitObj);
            if (!isAddWhere) {
                ignGroCtrSql.append(" where ");
                isAddWhere = true;
            }
            ignGroCtrSql.append("(p.fnumber = ? and pi.FOrgUnitId = ?)");
            param.add(paramNumber);
            param.add(orgUnitId);
            if (marker < ignoreGroupControlMapSize) {
                ignGroCtrSql.append(" or ");
            }
            ++marker;
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)ignGroCtrSql.toString(), (Object[])param.toArray());
        try {
            while (rowSet.next()) {
                paramValueMap.put(rowSet.getString("paraNumber"), rowSet.getString("paramValue"));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)ignGroCtrSql.toString());
            throw new BOSException(ignGroCtrSql.toString() + e.getMessage());
        }
        return paramValueMap;
    }

    private HashMap getParamValueByCache(Context ctx, HashMap paramMap) throws EASBizException, BOSException {
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        if (ParamUtils.isEmptyMap(paramMap)) {
            return paramValueMap;
        }
        String paramValue = "";
        for (Object paramNumberObj : paramMap.keySet()) {
            String paramNumber = StringUtils.cnulls(paramNumberObj);
            ObjectStringPK orgUnitId = new ObjectStringPK(StringUtils.cnulls(paramMap.get(paramNumber)));
            paramValue = this.getParamValueIgnoreGroupControl(ctx, paramNumber, (IObjectPK)orgUnitId, false);
            paramValueMap.put(paramNumber, paramValue);
        }
        return paramValueMap;
    }
}

