/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.EmunCustomize;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamClientUtil;
import com.kingdee.eas.base.param.util.ParamUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MutilLangeToolForParam {
    private static Logger logger = Logger.getLogger((String)MutilLangeToolForParam.class.getName());
    static LanguageInfo[] allLanguage = null;
    public static final Locale LOCALE_EN = new Locale("L1");
    public static final Locale LOCALE_CN = new Locale("L2");
    public static final Locale LOCALE_WT = new Locale("L3");

    private static void init() {
        if (KDBizMultiLangBox.getLanguageList() != null) {
            int size = KDBizMultiLangBox.getLanguageList().size();
            allLanguage = new LanguageInfo[size];
            for (int i = 0; i < size; ++i) {
                MutilLangeToolForParam.allLanguage[i] = (LanguageInfo)KDBizMultiLangBox.getLanguageList().get(i);
            }
        } else {
            allLanguage = new LanguageInfo[3];
            MutilLangeToolForParam.allLanguage[0] = new LanguageInfo(LOCALE_EN);
            MutilLangeToolForParam.allLanguage[1] = new LanguageInfo(LOCALE_CN);
            MutilLangeToolForParam.allLanguage[2] = new LanguageInfo(LOCALE_WT);
        }
    }

    public static void muti2Obj(IObjectValue source, String sourceName, IObjectValue dest, String destName) {
        MutilLangeToolForParam.muti2Obj(source, sourceName, dest, destName, null);
    }

    public static void muti2Obj(IObjectValue source, String sourceName, IObjectValue dest, String destName, Context ctx) {
        if (allLanguage == null) {
            MutilLangeToolForParam.init();
        }
        if (source == null || dest == null || allLanguage == null) {
            logger.info((Object)" data is null ,not translate ,return !");
            return;
        }
        Locale local = MutilLangeToolForParam.getLocale(ctx);
        for (int i = 0; i < allLanguage.length; ++i) {
            LanguageInfo info = allLanguage[i];
            dest.put(destName + "_" + info.getLocale(), source.get(sourceName, info.getLocale()));
            if (!local.equals(info.getLocale())) continue;
            dest.put(destName, source.get(sourceName, info.getLocale()));
        }
    }

    public static void muti2Obj(String sourceValue, IObjectValue dest, String destName) {
        MutilLangeToolForParam.muti2Obj(sourceValue, dest, destName, null);
    }

    public static void muti2Obj(String sourceValue, IObjectValue dest, String destName, Context ctx) {
        if (allLanguage == null) {
            MutilLangeToolForParam.init();
        }
        if (sourceValue == null || dest == null || allLanguage == null) {
            logger.info((Object)" data is null ,not translate ,return !");
            return;
        }
        Locale local = MutilLangeToolForParam.getLocale(ctx);
        for (int i = 0; i < allLanguage.length; ++i) {
            LanguageInfo info = allLanguage[i];
            dest.put(destName + "_" + info.getLocale(), (Object)sourceValue);
            if (!local.equals(info.getLocale())) continue;
            dest.put(destName, (Object)sourceValue);
        }
    }

    public static Locale getLocale(Context ctx) {
        Locale local = null;
        local = ctx == null ? SysContext.getSysContext().getLocale() : ContextUtils.getLocaleFromEnv();
        return local;
    }

    public static void setParamAlias(ParamItemInfo paramItem) {
        try {
            if (allLanguage == null) {
                MutilLangeToolForParam.init();
            }
            if (paramItem == null || paramItem.getKeyID() == null || paramItem.getKeyID().getTheValueRange() == null) {
                return;
            }
            for (int i = 0; i < allLanguage.length; ++i) {
                LanguageInfo info = allLanguage[i];
                EmunCustomize[] list = (EmunCustomize[])ParamClientUtil.iniEnumValues(paramItem.getKeyID().getTheValueRange().getValueEnum(info.getLocale()), paramItem.getKeyID().getTheValueRange().getExclusValue(info.getLocale()));
                if (list == null || list.length <= 0 || paramItem.getValue() == null) continue;
                paramItem.put("valueAlias", list[Integer.parseInt((String)paramItem.getValue().trim())].strValue, info.getLocale());
            }
        }
        catch (Exception e) {
            logger.error((Object)(" param set Alias occor error! paramItemId is: " + paramItem.getId() + " paramNumber is :" + paramItem.getKeyID().getNumber()), (Throwable)e);
        }
    }

    public static LanguageInfo[] getLanuageInfo() {
        if (allLanguage != null) {
            return allLanguage;
        }
        MutilLangeToolForParam.init();
        return allLanguage;
    }

    public static Map getLanguageValue(KDMultiLangBox mutiBox) {
        HashMap<Locale, String> retMap = new HashMap<Locale, String>();
        if (allLanguage == null) {
            MutilLangeToolForParam.init();
        }
        for (int i = 0; i < allLanguage.length; ++i) {
            MultiLangItem mutiItem = mutiBox.getItemBy(allLanguage[i]);
            if (StringUtils.isEmpty((String)StringUtils.cnulls((Object)mutiItem.getData()))) continue;
            retMap.put(allLanguage[i].getLocale(), StringUtils.cnulls((Object)mutiItem.getData()));
        }
        return retMap;
    }

    public static void setParamAlias2(Context ctx, ParamItemInfo paramItem, String paramValue) {
        try {
            if (allLanguage == null) {
                MutilLangeToolForParam.init();
            }
            String paramId = paramItem.getKeyID().getId().toString();
            ParamInfo paramInfo = MutilLangeToolForParam.getIParam(ctx).getParamInfo((IObjectPK)new ObjectUuidPK(paramId));
            if (paramItem == null || paramItem.getKeyID() == null || paramInfo.getTheValueRange() == null) {
                return;
            }
            for (int i = 0; i < allLanguage.length; ++i) {
                LanguageInfo info = allLanguage[i];
                Vector vector = ParamUtil.getEnumValues(paramInfo.getTheValueRange().getValueEnum(info.getLocale()));
                if (vector == null || vector.size() <= 0 || paramItem.getValue() == null) continue;
                String emun = (String)vector.get(Integer.parseInt(paramValue));
                paramItem.put("valueAlias", emun, info.getLocale());
            }
        }
        catch (Exception e) {
            logger.error((Object)(" param set Alias occor error! paramItemId is: " + paramItem.getId() + " paramNumber is :" + paramItem.getKeyID().getNumber()), (Throwable)e);
        }
    }

    private static IParam getIParam(Context ctx) throws BOSException {
        IParam iParam = ctx == null ? ParamFactory.getRemoteInstance() : ParamFactory.getLocalInstance(ctx);
        return iParam;
    }
}

