/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.param.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ParamManager {
    private static IParamControl iParamControl = null;
    static Logger logger = Logger.getLogger((String)ParamManager.class.getName());
    private static Map<String, String> clientCache = new HashMap<String, String>();
    private static Set<String> param_can_cache_client = new HashSet<String>();
    private static boolean init = false;

    private ParamManager() {
    }

    private static IParamControl getIParamControl(Context ctx) throws BOSException {
        if (ctx == null) {
            iParamControl = ParamControlFactory.getRemoteInstance();
            if (!init) {
                File path = new File(System.getProperty("user.dir").trim() + "/deploy/client/ParamConfig.xml");
                if (path.exists()) {
                    XMLConfiguration config = XMLConfiguration.getInstance((File)path);
                    param_can_cache_client.addAll(config.getConfigItem("param_can_cache_client").getProperties().keySet());
                    try {
                        clientCache.putAll(iParamControl.getParamHashMap(param_can_cache_client.toArray(new String[0]), null));
                    }
                    catch (EASBizException e) {
                        logger.error((Object)"preload group control param failed", (Throwable)e);
                    }
                }
                init = true;
            }
        } else {
            iParamControl = ParamControlFactory.getLocalInstance(ctx);
        }
        return iParamControl;
    }

    private static IParamControl getIParamControl() throws BOSException {
        return ParamManager.getIParamControl(null);
    }

    public static String getParamValue(IObjectPK orgUnitID, String paramNumber) throws BOSException, EASBizException {
        String result = null;
        if (param_can_cache_client.contains(paramNumber)) {
            result = clientCache.get(paramNumber);
            if (result == null) {
                result = ParamManager.getIParamControl().getParamValue(orgUnitID, paramNumber);
                clientCache.put(paramNumber, result);
            }
            return result;
        }
        return ParamManager.getIParamControl().getParamValue(orgUnitID, paramNumber);
    }

    public static HashMap getParamHashMap(HashMap paramKeyMap) throws BOSException, EASBizException {
        return ParamManager.getIParamControl().getParamHashMap(paramKeyMap);
    }

    public static HashMap getParamHashMap(String[] numbers, String orgId) throws BOSException, EASBizException {
        return ParamManager.getIParamControl().getParamHashMap(numbers, orgId);
    }

    public static void paramReferenced(String paramNumber, String orgUnitId) throws BOSException, EASBizException {
        ParamManager.getIParamControl().paramReferenced(paramNumber, orgUnitId);
    }

    public static ParamInfo getParamByNumber(String paramNumber) throws BOSException, EASBizException {
        return ParamManager.getIParamControl().getParamByNumber(paramNumber);
    }

    public static ParamItemInfo getParamByOrgUnitIDAndKeyID(String orgUnitID, String keyID) throws BOSException {
        return ParamManager.getIParamControl().getItemByOrgUnitIDKeyID(orgUnitID, keyID);
    }

    public static void updateParamByNumber(String paramNumber, String defValue) throws BOSException, EASBizException {
        ParamManager.getIParamControl().updateParamByNumber(paramNumber, defValue);
    }

    public static void updateParamItemByNumberAndOrg(String paramNumber, String orgUnitID, String value) throws BOSException, EASBizException {
        ParamManager.getIParamControl().updateParamItemByNumberAndOrg(paramNumber, orgUnitID, value);
    }

    public static String getParamValue(Context ctx, IObjectPK orgUnitID, String paramNumber) throws BOSException, EASBizException {
        if (ctx == null) {
            return ParamManager.getParamValue(orgUnitID, paramNumber);
        }
        return ParamManager.getIParamControl(ctx).getParamValue(orgUnitID, paramNumber);
    }

    public static String getParamValue(Context ctx, IObjectPK orgUnitID, String paramNumber, boolean setRefence) throws BOSException, EASBizException {
        if (!setRefence) {
            return ParamManager.getParamValue(ctx, orgUnitID, paramNumber);
        }
        return ParamManager.getIParamControl(ctx).getParamValue(orgUnitID, paramNumber, setRefence);
    }

    public static String getParamValueIgnoreGroupControl(Context ctx, String paramNumber, IObjectPK orgUnitId, boolean setReference) throws EASBizException, BOSException {
        if (!setReference) {
            return ParamManager.getParamValue(ctx, orgUnitId, paramNumber);
        }
        return ParamManager.getIParamControl(ctx).getParamValueIgnoreGroupControl(paramNumber, orgUnitId, setReference);
    }

    public static HashMap getParamHashMap(Context ctx, HashMap paramKeyMap) throws BOSException, EASBizException {
        return ParamManager.getIParamControl(ctx).getParamHashMap(paramKeyMap);
    }

    public static ArrayList getParamHashMapBatch(Context ctx, ArrayList paramNumberList, ArrayList orgIdStrList) throws BOSException, EASBizException {
        return ParamManager.getIParamControl(ctx).getParamHashMapBatch(paramNumberList, orgIdStrList);
    }

    public static ArrayList getParamListBatch(Context ctx, ArrayList paramNumberList, ArrayList orgIdStrList) throws BOSException, EASBizException {
        return ParamManager.getIParamControl(ctx).getParamListPatch(paramNumberList, orgIdStrList);
    }

    public static HashMap getParamHashMap(Context ctx, String[] numbers, String orgId) throws BOSException, EASBizException {
        return ParamManager.getIParamControl(ctx).getParamHashMap(numbers, orgId);
    }

    public static void paramReferenced(Context ctx, String paramNumber, String orgUnitId) throws BOSException, EASBizException {
        ParamManager.getIParamControl(ctx).paramReferenced(paramNumber, orgUnitId);
    }

    public static ParamInfo getParamByNumber(Context ctx, String paramNumber) throws BOSException, EASBizException {
        return ParamManager.getIParamControl(ctx).getParamByNumber(paramNumber);
    }

    public static ParamItemInfo getParamByOrgUnitIDAndKeyID(Context ctx, String orgUnitID, String keyID) throws BOSException {
        return ParamManager.getIParamControl(ctx).getItemByOrgUnitIDKeyID(orgUnitID, keyID);
    }

    public static void updateParamByNumber(Context ctx, String paramNumber, String defValue) throws BOSException, EASBizException {
        ParamManager.getIParamControl(ctx).updateParamByNumber(paramNumber, defValue);
    }

    public static void updateParamItemByNumberAndOrg(Context ctx, String paramNumber, String orgUnitID, String value) throws BOSException, EASBizException {
        ParamManager.getIParamControl(ctx).updateParamItemByNumberAndOrg(paramNumber, orgUnitID, value);
    }

    public static ParamItemInfo getParamItemInfoByNumberAndOrg(Context ctx, String paramNumber, String orgUnitID) throws BOSException, EASBizException {
        return ParamManager.getIParamControl(ctx).getParamItemByNumberAndOrg(paramNumber, orgUnitID);
    }

    public static String getSpecialParamValue(Context ctx, String paramNumber) throws EASBizException, BOSException {
        String value = ParamManager.getIParamControl(ctx).getSpecialParamValue(paramNumber);
        logger.info((Object)("Current Special Param value:" + value));
        return value;
    }

    public static IObjectCollection getParamModifiedOrgUnitList(Context ctx, ParamItemInfo paramItem) throws BOSException, EASBizException {
        return ParamManager.getIParamControl(ctx).getParamModifiedOrgUnitList(paramItem);
    }

    public static IObjectCollection copyParam(Context ctx, FullOrgUnitInfo originalOrgUnit, IObjectCollection destinationOrgUnit) throws BOSException, EASBizException {
        return ParamManager.getIParamControl(ctx).copyParam(originalOrgUnit, destinationOrgUnit);
    }

    public static IObjectCollection deleteOrgUnitParam(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        return ParamManager.getIParamControl(ctx).deleteOrgUnitParam(orgUnitId);
    }

    public static void resetCache() {
        init = false;
        param_can_cache_client.clear();
        clientCache.clear();
    }
}

