/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.ba.IRptAccepter;
import com.kingdee.eas.cp.ba.IRptReceiver;
import com.kingdee.eas.cp.ba.IRptRelease;
import com.kingdee.eas.cp.ba.IRptReportType;
import com.kingdee.eas.cp.ba.RptAccepterFactory;
import com.kingdee.eas.cp.ba.RptReceiverCollection;
import com.kingdee.eas.cp.ba.RptReceiverFactory;
import com.kingdee.eas.cp.ba.RptReceiverInfo;
import com.kingdee.eas.cp.ba.RptReleaseCollection;
import com.kingdee.eas.cp.ba.RptReleaseFactory;
import com.kingdee.eas.cp.ba.RptReleaseInfo;
import com.kingdee.eas.cp.ba.RptReportTypeCollection;
import com.kingdee.eas.cp.ba.RptReportTypeFactory;
import com.kingdee.eas.cp.ba.RptReportTypeInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.util.UuidException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ContructRptReportTree
implements Serializable {
    private static final Logger logger = CoreUIObject.getLogger(ContructRptReportTree.class);
    private IRptAccepter iAcc = null;
    private IRptRelease iRptRelease = null;
    private IRptReceiver iRptReceiver = null;

    public ContructRptReportTree(Context ctx) throws BOSException {
        this.iAcc = RptAccepterFactory.getLocalInstance(ctx);
        this.iRptRelease = RptReleaseFactory.getLocalInstance(ctx);
        this.iRptReceiver = RptReceiverFactory.getLocalInstance(ctx);
    }

    public AbstractObjectCollection getPermissionTreeCollection(Context ctx) throws BOSException, EASBizException {
        IRptReportType treeCtrl = RptReportTypeFactory.getLocalInstance(ctx);
        RptReportTypeInfo rptInfo = this.getRootInfo(ctx, treeCtrl);
        AbstractObjectCollection cols = this.getThirdCollection_new(ctx, treeCtrl, rptInfo);
        this.checkTreeNode(ctx, (RptReportTypeCollection)cols);
        return cols;
    }

    private AbstractObjectCollection checkTreeNode(Context ctx, RptReportTypeCollection cols) throws EASBizException, BOSException {
        if (cols != null && cols.size() <= 0) {
            return cols;
        }
        Iterator ite = cols.iterator();
        boolean hasChild = false;
        while (ite.hasNext()) {
            hasChild = false;
            RptReportTypeInfo typeInfo = (RptReportTypeInfo)ite.next();
            if (typeInfo.isIsLeaf()) continue;
            RptReportTypeCollection tempCols = (RptReportTypeCollection)this.getChildren(ctx, typeInfo, 1, null);
            if (tempCols != null && tempCols.size() > 0) {
                Iterator tempIte = tempCols.iterator();
                while (tempIte.hasNext()) {
                    RptReportTypeInfo tempTypeInfo = (RptReportTypeInfo)tempIte.next();
                    if (tempTypeInfo.isIsLeaf() && tempTypeInfo.isIsBusiness()) {
                        if (!this.checkHasBizReport(ctx, tempTypeInfo)) continue;
                        hasChild = true;
                        break;
                    }
                    hasChild = true;
                    break;
                }
            }
            if (hasChild) continue;
            typeInfo.setIsLeaf(true);
        }
        return cols;
    }

    private AbstractObjectCollection getThirdCollection_new(Context ctx, IRptReportType treeCtrl, RptReportTypeInfo info) throws EASBizException, BOSException {
        RptReportTypeInfo rptInfo = null;
        TreeBaseCollection cols = null;
        RptReportTypeCollection childCols = new RptReportTypeCollection();
        cols = treeCtrl.getChildren(info);
        if (cols != null && cols.size() > 0) {
            Iterator ite = cols.iterator();
            IRptAccepter iAcc = RptAccepterFactory.getLocalInstance(ctx);
            while (ite.hasNext()) {
                rptInfo = (RptReportTypeInfo)ite.next();
                if (!this.checkPersonPermission(iAcc, rptInfo.getId().toString(), this.getUserInfo(ctx))) continue;
                childCols.addObject((IObjectValue)rptInfo);
            }
        }
        return childCols;
    }

    private AbstractObjectCollection getThirdCollection(Context ctx, IRptReportType treeCtrl, RptReportTypeInfo info) throws EASBizException, BOSException {
        RptReportTypeInfo tempInfo = null;
        RptReportTypeInfo rptInfo = null;
        TreeBaseCollection cols = null;
        RptReportTypeCollection childCols = new RptReportTypeCollection();
        cols = treeCtrl.getChildren(info);
        if (cols != null && cols.size() > 0) {
            Iterator ite = cols.iterator();
            RptReportTypeCollection tempCols = null;
            IRptAccepter iAcc = RptAccepterFactory.getLocalInstance(ctx);
            IRptRelease iRptRelease = RptReleaseFactory.getLocalInstance(ctx);
            IRptReceiver iRptReceiver = RptReceiverFactory.getLocalInstance(ctx);
            while (ite.hasNext()) {
                rptInfo = (RptReportTypeInfo)ite.next();
                if (!this.checkPersonPermission(iAcc, rptInfo.getId().toString(), this.getUserInfo(ctx))) continue;
                childCols.addObject((IObjectValue)rptInfo);
                tempCols = treeCtrl.getRptReportTypeCollection(this.getViewInfo(rptInfo));
                if (tempCols == null || tempCols.size() <= 0) continue;
                int leng = tempCols.size();
                for (int i = 0; i < leng; ++i) {
                    tempInfo = (RptReportTypeInfo)tempCols.getObject(i);
                    if (tempInfo.isIsLeaf() && tempInfo.isIsBusiness()) {
                        if (!this.checkHasBizReport(ctx, tempInfo)) continue;
                        childCols.addObject((IObjectValue)tempInfo);
                        continue;
                    }
                    childCols.addObject((IObjectValue)tempInfo);
                }
            }
        }
        return childCols;
    }

    private boolean checkPersonPermission(IRptAccepter iAcc, String rptTypeID, UserInfo uInfo) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)uInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("value", (Object)uInfo.getDefOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("report.id", (Object)rptTypeID, CompareType.EQUALS));
        filter.setMaskString("( #0 or #1 ) and #2 ");
        boolean exist = false;
        try {
            exist = iAcc.exists(filter);
        }
        catch (Exception e) {
            logger.info((Object)"checkPersonPermission error!");
            e.printStackTrace();
        }
        return exist;
    }

    private boolean checkHasBizReport(Context ctx, RptReportTypeInfo tempInfo) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rptSort.id", (Object)tempInfo.getId().toString()));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        RptReceiverInfo recInfo = null;
        RptReceiverCollection recCols = null;
        Iterator recIte = null;
        RptReleaseInfo rrInfo = null;
        RptReleaseCollection cols = null;
        cols = this.iRptRelease.getRptReleaseCollection(ev);
        Iterator ite = cols.iterator();
        while (ite.hasNext()) {
            rrInfo = (RptReleaseInfo)ite.next();
            ev.clear();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("item", (Object)rrInfo.getId().toString()));
            filter.setMaskString(" #0 ");
            ev.setFilter(filter);
            recCols = this.iRptReceiver.getRptReceiverCollection(ev);
            recIte = recCols.iterator();
            while (recIte.hasNext()) {
                recInfo = (RptReceiverInfo)recIte.next();
                if (recInfo.getValue() == null || recInfo.getValue().trim().length() <= 0 || !recInfo.getValue().equals(this.getUserPk(ctx).toString()) && !recInfo.getValue().equals(this.getUserInfo(ctx).getDefOrgUnit().getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    private RptReportTypeInfo getRootInfo(Context ctx, IRptReportType treeCtrl) throws BOSException {
        if (treeCtrl == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(2), CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        RptReportTypeCollection cols = treeCtrl.getRptReportTypeCollection(viewInfo);
        RptReportTypeInfo rptInfo = null;
        if (cols != null && cols.size() >= 1) {
            rptInfo = (RptReportTypeInfo)cols.getObject(0);
        }
        return rptInfo;
    }

    private EntityViewInfo getViewInfo(TreeBaseInfo parentNodeInfo) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        if (parentNodeInfo != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentNodeInfo.getLongNumber() + "!%"), CompareType.LIKE));
        }
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        return viewInfo;
    }

    protected IObjectPK getUserPk(Context ctx) {
        ObjectUuidPK userPK = new ObjectUuidPK(BOSUuid.read((String)ctx.getCaller().toString()));
        return userPK;
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException, EASBizException, UuidException {
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserByID((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ctx.getCaller().toString())));
        return userInfo;
    }

    public List getAllReport(Context ctx, TreeBaseInfo treeInfo) {
        if (treeInfo == null) {
            return null;
        }
        List dataList = new ArrayList();
        IRptReportType iRpt = null;
        try {
            iRpt = RptReportTypeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.info((Object)e);
            return dataList;
        }
        if (treeInfo.getLevel() == 2) {
            if (treeInfo.isIsLeaf()) {
                dataList = this.getAllReport(ctx, treeInfo, true);
            } else {
                RptReportTypeInfo rptInfo2 = null;
                TreeBaseCollection cols = null;
                try {
                    cols = iRpt.getChildren(treeInfo);
                    IRptAccepter iAcc = RptAccepterFactory.getLocalInstance(ctx);
                    for (RptReportTypeInfo rptInfo2 : cols) {
                        if (!this.checkPersonPermission(iAcc, rptInfo2.getId().toString(), this.getUserInfo(ctx))) continue;
                        dataList.addAll(this.getAllReport(ctx, rptInfo2, true));
                    }
                }
                catch (Exception ee) {
                    logger.info((Object)ee);
                }
            }
        } else if (treeInfo.getLevel() >= 3) {
            dataList = this.getAllReport(ctx, treeInfo, true);
        }
        return dataList;
    }

    public List getAllReport(Context ctx, TreeBaseInfo treeInfo, boolean mark) {
        ArrayList<String> dataList = new ArrayList<String>();
        if (treeInfo.isIsLeaf()) {
            dataList.add(treeInfo.getId().toString());
        } else {
            IRptReportType iRpt = null;
            TreeBaseCollection cols = null;
            RptReportTypeInfo rptInfo2 = null;
            try {
                iRpt = RptReportTypeFactory.getLocalInstance(ctx);
                cols = iRpt.getAllChildren(treeInfo);
            }
            catch (Exception e) {
                logger.info((Object)e);
                return dataList;
            }
            for (RptReportTypeInfo rptInfo2 : cols) {
                if (!rptInfo2.isIsLeaf()) continue;
                dataList.add(rptInfo2.getId().toString());
            }
        }
        return dataList;
    }

    public AbstractObjectCollection getPermissionChild(Context ctx, TreeBaseInfo parentNodeInfo, int level, FilterInfo filter) throws BOSException, EASBizException {
        AbstractObjectCollection cols = this.getChildren(ctx, parentNodeInfo, level, filter);
        RptReportTypeCollection tempCols = null;
        if (cols != null) {
            tempCols = new RptReportTypeCollection();
            for (RptReportTypeInfo rrInfo : cols) {
                if (rrInfo.isIsLeaf() && rrInfo.isIsBusiness()) {
                    if (!this.checkHasBizReport(ctx, rrInfo)) continue;
                    tempCols.addObject((IObjectValue)rrInfo);
                    continue;
                }
                tempCols.addObject((IObjectValue)rrInfo);
            }
        }
        this.checkTreeNode(ctx, tempCols);
        return tempCols;
    }

    private AbstractObjectCollection getChildren(Context ctx, TreeBaseInfo parentNodeInfo, int level, FilterInfo filter) throws BOSException {
        EntityViewInfo viewInfo = this.getViewInfo(parentNodeInfo, level);
        if (parentNodeInfo != null && filter != null && filter.size() > 0) {
            viewInfo.getFilter().mergeFilter(filter, "AND");
        }
        RptReportTypeCollection result = RptReportTypeFactory.getLocalInstance(ctx).getRptReportTypeCollection(viewInfo);
        return result;
    }

    private EntityViewInfo getViewInfo(TreeBaseInfo parentNodeInfo, int level) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(new FilterInfo());
        if (parentNodeInfo != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(parentNodeInfo.getLongNumber() + "!%"), CompareType.LIKE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel()), CompareType.GREATER));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(parentNodeInfo.getLevel() + level), CompareType.LESS_EQUALS));
        } else {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(level), CompareType.LESS_EQUALS));
        }
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        viewInfo.getSorter().add(new SorterItemInfo("longNumber"));
        return viewInfo;
    }
}

