/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.ba.IRptRelease;
import com.kingdee.eas.cp.ba.IRptReportType;
import com.kingdee.eas.cp.ba.RptReleaseException;
import com.kingdee.eas.cp.ba.RptReleaseFactory;
import com.kingdee.eas.cp.ba.RptReleaseInfo;
import com.kingdee.eas.cp.ba.RptReleaseUploadInfo;
import com.kingdee.eas.cp.ba.RptReportTypeFactory;
import com.kingdee.eas.cp.ba.RptReportTypeInfo;
import com.kingdee.eas.cp.ba.RptTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import java.util.Locale;

class RptReleaseAppHandle
implements Serializable {
    private static final String RES = "com.kingdee.eas.cp.ba.client.RptResource";

    RptReleaseAppHandle() {
    }

    protected void rptReleaseReport(Context ctx, RptReleaseInfo rptReleaseInfo, File[] files) throws Exception {
        if (rptReleaseInfo == null || files == null || files.length <= 0) {
            return;
        }
        BOSUuid boID = null;
        IRptReportType iRpt = null;
        IRptRelease iRptRelease = null;
        File tempFile = null;
        for (int i = 0; i < files.length; ++i) {
            boID = BOSUuid.create((BOSObjectType)rptReleaseInfo.getBOSType());
            tempFile = files[i];
            this.addNewAttachment(ctx, tempFile, boID.toString());
            rptReleaseInfo.setId(boID);
            this.initRptReleaseInfo(tempFile, rptReleaseInfo);
            iRpt = RptReportTypeFactory.getLocalInstance(ctx);
            this.rptReportTypeTreeHandle(iRpt, rptReleaseInfo);
            iRptRelease = RptReleaseFactory.getLocalInstance(ctx);
            iRptRelease.addnew((CoreBaseInfo)rptReleaseInfo);
        }
    }

    private String addNewAttachment(Context ctx, File file, String boId) throws Exception {
        if (file == null) {
            throw new RptReleaseException(RptReleaseException.TEMPFILL_ERROR);
        }
        String fullname = file.getName();
        String mainname = StringUtil4File.getMainFileName((String)fullname);
        String extname = StringUtil4File.getExtendedFileName((String)fullname);
        byte[] content = null;
        try {
            byte[] b = null;
            FileInputStream fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            long size = fc.size();
            b = new byte[new Long(size).intValue()];
            MappedByteBuffer mbb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            mbb.get(b);
            mbb.clear();
            fc.close();
            fis.close();
            content = b;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SimpleAttachmentInfo sai = new SimpleAttachmentInfo();
        sai.setMainName(mainname);
        sai.setExtName(extname);
        sai.setContent(content);
        sai.setIsShared(false);
        return this.addNewAttachment(ctx, boId, sai);
    }

    private String addNewAttachment(Context ctx, String boID, SimpleAttachmentInfo sai) throws BOSException, EASBizException {
        String attchID = "";
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        attchID = asm.addNewAttachment(ctx, boID, sai);
        return attchID;
    }

    private void initRptReleaseInfo(File tempFile, RptReleaseInfo rrInfo) {
        String filePath = tempFile.getPath();
        if (filePath.endsWith(".xls")) {
            rrInfo.setReleaseType(RptTypeEnum.SNAP_EXCEL_MODE);
        } else if (filePath.endsWith(".html") || filePath.endsWith(".htm")) {
            rrInfo.setReleaseType(RptTypeEnum.SNAP_HTML_MODE);
        } else if (filePath.endsWith(".doc")) {
            rrInfo.setReleaseType(RptTypeEnum.SNAP_WORD_MODE);
        }
        rrInfo.setName(StringUtil4File.getMainFileName((String)tempFile.getName()));
        rrInfo.setFromSys(ResourceBase.getString((String)RES, (String)"rpttype_outside", (Locale)LocaleUtils.getLocale((String)"l1")), LocaleUtils.getLocale((String)"l1"));
        rrInfo.setFromSys(ResourceBase.getString((String)RES, (String)"rpttype_outside", (Locale)LocaleUtils.getLocale((String)"l2")), LocaleUtils.getLocale((String)"l2"));
        rrInfo.setFromSys(ResourceBase.getString((String)RES, (String)"rpttype_outside", (Locale)LocaleUtils.getLocale((String)"l3")), LocaleUtils.getLocale((String)"l3"));
    }

    private void rptReportTypeTreeHandle(IRptReportType iRpt, RptReleaseInfo info) throws EASBizException, BOSException {
        if (info == null) {
            return;
        }
        RptReportTypeInfo newInfo2 = null;
        RptReportTypeInfo tempInfo = null;
        TreeBaseCollection cols = null;
        RptReportTypeInfo rptInfo = info.getRptSort();
        cols = iRpt.getChildren(rptInfo);
        for (RptReportTypeInfo newInfo2 : cols) {
            if (newInfo2.getName() != null && newInfo2.getName().equals(info.getType()) && newInfo2.isIsBusiness()) {
                info.setRptSort(newInfo2);
                break;
            }
            newInfo2 = null;
        }
        if (newInfo2 != null) {
            return;
        }
        tempInfo = new RptReportTypeInfo();
        tempInfo.setParent(info.getRptSort());
        String number = String.valueOf(new Date().getTime());
        tempInfo.setName(info.getType(LocaleUtils.getLocale((String)"l1")), LocaleUtils.getLocale((String)"l1"));
        tempInfo.setName(info.getType(LocaleUtils.getLocale((String)"l2")), LocaleUtils.getLocale((String)"l2"));
        tempInfo.setName(info.getType(LocaleUtils.getLocale((String)"l3")), LocaleUtils.getLocale((String)"l3"));
        tempInfo.setNumber(number);
        tempInfo.setIsLeaf(true);
        tempInfo.setIsStart(1);
        tempInfo.setIsBusiness(true);
        if (info.getRptSort().getLevel() == 2) {
            tempInfo.setIsPortlet(true);
        } else {
            tempInfo.setIsPortlet(false);
        }
        IObjectPK tempPK = iRpt.addnew((CoreBaseInfo)tempInfo);
        info.setRptSort((RptReportTypeInfo)iRpt.getTreeBaseInfo(tempPK));
    }

    protected String addNewOutsideReport(IRptRelease iRpt, IAttachment iAtt, IRptReportType iRptType, RptReleaseUploadInfo outsideReport) throws EASBizException, BOSException {
        if (outsideReport == null) {
            return null;
        }
        RptReleaseInfo relInfo = outsideReport.getRelInfo();
        AttachmentInfo attInfo = outsideReport.getAttInfo();
        this.rptReportTypeTreeHandle(iRptType, relInfo);
        iRpt.addnew((CoreBaseInfo)relInfo);
        iAtt.addnew(attInfo);
        return null;
    }
}

