/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.ba.RptReleaseException;
import com.kingdee.eas.cp.ba.RptReleaseFactory;
import com.kingdee.eas.cp.ba.RptReleaseInfo;
import com.kingdee.eas.cp.ba.RptTypeEnum;
import com.kingdee.eas.cp.ba.app.AbstractRptReleaseControllerBean;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class RptReleaseControllerBean
extends AbstractRptReleaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.ba.app.RptReleaseControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            RptReleaseInfo rrInfo = RptReleaseFactory.getLocalInstance(ctx).getRptReleaseInfo(pk);
            if (rrInfo == null) {
                return;
            }
            if (RptTypeEnum.SNAP_HTML_MODE.equals((Object)rrInfo.getReleaseType()) || RptTypeEnum.SNAP_EXCEL_MODE.equals((Object)rrInfo.getReleaseType())) {
                this.deleteAttachment(ctx, rrInfo.getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RptReleaseInfo relInfo = null;
        if (model == null || !(model instanceof RptReleaseInfo)) {
            throw new RptReleaseException(RptReleaseException.RELEASEINFO_NOT_NULL);
        }
        relInfo = (RptReleaseInfo)model;
        if (RptTypeEnum.SNAP_HTML_MODE.equals((Object)relInfo.getReleaseType()) || RptTypeEnum.SNAP_EXCEL_MODE.equals((Object)relInfo.getReleaseType())) {
            this.checkStaticInfo(relInfo);
        } else {
            this.checkLinkedInfo(relInfo);
        }
        return super._submit(ctx, model);
    }

    private void checkStaticInfo(RptReleaseInfo relInfo) {
    }

    private void checkLinkedInfo(RptReleaseInfo relInfo) {
    }

    private void deleteAttachment(Context ctx, BOSUuid bizID) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("boID", (Object)bizID));
        filterInfo.setMaskString(" #0 ");
        ev.setFilter(filterInfo);
        BoAttchAssoCollection cols = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoCollection(ev);
        if (cols == null || cols.size() <= 0) {
            return;
        }
        BoAttchAssoInfo info = null;
        Iterator ite = cols.iterator();
        IAttachment iatt = AttachmentFactory.getLocalInstance((Context)ctx);
        while (ite.hasNext()) {
            info = (BoAttchAssoInfo)ite.next();
            iatt.delete((IObjectPK)new ObjectUuidPK(info.getAttachment().getId()));
        }
    }
}

