/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.ba.app.AbstractRptSolutionControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class RptSolutionControllerBean
extends AbstractRptSolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.ba.app.RptSolutionControllerBean");

    @Override
    protected void _saveSolutionData(Context ctx, String id, byte[] solutionDate) throws BOSException, EASBizException {
        PreparedStatement ps = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            String sql = "update T_BA_RptSolution set FSolutionData = ? where FID = ?";
            ps = connection.prepareStatement(sql);
            if (solutionDate == null) {
                ps.setBytes(1, null);
            } else {
                ps.setBinaryStream(1, (InputStream)new SerializableByteArrayInputStream(solutionDate), solutionDate.length);
            }
            ps.setString(2, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    @Override
    protected byte[] _getSolutionData(Context ctx, String id) throws BOSException, EASBizException {
        byte[] solutionData = null;
        String sql = "select FSolutionData from T_BA_RptSolution where fid = ?";
        Object[] param = new Object[1];
        Blob blog1 = null;
        param[0] = id;
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
            if (set.next() && (blog1 = set.getBlob("FSolutionData")) != null) {
                int size = new Long(blog1.length()).intValue();
                solutionData = new byte[size];
                InputStream is = blog1.getBinaryStream();
                is.read(solutionData);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getSolutionData_T_BA_RptSolution :", (Throwable)e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return solutionData;
    }
}

