/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.ba.util;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.cp.ba.RptReleaseFactory;
import com.kingdee.eas.cp.ba.RptReleaseInfo;
import com.kingdee.eas.cp.ba.RptReportException;
import com.kingdee.eas.cp.ba.RptTypeEnum;
import com.kingdee.eas.cp.ba.SourceTypeEnum;
import com.kingdee.eas.cp.ba.client.RptReportTypeTreeUI;
import com.kingdee.eas.cp.eip.fts.utils.Utils;
import com.kingdee.eas.fi.rpt.client.ReportPublishHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportHandleFactory {
    private static final Logger logger = CoreUIObject.getLogger(RptReportTypeTreeUI.class);

    public static void openStaticReport(String reportID, Component owner) {
        try {
            String attchID = ReportHandleFactory.getAttacheID(reportID);
            ReportHandleFactory.getFileGetter().viewAttachment(attchID, owner);
        }
        catch (Exception ee) {
            logger.error((Object)Utils.buildDetail((Throwable)ee));
        }
    }

    public static void openStaticReport_coalition(String reportID, Component owner) throws Exception {
        List idList = ReportHandleFactory.getAttacheIDs(reportID);
        if (idList == null || idList.size() <= 0) {
            throw new RptReportException(RptReportException.NOT_ATTACHEMENT);
        }
        int j = idList.size();
        for (int i = 1; i < j; ++i) {
            ReportHandleFactory.getFileGetter().downloadAttachment((String)idList.get(i));
        }
        String attchID = (String)idList.get(0);
        ReportHandleFactory.getFileGetter().viewAttachment(attchID, owner);
    }

    public static void openDynamicReport(String releaseType, String uiClassName, Object querySolution, String oprt) throws UIException {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("QuerySolution", querySolution);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)oprt).create(uiClassName, ctx, null, OprtState.VIEW);
        if (uiWindow != null) {
            uiWindow.show();
        }
    }

    public static void openDynamicReport(Map ctx, String uiClassName, String querySolution, SourceTypeEnum sourceType, String oprt) throws Exception {
        if (SourceTypeEnum.USER_DEFINED_TYPE.equals((Object)sourceType)) {
            ReportHandleFactory.openDynamicReport_UserDefined(ctx, uiClassName, querySolution);
        } else if (SourceTypeEnum.COALITION_TYPE.equals((Object)sourceType)) {
            ReportHandleFactory.openDynamicReport_UserDefined(ctx, uiClassName, querySolution);
        } else if (SourceTypeEnum.DEFAULT_TYPE.equals((Object)sourceType)) {
            ReportHandleFactory.openDynamicReport_Default(ctx, uiClassName, querySolution, oprt);
        }
    }

    public static void openDynamicReport(Map ctx, String uiClassName, Object querySolution, SourceTypeEnum sourceType, String oprt) throws Exception {
        if (SourceTypeEnum.USER_DEFINED_TYPE.equals((Object)sourceType)) {
            ReportHandleFactory.openDynamicReport_UserDefined(ctx, uiClassName, querySolution);
        } else if (SourceTypeEnum.COALITION_TYPE.equals((Object)sourceType)) {
            ReportHandleFactory.openDynamicReport_UserDefined(ctx, uiClassName, querySolution);
        } else if (SourceTypeEnum.DEFAULT_TYPE.equals((Object)sourceType)) {
            ReportHandleFactory.openDynamicReport_Default(ctx, uiClassName, oprt);
        } else {
            ReportHandleFactory.openDynamicReport_Default(ctx, uiClassName, oprt);
        }
    }

    public static void openDynamicReport_Default(Map ctx, String uiClassName, String querySolution, String oprt) throws ParserException, UIException {
        ctx.put("RPTFilter", new EntityViewInfo(querySolution.toString()));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)oprt).create(uiClassName, ctx, null, OprtState.VIEW);
        if (uiWindow != null) {
            uiWindow.show();
        }
    }

    public static void openDynamicReport_Default(Map ctx, String uiClassName, String oprt) throws ParserException, UIException {
        IUIWindow uiWindow = UIFactory.createUIFactory((String)oprt).create(uiClassName, ctx, null, OprtState.VIEW);
        if (uiWindow != null) {
            uiWindow.show();
        }
    }

    public static void openDynamicReport_UserDefined(Map ctx, String uiClassName, String querySolution) throws Exception {
        ReportPublishHelper.showReport(ctx.get("RPTPARENTUI"), ctx.get("RPTPARENTSUPERUI"), (String)ctx.get("RPTTEMPNAME").toString(), (Object)querySolution, (String)uiClassName);
    }

    public static void openDynamicReport_UserDefined(Map ctx, String uiClassName, Object querySolution) throws Exception {
        ReportPublishHelper.showReport(ctx.get("RPTPARENTUI"), ctx.get("RPTPARENTSUPERUI"), (String)ctx.get("RPTTEMPNAME").toString(), (Object)querySolution, (String)uiClassName);
    }

    public static String getAttacheID(String seleID) throws Exception {
        IBoAttchAsso boAtt = null;
        BoAttchAssoInfo info = null;
        BoAttchAssoCollection cols = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)seleID, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        boAtt = BoAttchAssoFactory.getRemoteInstance();
        cols = boAtt.getBoAttchAssoCollection(ev);
        if (cols != null && cols.size() > 0) {
            info = cols.get(0);
        }
        if (info == null) {
            return null;
        }
        return info.getAttachment().getId().toString();
    }

    public static List getAttacheIDs(String seleID) throws Exception {
        IBoAttchAsso boAtt = null;
        BoAttchAssoInfo info2 = null;
        BoAttchAssoCollection cols = null;
        ArrayList<String> dataList = new ArrayList<String>();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)seleID, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        boAtt = BoAttchAssoFactory.getRemoteInstance();
        cols = boAtt.getBoAttchAssoCollection(ev);
        for (BoAttchAssoInfo info2 : cols) {
            dataList.add(info2.getAttachment().getId().toString());
        }
        return dataList;
    }

    private static FileGetter getFileGetter() throws Exception {
        FileGetter fg = new FileGetter(AttachmentFactory.getRemoteInstance(), AttachmentFtpFacadeFactory.getRemoteInstance());
        return fg;
    }

    public static void viewReport(Map map, String rptID, Locale locale, Component owner) throws Exception {
        RptReleaseInfo rptInfo = RptReleaseFactory.getRemoteInstance().getRptReleaseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)rptID)));
        if (rptInfo == null) {
            throw new RptReportException(RptReportException.RPT_NOT_EXIST);
        }
        if (RptTypeEnum.SNAP_LINK_MODE.equals((Object)rptInfo.getReleaseType())) {
            Map tempMap = map;
            tempMap.put("RPTTEMPNAME", rptInfo.getName(locale));
            tempMap.put("RPTPARENTUI", owner);
            tempMap.put("RPTPARENTSUPERUI", null);
            tempMap.put("canResize", "true");
            Object obj = CommonUtil.getObject((byte[])rptInfo.getParam());
            tempMap.put("RPTFilter", obj);
            ReportHandleFactory.openDynamicReport(tempMap, rptInfo.getUiClassName(), obj, rptInfo.getSourceReportType(), "com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
        } else if (SourceTypeEnum.COALITION_TYPE.equals((Object)rptInfo.getSourceReportType())) {
            ReportHandleFactory.openStaticReport_coalition(rptID, owner);
        } else {
            ReportHandleFactory.openStaticReport(rptID, owner);
        }
    }
}

