/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.AmountControlTypeEnum;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonWebUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.SourceSystem;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizCollCopyUtils {
    public static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.BizCollCopyUtils");

    public static CoreBaseInfo reduceModel(Context ctx, SysContext sysCtx, CoreBaseInfo model) throws EASBizException, BOSException {
        AbstractObjectCollection collectionEntries;
        boolean isControlPaySchedule;
        StringBuffer sb;
        HashMap<String, ExchangeRateInfo> exchangeMap = new HashMap<String, ExchangeRateInfo>();
        Boolean isEntryCurrencySameWithColl = true;
        String entryCurrencyId = null;
        BOSObjectType entryBosType = null;
        UserInfo currentUser = null;
        boolean isFromWeb = false;
        if (ctx != null) {
            isFromWeb = true;
            currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        } else if (sysCtx != null) {
            currentUser = sysCtx.getCurrentUserInfo();
        }
        Date serverDate = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        model.setDate("bizReqDate", serverDate);
        model.setDate("bizDate", serverDate);
        model.put("creator", (Object)currentUser);
        model.setTimestamp("createTime", new Timestamp(System.currentTimeMillis()));
        model.put("biller", (Object)currentUser);
        model.setDate("billDate", serverDate);
        model.put("state", (Object)StateEnum.NEW);
        model.put("sourceSystem", (Object)SourceSystem.CPBC);
        model.put("isCopy", (Object)true);
        BizCollCopyUtils.getBillName(model);
        CompanyOrgUnitInfo applierCompany = (CompanyOrgUnitInfo)model.get("appliercompany");
        String applierCompanyId = applierCompany.getId().toString();
        CurrencyInfo baseCurrency = (CurrencyInfo)model.get("currencytype");
        if (applierCompany.getBaseCurrency() != null) {
            baseCurrency = applierCompany.getBaseCurrency();
            if (baseCurrency != null && (baseCurrency.getName() == null || baseCurrency.getNumber() == null)) {
                baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()), BizCollUtil.getDefaultSelector());
            }
            model.put("currencytype", (Object)baseCurrency);
        }
        if (model.get("name") != null) {
            sb = new StringBuffer(model.get("name").toString());
            model.put("name", (Object)sb.toString());
        } else {
            sb = new StringBuffer("(");
            sb.append(EASResource.getString((String)RESBIZCOLL, (String)"copy"));
            sb.append(")");
            model.put("name", (Object)sb.toString());
        }
        String[] nullProp = new String[]{"payDate", "submitDate", "auditor", "auditDate", "lastUpdateTime", "amountBalance", "amountUsed", "sourceBillId", "imageNo", "amountPaid", "amountNotPaid", "amountEncashed", "amountSendedBack", "lastUpdateUser", "lastUpdateTime", "actionFlag", "encashedAmount", "loanAmount", "returnamount", "budgetDescription", "overAmountDesc", "voucherFlag", "amountPayable", "isRePay", "voucherNumbers", "disAuditPerson", "disAuditOption", "accessoryCount", "sourceBillType", "cqBillId", "cqBillerId", "cqTaxNumber", "cqBillIdAndNum", "cqClientId", "cqClientSecret", "disAuditAdjustOption", "adjustState", "disAuditAdjustPerson", "ivAccessoryCount", "expenseShare"};
        BizCollCopyUtils.setModelPropNull(model, nullProp);
        String[] falseProp = new String[]{"isVouchered", "isDapVouchered", "pcaVouchered", "isCreatePayBill", "isCreatePrePaymentBill", "isCreateOtherBill", "isEvaluation", "isOverBudget", "fiVouchered", "isCreatePayPlanBill", "isCallBackPayPlan", "isSetPayState", "isElectronicInvoice"};
        BizCollCopyUtils.setModelPropBoolean(model, falseProp);
        if (model.get("reqCheckEntries") != null && ((AbstractObjectCollection)model.get("ReqCheckEntries")).size() > 0) {
            ((AbstractObjectCollection)model.get("ReqCheckEntries")).clear();
        }
        if (model.get("LoanCheckEntries") != null && ((AbstractObjectCollection)model.get("LoanCheckEntries")).size() > 0) {
            ((AbstractObjectCollection)model.get("LoanCheckEntries")).clear();
        }
        if (model.get("AccountRecords") != null && ((AbstractObjectCollection)model.get("AccountRecords")).size() > 0) {
            ((AbstractObjectCollection)model.get("AccountRecords")).clear();
        }
        if (model.get("payEntries") != null && ((AbstractObjectCollection)model.get("payEntries")).size() > 0) {
            ((AbstractObjectCollection)model.get("payEntries")).clear();
        }
        if (model.get("tickeEntries") != null && ((AbstractObjectCollection)model.get("tickeEntries")).size() > 0) {
            ((AbstractObjectCollection)model.get("tickeEntries")).clear();
        }
        if (model.get("vatInvoiceEntries") != null && ((AbstractObjectCollection)model.get("vatInvoiceEntries")).size() > 0) {
            ((AbstractObjectCollection)model.get("vatInvoiceEntries")).clear();
        }
        if (model.get("acAdjustEntries") != null && ((AbstractObjectCollection)model.get("acAdjustEntries")).size() > 0) {
            ((AbstractObjectCollection)model.get("acAdjustEntries")).clear();
        }
        BigDecimal zero = new BigDecimal("0.00");
        AbstractObjectCollection entries = (AbstractObjectCollection)model.get("entries");
        if (model instanceof LoanBillInfo) {
            model.put("amountControlType", (Object)AmountControlTypeEnum.oneTOmore);
            Calendar calendar = Calendar.getInstance();
            calendar.add(2, 3);
            ((LoanBillInfo)model).setForeseeDate(calendar.getTime());
        }
        BigDecimal amountSum = zero;
        BigDecimal amountOriSum = zero;
        BigDecimal amountApprovedSum = new BigDecimal(0.0);
        ExchangeRateInfo exchangeRate1 = new ExchangeRateInfo();
        ExchangeRateInfo exchangeRateZero = new ExchangeRateInfo();
        ExchangeAuxInfo exchangeAuxInfo = new ExchangeAuxInfo();
        exchangeAuxInfo.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        exchangeAuxInfo.setPrecision(4);
        exchangeRate1.setConvertRate(new BigDecimal("1.0000"));
        exchangeRate1.setExchangeAux(exchangeAuxInfo);
        exchangeRateZero.setConvertRate(new BigDecimal("0.0000"));
        exchangeRateZero.setExchangeAux(exchangeAuxInfo);
        exchangeMap.put(baseCurrency.getId().toString(), exchangeRate1);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP016");
        paramList.add("CP008");
        paramList.add("CP00803");
        paramList.add("CP_BC_BAPS");
        paramList.add("CP_BC_TAPS");
        paramList.add("CP_BC_PAPS");
        paramList.add("CP_BC_BAOPS");
        paramList.add("CP_BC_DLPS");
        paramList.add("CP_BC_ELPS");
        Map paramMap = ExpenseCommenFacadeFactory.getRemoteInstance().getParamsForCompany(paramList, applierCompanyId);
        boolean isInitAmountApproved = paramMap.get("CP016") == null ? false : new Boolean(paramMap.get("CP016").toString());
        boolean CP008 = paramMap.get("CP008") == null ? false : new Boolean(paramMap.get("CP008").toString());
        boolean CP00803 = paramMap.get("CP00803") == null ? false : new Boolean(paramMap.get("CP00803").toString());
        boolean bl = isControlPaySchedule = CP008 && CP00803;
        if (isControlPaySchedule && model instanceof BizCollBillBaseInfo) {
            isControlPaySchedule = BizCollUtil.isControlPayPaySchedule((BizCollBillBaseInfo)model, paramMap);
        }
        model.put("isPaySchedule", (Object)isControlPaySchedule);
        if (entries != null && entries.size() > 0) {
            entryBosType = entries.getObject(0).getBOSType();
            int js = entries.size();
            for (int j = 0; j < js; ++j) {
                CoreBillEntryBaseInfo lastEntry = null;
                CoreBillEntryBaseInfo entry = (CoreBillEntryBaseInfo)entries.getObject(j);
                if (j > 0) {
                    lastEntry = (CoreBillEntryBaseInfo)entries.getObject(j - 1);
                }
                BOSUuid entryId = BOSUuid.create((BOSObjectType)entryBosType);
                entry.setId(entryId);
                entry.setNull("budgetAmount");
                entry.setNull("amountBalance");
                entry.setNull("amountBalanceOri");
                entry.setNull("amountUsed");
                entry.setNull("amountUsedOri");
                entry.setNull("sourceBillID");
                entry.setNull("sourceBillEntryID");
                entry.setNull("sourceBillNumber");
                entry.setNull("budgetBalance");
                entry.setNull("amountPaid");
                entry.setNull("ticketNumber");
                entry.setNull("ticketUrl");
                entry.setNull("entrySerialNo");
                entry.setNull("ticketCode");
                entry.setNull("ticketRandomCode");
                entry.setNull("application");
                entry.setNull("invoiceEntryId");
                entry.setNull("voucherDesc");
                entry.setNull("amountUsedOri");
                entry.setNull("budgetDoOri");
                entry.setNull("budgetUsed");
                entry.setNull("budgetUsedOri");
                entry.setNull("monthlyBalance");
                entry.setNull("travelOrders");
                entry.setNull("travelIntegrators");
                entry.setBigDecimal("budgetDo", BizCollUtil.ZERO);
                entry.setString("invoiceNum", EASResource.getString((String)RESBIZCOLL, (String)"InvoiceNum"));
                entry.setNull("entryTicNumber");
                entry.setNull("entrySerialNo");
                if (entry.get("currencyType") != null) {
                    String key;
                    if (lastEntry != null && !entry.get("currencyType").equals(lastEntry.get("currencyType"))) {
                        isEntryCurrencySameWithColl = false;
                    }
                    entryCurrencyId = key = ((CurrencyInfo)entry.get("currencyType")).getId().toString();
                    ExchangeRateInfo exchangeRate = (ExchangeRateInfo)exchangeMap.get(key);
                    if (exchangeRate == null) {
                        exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getRemoteInstance().getExRateInfo(key, null, applierCompanyId, (Date)model.get("BizReqDate"));
                        if (exchangeRate == null) {
                            exchangeRate = key.equals(baseCurrency.getId().toString()) ? exchangeRate1 : exchangeRateZero;
                        }
                        exchangeMap.put(key, exchangeRate);
                    }
                    entry.setBigDecimal("exchangeRate", exchangeRate.getConvertRate());
                    entry.setInt("exchangeRatePrecision", exchangeRate.getExchangeAux().getPrecision());
                    entry.setInt("convertMode", exchangeRate.getExchangeAux().getConvertMode().getValue());
                    BigDecimal amount = zero;
                    BigDecimal amountApproved = zero;
                    BigDecimal amountWithoutTax = zero;
                    BigDecimal amountApprovedWithoutTax = zero;
                    BigDecimal amountOri = entry.getBigDecimal("amountOri") == null ? zero : entry.getBigDecimal("amountOri");
                    BigDecimal amountApprovedOri = entry.getBigDecimal("amountApprovedOri") == null ? zero : entry.getBigDecimal("amountApprovedOri");
                    BigDecimal amountOriWithoutTax = entry.getBigDecimal("amountOriWithoutTax") == null ? zero : entry.getBigDecimal("amountOriWithoutTax");
                    BigDecimal amountApprovedOriWithoutTax = entry.getBigDecimal("amountApprovedOriWithoutTax") == null ? zero : entry.getBigDecimal("amountApprovedOriWithoutTax");
                    BigDecimal exRate = exchangeRate.getConvertRate();
                    if (exRate != null && zero.compareTo(exRate) != 0) {
                        if (exchangeRate.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                            amount = amountOri.multiply(exRate).setScale(2, 4);
                            amountWithoutTax = amountOriWithoutTax.multiply(exRate).setScale(2, 4);
                            amountApproved = amountApprovedOri.multiply(exRate).setScale(2, 4);
                            amountApprovedWithoutTax = amountApprovedOriWithoutTax.multiply(exRate).setScale(2, 4);
                        } else {
                            amount = amountOri.divide(exRate, 2, 4);
                            amountWithoutTax = amountOriWithoutTax.divide(exRate, 2, 4);
                            amountApproved = amountApprovedOri.divide(exRate, 2, 4);
                            amountApprovedWithoutTax = amountApprovedOriWithoutTax.divide(exRate, 2, 4);
                        }
                    }
                    entry.setBigDecimal("amount", amount);
                    entry.setBigDecimal("amountWithoutTax", amountWithoutTax);
                    if (isFromWeb && !isInitAmountApproved) {
                        amountApprovedOri = zero;
                        amountApprovedOriWithoutTax = zero;
                        amountApproved = zero;
                        amountApprovedWithoutTax = zero;
                        entry.setBigDecimal("taxApproved", zero);
                    }
                    entry.setBigDecimal("amountApprovedOri", amountApprovedOri);
                    entry.setBigDecimal("amountApprovedOriWithoutTax", amountApprovedOriWithoutTax);
                    entry.setBigDecimal("amountApproved", amountApproved);
                    entry.setBigDecimal("amountApprovedWithoutTax", amountApprovedWithoutTax);
                    amountSum = amountSum.add(amount);
                    amountOriSum = amountOriSum.add(amountOri);
                    amountApprovedSum = amountApprovedSum.add(amountApproved);
                }
                if (!(model instanceof ExpenseAccountBillInfo)) continue;
                entry.setDate("happenTime", DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis())));
            }
            model.put("amount", (Object)amountSum);
            model.put("amountApproved", (Object)amountApprovedSum);
            if (model instanceof ExpenseAccountBillInfo) {
                model.put("amountEncashed", (Object)amountSum);
            }
        }
        if ((collectionEntries = (AbstractObjectCollection)model.get("collectionEntries")) != null && collectionEntries.size() > 0) {
            BOSObjectType colEntryBosType = collectionEntries.getObject(0).getBOSType();
            int ks = collectionEntries.size();
            for (int k = 0; k < ks; ++k) {
                BEBankInfo beBankInfo;
                CoreBillEntryBaseInfo entry = (CoreBillEntryBaseInfo)collectionEntries.getObject(k);
                BOSUuid collectionEntryId = BOSUuid.create((BOSObjectType)colEntryBosType);
                entry.setId(collectionEntryId);
                if (entry.get("currencyType") != null) {
                    String key = ((CurrencyInfo)entry.get("currencyType")).getId().toString();
                    ExchangeRateInfo exchangeRate = (ExchangeRateInfo)exchangeMap.get(key);
                    if (exchangeRate == null) {
                        exchangeRate = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getRemoteInstance().getExRateInfo(key, null, applierCompanyId, (Date)model.get("BizReqDate"));
                        if (exchangeRate == null) {
                            exchangeRate = key.equals(baseCurrency.getId().toString()) ? exchangeRate1 : exchangeRateZero;
                        }
                        exchangeMap.put(key, exchangeRate);
                    }
                    if (exchangeRate != null && exchangeRate.get("convertRate") != null && exchangeRate.get("exchangeAux") != null) {
                        entry.setInt("exchangeRatePrecision", exchangeRate.getExchangeAux().getPrecision());
                        entry.setInt("convertMode", exchangeRate.getExchangeAux().getConvertMode().getValue());
                        entry.setBigDecimal("exchangeRate", new BigDecimal(exchangeRate.getConvertRate().toString()));
                        if (ks == 1) {
                            BigDecimal amountOri = zero;
                            if (isEntryCurrencySameWithColl.booleanValue() && key.equals(entryCurrencyId)) {
                                amountOri = amountOriSum;
                            } else {
                                BigDecimal exRate = exchangeRate.getConvertRate();
                                if (exRate != null && zero.compareTo(exRate) != 0) {
                                    amountOri = exchangeRate.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? amountSum.divide(exRate, 2, 4) : amountSum.multiply(exRate).setScale(2, 4);
                                }
                            }
                            entry.setBigDecimal("amount", amountSum.setScale(2, 4));
                            entry.setBigDecimal("amountOri", amountOri.setScale(2, 4));
                        } else {
                            BigDecimal amount = zero;
                            BigDecimal amountOri = entry.getBigDecimal("amountOri") == null ? new BigDecimal(0.0) : entry.getBigDecimal("amountOri");
                            BigDecimal exRate = exchangeRate.getConvertRate();
                            if (exRate != null && zero.compareTo(exRate) != 0) {
                                amount = exchangeRate.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? amountOri.multiply(exRate).setScale(2, 4) : amountOri.divide(exRate, 2, 4);
                            }
                            entry.setBigDecimal("amount", amount.setScale(2, 4));
                        }
                    }
                }
                if (entry.get("payerbankf7") == null || ((beBankInfo = (BEBankInfo)entry.get("payerbankf7")).getName() == null || beBankInfo.getName().equals(entry.get("payerbank"))) && (beBankInfo.getName() != null || entry.get("payerbank") == null)) continue;
                entry.setString("payerbank", beBankInfo.getName());
            }
        }
        return model;
    }

    public static void reduceModels(Context ctx, SysContext sysCtx, List<CoreBaseInfo> models) throws EASBizException, BOSException {
        int is = models.size();
        for (int i = 0; i < is; ++i) {
            CoreBaseInfo model = models.get(i);
            BizCollCopyUtils.reduceModel(ctx, sysCtx, model);
        }
    }

    public static void setModelPropNull(CoreBaseInfo model, String[] props) {
        int il = props.length;
        for (int i = 0; i < il; ++i) {
            if (model.get(props[i]) == null) continue;
            model.setNull(props[i]);
        }
    }

    public static void setModelPropBoolean(CoreBaseInfo model, String[] props) {
        int il = props.length;
        for (int i = 0; i < il; ++i) {
            if (model.get(props[i]) == null) continue;
            model.setBoolean(props[i], false);
        }
    }

    public static void getBillName(CoreBaseInfo billInfo) {
        String name = "CPBCBILL";
        Locale local = SysContext.getSysContext().getOriginLocale();
        if (billInfo instanceof OtherExpenseBillInfo) {
            name = ResourceBase.getString((String)RESBIZCOLL, (String)"OtherExpenseBill", (Locale)local);
        } else if (billInfo instanceof EvectionReqBillInfo) {
            name = ResourceBase.getString((String)RESBIZCOLL, (String)"EvectionReqBill", (Locale)local);
        } else if (billInfo instanceof DailyLoanBillInfo) {
            name = ResourceBase.getString((String)RESBIZCOLL, (String)"DailyLoanBill", (Locale)local);
        } else if (billInfo instanceof EvectionLoanBillInfo) {
            name = ResourceBase.getString((String)RESBIZCOLL, (String)"EvectionLoanBill", (Locale)local);
        } else if (billInfo instanceof BizAccountBillInfo) {
            name = ResourceBase.getString((String)RESBIZCOLL, (String)"bizBill", (Locale)local);
        } else if (billInfo instanceof BizAccountOutBillInfo) {
            name = ResourceBase.getString((String)RESBIZCOLL, (String)"BizAccountOutBill", (Locale)local);
        } else if (billInfo instanceof DailyPurchaseAccountBillInfo) {
            name = ResourceBase.getString((String)RESBIZCOLL, (String)"DailyPurchaseAccountBill", (Locale)local);
        } else if (billInfo instanceof TravelAccountBillInfo) {
            name = ResourceBase.getString((String)RESBIZCOLL, (String)"TravelAccountBill", (Locale)local);
        }
        billInfo.put("name", (Object)name);
    }
}

