/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountStandardFactory;
import com.kingdee.eas.cp.bc.BizAccountBillEntryCollection;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountBillLoanCheckEntryCollection;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ControlMethod;
import com.kingdee.eas.cp.bc.ControlType;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractBizAccountBillControllerBean;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizAccountBillControllerBean
extends AbstractBizAccountBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.BizAccountBillControllerBean");

    @Override
    protected void checkEntry(ExpenseAccountBillInfo model) throws BOSException, EASBizException {
        BizAccountBillInfo info = (BizAccountBillInfo)model;
        BizAccountBillEntryInfo entry = null;
        for (int i = info.getEntries().size() - 1; i > -1; --i) {
            entry = info.getEntries().get(i);
            if (entry.getHappenTime() == null) {
                throw new ExpAccException(ExpAccException.HAPPENDATA_NOT_NULL);
            }
            if (!StringUtils.isEmpty((String)entry.getComment()) && entry.getComment().length() > 200) {
                throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
            }
            if (!StringUtils.isEmpty((String)entry.getParticipants()) && entry.getParticipants().length() > 80) {
                throw new ExpAccException(ExpAccException.PARTICIPANT_TOO_LONG);
            }
            if (entry.getCostCenter() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COSTCENTER_NOT_NULL);
            }
            if (entry.getCompany() != null) continue;
            throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
        }
    }

    @Override
    protected void checkSaveEntry(ExpenseAccountBillInfo model) throws BOSException, EASBizException {
        super.checkSaveEntry(model);
        BizAccountBillInfo info = (BizAccountBillInfo)model;
        BizAccountBillEntryInfo entry = null;
        for (int i = info.getEntries().size() - 1; i > -1; --i) {
            entry = info.getEntries().get(i);
            if (StringUtils.isEmpty((String)entry.getComment()) || entry.getComment().length() <= 200) continue;
            throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
        }
    }

    @Override
    protected void checkBillValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBillValidate(ctx, model);
        BizAccountBillInfo info = (BizAccountBillInfo)model;
        String sourceId = info.getSourceBillId();
        BizAccountBillEntryInfo entry = null;
        if (info.getApplierCompany() == null) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTNULL);
        }
        if (info.getNumber() == null) {
            throw new ExpAccException(DailyLoanBillException.NUMBER_NOT_NULL);
        }
        if (info.getPrior() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_PRIOR_EXCEPTION);
        }
        if (info.getCurrencyType() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_CURRENCY_EXCEPTION);
        }
        if (info.getBizReqDate() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDATE_EXCEPTION);
        }
        if (info.getApplier() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_APLLIER_EXCEPTION);
        }
        if (info.getOrgUnit() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDEPT_EXCEPTION);
        }
        for (int i = info.getEntries().size() - 1; i > -1; --i) {
            entry = info.getEntries().get(i);
            if (entry.getHappenTime() == null) {
                throw new ExpAccException(ExpAccException.HAPPENDATA_NOT_NULL);
            }
            if (!StringUtils.isEmpty((String)entry.getComment()) && entry.getComment().length() > 200) {
                throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
            }
            if (entry.getCurrencyType() == null) {
                throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
            }
            if (entry.getCostCenter() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entry.getCompany() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entry.getExpenseType() == null) {
                throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
            }
            if (sourceId != null) {
                if (entry.getAmount() == null) {
                    throw new ExpAccException(ExpAccException.AMOUNTNOTLESSTHENZERO);
                }
            } else if (entry.getAmount() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (BizCollUtil.bigDecimalObjectLessThan(entry.getAmountApproved(), entry.getAmount())) continue;
            throw new BizCollException(BizCollException.CHECKAMOUNT_LESS_APPROVEDAMOUNT, new Object[]{i + 1, entry.getAmountApproved(), entry.getAmount()});
        }
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizAccountBillInfo info = (BizAccountBillInfo)model;
        BizAccountBillLoanCheckEntryCollection loanCheckEntries = info.getLoanCheckEntries();
        if (null != loanCheckEntries && loanCheckEntries.size() > 0) {
            info.setIsRelevanceLoan(true);
        } else {
            info.setIsRelevanceLoan(false);
        }
        this.savaAccesoryCount(ctx, info);
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizAccountBillInfo info = (BizAccountBillInfo)model;
        BizAccountBillLoanCheckEntryCollection loanCheckEntries = info.getLoanCheckEntries();
        if (null != loanCheckEntries && loanCheckEntries.size() > 0) {
            info.setIsRelevanceLoan(true);
        } else {
            info.setIsRelevanceLoan(false);
        }
        this.savaAccesoryCount(ctx, info);
        IObjectPK retValue = super._submit(ctx, model);
        return retValue;
    }

    @Override
    protected void checkForSubmit(Context ctx, BizCollBillBaseInfo infoOld, BizCollBillBaseInfo info) throws EASBizException, BOSException {
        super.checkForSubmit(ctx, infoOld, info);
        if (info.getBoolean("isBatchSubmit") && this.isAccountStandard) {
            this.validateAccountStandard(ctx, (BizAccountBillInfo)info, (BizAccountBillInfo)infoOld);
        }
    }

    protected void validateAccountStandard(Context ctx, BizAccountBillInfo info, BizAccountBillInfo infoOld) throws EASBizException, BOSException {
        PersonInfo applier = info.getApplier();
        HashMap<String, Map> accountStandards = new HashMap<String, Map>();
        BizAccountBillEntryCollection entries = (BizAccountBillEntryCollection)((Object)info.get("entries"));
        BizAccountBillEntryCollection entriesNew = new BizAccountBillEntryCollection();
        int entriesSize = entries.size();
        for (int i = 0; i < entriesSize; ++i) {
            BizAccountBillEntryInfo entry = entries.get(i);
            ExpenseTypeInfo expenseType = entry.getExpenseType();
            CurrencyInfo currencyType = entry.getCurrencyType();
            Date happenTime = entry.getHappenTime();
            if (currencyType == null || happenTime == null || expenseType == null || expenseType.getControlType() == null || ControlType.No.equals((Object)expenseType.getControlType())) continue;
            BizAccountBillEntryInfo entryInfo = new BizAccountBillEntryInfo();
            entryInfo.setId(entry.getId());
            entryInfo.setExpenseType(expenseType);
            entryInfo.setCurrencyType(currencyType);
            entryInfo.setHappenTime(happenTime);
            entryInfo.setAmountOri(entry.getAmountOri());
            entriesNew.add(entryInfo);
        }
        if (entriesNew.isEmpty()) {
            return;
        }
        BizAccountBillInfo infoNew = new BizAccountBillInfo();
        infoNew.setId(info.getId());
        infoNew.setApplier(applier);
        infoNew.setApplierCompany(info.getApplierCompany());
        infoNew.put("entries", (Object)entriesNew);
        List accountStandardList = AccountStandardFactory.getLocalInstance(ctx).fetchAccountStandard((IObjectValue)infoNew);
        boolean isSubmited = infoOld != null && StateEnum.SUBMIT.equals((Object)infoOld.getState());
        HashMap<String, Map> keyLimitAmount = new HashMap<String, Map>();
        int resultSize = accountStandardList.size();
        for (int j = 0; j < resultSize; ++j) {
            Map result = (Map)accountStandardList.get(j);
            if (result == null) continue;
            ExpenseTypeInfo expenseType = (ExpenseTypeInfo)result.get("expenseType");
            CurrencyInfo currencyType = (CurrencyInfo)result.get("currencyInfo");
            String mapKey = this.buildMapKey(applier, expenseType, currencyType, entriesNew.get(j).getHappenTime());
            if (isSubmited) {
                BigDecimal amountOri = entriesNew.get(j).getAmountOri();
                result.put("amountbalance", amountOri.add((BigDecimal)result.get("amountbalance")));
                result.put("totalAmount", ((BigDecimal)result.get("totalAmount")).subtract(amountOri));
            }
            accountStandards.put(mapKey, result);
            ControlMethod controlMethod = expenseType.getControlMethod();
            if (controlMethod.getValue() != 0) continue;
            int curMonth = Integer.parseInt(mapKey.substring(mapKey.length() - 4, mapKey.length() - 2));
            String commonKey = mapKey.substring(0, mapKey.length() - 4);
            Map accountStandard = (Map)keyLimitAmount.get(commonKey);
            if (accountStandard != null) {
                int month = (Integer)accountStandard.get("curMonth");
                if (curMonth <= month) continue;
                result.put("curMonth", curMonth);
                keyLimitAmount.put(commonKey, result);
                continue;
            }
            result.put("curMonth", curMonth);
            keyLimitAmount.put(commonKey, result);
        }
        HashMap<String, BigDecimal> balanceInfo = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> keyTotalAmount = new HashMap<String, BigDecimal>();
        for (int j = 0; j < entriesSize; ++j) {
            Date happenTime;
            CurrencyInfo currencyType;
            BizAccountBillEntryInfo entry = entries.get(j);
            ExpenseTypeInfo expenseType = entry.getExpenseType();
            String mapKey = this.buildMapKey(applier, expenseType, currencyType = entry.getCurrencyType(), happenTime = entry.getHappenTime());
            Map accountStandard = (Map)accountStandards.get(mapKey);
            if (accountStandard == null) continue;
            BigDecimal amountOri = entry.getAmountOri();
            BigDecimal accountBalance = null;
            accountBalance = balanceInfo.get(mapKey) != null ? (BigDecimal)balanceInfo.get(mapKey) : (BigDecimal)accountStandard.get("amountbalance");
            ControlMethod controlMethod = expenseType.getControlMethod();
            if (controlMethod.getValue() == 0) {
                String commonKey = mapKey.substring(0, mapKey.length() - 4);
                if (keyTotalAmount.containsKey(commonKey)) {
                    keyTotalAmount.put(commonKey, ((BigDecimal)keyTotalAmount.get(commonKey)).add(amountOri));
                    amountOri = (BigDecimal)keyTotalAmount.get(commonKey);
                } else {
                    keyTotalAmount.put(commonKey, amountOri);
                }
                if (keyLimitAmount.get(commonKey) != null) {
                    accountStandard = (Map)keyLimitAmount.get(commonKey);
                    accountBalance = (BigDecimal)accountStandard.get("amountbalance");
                }
                if (accountStandard.get("curMonth") != null) {
                    int curMonth = (Integer)accountStandard.get("curMonth");
                    mapKey = curMonth < 10 ? commonKey + "0" + curMonth + ".0" : commonKey + curMonth + ".0";
                }
            }
            accountBalance = accountBalance.subtract(amountOri);
            balanceInfo.put(mapKey, accountBalance);
            if (accountBalance.compareTo(BizCollUtil.ZERO) >= 0) continue;
            ControlType controlType = (ControlType)((Object)accountStandard.get("controlType"));
            if (controlType.getValue() == 1) {
                throw new StandardException(StandardException.EXCEED_LIMIT_NOT_SUBMIT);
            }
            if (controlType.getValue() == 2) {
                if (!StringUtils.isEmpty((String)info.getOverAmountDesc())) continue;
                throw new StandardException(StandardException.EXCEED_LIMIT_FILL_EXPLANATION_AND_SUBMIT);
            }
            if (controlType.getValue() != 3) continue;
            throw new StandardException(StandardException.EXCEED_LIMIT_COMFIRM_SUBMIT);
        }
    }

    protected String buildMapKey(PersonInfo applier, ExpenseTypeInfo expenseType, CurrencyInfo currency, Date happenTime) {
        if (applier == null || expenseType == null || currency == null) {
            return "";
        }
        String mapKey = applier.getId() + "." + expenseType.getNumber() + "." + currency.getNumber();
        ControlMethod controlMethod = expenseType.getControlMethod();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(happenTime);
        String month = calendar.get(2) + 1 + "";
        if (month.length() == 1) {
            month = '0' + month;
        }
        if (controlMethod.getValue() == 0) {
            mapKey = mapKey + "." + calendar.get(1) + "." + month + ".0";
        } else if (controlMethod.getValue() == 1) {
            mapKey = mapKey + "." + calendar.get(1) + "." + month + ".1";
        }
        return mapKey;
    }

    @Override
    protected String getPermItemName() {
        return "cp_bc_ExpenseAccount_Update";
    }
}

