/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AmountControlTypeEnum;
import com.kingdee.eas.cp.bc.BizCollRptUtil;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IntvlType;
import com.kingdee.eas.cp.bc.app.AbstractBizListRptFacadeControllerBean;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizListRptFacadeControllerBean
extends AbstractBizListRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.BizListRptFacadeControllerBean");
    public static final String SEVSOURCE = "com.kingdee.eas.cp.bc.BizCollResource";
    boolean CostCompanyIndex;
    boolean CostCenterIndex;
    boolean EntryCompanyIndex;
    boolean EntryCostCenterIndex;
    boolean ApplierCompanyIndex;
    boolean OrgUnitIndex;
    boolean ExpenseTypeIndex;
    boolean OperationTypeIndex;
    Boolean isApplier = false;
    Boolean isBillNumber = false;
    boolean isDelimitOrgScope = false;
    boolean ViewAdminOrgShowByRange = false;
    StringBuffer sqlstr = new StringBuffer();
    String ApplierEndString = "{[Applier].[" + BizCollRptUtil.ALIAS_TOTAL + "]}";
    String isBillNumberEndString = "{[BillNumber].[" + BizCollRptUtil.ALIAS_TOTAL + "]}";
    String CurrencyTypeEndString = "{[CurrencyType].[" + BizCollRptUtil.ALIAS_TOTAL + "]}";
    Map<Object, Object> tableStyle;
    Map<String, String> dimensionName = new HashMap<String, String>();

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        Object[][] tableValue = (Object[][])params.getObjectElement("kDTable1.value");
        this.initDimensionName(ctx);
        this.tableStyle = this.getTableStyle(tableValue);
        Locale local = ctx.getLocale();
        this.ApplierCompanyIndex = this.tableStyle.containsKey(ResourceBase.getString((String)SEVSOURCE, (String)"ApplierCompany", (Locale)local));
        this.OrgUnitIndex = this.tableStyle.containsKey(ResourceBase.getString((String)SEVSOURCE, (String)"OrgUnit", (Locale)local));
        this.CostCompanyIndex = this.tableStyle.containsKey(ResourceBase.getString((String)SEVSOURCE, (String)"CostCompany", (Locale)local));
        this.CostCenterIndex = this.tableStyle.containsKey(ResourceBase.getString((String)SEVSOURCE, (String)"CostCenter", (Locale)local));
        this.EntryCompanyIndex = this.tableStyle.containsKey(ResourceBase.getString((String)SEVSOURCE, (String)"EntryCompany", (Locale)local));
        this.EntryCostCenterIndex = this.tableStyle.containsKey(ResourceBase.getString((String)SEVSOURCE, (String)"EntryCostCenter", (Locale)local));
        this.ExpenseTypeIndex = this.tableStyle.containsKey(ResourceBase.getString((String)SEVSOURCE, (String)"EntryExpenseType", (Locale)local));
        this.OperationTypeIndex = this.tableStyle.containsKey(ResourceBase.getString((String)SEVSOURCE, (String)"EntryOperationType", (Locale)local));
        this.isApplier = (Boolean)params.getObjectElement("kDCBIsApplier.value");
        this.isBillNumber = (Boolean)params.getObjectElement("kDCBIsBillNumber.value");
        if (this.isBillNumber == null) {
            this.isBillNumber = false;
        }
        Boolean isMonth = (Boolean)params.getObjectElement("kdrbMonth.value");
        Boolean isQuarter = (Boolean)params.getObjectElement("kdrbQuarter.value");
        Boolean isYear = (Boolean)params.getObjectElement("kdrbYear.value");
        Boolean isPeriod = (Boolean)params.getObjectElement("kdrbPeriod.value");
        Date dateBegin = (Date)params.getObjectElement("kddpBegin.value");
        Date dateEnd = (Date)params.getObjectElement("kddpEnd.value");
        HashMap<String, Boolean> periodMap = new HashMap<String, Boolean>();
        periodMap.put("isMonth", isMonth);
        periodMap.put("isQuarter", isQuarter);
        periodMap.put("isYear", isYear);
        periodMap.put("isPeriod", isPeriod);
        Set companyIdSet = (Set)params.getObject("companyIdSet");
        Set payModeIdSet = (Set)params.getObject("payModeIdSet");
        Set applierCompanyIdSet = (Set)params.getObject("applierCompanyIdSet");
        Set applierIdSet = (Set)params.getObject("applierIdSet");
        Set currencyIdSet = (Set)params.getObject("currencyIdSet");
        Set currencyId1Set = (Set)params.getObject("currencyId1Set");
        Set applierOrgUnitIdSet = (Set)params.getObject("applierOrgUnitIdSet");
        Set costedDeptIdSet = (Set)params.getObject("costedDeptIdSet");
        Set expenseTypeIdSet = (Set)params.getObject("expenseTypeIdSet");
        Set operationTypeIdSet = (Set)params.getObject("operationTypeIdSet");
        Set entryCompanyIdSet = (Set)params.getObject("entryCompanyIdSet");
        Set entryCostedDeptIdSet = (Set)params.getObject("entryCostedDeptIdSet");
        Set stateSet = (Set)params.getObject("stateSet");
        IntvlType periodType = (IntvlType)params.getObjectElement("kdcbCountPeriodType.value");
        IntvlType amountControl = (IntvlType)params.getObjectElement("kdcbAmountControlType.value");
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        this.initParam(ctx);
        if ((applierOrgUnitIdSet == null || applierOrgUnitIdSet.size() == 0) && this.ViewAdminOrgShowByRange) {
            String orgUnitFilter = this.getOrgUnitFilter(ctx);
            filterMap.put("applierOrgUnitIdSql", orgUnitFilter);
        }
        filterMap.put("companyIdSet", companyIdSet);
        filterMap.put("payModeIdSet", payModeIdSet);
        filterMap.put("applierCompanyIdSet", applierCompanyIdSet);
        filterMap.put("applierIdSet", applierIdSet);
        filterMap.put("currencyIdSet", currencyIdSet);
        filterMap.put("currencyId1Set", currencyId1Set);
        filterMap.put("amountControl", amountControl);
        filterMap.put("applierOrgUnitIdSet", applierOrgUnitIdSet);
        filterMap.put("costedDeptIdSet", costedDeptIdSet);
        filterMap.put("expenseTypeIdSet", expenseTypeIdSet);
        filterMap.put("operationTypeIdSet", operationTypeIdSet);
        filterMap.put("entryCompanyIdSet", entryCompanyIdSet);
        filterMap.put("entryCostedDeptIdSet", entryCostedDeptIdSet);
        filterMap.put("stateSet", stateSet);
        String configFile = "BizListRptConfig.xml";
        StringBuffer sql = new StringBuffer();
        StringBuffer mdx = new StringBuffer();
        SchemaSource ss = new SchemaSource();
        this.registerNodeByNeedFilter(ctx, sql, ss);
        sql = this.getDataItemQuarterSql(ctx, dateBegin, dateEnd, periodMap, periodType, sql);
        ss.setDataItem("Quarter", sql.toString(), null);
        sql = this.getDataItemFactSql(ctx, dateBegin, dateEnd, periodMap, periodType, filterMap, sql);
        ss.setDataItem("Fact", sql.toString(), null);
        mdx.append(this.getMdx(this.isApplier, ctx));
        ss.setCaller(BizListRptFacadeControllerBean.class);
        ss.setFilename(configFile);
        logger.error((Object)mdx.toString());
        ss.setMdx(mdx.toString());
        this.setConfigXmlDim(ss, this.isApplier, ctx);
        return ss;
    }

    private StringBuffer getDataItemFactSql(Context ctx, Date dateBegin, Date dateEnd, Map periodMap, IntvlType periodType, Map filterMap, StringBuffer sql) throws EASBizException, BOSException {
        int i;
        Calendar calendarBegin = Calendar.getInstance();
        Calendar calendarEnd = Calendar.getInstance();
        int currentYear = DateTimeUtils.getYear((Date)calendarBegin.getTime());
        int currentQuarter = DateTimeUtils.getQuarter((Date)calendarBegin.getTime());
        if ("isMonth".equals(this.getPeriodType(periodMap))) {
            calendarBegin.set(5, 1);
        } else if ("isQuarter".equals(this.getPeriodType(periodMap))) {
            calendarBegin.set(5, 1);
            calendarBegin.set(2, (currentQuarter - 1) * 3);
        } else if ("isYear".equals(this.getPeriodType(periodMap))) {
            calendarBegin.set(5, 1);
            calendarBegin.set(2, 0);
            calendarBegin.set(1, currentYear);
        } else if ("isPeriod".equals(this.getPeriodType(periodMap))) {
            calendarBegin.setTime(dateBegin);
            calendarEnd.setTime(dateEnd);
        }
        calendarBegin.set(11, 0);
        calendarBegin.set(12, 0);
        calendarBegin.set(13, 0);
        calendarEnd.set(11, 23);
        calendarEnd.set(12, 59);
        calendarEnd.set(13, 59);
        Date beginDate = calendarBegin.getTime();
        Date endDate = calendarEnd.getTime();
        String quarterSql = sql.toString();
        HashMap<String, Integer> periodTypeMap = new HashMap<String, Integer>();
        if (!StringUtils.isEmpty((String)quarterSql)) {
            String[] periodTypeLength = quarterSql.split("union all");
            periodTypeMap.put(periodType.getValue(), periodTypeLength.length);
        }
        StringBuilder fQuarterIDSql = this.getFQuarterIDByPeriodType(periodType, periodMap, periodTypeMap, beginDate, endDate);
        String fQuarterId = fQuarterIDSql.toString();
        sql.setLength(0);
        if ("isMonth".equals(this.getPeriodType(periodMap))) {
            calendarBegin.add(2, 1);
            calendarBegin.add(5, -1);
            endDate = calendarBegin.getTime();
            sql.append(this.getFactSql(fQuarterId, this.isApplier, beginDate, endDate, filterMap, ctx));
        } else if ("isQuarter".equals(this.getPeriodType(periodMap))) {
            if (periodType.getValue().equals("month")) {
                calendarBegin.add(2, 1);
                calendarBegin.add(5, -1);
                endDate = calendarBegin.getTime();
                for (i = 1; i < 3; ++i) {
                    calendarBegin.add(5, 1);
                    calendarBegin.add(2, 1);
                    calendarBegin.add(5, -1);
                    endDate = calendarBegin.getTime();
                }
                sql.append(this.getFactSql(fQuarterId, this.isApplier, beginDate, endDate, filterMap, ctx));
            } else if (periodType.getValue().equals("quarter")) {
                calendarBegin.add(2, 3);
                calendarBegin.add(5, -1);
                endDate = calendarBegin.getTime();
                sql.append(this.getFactSql(fQuarterId, this.isApplier, beginDate, endDate, filterMap, ctx));
            }
        } else if ("isYear".equals(this.getPeriodType(periodMap))) {
            if (periodType.getValue().equals("month")) {
                calendarBegin.add(2, 1);
                calendarBegin.add(5, -1);
                endDate = calendarBegin.getTime();
                while (i < 12) {
                    ++i;
                    calendarBegin.add(5, 1);
                    calendarBegin.add(2, 1);
                    calendarBegin.add(5, -1);
                    endDate = calendarBegin.getTime();
                }
                sql.append(this.getFactSql(fQuarterId, this.isApplier, beginDate, endDate, filterMap, ctx));
            } else if (periodType.getValue().equals("quarter")) {
                calendarBegin.add(2, 3);
                calendarBegin.add(5, -1);
                endDate = calendarBegin.getTime();
                while (i < 4) {
                    ++i;
                    calendarBegin.add(5, 1);
                    calendarBegin.add(2, 3);
                    calendarBegin.add(5, -1);
                    endDate = calendarBegin.getTime();
                }
                sql.append(this.getFactSql(fQuarterId, this.isApplier, beginDate, endDate, filterMap, ctx));
            } else if (periodType.getValue().equals("year")) {
                calendarBegin.add(1, 1);
                calendarBegin.add(5, -1);
                endDate = calendarBegin.getTime();
                sql.append(this.getFactSql(fQuarterId, this.isApplier, beginDate, endDate, filterMap, ctx));
            }
        } else if ("isPeriod".equals(this.getPeriodType(periodMap))) {
            if (periodType.getValue().equals("month")) {
                int j = (DateTimeUtils.getYear((Date)dateEnd) - DateTimeUtils.getYear((Date)dateBegin)) * 12 + (DateTimeUtils.getMonth((Date)dateEnd) - DateTimeUtils.getMonth((Date)dateBegin)) + 1;
                calendarBegin.set(5, 1);
                calendarBegin.add(2, 1);
                calendarBegin.add(5, -1);
                Date centerDate = null;
                centerDate = i == j ? endDate : calendarBegin.getTime();
                while (i < j) {
                    calendarBegin.add(5, 1);
                    calendarBegin.add(2, 1);
                    calendarBegin.add(5, -1);
                    if (++i == j) {
                        centerDate = endDate;
                        continue;
                    }
                    centerDate = calendarBegin.getTime();
                }
                sql.append(this.getFactSql(fQuarterId, this.isApplier, beginDate, centerDate, filterMap, ctx));
            } else if (periodType.getValue().equals("quarter")) {
                int j = (DateTimeUtils.getYear((Date)dateEnd) - DateTimeUtils.getYear((Date)dateBegin)) * 4 + (DateTimeUtils.getQuarter((Date)dateEnd) - DateTimeUtils.getQuarter((Date)dateBegin)) + 1;
                currentQuarter = DateTimeUtils.getQuarter((Date)calendarBegin.getTime());
                calendarBegin.set(2, currentQuarter * 3);
                calendarBegin.set(5, 1);
                calendarBegin.add(5, -1);
                Date centerDate = calendarBegin.getTime();
                while (i < j) {
                    calendarBegin.add(5, 1);
                    calendarBegin.add(2, 3);
                    calendarBegin.add(5, -1);
                    if (++i == j) {
                        centerDate = endDate;
                        continue;
                    }
                    centerDate = calendarBegin.getTime();
                }
                sql.append(this.getFactSql(fQuarterId, this.isApplier, beginDate, centerDate, filterMap, ctx));
            } else if (periodType.getValue().equals("year")) {
                int j = DateTimeUtils.getYear((Date)dateEnd) - DateTimeUtils.getYear((Date)dateBegin) + 1;
                calendarBegin.set(5, 1);
                calendarBegin.set(2, 0);
                calendarBegin.add(1, 1);
                calendarBegin.add(5, -1);
                Date centerDate = calendarBegin.getTime();
                while (i < j) {
                    calendarBegin.add(5, 1);
                    calendarBegin.add(1, 1);
                    calendarBegin.add(5, -1);
                    if (++i == j) {
                        centerDate = endDate;
                        continue;
                    }
                    centerDate = calendarBegin.getTime();
                }
                sql.append(this.getFactSql(fQuarterId, this.isApplier, beginDate, centerDate, filterMap, ctx));
            }
        }
        logger.error((Object)("\nFact: " + sql.toString()));
        return sql;
    }

    private StringBuffer getDataItemQuarterSql(Context ctx, Date dateBegin, Date dateEnd, Map periodMap, IntvlType periodType, StringBuffer sql) {
        block20: {
            int i;
            Date beginDate;
            int currentQuarter;
            Calendar calendarBegin;
            block23: {
                block25: {
                    block24: {
                        block21: {
                            block22: {
                                block19: {
                                    calendarBegin = Calendar.getInstance();
                                    Calendar calendarEnd = Calendar.getInstance();
                                    int currentYear = DateTimeUtils.getYear((Date)calendarBegin.getTime());
                                    currentQuarter = DateTimeUtils.getQuarter((Date)calendarBegin.getTime());
                                    if ("isMonth".equals(this.getPeriodType(periodMap))) {
                                        calendarBegin.set(5, 1);
                                    } else if ("isQuarter".equals(this.getPeriodType(periodMap))) {
                                        calendarBegin.set(5, 1);
                                        calendarBegin.set(2, (currentQuarter - 1) * 3);
                                    } else if ("isYear".equals(this.getPeriodType(periodMap))) {
                                        calendarBegin.set(5, 1);
                                        calendarBegin.set(2, 0);
                                        calendarBegin.set(1, currentYear);
                                    } else if ("isPeriod".equals(this.getPeriodType(periodMap))) {
                                        calendarBegin.setTime(dateBegin);
                                        calendarEnd.setTime(dateEnd);
                                    }
                                    calendarBegin.set(11, 0);
                                    calendarBegin.set(12, 0);
                                    calendarBegin.set(13, 0);
                                    calendarEnd.set(11, 23);
                                    calendarEnd.set(12, 59);
                                    calendarEnd.set(13, 59);
                                    beginDate = calendarBegin.getTime();
                                    Date endDate = calendarEnd.getTime();
                                    sql.setLength(0);
                                    if (!"isMonth".equals(this.getPeriodType(periodMap))) break block19;
                                    sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "month"));
                                    break block20;
                                }
                                if (!"isQuarter".equals(this.getPeriodType(periodMap))) break block21;
                                if (!periodType.getValue().equals("month")) break block22;
                                calendarBegin.add(2, 1);
                                calendarBegin.add(5, -1);
                                sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "month"));
                                for (i = 1; i < 3; ++i) {
                                    calendarBegin.add(5, 1);
                                    beginDate = calendarBegin.getTime();
                                    calendarBegin.add(2, 1);
                                    calendarBegin.add(5, -1);
                                    sql.append(" union all ");
                                    sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "month"));
                                }
                                break block20;
                            }
                            if (!periodType.getValue().equals("quarter")) break block20;
                            sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "quarter"));
                            break block20;
                        }
                        if (!"isYear".equals(this.getPeriodType(periodMap))) break block23;
                        if (!periodType.getValue().equals("month")) break block24;
                        calendarBegin.add(2, 1);
                        calendarBegin.add(5, -1);
                        sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "month"));
                        while (i < 12) {
                            ++i;
                            calendarBegin.add(5, 1);
                            beginDate = calendarBegin.getTime();
                            calendarBegin.add(2, 1);
                            calendarBegin.add(5, -1);
                            sql.append(" union all ");
                            sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "month"));
                        }
                        break block20;
                    }
                    if (!periodType.getValue().equals("quarter")) break block25;
                    calendarBegin.add(2, 3);
                    calendarBegin.add(5, -1);
                    sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "quarter"));
                    while (i < 4) {
                        ++i;
                        calendarBegin.add(5, 1);
                        beginDate = calendarBegin.getTime();
                        calendarBegin.add(2, 3);
                        calendarBegin.add(5, -1);
                        sql.append(" union all ");
                        sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "quarter"));
                    }
                    break block20;
                }
                if (!periodType.getValue().equals("year")) break block20;
                sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "year"));
                break block20;
            }
            if ("isPeriod".equals(this.getPeriodType(periodMap))) {
                if (periodType.getValue().equals("month")) {
                    calendarBegin.set(5, 1);
                    calendarBegin.add(2, 1);
                    calendarBegin.add(5, -1);
                    sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "month"));
                    int j = (DateTimeUtils.getYear((Date)dateEnd) - DateTimeUtils.getYear((Date)dateBegin)) * 12 + (DateTimeUtils.getMonth((Date)dateEnd) - DateTimeUtils.getMonth((Date)dateBegin)) + 1;
                    while (i < j) {
                        ++i;
                        calendarBegin.add(5, 1);
                        beginDate = calendarBegin.getTime();
                        calendarBegin.add(2, 1);
                        calendarBegin.add(5, -1);
                        sql.append(" union all ");
                        sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "month"));
                    }
                } else if (periodType.getValue().equals("quarter")) {
                    int j = (DateTimeUtils.getYear((Date)dateEnd) - DateTimeUtils.getYear((Date)dateBegin)) * 4 + (DateTimeUtils.getQuarter((Date)dateEnd) - DateTimeUtils.getQuarter((Date)dateBegin)) + 1;
                    currentQuarter = DateTimeUtils.getQuarter((Date)calendarBegin.getTime());
                    calendarBegin.set(2, currentQuarter * 3);
                    calendarBegin.set(5, 1);
                    calendarBegin.add(5, -1);
                    sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "quarter"));
                    while (i < j) {
                        ++i;
                        calendarBegin.add(5, 1);
                        beginDate = calendarBegin.getTime();
                        calendarBegin.add(2, 3);
                        calendarBegin.add(5, -1);
                        sql.append(" union all ");
                        sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "quarter"));
                    }
                } else if (periodType.getValue().equals("year")) {
                    int j = DateTimeUtils.getYear((Date)dateEnd) - DateTimeUtils.getYear((Date)dateBegin) + 1;
                    calendarBegin.set(5, 1);
                    calendarBegin.set(2, 0);
                    calendarBegin.add(1, 1);
                    calendarBegin.add(5, -1);
                    sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "year"));
                    while (i < j) {
                        ++i;
                        calendarBegin.add(5, 1);
                        beginDate = calendarBegin.getTime();
                        calendarBegin.add(1, 1);
                        calendarBegin.add(5, -1);
                        sql.append(" union all ");
                        sql.append(this.getQuarterDimensionSql(ctx, i, beginDate, "year"));
                    }
                }
            }
        }
        return sql;
    }

    private void registerNodeByNeedFilter(Context ctx, StringBuffer sql, SchemaSource ss) {
        Locale locale = ctx.getLocale();
        sql.setLength(0);
        sql.append("select T.FId,T.Fname_").append(locale).append(" FName from T_BD_Person T ");
        ss.setDataItem("Applier", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.FName_").append(locale).append(" FName,FParentID FParentID from T_ORG_Company T ");
        ss.setDataItem("ApplierCompany", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.Fname_").append(locale).append(" FName,FParentID FParentID from T_ORG_Admin T ");
        ss.setDataItem("OrgUnit", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.FName_").append(locale).append(" FName,FParentID FParentID from T_ORG_Company T ");
        ss.setDataItem("Company", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.Fname_").append(locale).append(" FName,FParentID FParentID from T_ORG_CostCenter T ");
        ss.setDataItem("CostCenter", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.FName_").append(locale).append(" FName,FParentID FParentID from T_ORG_Company T ");
        ss.setDataItem("EntryCompany", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.Fname_").append(locale).append(" FName,FParentID FParentID from T_ORG_CostCenter T ");
        ss.setDataItem("EntryCostCenter", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.Fname_").append(locale).append(" FName from T_BC_OperationType T ");
        ss.setDataItem("OperationType", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.Fname_").append(locale).append(" FName from T_BC_ExpenseType T ");
        ss.setDataItem("ExpenseType", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.Fnumber ").append(" from (select FId,Fnumber from t_bc_BizAccountbill Union All select FId,Fnumber from t_bc_BizAccountOutBill").append(" Union All select FId,Fnumber from t_bc_DailyPurchaseAccountBill Union All select FId,Fnumber from t_bc_TravelAccountBill) T ");
        ss.setDataItem("BillNumber", sql.toString(), null);
        sql.setLength(0);
        sql.append("select T.FId,T.Fname_").append(locale).append(" FName from T_BD_Currency T ");
        ss.setDataItem("CurrencyType", sql.toString(), null);
    }

    private Map<Object, Object> getTableStyle(Object[][] tableValue) {
        LinkedHashMap<Object, Object> tableStyle = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < tableValue.length; ++i) {
            if (!tableValue[i][1].equals(new Boolean(true))) continue;
            tableStyle.put(tableValue[i][0], this.dimensionName.get(tableValue[i][0]));
        }
        return tableStyle;
    }

    private String getPeriodType(Map periodMap) {
        StringBuffer periodType = new StringBuffer();
        Iterator iterator = periodMap.entrySet().iterator();
        Map.Entry entrySet = null;
        Boolean boolValue = null;
        while (iterator.hasNext()) {
            entrySet = iterator.next();
            boolValue = (Boolean)entrySet.getValue();
            if (!boolValue.booleanValue()) continue;
            return (String)entrySet.getKey();
        }
        return periodType.toString();
    }

    private StringBuffer getQuarterDimensionSql(Context ctx, int i, Date beginDate, String name) {
        StringBuffer sql = new StringBuffer();
        Locale local = ctx.getOriginLocale();
        if ("month".equals(name)) {
            String temp = MessageFormat.format(ResourceBase.getString((String)SEVSOURCE, (String)"yearAndMonth", (Locale)local), String.valueOf(DateTimeUtils.getYear((Date)beginDate)), String.valueOf(DateTimeUtils.getMonth((Date)beginDate)));
            sql.append(" select ").append(i).append(" fid ,'").append(temp).append("' fname");
        } else if ("quarter".equals(name)) {
            String temp = MessageFormat.format(ResourceBase.getString((String)SEVSOURCE, (String)"searchQuarter", (Locale)local), String.valueOf(DateTimeUtils.getYear((Date)beginDate)), String.valueOf(DateTimeUtils.getQuarter((Date)beginDate)));
            sql.append(" select ").append(i).append(" fid ,'").append(temp).append("' fname");
        } else if ("year".equals(name)) {
            String temp = MessageFormat.format(ResourceBase.getString((String)SEVSOURCE, (String)"searchYear", (Locale)local), String.valueOf(DateTimeUtils.getYear((Date)beginDate)));
            sql.append(" select ").append(i).append(" fid ,'").append(temp).append("' fname");
        }
        return sql;
    }

    private StringBuffer getFactSql(String i, Boolean isApplier, Date beginDate, Date endDate, Map filterMap, Context ctx) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        endDate.setHours(23);
        endDate.setMinutes(59);
        endDate.setSeconds(59);
        sql.append(this.getTableSqlSelect(i, isApplier, "T_BC_BizAccountBill", "T_BC_BizAccountBillEntry", ctx));
        sql.append(this.getTableSqlWhere(beginDate, endDate, filterMap, ctx));
        sql.append(" union all ");
        sql.append(this.getTableSqlSelect(i, isApplier, "T_BC_TravelAccountBill", "T_BC_TravelAccountBillEntry", ctx));
        sql.append(this.getTableSqlWhere(beginDate, endDate, filterMap, ctx));
        sql.append(" union all ");
        sql.append(this.getTableSqlSelect(i, isApplier, "T_BC_DailyPurchaseAccountBill", "T_BC_DailyPurchaseAccontEntry", ctx));
        sql.append(this.getTableSqlWhere(beginDate, endDate, filterMap, ctx));
        sql.append(" union all ");
        sql.append(this.getTableSqlSelect(i, isApplier, "T_BC_BizAccountOutBill", "T_BC_BizAccountOutBillEntry", ctx));
        sql.append(this.getTableSqlWhere(beginDate, endDate, filterMap, ctx));
        return sql;
    }

    private StringBuilder getFQuarterIDByPeriodType(IntvlType periodType, Map periodMap, Map<String, Integer> periodTypeMap, Date beginDate, Date endDate) {
        Calendar calendarBegin = Calendar.getInstance();
        calendarBegin.setTime(beginDate);
        StringBuilder fQuarterID = null;
        Integer count = periodTypeMap.get(periodType.getValue());
        int quarterCount = 1;
        fQuarterID = "isPeriod".equals(this.getPeriodType(periodMap)) ? this.doHandlerIsPeriod(periodType, beginDate, endDate, calendarBegin, quarterCount) : this.doHandlerNotPeriod(periodType, calendarBegin, quarterCount, count);
        fQuarterID.append(" end ");
        return fQuarterID;
    }

    private StringBuilder doHandlerIsPeriod(IntvlType periodType, Date beginDate, Date endDate, Calendar calendarBegin, int quarterCount) {
        StringBuilder fQuarterID = new StringBuilder();
        fQuarterID.append(" case when ");
        if ("month".equals(periodType.getValue())) {
            this.doHandlerIsPeriodByMonth(beginDate, endDate, calendarBegin, quarterCount, fQuarterID);
        } else if ("quarter".equals(periodType.getValue())) {
            this.doHandlerIsPeriodByQuarter(beginDate, endDate, calendarBegin, quarterCount, fQuarterID);
        } else if ("year".equals(periodType.getValue())) {
            this.doHandlerIsPeriodByYear(beginDate, endDate, calendarBegin, quarterCount, fQuarterID);
        }
        return fQuarterID;
    }

    private void doHandlerIsPeriodByYear(Date beginDate, Date endDate, Calendar calendarBegin, int quarterCount, StringBuilder fQuarterID) {
        fQuarterID.append(" FBizReqDate between {").append(DateTimeUtils.format((Date)calendarBegin.getTime()));
        int j = DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)beginDate) + 1;
        calendarBegin.set(5, 1);
        calendarBegin.set(2, 0);
        calendarBegin.add(1, 1);
        calendarBegin.add(5, -1);
        Date centerDate = calendarBegin.getTime();
        fQuarterID.append("} and {").append(DateTimeUtils.format((Date)centerDate)).append("} then " + quarterCount++);
        while (quarterCount <= j) {
            fQuarterID.append(" when ");
            calendarBegin.add(5, 1);
            fQuarterID.append(" FBizReqDate between {").append(DateTimeUtils.format((Date)calendarBegin.getTime()));
            calendarBegin.add(1, 1);
            calendarBegin.add(5, -1);
            centerDate = quarterCount == j ? endDate : calendarBegin.getTime();
            fQuarterID.append("} and {").append(DateTimeUtils.format((Date)centerDate)).append("} then " + quarterCount++);
        }
    }

    private void doHandlerIsPeriodByQuarter(Date beginDate, Date endDate, Calendar calendarBegin, int quarterCount, StringBuilder fQuarterID) {
        fQuarterID.append(" FBizReqDate between {").append(DateTimeUtils.format((Date)calendarBegin.getTime()));
        int j = (DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)beginDate)) * 4 + (DateTimeUtils.getQuarter((Date)endDate) - DateTimeUtils.getQuarter((Date)beginDate)) + 1;
        int currentQuarter = DateTimeUtils.getQuarter((Date)calendarBegin.getTime());
        calendarBegin.set(2, currentQuarter * 3);
        calendarBegin.set(5, 1);
        calendarBegin.add(5, -1);
        Date centerDate = calendarBegin.getTime();
        fQuarterID.append("} and {").append(DateTimeUtils.format((Date)centerDate)).append("} then " + quarterCount++);
        while (quarterCount <= j) {
            fQuarterID.append(" when ");
            calendarBegin.add(5, 1);
            fQuarterID.append(" FBizReqDate between {").append(DateTimeUtils.format((Date)calendarBegin.getTime()));
            calendarBegin.add(2, 3);
            calendarBegin.add(5, -1);
            centerDate = quarterCount == j ? endDate : calendarBegin.getTime();
            fQuarterID.append("} and {").append(DateTimeUtils.format((Date)centerDate)).append("} then " + quarterCount++);
        }
    }

    private void doHandlerIsPeriodByMonth(Date beginDate, Date endDate, Calendar calendarBegin, int quarterCount, StringBuilder fQuarterID) {
        fQuarterID.append(" FBizReqDate between {").append(DateTimeUtils.format((Date)calendarBegin.getTime()));
        int j = (DateTimeUtils.getYear((Date)endDate) - DateTimeUtils.getYear((Date)beginDate)) * 12 + (DateTimeUtils.getMonth((Date)endDate) - DateTimeUtils.getMonth((Date)beginDate)) + 1;
        calendarBegin.set(5, 1);
        calendarBegin.add(2, 1);
        calendarBegin.add(5, -1);
        Date centerDate = null;
        centerDate = quarterCount == j ? endDate : calendarBegin.getTime();
        fQuarterID.append("} and {").append(DateTimeUtils.format((Date)centerDate)).append("} then " + quarterCount++);
        while (quarterCount <= j) {
            fQuarterID.append(" when ");
            calendarBegin.add(5, 1);
            fQuarterID.append(" FBizReqDate between {").append(DateTimeUtils.format((Date)calendarBegin.getTime()));
            calendarBegin.add(2, 1);
            calendarBegin.add(5, -1);
            centerDate = quarterCount == j ? endDate : calendarBegin.getTime();
            fQuarterID.append("} and {").append(DateTimeUtils.format((Date)centerDate)).append("} then " + quarterCount++);
        }
    }

    private StringBuilder doHandlerNotPeriod(IntvlType periodType, Calendar calendarBegin, int quarterCount, int count) {
        StringBuilder fQuarterID = new StringBuilder();
        for (int x = 0; x < count; ++x) {
            if (x == 0) {
                fQuarterID.append(" case when ");
            } else {
                fQuarterID.append(" when ");
            }
            if (x > 0) {
                calendarBegin.add(5, 1);
                calendarBegin.set(11, 0);
                calendarBegin.set(12, 0);
                calendarBegin.set(13, 0);
            }
            fQuarterID.append(" FBizReqDate between {").append(DateTimeUtils.format((Date)calendarBegin.getTime()));
            if ("month".equals(periodType.getValue())) {
                calendarBegin.add(2, 1);
            } else if ("quarter".equals(periodType.getValue())) {
                calendarBegin.add(2, 3);
            } else if ("year".equals(periodType.getValue())) {
                calendarBegin.add(1, 1);
            }
            calendarBegin.add(5, -1);
            calendarBegin.set(11, 23);
            calendarBegin.set(12, 59);
            calendarBegin.set(13, 59);
            fQuarterID.append("} and {").append(DateTimeUtils.format((Date)calendarBegin.getTime())).append("} then " + quarterCount++);
        }
        return fQuarterID;
    }

    private StringBuffer getTableSqlSelect(String i, Boolean isAppler, String tableName, String entryTableName, Context ctx) {
        this.sqlstr.setLength(0);
        this.sqlstr.append(" select ");
        if (this.CostCompanyIndex || this.EntryCompanyIndex) {
            this.sqlstr.append("A.FID FCompanyID,");
            if (this.CostCenterIndex || this.EntryCostCenterIndex) {
                this.sqlstr.append("F.FID FCostCenterID,");
            }
        } else if (this.ApplierCompanyIndex) {
            this.sqlstr.append("A.FID FApplierCompanyID,");
            if (this.OrgUnitIndex) {
                this.sqlstr.append("F.FID FOrgUnitID,");
            }
        }
        if (this.OperationTypeIndex) {
            this.sqlstr.append("H.FID FOperationTypeId,");
        }
        if (this.ExpenseTypeIndex) {
            this.sqlstr.append("D.FID FExpenseTypeId,");
        }
        if (isAppler.booleanValue()) {
            this.sqlstr.append("E.FID FApplierId,");
        }
        if (this.isBillNumber.booleanValue()) {
            this.sqlstr.append("B.FID FBillNumberId,");
        }
        this.sqlstr.append("G.FID FCurrencyID,");
        this.sqlstr.append(i).append(" FQuarterID,case when (B.Fstate=80 or B.Fstate=70 or B.Fstate=65 or B.Fstate=45 or B.Fstate=60 or B.Fstate=110 or B.Fstate=115) then C.FAmountApproved else 0 end FAmount1,").append(" case when (B.Fstate=80 or B.Fstate=70 or B.Fstate=65 or B.Fstate=45 or B.Fstate=60 or B.Fstate=110 or B.Fstate=115) then C.FAmountApprovedOri else 0 end FAmount1Ori, ").append(" case when (B.Fstate=20 or B.Fstate=25 or B.Fstate=30) then C.FAmountOri else 0 end FAmount2Ori, ").append(" case when (B.Fstate=20 or B.Fstate=25 or B.Fstate=30) then C.FAmount else 0 end FAmount2 from ");
        if (this.CostCompanyIndex || this.ApplierCompanyIndex || this.EntryCompanyIndex) {
            this.sqlstr.append(" T_ORG_Company A inner join ");
        }
        if (this.ApplierCompanyIndex) {
            this.sqlstr.append(tableName);
            this.sqlstr.append(" B on A.FID=B.FApplierCompanyID ");
            this.sqlstr.append("inner join ").append(entryTableName);
            this.sqlstr.append(" C on C.FBillID=B.FID ");
        } else if (this.CostCompanyIndex) {
            this.sqlstr.append(tableName);
            this.sqlstr.append(" B on A.FID=B.FCompanyID ");
            this.sqlstr.append("inner join ").append(entryTableName);
            this.sqlstr.append(" C on C.FBillID=B.FID ");
        } else if (this.EntryCompanyIndex) {
            this.sqlstr.append(entryTableName);
            this.sqlstr.append(" C on A.FID=C.FCompanyId ");
            this.sqlstr.append("inner join ").append(tableName);
            this.sqlstr.append(" B on C.FBillID=B.FID ");
        } else {
            this.sqlstr.append(tableName);
            this.sqlstr.append(" B ");
            this.sqlstr.append("inner join ").append(entryTableName);
            this.sqlstr.append(" C on C.FBillID=B.FID ");
        }
        if (this.CostCenterIndex) {
            this.sqlstr.append("inner join T_ORG_CostCenter F on B.FCostedDeptID=F.FID ");
        }
        if (this.OrgUnitIndex) {
            this.sqlstr.append("inner join T_ORG_Admin F on B.FOrgUnitID=F.FID ");
        }
        if (this.EntryCostCenterIndex) {
            this.sqlstr.append("inner join T_ORG_CostCenter F on C.FCostCenterId=F.FID ");
        }
        if (this.OperationTypeIndex) {
            this.sqlstr.append("inner join T_BC_OperationType H on C.FOperationTypeID=H.FID ");
        }
        if (this.ExpenseTypeIndex) {
            this.sqlstr.append("inner join T_BC_ExpenseType D on C.FExpenseTypeID=D.FID ");
        }
        if (isAppler.booleanValue()) {
            this.sqlstr.append("inner join T_BD_Person E on B.FApplierId=E.FID ");
        }
        this.sqlstr.append("left join T_BD_Currency G on C.FCurrencyID=G.FID ");
        return this.sqlstr;
    }

    private StringBuffer getTableSqlWhere(Date beginDate, Date endDate, Map filterMap, Context ctx) throws EASBizException, BOSException {
        this.sqlstr.setLength(0);
        this.sqlstr.append(" where ").append(" FBizReqDate between {").append(DateTimeUtils.format((Date)beginDate)).append("} and {").append(DateTimeUtils.format((Date)endDate)).append("}");
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Iterator iterator = filterMap.entrySet().iterator();
        Map.Entry entrySet = null;
        Object objectValue = null;
        while (iterator.hasNext()) {
            IntvlType type;
            entrySet = iterator.next();
            objectValue = entrySet.getValue();
            if (objectValue instanceof Set) {
                Iterator setIt;
                Set set;
                if (entrySet.getKey().equals("companyIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() > 0) {
                        this.sqlstr.append(" and B.FCompanyId in (");
                        setIt = set.iterator();
                        while (setIt.hasNext()) {
                            this.sqlstr.append("'");
                            this.sqlstr.append((String)setIt.next());
                            this.sqlstr.append("'");
                            this.sqlstr.append(",");
                        }
                        this.sqlstr.setLength(this.sqlstr.length() - 1);
                        this.sqlstr.append(")");
                        continue;
                    }
                    if (!this.isDelimitOrgScope) continue;
                    this.sqlstr.append(" and C.FCompanyId in (select forgid from T_PM_OrgRange where fuserid='" + userId + "' and ftype=" + 10 + ") ");
                    continue;
                }
                if (entrySet.getKey().equals("payModeIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() <= 0) continue;
                    this.sqlstr.append(" and B.FPayMent in (");
                    setIt = set.iterator();
                    while (setIt.hasNext()) {
                        this.sqlstr.append("'");
                        this.sqlstr.append((String)setIt.next());
                        this.sqlstr.append("'");
                        this.sqlstr.append(",");
                    }
                    this.sqlstr.setLength(this.sqlstr.length() - 1);
                    this.sqlstr.append(")");
                    continue;
                }
                if (entrySet.getKey().equals("applierCompanyIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() > 0) {
                        this.sqlstr.append(" and B.FApplierCompanyID in (");
                        setIt = set.iterator();
                        while (setIt.hasNext()) {
                            this.sqlstr.append("'");
                            this.sqlstr.append((String)setIt.next());
                            this.sqlstr.append("'");
                            this.sqlstr.append(",");
                        }
                        this.sqlstr.setLength(this.sqlstr.length() - 1);
                        this.sqlstr.append(")");
                        continue;
                    }
                    if (!this.isDelimitOrgScope) continue;
                    this.sqlstr.append(" and B.FApplierCompanyID in (select forgid from T_PM_OrgRange where fuserid='" + userId + "' and ftype=" + 10 + ") ");
                    continue;
                }
                if (entrySet.getKey().equals("applierIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() <= 0) continue;
                    this.sqlstr.append(" and B.FApplierID in (");
                    setIt = set.iterator();
                    while (setIt.hasNext()) {
                        this.sqlstr.append("'");
                        this.sqlstr.append((String)setIt.next());
                        this.sqlstr.append("'");
                        this.sqlstr.append(",");
                    }
                    this.sqlstr.setLength(this.sqlstr.length() - 1);
                    this.sqlstr.append(")");
                    continue;
                }
                if (entrySet.getKey().equals("currencyIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() <= 0) continue;
                    this.sqlstr.append(" and B.FCurrencyID in (");
                    setIt = set.iterator();
                    while (setIt.hasNext()) {
                        this.sqlstr.append("'");
                        this.sqlstr.append((String)setIt.next());
                        this.sqlstr.append("'");
                        this.sqlstr.append(",");
                    }
                    this.sqlstr.setLength(this.sqlstr.length() - 1);
                    this.sqlstr.append(")");
                    continue;
                }
                if (entrySet.getKey().equals("currencyId1Set")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() <= 0) continue;
                    this.sqlstr.append(" and C.FCurrencyID in (");
                    setIt = set.iterator();
                    while (setIt.hasNext()) {
                        this.sqlstr.append("'");
                        this.sqlstr.append((String)setIt.next());
                        this.sqlstr.append("'");
                        this.sqlstr.append(",");
                    }
                    this.sqlstr.setLength(this.sqlstr.length() - 1);
                    this.sqlstr.append(")");
                    continue;
                }
                if (entrySet.getKey().equals("applierOrgUnitIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() > 0) {
                        this.sqlstr.append(" and B.FOrgUnitID in (");
                        setIt = set.iterator();
                        while (setIt.hasNext()) {
                            this.sqlstr.append("'");
                            this.sqlstr.append((String)setIt.next());
                            this.sqlstr.append("'");
                            this.sqlstr.append(",");
                        }
                        this.sqlstr.setLength(this.sqlstr.length() - 1);
                        this.sqlstr.append(")");
                        continue;
                    }
                    String applierOrgUnitIdSql = (String)filterMap.get("applierOrgUnitIdSql");
                    if (StringUtils.isEmpty((String)applierOrgUnitIdSql)) continue;
                    this.sqlstr.append(" and B.FOrgUnitID in ( " + applierOrgUnitIdSql + " ) ");
                    continue;
                }
                if (entrySet.getKey().equals("costedDeptIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() > 0) {
                        this.sqlstr.append(" and B.FCostedDeptID in (");
                        setIt = set.iterator();
                        while (setIt.hasNext()) {
                            this.sqlstr.append("'");
                            this.sqlstr.append((String)setIt.next());
                            this.sqlstr.append("'");
                            this.sqlstr.append(",");
                        }
                        this.sqlstr.setLength(this.sqlstr.length() - 1);
                        this.sqlstr.append(")");
                        continue;
                    }
                    if (!this.isDelimitOrgScope) continue;
                    this.sqlstr.append(" and C.FCostCenterId in (select forgid from T_PM_OrgRange where fuserid='" + userId + "' and ftype=" + 10 + ") ");
                    continue;
                }
                if (entrySet.getKey().equals("stateSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() <= 0) continue;
                    this.sqlstr.append(" and B.Fstate in (");
                    setIt = set.iterator();
                    while (setIt.hasNext()) {
                        this.sqlstr.append((Integer)setIt.next());
                        this.sqlstr.append(",");
                    }
                    this.sqlstr.setLength(this.sqlstr.length() - 1);
                    this.sqlstr.append(")");
                    continue;
                }
                if (entrySet.getKey().equals("expenseTypeIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() <= 0) continue;
                    this.sqlstr.append(" and C.FExpenseTypeId in (");
                    setIt = set.iterator();
                    while (setIt.hasNext()) {
                        this.sqlstr.append("'");
                        this.sqlstr.append((String)setIt.next());
                        this.sqlstr.append("'");
                        this.sqlstr.append(",");
                    }
                    this.sqlstr.setLength(this.sqlstr.length() - 1);
                    this.sqlstr.append(")");
                    continue;
                }
                if (entrySet.getKey().equals("operationTypeIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() <= 0) continue;
                    this.sqlstr.append(" and C.FOperationTypeId in (");
                    setIt = set.iterator();
                    while (setIt.hasNext()) {
                        this.sqlstr.append("'");
                        this.sqlstr.append((String)setIt.next());
                        this.sqlstr.append("'");
                        this.sqlstr.append(",");
                    }
                    this.sqlstr.setLength(this.sqlstr.length() - 1);
                    this.sqlstr.append(")");
                    continue;
                }
                if (entrySet.getKey().equals("entryCompanyIdSet")) {
                    set = (Set)entrySet.getValue();
                    if (set.size() > 0) {
                        this.sqlstr.append(" and C.FCompanyId in (");
                        setIt = set.iterator();
                        while (setIt.hasNext()) {
                            this.sqlstr.append("'");
                            this.sqlstr.append((String)setIt.next());
                            this.sqlstr.append("'");
                            this.sqlstr.append(",");
                        }
                        this.sqlstr.setLength(this.sqlstr.length() - 1);
                        this.sqlstr.append(")");
                        continue;
                    }
                    if (!this.isDelimitOrgScope) continue;
                    this.sqlstr.append(" and C.FCompanyId in (select forgid from T_PM_OrgRange where fuserid='" + userId + "' and ftype=" + 10 + ") ");
                    continue;
                }
                if (!entrySet.getKey().equals("entryCostedDeptIdSet")) continue;
                set = (Set)entrySet.getValue();
                if (set.size() > 0) {
                    this.sqlstr.append(" and C.FCostCenterId in (");
                    setIt = set.iterator();
                    while (setIt.hasNext()) {
                        this.sqlstr.append("'");
                        this.sqlstr.append((String)setIt.next());
                        this.sqlstr.append("'");
                        this.sqlstr.append(",");
                    }
                    this.sqlstr.setLength(this.sqlstr.length() - 1);
                    this.sqlstr.append(")");
                    continue;
                }
                if (!this.isDelimitOrgScope) continue;
                this.sqlstr.append(" and C.FCostCenterId in (select forgid from T_PM_OrgRange where fuserid='" + userId + "' and ftype=" + 10 + ") ");
                continue;
            }
            if (!(objectValue instanceof IntvlType) || !entrySet.getKey().equals("amountControl") || (type = (IntvlType)entrySet.getValue()) == null || type.getValue().equals("All")) continue;
            this.sqlstr.append(" and B.FAmountControlType = ");
            this.sqlstr.append(AmountControlTypeEnum.getEnum(type.getValue()).getValue());
        }
        return this.sqlstr;
    }

    private void setConfigXmlDim(SchemaSource ss, Boolean isAppler, Context ctx) {
        if (this.ApplierCompanyIndex) {
            ss.setMacroValue("ApplierCompanyCube", "<DimensionUsage name=\"ApplierCompany\" foreignKey=\"FApplierCompanyID\" />");
        }
        if (this.OrgUnitIndex) {
            ss.setMacroValue("OrgUnitCube", "<DimensionUsage name=\"OrgUnit\" foreignKey=\"FOrgUnitID\" />");
        }
        if (this.CostCompanyIndex) {
            ss.setMacroValue("CompanyCube", "<DimensionUsage name=\"Company\" foreignKey=\"FCompanyID\" />");
        }
        if (this.CostCenterIndex) {
            ss.setMacroValue("CostCenterCube", "<DimensionUsage name=\"CostCenter\" foreignKey=\"FCostCenterID\" />");
        }
        if (this.EntryCompanyIndex) {
            ss.setMacroValue("EntryCompanyCube", "<DimensionUsage name=\"EntryCompany\" foreignKey=\"FCompanyID\" />");
        }
        if (this.EntryCostCenterIndex) {
            ss.setMacroValue("EntryCostCenterCube", "<DimensionUsage name=\"EntryCostCenter\" foreignKey=\"FCostCenterID\" />");
        }
        if (this.ExpenseTypeIndex) {
            ss.setMacroValue("ExpenseTypeCube", "<DimensionUsage name=\"ExpenseType\" foreignKey=\"FExpenseTypeId\" />");
        }
        if (this.OperationTypeIndex) {
            ss.setMacroValue("OperationTypeCube", "<DimensionUsage name=\"OperationType\" foreignKey=\"FOperationTypeId\" />");
        }
        if (isAppler.booleanValue()) {
            ss.setMacroValue("ApplierCube", "<DimensionUsage name=\"Applier\" foreignKey=\"FApplierId\" />");
        }
        if (this.isBillNumber.booleanValue()) {
            ss.setMacroValue("BillNumberCube", "<DimensionUsage name=\"BillNumber\" foreignKey=\"FBillNumberId\"/>");
        }
        ss.setMacroValue("CurrencyTypeCube", "<DimensionUsage name=\"CurrencyType\" foreignKey=\"FCurrencyID\" />");
    }

    private StringBuffer getMdx(Boolean isApplier, Context ctx) {
        StringBuffer mdx = new StringBuffer();
        StringBuffer memberStartString = new StringBuffer();
        StringBuffer memberEndString = new StringBuffer();
        this.buildMdxHead(ctx, mdx);
        this.buildMdxBody(ctx, mdx, memberStartString, memberEndString);
        Locale local = ctx.getLocale();
        String total = ResourceBase.getString((String)SEVSOURCE, (String)"total", (Locale)local);
        String alias_sum = ResourceBase.getString((String)SEVSOURCE, (String)"sum", (Locale)local);
        if (isApplier.booleanValue()) {
            memberStartString.append(",[Applier]");
            memberEndString.append("*").append("{[Applier].[" + total + "]}");
        }
        if (this.isBillNumber != null && this.isBillNumber.booleanValue()) {
            memberStartString.append(",[BillNumber]");
            memberEndString.append("*").append(this.isBillNumberEndString);
        }
        if (memberStartString.length() > 0) {
            memberStartString.append(",[CurrencyType]");
            memberEndString.append("*").append("{[CurrencyType].[" + total + "]}");
        } else {
            memberStartString.append("[CurrencyType]");
            memberEndString.append("{[CurrencyType].[" + total + "]}");
        }
        mdx.append(" select {[Quarter].Members}*{{[Measures].Members},{[Measures].[" + alias_sum + "]}} on columns ,  {FactMembersWithAncestor(" + memberStartString + ")," + memberEndString + "} on rows from Fact ");
        return mdx;
    }

    private void buildMdxHead(Context ctx, StringBuffer mdx) {
        Locale local = ctx.getLocale();
        String alias_sum = ResourceBase.getString((String)SEVSOURCE, (String)"sum", (Locale)local);
        String alias_total = ResourceBase.getString((String)SEVSOURCE, (String)"total", (Locale)local);
        mdx.append("with member [Measures].[").append(alias_sum).append("] as '([Measures].FAmount1+[Measures].FAmount2)',formatString='#,##0.00'  ");
        if (this.CostCompanyIndex) {
            mdx.append(" member [Company].[").append(alias_total).append("] as 'Company.[V$All]',formatString='#,##0.00' ");
            if (this.CostCenterIndex) {
                mdx.append(" member [CostCenter].[").append(alias_total).append("] as 'CostCenter.[V$All]',formatString='#,##0.00' ");
            }
        } else if (this.ApplierCompanyIndex) {
            mdx.append(" member [ApplierCompany].[").append(alias_total).append("] as 'ApplierCompany.[V$All]',formatString='#,##0.00' ");
            if (this.OrgUnitIndex) {
                mdx.append(" member [OrgUnit].[").append(alias_total).append("] as 'OrgUnit.[V$All]',formatString='#,##0.00' ");
            }
        } else if (this.EntryCompanyIndex) {
            mdx.append(" member [EntryCompany].[").append(alias_total).append("] as 'EntryCompany.[V$All]',formatString='#,##0.00' ");
            if (this.EntryCostCenterIndex) {
                mdx.append(" member [EntryCostCenter].[").append(alias_total).append("] as 'EntryCostCenter.[V$All]',formatString='#,##0.00' ");
            }
        }
        if (this.OperationTypeIndex) {
            mdx.append(" member [OperationType].[").append(alias_total).append("] as 'OperationType.[V$All]',formatString='#,##0.00' ");
        }
        if (this.ExpenseTypeIndex) {
            mdx.append(" member [ExpenseType].[").append(alias_total).append("] as 'ExpenseType.[V$All]',formatString='#,##0.00' ");
        }
        if (this.isApplier.booleanValue()) {
            mdx.append(" member [Applier].[").append(alias_total).append("] as 'Applier.[V$All]',formatString='#,##0.00' ");
        }
        if (this.isBillNumber.booleanValue()) {
            mdx.append(" member [BillNumber].[").append(BizCollRptUtil.ALIAS_TOTAL).append("] as 'BillNumber.[V$All]',formatString='#,##0.00' ");
        }
        mdx.append(" member [CurrencyType].[").append(alias_total).append("] as 'CurrencyType.[V$All]',formatString='#,##0.00' ");
    }

    private void buildMdxBody(Context ctx, StringBuffer mdx, StringBuffer memberStartString, StringBuffer memberEndString) {
        for (Map.Entry<Object, Object> entry : this.tableStyle.entrySet()) {
            if (entry.getValue() == null) continue;
            memberStartString.append(entry.getValue()).append(",");
            memberEndString.append(this.dimensionName.get(entry.getKey() + "EndString")).append("*");
        }
        if (memberStartString.length() > 0) {
            memberStartString.deleteCharAt(memberStartString.length() - 1);
            memberEndString.deleteCharAt(memberEndString.length() - 1);
        }
    }

    private String getOrgUnitFilter(Context ctx) throws BOSException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String orgUnitFilter = " select forgid from T_PM_OrgRange where fuserid='" + userId + "'  and ftype= " + 20;
        return orgUnitFilter;
    }

    private void initParam(Context ctx) throws BOSException, EASBizException {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP019");
        paramList.add("ViewAdminOrgShowByRange");
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        this.isDelimitOrgScope = paramMap.get("CP019") == null ? false : new Boolean(paramMap.get("CP019").toString());
        this.ViewAdminOrgShowByRange = paramMap.get("ViewAdminOrgShowByRange") == null ? false : new Boolean(paramMap.get("ViewAdminOrgShowByRange").toString());
    }

    protected void initDimensionName(Context ctx) {
        Locale local = ctx.getLocale();
        String total = ResourceBase.getString((String)SEVSOURCE, (String)"total", (Locale)local);
        String applierCompany = ResourceBase.getString((String)SEVSOURCE, (String)"ApplierCompany", (Locale)local);
        String orgUnit = ResourceBase.getString((String)SEVSOURCE, (String)"OrgUnit", (Locale)local);
        String costCompany = ResourceBase.getString((String)SEVSOURCE, (String)"CostCompany", (Locale)local);
        String costCenter = ResourceBase.getString((String)SEVSOURCE, (String)"CostCenter", (Locale)local);
        String entryCompany = ResourceBase.getString((String)SEVSOURCE, (String)"EntryCompany", (Locale)local);
        String entryCostCenter = ResourceBase.getString((String)SEVSOURCE, (String)"EntryCostCenter", (Locale)local);
        String entryExpenseType = ResourceBase.getString((String)SEVSOURCE, (String)"EntryExpenseType", (Locale)local);
        String entryOperationType = ResourceBase.getString((String)SEVSOURCE, (String)"EntryOperationType", (Locale)local);
        this.dimensionName.put(applierCompany + "EndString", "{[ApplierCompany].[" + total + "]}");
        this.dimensionName.put(orgUnit + "EndString", "{[OrgUnit].[" + total + "]}");
        this.dimensionName.put(costCompany + "EndString", "{[Company].[" + total + "]}");
        this.dimensionName.put(costCenter + "EndString", "{[CostCenter].[" + total + "]}");
        this.dimensionName.put(entryCompany + "EndString", "{[EntryCompany].[" + total + "]}");
        this.dimensionName.put(entryCostCenter + "EndString", "{[EntryCostCenter].[" + total + "]}");
        this.dimensionName.put(entryExpenseType + "EndString", "{[ExpenseType].[" + total + "]}");
        this.dimensionName.put(entryOperationType + "EndString", "{[OperationType].[" + total + "]}");
        this.dimensionName.put(applierCompany, "[ApplierCompany]");
        this.dimensionName.put(orgUnit, "[OrgUnit]");
        this.dimensionName.put(costCompany, "[Company]");
        this.dimensionName.put(costCenter, "[CostCenter]");
        this.dimensionName.put(entryCompany, "[EntryCompany]");
        this.dimensionName.put(entryCostCenter, "[EntryCostCenter]");
        this.dimensionName.put(entryExpenseType, "[ExpenseType]");
        this.dimensionName.put(entryOperationType, "[OperationType]");
    }
}

