/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.IVoucherAbstract;
import com.kingdee.eas.basedata.assistant.VoucherAbstractCollection;
import com.kingdee.eas.basedata.assistant.VoucherAbstractFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AbstractBizAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.AbstractBizAccountOutBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.AbstractDailyLoanBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.AbstractDailyPurchaseAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.AbstractTravelAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BillTypeCollection;
import com.kingdee.eas.cp.bc.BillTypeFactory;
import com.kingdee.eas.cp.bc.BillTypeInfo;
import com.kingdee.eas.cp.bc.BizAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizBillUtil;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountCollection;
import com.kingdee.eas.cp.bc.CollectionAccountCoreBaseInfo;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ICollectionAccount;
import com.kingdee.eas.cp.bc.ICommonUtilFacade;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.PayerTypeEnum;
import com.kingdee.eas.cp.bc.RePaymentBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CommonDataWebUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.CommonDataWebUtils");
    public static String peronType = "person";
    public static String companyType = "company";

    public static boolean checkBillHasRePaybill(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException, SQLException {
        boolean isHasRePaybill = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer markString = new StringBuffer("");
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)info.get("id").toString(), CompareType.EQUALS));
        markString.append("#0 ");
        filter.setMaskString(markString.toString());
        viewInfo.setFilter(filter);
        IQueryExecutor exec = null;
        IDynamicObject iDynamicObject = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        exec.setObjectView(viewInfo);
        IRowSet rs = exec.executeQuery();
        while (rs.next()) {
            PaymentBillInfo paymentInfo;
            String billId = rs.getString("destObjectID");
            ObjectUuidPK objpk = new ObjectUuidPK(billId);
            if (!CommonDataWebUtils.isPayMentBill(billId) || BillStatusEnum.PAYED == (paymentInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)objpk)).getBillStatus() || paymentInfo.getActPayLocAmt().compareTo(BizCollUtil.ZERO) >= 0) continue;
            isHasRePaybill = true;
        }
        return isHasRePaybill;
    }

    public static Map getOrgRangeByUser(Context ctx, String userId) throws BOSException, SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (userId == null || userId.length() <= 0) {
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            userId = user.getId().toString();
        }
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT FLONGNUMBER, TPOR.FORGID ").append("FROM T_PM_ORGRANGE TPOR INNER JOIN T_ORG_COMPANY TOC ON TPOR.FORGID = TOC.FID ").append("WHERE TPOR.FTYPE = ? AND TPOR.FUSERID = ? ");
        Object[] params = new Object[]{10, userId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params);
        if (rowSet != null) {
            while (rowSet.next()) {
                String id = rowSet.getObject("FORGID").toString();
                String longNumber = rowSet.getObject("FLONGNUMBER").toString();
                result.put(id, longNumber);
            }
        }
        return result;
    }

    public static List<String> getChildCompanyOrg(Context context) throws EASBizException, BOSException {
        ArrayList<String> companyOrgList = new ArrayList<String>();
        CompanyOrgUnitInfo currentCompanyOrgUnit = ContextUtil.getCurrentFIUnit((Context)context);
        String userId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        FilterInfo queryOrgRangeFilter = new FilterInfo();
        queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("type", (Object)OrgRangeType.BIZ_ORG_TYPE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(queryOrgRangeFilter);
        OrgRangeCollection orgRangeCollection = OrgRangeFactory.getLocalInstance((Context)context).getOrgRangeCollection(entityViewInfo);
        if (orgRangeCollection.size() == 0) {
            return companyOrgList;
        }
        StringBuffer oqlSb = new StringBuffer();
        oqlSb.append("select id where longNumber like '%").append(currentCompanyOrgUnit.getNumber()).append("!%' ").append("and id in (");
        int is = orgRangeCollection.size();
        for (int i = 0; i < is; ++i) {
            oqlSb.append("'").append(orgRangeCollection.get(i).getOrg().getId().toString()).append("',");
        }
        oqlSb.deleteCharAt(oqlSb.length() - 1);
        oqlSb.append(") ");
        CoreBaseCollection companyOrgUnits = CompanyOrgUnitFactory.getLocalInstance((Context)context).getCollection(oqlSb.toString());
        int js = companyOrgUnits.size();
        for (int j = 0; j < js; ++j) {
            companyOrgList.add(companyOrgUnits.get(j).getId().toString());
        }
        return companyOrgList;
    }

    public static String getChildCompanyOrgFilter(Context context) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompanyOrgUnit = ContextUtil.getCurrentFIUnit((Context)context);
        String sql = " id in (select fid from t_org_company where flongnumber like '" + currentCompanyOrgUnit.getLongNumber() + "%' and fisbizunit = 1 and fissealup = 0  and fid <> '" + currentCompanyOrgUnit.getId() + "')";
        return sql;
    }

    public static String getEqAndChildCompanyFilter(Context context, String companyId) throws EASBizException, BOSException {
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)context);
        ICompanyOrgUnit service = CompanyOrgUnitFactory.getLocalInstance((Context)context);
        if (companyId == null) {
            companyId = company.getId().toString();
        } else {
            company = service.getCompanyOrgUnitInfo("select id,parent,longNumber where id = '" + companyId + "'");
        }
        String orgRangeString = "select forgid from t_pm_orgrange where ftype = 10 and fuserid = '" + user.getId().toString() + "'";
        String eqString = null;
        String resultString = null;
        if (company.getParent() != null) {
            eqString = "select fid from t_org_company where fparentid = '" + company.getParent().getId().toString() + "' and fid <> '" + companyId + "'";
        }
        String childString = "select fid from t_org_company where flongnumber like '" + company.getLongNumber() + "%' and fid <> '" + companyId + "'";
        resultString = eqString == null ? "id in (" + orgRangeString + ") and id in (" + childString + ")" : "id in (" + orgRangeString + ") and (id in (" + childString + ") or id in (" + eqString + "))";
        return resultString;
    }

    public static List<String> getEqAndChildCompanyOrg(Context context, String companyId) throws EASBizException, BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)context);
        ICompanyOrgUnit service = CompanyOrgUnitFactory.getLocalInstance((Context)context);
        if (companyId == null) {
            companyId = company.getId().toString();
        } else {
            company = service.getCompanyOrgUnitInfo("select id,parent,longNumber where id = '" + companyId + "'");
        }
        String orgRangeString = "select forgid from t_pm_orgrange where ftype = 10 and fuserid = '" + user.getId().toString() + "'";
        String eqString = null;
        String resultString = null;
        if (company.getParent() != null) {
            eqString = "select fid from t_org_company where fparentid = '" + company.getParent().getId().toString() + "' and fid <> '" + companyId + "'";
        }
        String childString = "select fid from t_org_company where flongnumber like '" + company.getLongNumber() + "%' and fid <> '" + companyId + "'";
        resultString = eqString == null ? "id in (" + orgRangeString + ") and id in (" + childString + ")" : "id in (" + orgRangeString + ") and (id in (" + childString + ") or id in (" + eqString + "))";
        resultList.add(resultString);
        return resultList;
    }

    public static List<String> getEqAndChildPerson(Context context) throws EASBizException, BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        String companyFilter = CommonDataWebUtils.getEqAndChildCompanyFilter(context, null);
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("SELECT ADMINORGUNIT.fid ");
        selectSql.append(" FROM  T_ORG_PositionMember POSITIONMEMBER ");
        selectSql.append(" inner  JOIN T_ORG_Position POSITION  ON POSITIONMEMBER.FPositionID = POSITION.FID ");
        selectSql.append(" inner  JOIN T_ORG_Admin ADMINORGUNIT ON POSITION.FAdminOrgUnitID = ADMINORGUNIT.FID ");
        selectSql.append(" where  POSITIONMEMBER.fisPrimary=1 and ADMINORGUNIT.FID IN (" + companyFilter + ")  ");
        IRowSet set = DbUtil.executeQuery((Context)context, (String)selectSql.toString());
        try {
            while (set.next()) {
                resultList.add(set.getString("fid"));
            }
            return resultList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isPayMentBill(String id) {
        BOSObjectType bosType = null;
        PaymentBillInfo info = new PaymentBillInfo();
        bosType = info.getBOSType();
        return bosType.equals((Object)CommonDataWebUtils.getBOSType(id));
    }

    private static boolean isRepayMentBill(String id) {
        BOSObjectType bosType = null;
        RePaymentBillInfo info = new RePaymentBillInfo();
        bosType = info.getBOSType();
        return bosType.equals((Object)CommonDataWebUtils.getBOSType(id));
    }

    private static boolean isAgentMentBill(String id) {
        BOSObjectType bosType = null;
        AgentPayBillInfo info = new AgentPayBillInfo();
        bosType = info.getBOSType();
        return bosType.equals((Object)CommonDataWebUtils.getBOSType(id));
    }

    private static BOSObjectType getBOSType(String type) {
        int len = type.length();
        if (len >= 8) {
            return BOSUuid.getBOSObjectType((String)type, (boolean)true);
        }
        return null;
    }

    public static boolean checkBillHasNextBill(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException, SQLException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)info.get("id").toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        IRowSet rs = exec.executeQuery();
        return rs.next();
    }

    public static boolean checkForBillClose(Context ctx, String id) throws BOSException, EASBizException, SQLException {
        boolean isPass = true;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)id, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        IRowSet rs = exec.executeQuery();
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        while (rs.next()) {
            BizCollBillBaseInfo sourceinfo;
            IObjectValue destInfo;
            ObjectUuidPK objpk;
            String billId = rs.getString("destObjectID");
            if (CommonDataWebUtils.isRepayMentBill(billId)) {
                objpk = new ObjectUuidPK(billId);
                RePaymentBillInfo rePaymentBillInfo = (RePaymentBillInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, CommonDataWebUtils.getSelector());
                StateEnum billState = rePaymentBillInfo.getState();
                if (StateEnum.CHECKFAILD.equals((Object)billState) || StateEnum.CHECKED.equals((Object)billState) || StateEnum.ALREADVOUCHER.equals((Object)billState) || StateEnum.ALREADYABANDON.equals((Object)billState) || StateEnum.ISRECEIVEBILL.equals((Object)billState)) continue;
                isPass = false;
                break;
            }
            if (CommonDataWebUtils.isPayMentBill(billId) || CommonDataWebUtils.isVoucher(billId) || CommonDataWebUtils.isAgentMentBill(billId) || !((destInfo = iDynamicObject.getValue((objpk = new ObjectUuidPK(billId)).getObjectType(), (IObjectPK)objpk, CommonDataWebUtils.getSelector())) instanceof BizCollBillBaseInfo) || StateEnum.CLOSED.equals((Object)(sourceinfo = (BizCollBillBaseInfo)destInfo).getState()) || StateEnum.CHECKFAILD.equals((Object)sourceinfo.getState()) || StateEnum.ALREADYABANDON.equals((Object)sourceinfo.getState())) continue;
            isPass = false;
            break;
        }
        return isPass;
    }

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    private static boolean isVoucher(String id) {
        BOSObjectType bosType = CommonDataWebUtils.getBOSType(id);
        if (new VoucherInfo().getBOSType().equals((Object)bosType)) {
            return true;
        }
        return new PcVoucherInfo().getBOSType().equals((Object)bosType);
    }

    public static Set getApplierAdminOrgUnitIds(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
        Set ids = CommonDataWebUtils.getApplierAdminOrgUnitIds(ctx, company);
        return ids;
    }

    public static Set getApplierAdminOrgUnitIds(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        OrgUnitCollection unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(company.getId().toString(), 1, 0, selectors);
        if (unitColl == null) {
            return null;
        }
        for (int i = 0; i < unitColl.size(); ++i) {
            ids.add(unitColl.get(i).getId().toString());
        }
        boolean isAdminOrgShowByRange = CommonDataWebUtils.adminOrgShowByRange(ctx, "ViewAdminOrgShowByRange");
        if (isAdminOrgShowByRange) {
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            String userId = user.getId().toString();
            Set setIds = CommonDataWebUtils.getOrgIdsByUserAndType(ctx, userId, OrgRangeType.ADMIN_ORG_TYPE, null);
            ids.retainAll(setIds);
        }
        return ids;
    }

    public static boolean adminOrgShowByRange(Context ctx, String param) throws BOSException {
        if (StringUtils.isEmpty((String)param)) {
            return false;
        }
        String result = null;
        try {
            result = ParamManager.getParamValue((Context)ctx, null, (String)param);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return result != null && result.equalsIgnoreCase("true");
    }

    public static boolean adminOrgShowByRange(String param) throws BOSException {
        if (StringUtils.isEmpty((String)param)) {
            return false;
        }
        String result = null;
        try {
            result = ParamManager.getParamValue(null, null, (String)param);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return result != null && result.equalsIgnoreCase("true");
    }

    public static Map getApplierRelatedInfo(Context ctx, String applierId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            PositionInfo curInfo;
            PositionCollection col = PersonFactory.getLocalInstance((Context)ctx).getPositions(BOSUuid.read((String)applierId));
            AdminOrgUnitCollection admins = PersonFactory.getLocalInstance((Context)ctx).getAllAdminOrgUnit(BOSUuid.read((String)applierId));
            ObjectUuidPK userPK = new ObjectUuidPK(applierId);
            PersonInfo applier = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)userPK);
            ICommonUtilFacade iCommonUtilFacade = CommonUtilFacadeFactory.getLocalInstance(ctx);
            BizCollBillBaseInfo billInfo = iCommonUtilFacade.forLoanBillApplierAction(applier);
            result.put("costedDept", billInfo.getCostedDept());
            result.put("company", billInfo.getCompany());
            result.put("mainOrg", billInfo.getOrgUnit());
            result.put("mainPosition", billInfo.getPosition());
            result.put("cell", billInfo.getTel());
            Iterator it = col.iterator();
            StringBuffer sb = new StringBuffer();
            sb.append("id in (");
            while (it.hasNext()) {
                curInfo = (PositionInfo)it.next();
                sb.append("'").append(curInfo.getId().toString()).append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(") and Person.id = '" + applierId + "' ");
            result.put("positionFilter", sb.toString());
            it = admins.iterator();
            sb.setLength(0);
            sb.append("id in (");
            while (it.hasNext()) {
                curInfo = (AdminOrgUnitInfo)it.next();
                sb.append("'").append(curInfo.getId().toString()).append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")");
            result.put("orgFilter", sb.toString());
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getCostDeptFilter(Context ctx, String companyId) throws BOSException, EASBizException {
        Boolean isDelimitOrgScope = false;
        Set orgRangeSet = null;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP019");
        Map paramMap = null;
        paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        isDelimitOrgScope = paramMap.get("CP019") == null ? false : new Boolean(paramMap.get("CP019").toString());
        if (isDelimitOrgScope.booleanValue()) {
            String userid = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
            orgRangeSet = CommonDataWebUtils.getOrgIdsByUserAndType(ctx, userid, OrgRangeType.BIZ_ORG_TYPE, null);
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("CP019", isDelimitOrgScope);
        return CommonDataWebUtils.getCostDepFilter(ctx, companyId, map, orgRangeSet);
    }

    public static Set getCostDeptIds(Context ctx, String companyId) throws BOSException, EASBizException {
        Boolean isDelimitOrgScope = false;
        Set orgRangeSet = null;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP019");
        Map paramMap = null;
        paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        isDelimitOrgScope = paramMap.get("CP019") == null ? false : new Boolean(paramMap.get("CP019").toString());
        if (isDelimitOrgScope.booleanValue()) {
            String userid = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
            orgRangeSet = CommonDataWebUtils.getOrgIdsByUserAndType(ctx, userid, OrgRangeType.BIZ_ORG_TYPE, null);
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("CP019", isDelimitOrgScope);
        return CommonDataWebUtils.getCostDeptIds(ctx, companyId, map, orgRangeSet);
    }

    public static String getCompanyFilter(Context ctx, Set orgRangeSet, Boolean isDelimitUserOrgScope) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        if (!isDelimitUserOrgScope.booleanValue()) {
            return filterInfo.toString();
        }
        if (orgRangeSet.isEmpty()) {
            filterItems.add(new FilterItemInfo("id", (Object)"nodata", CompareType.EQUALS));
        } else {
            filterItems.add(new FilterItemInfo("id", (Object)orgRangeSet, CompareType.INCLUDE));
        }
        return filterInfo.toString();
    }

    public static FilterInfo getDefaultCUFilter(Context ctx) {
        FilterInfo filter = new FilterInfo();
        CtrlUnitInfo ctrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (ctrlUnit == null) {
            return filter;
        }
        HashSet<String> cuSet = new HashSet<String>();
        cuSet.add(ctrlUnit.getId().toString());
        cuSet.add("11111111-1111-1111-1111-111111111111CCE7AED4");
        cuSet.add("00000000-0000-0000-0000-000000000000CCE7AED4");
        filter.getFilterItems().add(new FilterItemInfo("CU.id", cuSet, CompareType.INCLUDE));
        return filter;
    }

    public static Set getOrgIdsByUserAndType(Context ctx, String userid, OrgRangeType orgRangeType, Set orgIdSet) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterColl = filter.getFilterItems();
        filterColl.add(new FilterItemInfo("user.id", (Object)userid));
        filterColl.add(new FilterItemInfo("type", (Object)String.valueOf(orgRangeType.getValue())));
        if (orgIdSet != null && orgIdSet.size() > 0) {
            filterColl.add(new FilterItemInfo("org.id", (Object)orgIdSet, CompareType.INCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        OrgRangeCollection orgcon = iOrgRange.getOrgRangeCollection(evi);
        int j = orgcon.size();
        for (int i = 0; i < j; ++i) {
            if (orgcon.get(i) == null || orgcon.get(i).getOrg() == null || orgcon.get(i).getOrg().getId() == null) continue;
            ret.add(orgcon.get(i).getOrg().getId().toString());
        }
        return ret;
    }

    public static String getCostDepFilter(Context ctx, String companyId, Map map, Set orgRangeIds) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        OrgUnitCollection unitColl = null;
        if (StringUtils.isNotBlank((String)companyId) && !companyId.equals("null")) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(companyId, 1, 5);
        }
        Set<String> orgIdSet = new HashSet();
        Boolean isDelimitUserOrgScope = new Boolean(false);
        if (map != null && map.size() > 0) {
            isDelimitUserOrgScope = (Boolean)map.get("CP019");
        }
        if (isDelimitUserOrgScope != null && isDelimitUserOrgScope.booleanValue()) {
            Set setIds = orgRangeIds;
            if (setIds != null && setIds.size() > 0 && unitColl != null && unitColl.size() > 0) {
                String temp = null;
                for (int i = unitColl.size() - 1; i >= 0; --i) {
                    temp = unitColl.get(i).getId().toString();
                    if (!setIds.contains(temp)) continue;
                    orgIdSet.add(temp);
                }
            }
        } else if (unitColl != null) {
            for (int i = unitColl.size() - 1; i >= 0; --i) {
                String temp = unitColl.get(i).getId().toString();
                orgIdSet.add(temp);
            }
        }
        if ((StringUtils.isBlank((String)companyId) || companyId.equals("null")) && orgRangeIds != null) {
            orgIdSet = orgRangeIds;
        }
        if (orgIdSet.size() > 0) {
            fic.add(new FilterItemInfo("id", orgIdSet, CompareType.INCLUDE));
        } else if (isDelimitUserOrgScope.booleanValue() && orgIdSet.size() < 1) {
            fic.add(new FilterItemInfo("id", (Object)"-1", CompareType.INCLUDE));
        }
        return filter.toString();
    }

    public static Set getCostDeptIds(Context ctx, String companyId, Map map, Set orgRangeIds) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        OrgUnitCollection unitColl = null;
        if (StringUtils.isNotBlank((String)companyId) && !companyId.equals("null")) {
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add(new SelectorItemInfo("fromUnit.id"));
            unitColl = BizBillUtil.getFromUnit(ctx, companyId, 1, 5, selectors);
        }
        Set<String> orgIdSet = new HashSet();
        Boolean isDelimitUserOrgScope = new Boolean(false);
        if (map != null && map.size() > 0) {
            isDelimitUserOrgScope = (Boolean)map.get("CP019");
        }
        if (isDelimitUserOrgScope != null && isDelimitUserOrgScope.booleanValue()) {
            Set setIds = orgRangeIds;
            if (setIds != null && setIds.size() > 0 && unitColl != null && unitColl.size() > 0) {
                String temp = null;
                for (int i = unitColl.size() - 1; i >= 0; --i) {
                    temp = unitColl.get(i).getId().toString();
                    if (!setIds.contains(temp)) continue;
                    orgIdSet.add(temp);
                }
            }
        } else if (unitColl != null) {
            for (int i = unitColl.size() - 1; i >= 0; --i) {
                String temp = unitColl.get(i).getId().toString();
                orgIdSet.add(temp);
            }
        }
        if ((StringUtils.isBlank((String)companyId) || companyId.equals("null")) && orgRangeIds != null) {
            orgIdSet = orgRangeIds;
        }
        if (isDelimitUserOrgScope.booleanValue() && orgIdSet.size() < 1) {
            orgIdSet.add("-1");
        }
        return orgIdSet;
    }

    public static Set getOrgIdsByUserAndType(Context ctx, String userid, String orgRangeType, Set orgIdSet) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterColl = filter.getFilterItems();
        filterColl.add(new FilterItemInfo("user.id", (Object)userid));
        filterColl.add(new FilterItemInfo("type", (Object)orgRangeType));
        if (orgIdSet != null && orgIdSet.size() > 0) {
            filterColl.add(new FilterItemInfo("org.id", (Object)orgIdSet, CompareType.INCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        OrgRangeCollection orgcon = iOrgRange.getOrgRangeCollection(evi);
        int j = orgcon.size();
        for (int i = 0; i < j; ++i) {
            if (orgcon.get(i) == null || orgcon.get(i).getOrg() == null || orgcon.get(i).getOrg().getId() == null) continue;
            ret.add(orgcon.get(i).getOrg().getId().toString());
        }
        return ret;
    }

    @Deprecated
    public static void initDefaultPersonalBank(Context ctx, BizCollBillBaseInfo info) throws BOSException {
        CommonDataWebUtils.initDefaultPersonalBank(ctx, info, true);
    }

    @Deprecated
    public static void initDefaultPersonalBank(Context ctx, BizCollBillBaseInfo info, boolean ifAllowBlank) throws BOSException {
        CollectionAccountCoreBaseInfo collectionEntry;
        int i;
        CollectionAccountCoreBaseInfo collection;
        AbstractObjectCollection collectionEntries;
        if (info == null) {
            return;
        }
        CollectionAccountInfo collectionAccount = BizBillUtil.getDefaultCollectionAccount(ctx, null);
        if (collectionAccount == null) {
            if (!ifAllowBlank) {
                return;
            }
            collectionAccount = new CollectionAccountInfo();
        }
        if (info.getPayerName() == null && info.getPayerBank() == null && info.getPayerAccount() == null) {
            info.setCollectionAccount(collectionAccount);
            info.setPayerAccount(collectionAccount.getBankAccount());
            info.setPayerName(collectionAccount.getPayee());
            info.setPayerBank(collectionAccount.getBebankStr());
            info.setOpenArea(collectionAccount.getOpenArea());
            info.setPayerBankStr(collectionAccount.getBebank());
        }
        if (info instanceof DailyPurchaseAccountBillInfo && ((DailyPurchaseAccountBillInfo)info).getPayerType() == null) {
            ((DailyPurchaseAccountBillInfo)info).setPayerType(PayerTypeEnum.other);
        }
        if (info instanceof BizAccountOutBillInfo && ((BizAccountOutBillInfo)info).getPayerType() == null) {
            ((BizAccountOutBillInfo)info).setPayerType(PayerTypeEnum.other);
        }
        if (info instanceof DailyLoanBillInfo) {
            collectionEntries = ((DailyLoanBillInfo)info).getCollectionEntries();
            collection = new DailyLoanBillAccountEntryInfo();
            if (collectionEntries != null && collectionEntries.size() > 0) {
                for (i = 0; i < collectionEntries.size(); ++i) {
                    collectionEntry = collectionEntries.get(i);
                    ((DailyLoanBillInfo)info).getCollectionEntries().add((DailyLoanBillAccountEntryInfo)collectionEntry);
                }
            } else {
                BizBillUtil.setDefaultPersonalBankExtendFields(ctx, collection, collectionAccount);
                collection.setId(BOSUuid.create((BOSObjectType)((AbstractDailyLoanBillAccountEntryInfo)collection).getBOSType()));
                ((AbstractDailyLoanBillAccountEntryInfo)collection).setPayerType(PayerTypeEnum.other);
                collection.setPayerName(collectionAccount.getPayee());
                collection.setPayerBank(collectionAccount.getBebankStr());
                collection.setPayerBankF7(collectionAccount.getBebank());
                collection.setPayerAccount(collectionAccount.getBankAccount());
                collection.setOpenArea(collectionAccount.getOpenArea());
                collection.setAmountOri(new BigDecimal(0.0));
                collection.setAmount(new BigDecimal(0.0));
                collection.setExchangeRate(new BigDecimal(1.0));
                collection.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                collection.setExchangeRatePrecision(4);
                collection.setCurrencyType(info.getCurrencyType());
                collection.setPayMode(((DailyLoanBillInfo)info).getPayMode());
                ((DailyLoanBillInfo)info).getCollectionEntries().add((DailyLoanBillAccountEntryInfo)collection);
            }
        }
        if (info instanceof BizAccountBillInfo) {
            collectionEntries = ((BizAccountBillInfo)info).getCollectionEntries();
            collection = new BizAccountBillAccountEntryInfo();
            if (collectionEntries != null && collectionEntries.size() > 0) {
                for (i = 0; i < collectionEntries.size(); ++i) {
                    collectionEntry = collectionEntries.get(i);
                    ((BizAccountBillInfo)info).getCollectionEntries().add((BizAccountBillAccountEntryInfo)collectionEntry);
                }
            } else {
                BizBillUtil.setDefaultPersonalBankExtendFields(ctx, collection, collectionAccount);
                collection.setId(BOSUuid.create((BOSObjectType)((AbstractBizAccountBillAccountEntryInfo)collection).getBOSType()));
                collection.setPayerName(collectionAccount.getPayee());
                collection.setPayerBank(collectionAccount.getBebankStr());
                collection.setPayerBankF7(collectionAccount.getBebank());
                collection.setPayerAccount(collectionAccount.getBankAccount());
                collection.setOpenArea(collectionAccount.getOpenArea());
                collection.setAmountOri(new BigDecimal(0.0));
                collection.setAmount(new BigDecimal(0.0));
                collection.setExchangeRate(new BigDecimal(1.0));
                collection.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                collection.setExchangeRatePrecision(4);
                collection.setCurrencyType(info.getCurrencyType());
                collection.setPayMode(((BizAccountBillInfo)info).getPayMode());
                ((BizAccountBillInfo)info).getCollectionEntries().add((BizAccountBillAccountEntryInfo)collection);
            }
        }
        if (info instanceof TravelAccountBillInfo) {
            collectionEntries = ((TravelAccountBillInfo)info).getCollectionEntries();
            collection = new TravelAccountBillAccountEntryInfo();
            if (collectionEntries != null && collectionEntries.size() > 0) {
                for (i = 0; i < collectionEntries.size(); ++i) {
                    collectionEntry = collectionEntries.get(i);
                    ((TravelAccountBillInfo)info).getCollectionEntries().add((TravelAccountBillAccountEntryInfo)collectionEntry);
                }
            } else {
                BizBillUtil.setDefaultPersonalBankExtendFields(ctx, collection, collectionAccount);
                collection.setId(BOSUuid.create((BOSObjectType)((AbstractTravelAccountBillAccountEntryInfo)collection).getBOSType()));
                collection.setPayerName(collectionAccount.getPayee());
                collection.setPayerBank(collectionAccount.getBebankStr());
                collection.setPayerBankF7(collectionAccount.getBebank());
                collection.setPayerAccount(collectionAccount.getBankAccount());
                collection.setOpenArea(collectionAccount.getOpenArea());
                collection.setAmountOri(new BigDecimal(0.0));
                collection.setAmount(new BigDecimal(0.0));
                collection.setExchangeRate(new BigDecimal(1.0));
                collection.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                collection.setExchangeRatePrecision(4);
                collection.setCurrencyType(info.getCurrencyType());
                collection.setPayMode(((TravelAccountBillInfo)info).getPayMode());
                ((TravelAccountBillInfo)info).getCollectionEntries().add((TravelAccountBillAccountEntryInfo)collection);
            }
        }
        if (info instanceof BizAccountOutBillInfo) {
            collectionEntries = ((BizAccountOutBillInfo)info).getCollectionEntries();
            collection = new BizAccountOutBillAccountEntryInfo();
            if (collectionEntries != null && collectionEntries.size() > 0) {
                for (i = 0; i < collectionEntries.size(); ++i) {
                    collectionEntry = collectionEntries.get(i);
                    ((BizAccountOutBillInfo)info).getCollectionEntries().add((BizAccountOutBillAccountEntryInfo)collectionEntry);
                }
            } else {
                if (((BizAccountOutBillInfo)info).getReqCheckEntries() != null && ((BizAccountOutBillInfo)info).getReqCheckEntries().size() > 0) {
                    ((AbstractBizAccountOutBillAccountEntryInfo)collection).setPayerType(PayerTypeEnum.other);
                } else {
                    ((AbstractBizAccountOutBillAccountEntryInfo)collection).setPayerType(PayerTypeEnum.supplier);
                }
                if (PayerTypeEnum.other.equals((Object)((AbstractBizAccountOutBillAccountEntryInfo)collection).getPayerType())) {
                    BizBillUtil.setDefaultPersonalBankExtendFields(ctx, collection, collectionAccount);
                    collection.setPayerName(collectionAccount.getPayee());
                    collection.setPayerBank(collectionAccount.getBebankStr());
                    collection.setPayerBankF7(collectionAccount.getBebank());
                    collection.setPayerAccount(collectionAccount.getBankAccount());
                    collection.setOpenArea(collectionAccount.getOpenArea());
                }
                collection.setId(BOSUuid.create((BOSObjectType)((AbstractBizAccountOutBillAccountEntryInfo)collection).getBOSType()));
                collection.setAmountOri(new BigDecimal(0.0));
                collection.setAmount(new BigDecimal(0.0));
                collection.setExchangeRate(new BigDecimal(1.0));
                collection.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                collection.setExchangeRatePrecision(4);
                collection.setCurrencyType(info.getCurrencyType());
                collection.setPayMode(((BizAccountOutBillInfo)info).getPayMode());
                ((BizAccountOutBillInfo)info).getCollectionEntries().add((BizAccountOutBillAccountEntryInfo)collection);
            }
        }
        if (info instanceof DailyPurchaseAccountBillInfo) {
            collectionEntries = ((DailyPurchaseAccountBillInfo)info).getCollectionEntries();
            collection = new DailyPurchaseAccountBillAccountEntryInfo();
            if (collectionEntries != null && collectionEntries.size() > 0) {
                for (i = 0; i < collectionEntries.size(); ++i) {
                    collectionEntry = collectionEntries.get(i);
                    ((DailyPurchaseAccountBillInfo)info).getCollectionEntries().add((DailyPurchaseAccountBillAccountEntryInfo)collectionEntry);
                }
            } else {
                if (((DailyPurchaseAccountBillInfo)info).getReqCheckEntries() != null && ((DailyPurchaseAccountBillInfo)info).getReqCheckEntries().size() > 0) {
                    ((AbstractDailyPurchaseAccountBillAccountEntryInfo)collection).setPayerType(PayerTypeEnum.other);
                } else {
                    ((AbstractDailyPurchaseAccountBillAccountEntryInfo)collection).setPayerType(PayerTypeEnum.supplier);
                }
                if (PayerTypeEnum.other.equals((Object)((AbstractDailyPurchaseAccountBillAccountEntryInfo)collection).getPayerType())) {
                    BizBillUtil.setDefaultPersonalBankExtendFields(ctx, collection, collectionAccount);
                    collection.setPayerName(collectionAccount.getPayee());
                    collection.setPayerBank(collectionAccount.getBebankStr());
                    collection.setPayerBankF7(collectionAccount.getBebank());
                    collection.setPayerAccount(collectionAccount.getBankAccount());
                    collection.setOpenArea(collectionAccount.getOpenArea());
                }
                collection.setId(BOSUuid.create((BOSObjectType)((AbstractDailyPurchaseAccountBillAccountEntryInfo)collection).getBOSType()));
                collection.setAmountOri(new BigDecimal(0.0));
                collection.setAmount(new BigDecimal(0.0));
                collection.setExchangeRate(new BigDecimal(1.0));
                collection.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                collection.setExchangeRatePrecision(4);
                collection.setCurrencyType(info.getCurrencyType());
                collection.setPayMode(((DailyPurchaseAccountBillInfo)info).getPayMode());
                ((DailyPurchaseAccountBillInfo)info).getCollectionEntries().add((DailyPurchaseAccountBillAccountEntryInfo)collection);
            }
        }
    }

    public static void savePayerInfo(BizCollBillBaseInfo model, Context ctx) throws BOSException, EASBizException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String personId = user.getPerson().getId().toString();
        ICollectionAccount collectionAccount = CollectionAccountFactory.getLocalInstance(ctx);
        StringBuilder log = new StringBuilder();
        log.append("##savePayerInfo number=" + model.getNumber());
        if (model instanceof EvectionLoanBillInfo && model.getBoolean("savePayerInfoIsBill")) {
            boolean exist;
            String payerAccount = model.getPayerAccount();
            String payerName = model.getPayerName();
            String payerBank = model.getPayerBank();
            BEBankInfo payerBankStr = model.getPayerBankStr();
            OpenAreaInfo openArea = model.getOpenArea();
            if (StringUtils.isBlank((String)payerAccount) || StringUtils.isBlank((String)payerBank) || StringUtils.isBlank((String)payerName)) {
                return;
            }
            payerAccount = payerAccount.replaceAll("\\s*", "");
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)payerAccount));
            filterInfo.getFilterItems().add(new FilterItemInfo("applier", (Object)personId));
            entityViewInfo.setFilter(filterInfo);
            CollectionAccountCollection collectionAccountCollection = collectionAccount.getCollectionAccountCollection(entityViewInfo);
            boolean bl = exist = collectionAccountCollection.size() != 0;
            if (exist && collectionAccountCollection.get(0).isIsShare()) {
                return;
            }
            CollectionAccountInfo collectionAccountInfo = exist ? collectionAccountCollection.get(0) : new CollectionAccountInfo();
            collectionAccountInfo.setState(EnableStateEnum.ENABLE);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            collectionAccountInfo.setApplier(personInfo);
            collectionAccountInfo.setState(EnableStateEnum.ENABLE);
            collectionAccountInfo.setPayee(payerName);
            collectionAccountInfo.setBebankStr(payerBank);
            collectionAccountInfo.setBebank(payerBankStr);
            collectionAccountInfo.setBankAccount(payerAccount);
            collectionAccountInfo.setOpenArea(openArea);
            if (collectionAccountInfo.getCompany() == null) {
                CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
                collectionAccountInfo.setCompany(company);
            }
            if (!exist) {
                collectionAccountInfo.setIsPublicAccount(false);
                collectionAccountInfo.setIsDefault(false);
            }
            collectionAccount.save((CoreBaseInfo)collectionAccountInfo);
            log.append(";" + payerName + "," + payerAccount + ",exist=" + exist);
        } else if (model instanceof ExpenseAccountBillInfo || model instanceof LoanBillInfo) {
            AbstractObjectCollection collectionAccounts = (AbstractObjectCollection)model.get("collectionEntries");
            int is = collectionAccounts.size();
            for (int i = 0; i < is; ++i) {
                boolean exist;
                CollectionAccountCoreBaseInfo accountInfo = (CollectionAccountCoreBaseInfo)collectionAccounts.getObject(i);
                if (model instanceof BizAccountOutBillInfo || model instanceof DailyPurchaseAccountBillInfo || model instanceof DailyLoanBillInfo) {
                    Integer parseInt = (Integer)accountInfo.get("payerType");
                    if (PayerTypeEnum.other.getValue() != parseInt.intValue()) continue;
                }
                String payerAccount = accountInfo.getPayerAccount();
                String payerName = accountInfo.getPayerName();
                String payerBank = accountInfo.getPayerBank();
                OpenAreaInfo openArea = accountInfo.getOpenArea();
                if (StringUtils.isBlank((String)payerAccount) || StringUtils.isBlank((String)payerBank) || StringUtils.isBlank((String)payerName)) continue;
                payerAccount = payerAccount.replaceAll("\\s*", "");
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)payerAccount));
                filterInfo.getFilterItems().add(new FilterItemInfo("creator.id", (Object)user.getId().toString()));
                filterInfo.getFilterItems().add(new FilterItemInfo("payee", (Object)payerName));
                entityViewInfo.setFilter(filterInfo);
                CollectionAccountCollection collectionAccountCollection = collectionAccount.getCollectionAccountCollection(entityViewInfo);
                boolean bl = exist = collectionAccountCollection.size() != 0;
                if (exist && collectionAccountCollection.get(0).isIsShare()) continue;
                CollectionAccountInfo collectionAccountInfo = exist ? collectionAccountCollection.get(0) : new CollectionAccountInfo();
                BizBillUtil.setCollectionAccountExtendFields(ctx, accountInfo, collectionAccountInfo);
                collectionAccountInfo.setState(EnableStateEnum.ENABLE);
                if (!exist) {
                    collectionAccountInfo.setCreator(user);
                    collectionAccountInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                } else {
                    collectionAccountInfo.setLastUpdateUser(user);
                    collectionAccountInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                }
                Object payerId = accountInfo.get("payerId");
                if (payerId != null && StringUtils.isNotEmpty((String)payerId.toString())) {
                    if (BOSUuid.isValidLength((String)payerId.toString()) && new PersonInfo().getBOSType().equals((Object)BizCollUtil.getBOSType(payerId.toString()))) {
                        PersonInfo personInfo = new PersonInfo();
                        personInfo.setId(BOSUuid.read((String)payerId.toString()));
                        collectionAccountInfo.setApplier(personInfo);
                    }
                } else {
                    collectionAccountInfo.setApplier(null);
                }
                collectionAccountInfo.setState(EnableStateEnum.ENABLE);
                collectionAccountInfo.setPayee(payerName);
                collectionAccountInfo.setBebankStr(payerBank);
                collectionAccountInfo.setBebank(accountInfo.getPayerBankF7());
                collectionAccountInfo.setBankAccount(payerAccount);
                collectionAccountInfo.setOpenArea(openArea);
                if (collectionAccountInfo.getCompany() == null) {
                    CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
                    collectionAccountInfo.setCompany(company);
                }
                if (!exist) {
                    collectionAccountInfo.setIsPublicAccount(accountInfo.getBoolean("isPublicAccount"));
                    collectionAccountInfo.setIsDefault(false);
                }
                collectionAccount.save((CoreBaseInfo)collectionAccountInfo);
                log.append(";" + payerName + "," + payerAccount + ",exist=" + exist);
            }
        }
        logger.info((Object)log);
    }

    @Deprecated
    public static CollectionAccountInfo initDefaultPersonalBank(Context ctx) throws BOSException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        CollectionAccountInfo collectionAccount = null;
        BOSObjectType collectionBosType = new CollectionAccountInfo().getBOSType();
        String personId = user.getPerson().getId().toString();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = BizBillUtil.getCollectionAccountSelector();
        SelectorItemCollection extendSic = BizBillUtil.getEntityNoEntryDepPropertySelector(ctx, collectionBosType, true, true, false);
        sic.addObjectCollection((IObjectCollection)extendSic);
        entityViewInfo.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("APPLIER.ID", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("ISDEFAULT", (Object)1));
        entityViewInfo.setFilter(filter);
        CollectionAccountCollection collectionAccountCollection = CollectionAccountFactory.getLocalInstance(ctx).getCollectionAccountCollection(entityViewInfo);
        if (collectionAccountCollection.size() > 0) {
            collectionAccount = (CollectionAccountInfo)collectionAccountCollection.getObject(0);
        }
        return collectionAccount;
    }

    public static List<String> getAdminOrgIdListByCompany(List<String> companyOrgUnitIds, Context context) throws BOSException {
        ArrayList<String> adminOrgIdList = new ArrayList<String>();
        FilterInfo queryAdminOrgFilter = new FilterInfo();
        queryAdminOrgFilter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0, CompareType.EQUALS));
        queryAdminOrgFilter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1, CompareType.EQUALS));
        queryAdminOrgFilter.getFilterItems().add(new FilterItemInfo("toUnit", new HashSet<String>(companyOrgUnitIds), CompareType.INCLUDE));
        queryAdminOrgFilter.setMaskString("#0 AND #1 AND #2");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(queryAdminOrgFilter);
        CoreBaseCollection orgUnitRelations = OrgUnitRelationFactory.getLocalInstance((Context)context).getCollection(entityViewInfo);
        int is = orgUnitRelations.size();
        for (int i = 0; i < is; ++i) {
            OrgUnitRelationInfo orgUnitRelationInfo = (OrgUnitRelationInfo)orgUnitRelations.get(i);
            adminOrgIdList.add(orgUnitRelationInfo.getFromUnit().getId().toString());
        }
        return adminOrgIdList;
    }

    public static String getAdminOrgIdsByCompany(List<String> companyOrgUnitIds, Context context) throws BOSException {
        List<String> adminOrgIdList = CommonDataWebUtils.getAdminOrgIdListByCompany(companyOrgUnitIds, context);
        StringBuffer adminOrgUnitIdsBuffer = new StringBuffer();
        int is = adminOrgIdList.size();
        for (int i = 0; i < is; ++i) {
            adminOrgUnitIdsBuffer.append("'").append(adminOrgIdList.get(i)).append("',");
        }
        adminOrgUnitIdsBuffer.deleteCharAt(adminOrgUnitIdsBuffer.length() - 1);
        return adminOrgUnitIdsBuffer.toString();
    }

    public static SelectorItemCollection getAccountSelector(String linkType) {
        SelectorItemCollection selecon = new SelectorItemCollection();
        selecon.add(new SelectorItemInfo("" + linkType + ".id"));
        return selecon;
    }

    public static Set convertSet(AbstractObjectCollection con) {
        HashSet<String> set = new HashSet<String>();
        int is = con.size();
        for (int i = 0; i < is; ++i) {
            set.add(con.getObject(i).getObjectValue("company").get("id").toString());
        }
        return set;
    }

    public static Set<String> getPropIds(AbstractObjectCollection collection, String propertyName) {
        HashSet<String> idSet = new HashSet<String>();
        int is = collection.size();
        for (int i = 0; i < is; ++i) {
            idSet.add(collection.getObject(i).getObjectValue(propertyName).get("id").toString());
        }
        return idSet;
    }

    public static Set getIds(List<Map> list) {
        HashSet<String> idlist = new HashSet<String>();
        int is = list.size();
        for (int i = 0; i < is; ++i) {
            idlist.add(list.get(i).get("id").toString());
        }
        return idlist;
    }

    public static String getSpecialData(Context ctx, String userId) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        String result = null;
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
        if (userInfo.getPerson() != null) {
            String personID = userInfo.getPerson().getId().toString();
            result = CommonDataWebUtils.getPositionLongNumbers(ctx, personID);
        }
        if (result != null && result.length() > 0) {
            return result;
        }
        return null;
    }

    private static String getPositionLongNumbers(Context context, String personID) throws BOSException, EASBizException {
        StringBuffer adminids = new StringBuffer();
        String adminid = null;
        String childAdminId = null;
        StringBuffer stringBuffer = new StringBuffer(400);
        stringBuffer.append("SELECT PositionChild.FAdminOrgUnitID as childAdminId,Position.FAdminOrgUnitID as AdminId FROM T_ORG_PositionHierarchy PositionHierarchy ").append(" INNER JOIN T_ORG_PositionMember PositionMember ON PositionHierarchy.Fparentid = PositionMember.FPositionID ").append(" INNER JOIN T_BD_Person Person ON PositionMember.FPersonID = Person.FID ").append(" INNER JOIN T_ORG_Position PositionChild ON PositionChild.FID = PositionHierarchy.FchildID ").append(" INNER JOIN T_ORG_Position Position ON Position.FID = PositionMember.FPositionID ").append(" WHERE PositionMember.FPersonID = ? and Position.fisRespPosition=1 AND PositionHierarchy.FHierarchyID = '00000000-0000-0000-0000-000000000001396FCAD0' ");
        Object[] params = new Object[]{personID};
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)stringBuffer.toString(), (Object[])params);
        try {
            while (rowSet.next()) {
                childAdminId = rowSet.getString("childAdminId");
                adminid = rowSet.getString("AdminId");
                if (!StringUtils.isEmpty((String)adminid) && adminids.indexOf(adminid) < 0) {
                    adminids.append(adminid + ",");
                }
                if (StringUtils.isEmpty((String)childAdminId) || adminids.indexOf(childAdminId) >= 0) continue;
                adminids.append(childAdminId + ",");
            }
            if (adminids.length() > 0) {
                adminids.setLength(adminids.length() - 1);
            }
        }
        catch (SQLException e) {
            throw new PermissionException(PermissionException.GET_INFO_FAIL, (Throwable)e);
        }
        return adminids.toString();
    }

    public static Map getPersonIdsByAdminIds(Context ctx, String ids) throws BOSException, SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        FilterItemInfo item = new FilterItemInfo("admin.FID", (Object)ids, CompareType.INCLUDE);
        sb.append("SELECT person.FID ID,person.FName_l2 Name ");
        sb.append("FROM t_bd_person person ");
        sb.append("INNER JOIN t_org_positionmember member ON member.FPersonID = person.FID ");
        sb.append("INNER JOIN t_org_position position ON position.FID = member.FPositionID ");
        sb.append("INNER JOIN t_org_admin admin ON admin.FID = position.FAdminOrgUnitID ");
        sb.append("WHERE ").append(item.toString());
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        while (set.next()) {
            result.put(set.getString("ID"), set.getString("Name"));
        }
        return result;
    }

    public static List<String> getEqAndChildCuIds(Context context, String orgId) throws BOSException, EASBizException {
        ArrayList<String> resultList = new ArrayList<String>();
        ICtrlUnit ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)context);
        CtrlUnitInfo ctrlUnitInfo = ctrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String number = ctrlUnitInfo.getNumber();
        String userId = ContextUtil.getCurrentUserInfo((Context)context).getId().toString();
        FilterInfo queryOrgRangeFilter = new FilterInfo();
        queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        queryOrgRangeFilter.getFilterItems().add(new FilterItemInfo("type", (Object)OrgRangeType.BIZ_ORG_TYPE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(queryOrgRangeFilter);
        OrgRangeCollection orgRangeCollection = OrgRangeFactory.getLocalInstance((Context)context).getOrgRangeCollection(entityViewInfo);
        if (orgRangeCollection.size() == 0) {
            return resultList;
        }
        StringBuffer oqlSb = new StringBuffer();
        if (ctrlUnitInfo.getParent() != null) {
            CtrlUnitInfo parentCu = ctrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(ctrlUnitInfo.getParent().getId()));
            if (parentCu.getParent() == null) {
                oqlSb.append("select id where (longnumber like '%");
            } else {
                oqlSb.append("select id where (longnumber like '%!");
            }
            oqlSb.append(parentCu.getNumber()).append("!%' ").append("and number != '").append(number).append("') ");
        } else {
            oqlSb.append("select id where (longnumber like '").append(number).append("!%') ");
        }
        oqlSb.append(" and id in (");
        int js = orgRangeCollection.size();
        for (int j = 0; j < js; ++j) {
            oqlSb.append("'").append(orgRangeCollection.get(j).getOrg().getId().toString()).append("'").append(",");
        }
        oqlSb.deleteCharAt(oqlSb.length() - 1);
        oqlSb.append(") ");
        CoreBaseCollection cuCollection = ctrlUnit.getCollection(oqlSb.toString());
        int is = cuCollection.size();
        for (int i = 0; i < is; ++i) {
            resultList.add(cuCollection.get(i).getId().toString());
        }
        return resultList;
    }

    public static String getParentCuIdsFilter(Context context, String orgId) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        StringBuffer oqlSb = new StringBuffer();
        ICtrlUnit ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)context);
        CtrlUnitInfo ctrlUnitInfo = ctrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String longNumber = ctrlUnitInfo.getLongNumber();
        String[] number = longNumber.split("!");
        oqlSb.append("in (");
        for (int i = 0; i < number.length; ++i) {
            oqlSb.append("'").append(number[i]).append("'").append(",");
        }
        oqlSb.deleteCharAt(oqlSb.length() - 1);
        oqlSb.append(") ");
        return oqlSb.toString();
    }

    public static String[] getParentCuIds(Context context, String orgId) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        StringBuffer oqlSb = new StringBuffer();
        ICtrlUnit ctrlUnit = CtrlUnitFactory.getLocalInstance((Context)context);
        CtrlUnitInfo ctrlUnitInfo = ctrlUnit.getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String[] number = new String[]{""};
        if (ctrlUnitInfo != null) {
            String longNumber = ctrlUnitInfo.getLongNumber();
            number = longNumber.split("!");
        }
        return number;
    }

    public static List<String> getChildAdminIds(Context context) throws BOSException, EASBizException {
        ArrayList<String> adminIds = new ArrayList<String>();
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
        List companyOrgUnitIds = OrgRangeFactory.getLocalInstance((Context)context).getOrgIdByUserAndType((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE);
        if (companyOrgUnitIds == null || companyOrgUnitIds.size() == 0) {
            return adminIds;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("toUnit", new HashSet(companyOrgUnitIds), CompareType.INCLUDE));
        filterInfo.setMaskString("#0 AND #1 AND #2");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection orgUnitRelations = OrgUnitRelationFactory.getLocalInstance((Context)context).getCollection(entityViewInfo);
        int is = orgUnitRelations.size();
        for (int i = 0; i < is; ++i) {
            OrgUnitRelationInfo orgUnitRelationInfo = (OrgUnitRelationInfo)orgUnitRelations.get(i);
            String fromUnitId = orgUnitRelationInfo.getFromUnit().getId().toString();
            adminIds.add(fromUnitId);
        }
        return adminIds;
    }

    public static void checkFunctionPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName, boolean orgExtFromCtx) throws EASBizException, BOSException {
        if (permItemName == null) {
            return;
        }
        if (userPK == null) {
            userPK = new ObjectUuidPK(((UserInfo)ctx.get((Object)"UserInfo")).getId().toString());
        }
        if (orgPK == null) {
            orgPK = new ObjectUuidPK(((CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo")).getId().toString());
        }
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        iPermission.checkFunctionPermission(userPK, orgPK, null, null, permItemName, orgExtFromCtx);
    }

    public static final IBizCtrl getEntityBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        if (entityObjectInfo.isDynamic()) {
            return (IBizCtrl)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)new MetaDataPK(entityObjectInfo.getFullName()));
        }
        String clzFactoryName = entityObjectInfo.getBusinessImplFactory();
        try {
            Class<?> clzFactory = Class.forName(clzFactoryName);
            IBizCtrl iBiz = CommonDataWebUtils.getBizInterface(null, clzFactory, null);
            return iBiz;
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static final IBizCtrl getFacadeBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        FacadeInfo facadeInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFacade(bosType);
        if (facadeInfo.isDynamic()) {
            return (IBizCtrl)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)new MetaDataPK(facadeInfo.getFullName()));
        }
        String clzFactoryName = facadeInfo.getBusinessImplFactory();
        try {
            Class<?> clzFactory = Class.forName(clzFactoryName);
            IBizCtrl iBiz = CommonDataWebUtils.getBizInterface(null, clzFactory, null);
            return iBiz;
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static final IBizCtrl getBizInterface(Context ctx, Class clzFactory, Context mainOrgCtx) throws BOSException {
        boolean isLocal = ctx != null;
        IBizCtrl iBiz = null;
        try {
            if (isLocal) {
                Class[] parameterTypes = new Class[]{Context.class};
                Method mGetInstance = clzFactory.getMethod("getLocalInstance", parameterTypes);
                iBiz = (IBizCtrl)mGetInstance.invoke(null, ctx);
            } else {
                iBiz = CommonDataWebUtils.getRemoteBizInterface(clzFactory, mainOrgCtx);
            }
        }
        catch (SecurityException e) {
            throw new BOSException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BOSException((Throwable)e);
        }
        return iBiz;
    }

    public static final IBizCtrl getRemoteBizInterface(Class clzFactory, Context mainOrgCtx) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        IBizCtrl iBiz;
        if (mainOrgCtx != null) {
            Method mGetInstance = clzFactory.getMethod("getRemoteInstanceWithObjectContext", Context.class);
            iBiz = (IBizCtrl)mGetInstance.invoke(null, mainOrgCtx);
        } else {
            Method mGetInstance = clzFactory.getMethod("getRemoteInstance", null);
            iBiz = (IBizCtrl)mGetInstance.invoke(null, null);
        }
        return iBiz;
    }

    public static List<String> getPersonChargeAdmin(Context ctx, String personId) throws BOSException {
        ArrayList<String> adminIdList = new ArrayList<String>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("position.isRespPosition", (Object)1));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.getSelector().add(new SelectorItemInfo("position.adminOrgUnit.id"));
        PositionMemberCollection positionMembers = PositionMemberFactory.getLocalInstance((Context)ctx).getPositionMemberCollection(entityViewInfo);
        int is = positionMembers.size();
        for (int i = 0; i < is; ++i) {
            adminIdList.add(positionMembers.get(i).getPosition().getAdminOrgUnit().getId().toString());
        }
        return adminIdList;
    }

    public static Set<String> getVoucherAbstractList(Context ctx, String cuid) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("id"));
        IVoucherAbstract voucherAbstract = null;
        voucherAbstract = ctx == null ? VoucherAbstractFactory.getRemoteInstance() : VoucherAbstractFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = null;
        if (!StringUtils.isEmpty((String)cuid)) {
            filter = voucherAbstract.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "adminCU");
        }
        if (filter != null) {
            view.setFilter(filter);
        }
        VoucherAbstractCollection coll = voucherAbstract.getVoucherAbstractCollection(view);
        HashSet<String> ids = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            ids.add(coll.get(i).getId().toString());
        }
        return ids;
    }

    public static List getBillTypes(Context ctx) throws BOSException {
        ArrayList<BillTypeInfo> billTypes = new ArrayList<BillTypeInfo>();
        EntityViewInfo viewbill = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        viewbill.setSelector(selector);
        SorterItemInfo sortInfo = new SorterItemInfo("number");
        sortInfo.setSortType(SortType.DESCEND);
        viewbill.getSorter().add(sortInfo);
        String oql = viewbill.toString();
        BillTypeCollection billTypeCol = BillTypeFactory.getLocalInstance(ctx).getBillTypeCollection(oql);
        BillTypeInfo btInfo = null;
        int size = billTypeCol.size();
        for (int i = 0; i < size; ++i) {
            btInfo = billTypeCol.get(i);
            billTypes.add(btInfo);
        }
        return billTypes;
    }
}

