/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.EvectionLoanBgParam;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillException;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillFactory;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.IEvectionReqBill;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.WorkFlowUtils;
import com.kingdee.eas.cp.bc.app.AbstractEvectionLoanBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.bg.BgControlFactory;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgControl;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public class EvectionLoanBillControllerBean
extends AbstractEvectionLoanBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.EvectionLoanBillControllerBean");

    private void reWriteBillState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(BOSUuid.read((String)id), state);
    }

    private void reWriteBillState(Context ctx, BOSUuid id, StateEnum state) throws BOSException, EASBizException {
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(id, state);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        EvectionLoanBillInfo info = (EvectionLoanBillInfo)this.getValue(ctx, pk);
        String orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (BizCollUtil.objectIsNull(orgId)) {
            orgId = BizCollUtil.getNextCompanyId(ctx);
        }
        this.abortWorkingWf(ctx, pk);
        if (null != info.getSourceBillId()) {
            WorkFlowUtils.setDeleteState(ctx, info.getId(), BOSUuid.read((String)info.getSourceBillId()));
        }
        super._delete(ctx, pk);
        if (iCodingRuleManager.isExist((IObjectValue)info, orgId) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, orgId)) {
            boolean returnvalue = iCodingRuleManager.recycleNumber((IObjectValue)info, orgId, info.getNumber());
            logger.error((Object)("\u3010EvectionLoanBill\u3011\u56de\u6536\u7f16\u7801\uff1a" + info.getNumber() + "\t,\u56de\u6536\u7ed3\u679c:" + returnvalue));
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected void checkAddNew(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        if ("submit".equals(action)) {
            this.checkValidate(ctx, (EvectionLoanBillInfo)model);
        } else if ("save".equals(action)) {
            if (this.objectIsNull(((EvectionLoanBillInfo)model).getNumber())) {
                throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
            }
            this.checkValidate(ctx, (EvectionLoanBillInfo)model);
        }
    }

    @Override
    protected void checkUpdate(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        if ("submit".equals(action)) {
            this.checkValidate(ctx, (EvectionLoanBillInfo)model);
        } else if ("save".equals(action)) {
            if (this.objectIsNull(((EvectionLoanBillInfo)model).getNumber())) {
                throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
            }
            this.checkValidate(ctx, (EvectionLoanBillInfo)model);
        }
    }

    @Override
    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        return super.submit(ctx, model);
    }

    private boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvectionLoanBillInfo info = (EvectionLoanBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            throw new EvectionLoanBillException(EvectionLoanBillException.NUMBER_NOT_DUP);
        }
    }

    @Override
    protected void checkBillValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBillValidate(ctx, model);
        EvectionLoanBillInfo info = (EvectionLoanBillInfo)model;
        if (!StringUtils.isEmpty((String)info.getName()) && info.getName().trim().length() > 80) {
            throw new EvectionLoanBillException(EvectionLoanBillException.NAME_TOO_LONG);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EvectionLoanBillException(DailyLoanBillException.NUMBER_NOT_NULL);
        }
        if (info.getNumber().trim().length() > 80) {
            throw new EvectionLoanBillException(EvectionLoanBillException.NUMBER_TOO_LONG);
        }
        if (info.getApplierCompany() == null) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTNULL);
        }
        if (BizCollUtil.objectIsNull(info.getApplier()) && (info.getApplier() == null || BizCollUtil.objectIsNull(info.getApplier().getId()))) {
            throw new EvectionLoanBillException(EvectionLoanBillException.APPLIER_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBizReqDate())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.REQDATE_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getCurrencyType()) && (info.getCurrencyType() == null || BizCollUtil.objectIsNull(info.getCurrencyType().getId()))) {
            throw new EvectionLoanBillException(EvectionLoanBillException.CURRENCY_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCostedDept()) && (info.getCostedDept() == null || BizCollUtil.objectIsNull(info.getCostedDept().getId()))) {
            throw new EvectionLoanBillException(EvectionLoanBillException.COSTEDDEPT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && !BizCollUtil.isBizUnitCostCenter(ctx, info.getCostedDept())) {
            throw new ExpAccException(ExpAccException.COSTCENTER_NOT_BIZUNIT);
        }
        if (BizCollUtil.objectIsNull(info.getOrgUnit()) && (info.getOrgUnit() == null || BizCollUtil.objectIsNull(info.getOrgUnit().getId()))) {
            throw new EvectionLoanBillException(EvectionLoanBillException.ORGUNIT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && BizCollUtil.objectIsNull(info.getCompany()) && (info.getCompany() == null || BizCollUtil.objectIsNull(info.getCompany().getId()))) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTNULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getPrior())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.PRIOR_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBillDate())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.BILLDATE_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBiller()) && (info.getBiller() == null || BizCollUtil.objectIsNull(info.getBiller().getId()))) {
            throw new EvectionLoanBillException(EvectionLoanBillException.BILLER_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getEntries())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.ENTRY_NOT_NULL);
        }
        int size = info.getEntries().size();
        if (size <= 0) {
            throw new EvectionLoanBillException(EvectionLoanBillException.ENTRY_NOT_NULL);
        }
        EvectionLoanBillEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (BizCollUtil.objectIsNull(entryInfo.getStartDate())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.STARTDATE_NOT_NULL);
            }
            if (entryInfo.getCurrencyType() == null) {
                throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getFrom())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.FROM_NOT_NULL);
            }
            if (entryInfo.getFrom().trim().length() > 100) {
                throw new EvectionLoanBillException(EvectionLoanBillException.FROM_TOO_LONG);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getEndDate())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.ENDDATE_NOT_NULL);
            }
            if (entryInfo.getStartDate().after(entryInfo.getEndDate())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.STARTDATE_NOT_GREATER_ENDDATE);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getTo())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.TO_NOT_NULL);
            }
            if (entryInfo.getTo().trim().length() > 100) {
                throw new EvectionLoanBillException(EvectionLoanBillException.TO_TOO_LONG);
            }
            if (entryInfo.getExpenseType() == null) {
                throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
            }
            if (BizCollUtil.objectIsNull((Object)entryInfo.getVehicle())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.VEHICLE_NOT_NULL);
            }
            if (entryInfo.getAmount() == null) {
                throw new ExpAccException(ExpAccException.AMOUNTNOTLESSTHENZERO);
            }
            if (entryInfo.getAmount() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (BizCollUtil.bigDecimalObjectLessThan(entryInfo.getAmountApproved(), entryInfo.getAmount())) continue;
            throw new BizCollException(BizCollException.CHECKAMOUNT_LESS_APPROVEDAMOUNT, new Object[]{i + 1, entryInfo.getAmountApproved(), entryInfo.getAmount()});
        }
    }

    protected void checkValidate(Context ctx, EvectionLoanBillInfo info) throws EASBizException {
        if (BizCollUtil.objectIsNull(info.getForeseeDate())) {
            Date date = info.getBizReqDate();
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(date);
            gc.add(2, 3);
            info.setForeseeDate(gc.getTime());
        }
        if ("submit".equals(this.action) && !this.billHasSubmit && !BizCollUtil.objectIsNull(info.getForeseeDate()) && info.getForeseeDate().compareTo(new Date()) <= 0) {
            throw new DailyLoanBillException(DailyLoanBillException.FORESEEDATEMUSTLATER);
        }
        if (!StringUtils.isEmpty((String)info.getName()) && info.getName().trim().length() > 80) {
            throw new EvectionLoanBillException(EvectionLoanBillException.NAME_TOO_LONG);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.NUMBER_NOT_NULL);
        }
        if (info.getNumber().trim().length() > 80) {
            throw new EvectionLoanBillException(EvectionLoanBillException.NUMBER_TOO_LONG);
        }
        if (info.getApplier() == null || BizCollUtil.objectIsNull(info.getApplier().getId())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.APPLIER_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBizReqDate())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.REQDATE_NOT_NULL);
        }
        if (info.getCurrencyType() == null || BizCollUtil.objectIsNull(info.getCurrencyType().getId())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.CURRENCY_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && (info.getCostedDept() == null || BizCollUtil.objectIsNull(info.getCostedDept().getId()))) {
            throw new EvectionLoanBillException(EvectionLoanBillException.COSTEDDEPT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && !BizCollUtil.isBizUnitCostCenter(ctx, info.getCostedDept())) {
            throw new ExpAccException(ExpAccException.COSTCENTER_NOT_BIZUNIT);
        }
        if (info.getOrgUnit() == null || BizCollUtil.objectIsNull(info.getOrgUnit().getId())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.ORGUNIT_NOT_NULL);
        }
        if ((this.showHeadCompanys.equals("0") || this.showHeadCompanys.equals("2")) && (info.getCompany() == null || BizCollUtil.objectIsNull(info.getCompany().getId()))) {
            throw new EvectionLoanBillException(EvectionLoanBillException.COMPANY_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getPrior())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.PRIOR_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull(info.getBillDate())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.BILLDATE_NOT_NULL);
        }
        if (info.getBiller() == null || BizCollUtil.objectIsNull(info.getBiller().getId())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.BILLER_NOT_NULL);
        }
        if (BizCollUtil.objectIsNull((Object)info.getEntries())) {
            throw new EvectionLoanBillException(EvectionLoanBillException.ENTRY_NOT_NULL);
        }
        int size = info.getEntries().size();
        if (size <= 0) {
            throw new EvectionLoanBillException(EvectionLoanBillException.ENTRY_NOT_NULL);
        }
        EvectionLoanBillEntryInfo entryInfo = null;
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (BizCollUtil.objectIsNull(entryInfo.getStartDate())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.STARTDATE_NOT_NULL);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getFrom())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.FROM_NOT_NULL);
            }
            if (entryInfo.getFrom().trim().length() > 100) {
                throw new EvectionLoanBillException(EvectionLoanBillException.FROM_TOO_LONG);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getEndDate())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.ENDDATE_NOT_NULL);
            }
            if (entryInfo.getStartDate().after(entryInfo.getEndDate())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.STARTDATE_NOT_GREATER_ENDDATE);
            }
            if (BizCollUtil.objectIsNull(entryInfo.getTo())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.TO_NOT_NULL);
            }
            if (entryInfo.getTo().trim().length() > 100) {
                throw new EvectionLoanBillException(EvectionLoanBillException.TO_TOO_LONG);
            }
            if (BizCollUtil.objectIsNull((Object)entryInfo.getVehicle())) {
                throw new EvectionLoanBillException(EvectionLoanBillException.VEHICLE_NOT_NULL);
            }
            if (!this.showHeadCompanys.equals("1") && !this.showHeadCompanys.equals("2") || this.fromMbos.booleanValue()) continue;
            if (BizCollUtil.objectIsNull(entryInfo.getCostCenter())) {
                throw new ExpAccException(ExpAccException.ENTRY_COSTCENTER_NOT_NULL);
            }
            if (!BizCollUtil.objectIsNull(entryInfo.getCompany())) continue;
            throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
        }
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionLoanBillInfo info = this.getEvectionLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CHECKED);
        info.setAuditDate(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected void _setNotPassState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionLoanBillInfo info = this.getEvectionLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CHECKFAILD);
        info.setAuditDate(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected BgCtrlParam[] _getBgParam(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return null;
        }
        EvectionLoanBillInfo info = this.getEvectionLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        BgCtrlParam[] params = new BgCtrlParam[]{new BgCtrlParam()};
        BgTypeInfo bgTypeInfo = BgTypeFactory.getLocalInstance((Context)ctx).getValueByNumber("ExpenseBudget");
        params[0].setBgTypeId(bgTypeInfo.getId());
        CompanyOrgUnitInfo couInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        PeriodInfo perInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)BizCollUtil.covertToSimpleDate(info.getBizReqDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)BizCollUtil.covertToSimpleDate(info.getBizReqDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)couInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            perInfo = periodc.get(0);
        }
        params[0].setPeriodId(perInfo.getId());
        params[0].setBizOrgUnitId(info.getCostedDept().getId());
        params[0].setCurrencyId(info.getCurrencyType().getId());
        params[0].setCompanyId(info.getCompany().getId());
        params[0].setCtrlSystem(SystemEnum.BUSINESS_COLLABORATION);
        params[0].setSrcBillId(info.getId());
        params[0].setSrcBillNumber(info.getNumber());
        params[0].setBizDate(info.getBizReqDate());
        if (info.getSupportedObj() != null && !BizCollUtil.objectIsNull(info.getSupportedObj().getId())) {
            BOSUuid costId = info.getSupportedObj().getId();
            ICostObject iCost = CostObjectFactory.getLocalInstance((Context)ctx);
            CostObjectInfo costInfo = iCost.getCostObjectInfo((IObjectPK)new ObjectUuidPK(costId));
            MaterialInfo mat = new MaterialInfo();
            mat.setId(costInfo.getRelatedId());
            params[0].addDimension(BgDimensionEnum.PRODUCT, (IObjectValue)mat);
        }
        params[0].addDimension(BgDimensionEnum.ACCOUNT, (IObjectValue)info.getExpenseType());
        BgCtrlData data = new BgCtrlData();
        data.setDataType(BgDataTypeEnum.Amount);
        data.setValue(info.getAmount());
        params[0].addData(BgElementEnum.AMT, data);
        return params;
    }

    @Override
    protected void _setPaymentState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionLoanBillInfo info = this.getEvectionLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.ALREADYPAYMENT);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected void _setCloseState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionLoanBillInfo info = this.getEvectionLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CLOSED);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected boolean _needBgAudit(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return BizCollUtil.isNeedBudgetControl(ctx, id);
    }

    @Override
    protected void _reBackBg(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        EvectionLoanBgParam dlBgParam = new EvectionLoanBgParam();
        BgCtrlParam[] params = dlBgParam.getBgParam(ctx, id);
        IBgControl iBgControl = BgControlFactory.getLocalInstance((Context)ctx);
        iBgControl.bgCancelAudit(params);
    }

    @Override
    protected void _payment(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        this.reWriteBillState(ctx, id, StateEnum.ISPAYBILL);
    }

    @Override
    protected void _setCheckingState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionLoanBillInfo info = this.getEvectionLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.CHECKING);
        info.setAuditDate(new Date());
        info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected void _setDraftState(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionLoanBillInfo info = this.getEvectionLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(StateEnum.DRAFT);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    @Override
    protected List _getCanDeleteIDs(Context ctx, List list) throws BOSException, EASBizException {
        ArrayList<String> returnList = new ArrayList<String>();
        if (BizCollUtil.objectIsNull(list) || list.size() == 0) {
            return returnList;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            EvectionLoanBillInfo info;
            String id = (String)list.get(i);
            if (BizCollUtil.objectIsNull(id) || !StateEnum.DRAFT.equals((Object)(info = this.getEvectionLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id))).getState()) && !StateEnum.NEW.equals((Object)info.getState()) || this.isTogetherCheckBill(ctx, id)) continue;
            returnList.add(id);
        }
        return returnList;
    }

    private boolean isTogetherCheckBill(Context ctx, String id) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("loanBillID", (Object)id.toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        IEvectionReqBill ier = EvectionReqBillFactory.getLocalInstance(ctx);
        return ier.exists(filter);
    }

    @Override
    protected boolean _isCanModify(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        return !BizCollUtil.objectIsNull(id);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid id, StateEnum state) throws BOSException, EASBizException {
        if (BizCollUtil.objectIsNull(id)) {
            return;
        }
        EvectionLoanBillInfo info = this.getEvectionLoanBillInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setState(state);
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)info, sic);
    }

    private void setActionFlag(Context ctx, EvectionLoanBillInfo billInfo, String actionFlag) throws BOSException, EASBizException {
        billInfo.setActionFlag(actionFlag);
        billInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        billInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("actionFlag"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)billInfo, sic);
    }

    private boolean isSourceBillRelatedBill(Context ctx, BizCollBillBaseInfo info) {
        boolean isSourceBillRelatedBill = false;
        try {
            if (BizCollUtil.checkBillHasTracDown(ctx, info)) {
                isSourceBillRelatedBill = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return isSourceBillRelatedBill;
    }

    private boolean isSourceBillRelatedBill(Context ctx, BizCollBillBaseInfo info, String destObjectID) {
        boolean isSourceBillRelatedBill = false;
        try {
            if (BizCollUtil.checkBillHasTracDown(ctx, info, destObjectID)) {
                isSourceBillRelatedBill = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return isSourceBillRelatedBill;
    }

    private boolean isSrcBillRelPayBill(Context ctx, BizCollBillBaseInfo info) {
        boolean isSrcBillRelPayBill = false;
        try {
            if (BizCollUtil.checkBillHasRePaybill(ctx, info)) {
                isSrcBillRelPayBill = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return isSrcBillRelPayBill;
    }

    @Override
    protected void _ngisc_submit(Context ctx, IObjectPK pk, CoreBillBaseInfo model) throws BOSException, EASBizException {
        super._ngisc_submit(ctx, pk, model);
    }

    @Override
    protected String getPermItemName() {
        return "cp_bc_EvectionLoan_Update";
    }
}

