/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractEvectionLoanBillEditUIHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EvectionLoanBillEditUIHandler
extends AbstractEvectionLoanBillEditUIHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.EvectionLoanBillEditUIHandler");

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        EntityViewInfo viewInfo = (EntityViewInfo)request.get("viewInfo");
        Map map = new HashMap();
        HashMap paramMap = (HashMap)request.get("paramMap");
        SettlementTypeCollection scol = SettlementTypeFactory.getLocalInstance((Context)context).getSettlementTypeCollection(viewInfo);
        BizCollBillBaseInfo baseInfo = (BizCollBillBaseInfo)request.getValue();
        if (baseInfo != null) {
            PersonInfo personInfo = baseInfo.getApplier();
            CostCenterOrgUnitInfo costCenterOrgUnitInfo = baseInfo.getCostedDept();
            CurrencyInfo currencyInfo = baseInfo.getCurrencyType();
            AdminOrgUnitInfo adminOrgUnitInfo = baseInfo.getOrgUnit();
            String loanBalanceAccountNumber = (String)paramMap.get("CP012");
            map = CommonUtilFacadeFactory.getLocalInstance(context).getAccount(personInfo, costCenterOrgUnitInfo, currencyInfo, adminOrgUnitInfo, loanBalanceAccountNumber, null);
        }
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
    }

    @Override
    protected void _handleActionViewBudgetBalance(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionViewBudgetBalance(request, response, context);
        BizCollBillBaseInfo info = (BizCollBillBaseInfo)request.get("info");
    }

    @Override
    protected void _handleActionViewRrcdsOfLendAndRepay(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void loadFields(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.loadFields(request, response, context);
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        EvectionLoanBillInfo info = new EvectionLoanBillInfo();
        try {
            BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getLocalInstance(context).forLoanBillCreateNewData();
            info.setCurrencyType(baseInfo.getCurrencyType());
            if (StringUtils.isEmpty((String)info.getName())) {
                info.setName(BizCollBillTypeEnum.EVECTION_LOAN.toString());
            }
            info.setState(StateEnum.NEW);
            if (info.getBillTypeCode() == null) {
                info.setBillTypeCode(BizCollBillTypeEnum.EVECTION_LOAN);
            }
            info.setPayMode(((DailyLoanBillInfo)baseInfo).getPayMode());
            info.setPrior(PriorEnum.LOW);
            Date now = new Date();
            info.setBizReqDate(DateTimeUtils.truncateDate((Date)now));
            info.setBiller(ContextUtil.getCurrentUserInfo((Context)context));
            info.setBillDate(DateTimeUtils.truncateDate((Date)now));
            info.setAmount(new BigDecimal("0.0"));
            info.setApplier(baseInfo.getApplier());
            info.setPosition(baseInfo.getPosition());
            info.setOrgUnit(baseInfo.getOrgUnit());
            info.setApplierCompany(baseInfo.getApplierCompany());
            info.setCostedDept(baseInfo.getCostedDept());
            info.setCompany(baseInfo.getCompany());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return info;
    }

    @Override
    public void handleInitUIData(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.handleInitUIData(request, response, context);
    }
}

