/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.EvectionStandardAssignCUCollection;
import com.kingdee.eas.cp.bc.EvectionStandardAssignCUFactory;
import com.kingdee.eas.cp.bc.EvectionStandardAssignCUInfo;
import com.kingdee.eas.cp.bc.EvectionStandardAssignPersonCollection;
import com.kingdee.eas.cp.bc.EvectionStandardAssignPersonFactory;
import com.kingdee.eas.cp.bc.EvectionStandardAssignPersonInfo;
import com.kingdee.eas.cp.bc.EvectionStandardCollection;
import com.kingdee.eas.cp.bc.EvectionStandardFactory;
import com.kingdee.eas.cp.bc.EvectionStandardGroupCollection;
import com.kingdee.eas.cp.bc.EvectionStandardGroupFactory;
import com.kingdee.eas.cp.bc.EvectionStandardGroupInfo;
import com.kingdee.eas.cp.bc.EvectionStandardInfo;
import com.kingdee.eas.cp.bc.IEvectionStandard;
import com.kingdee.eas.cp.bc.IEvectionStandardAssignCU;
import com.kingdee.eas.cp.bc.IEvectionStandardAssignPerson;
import com.kingdee.eas.cp.bc.ReimburseLevelCollection;
import com.kingdee.eas.cp.bc.ReimburseLevelFactory;
import com.kingdee.eas.cp.bc.ReimburseLevelInfo;
import com.kingdee.eas.cp.bc.StaffLevelAttriEnum;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.TravelAreaCollection;
import com.kingdee.eas.cp.bc.TravelAreaFactory;
import com.kingdee.eas.cp.bc.TravelAreaInfo;
import com.kingdee.eas.cp.bc.app.AbstractEvectionStandardControllerBean;
import com.kingdee.eas.cp.bc.app.CommonDataWebUtils;
import com.kingdee.eas.cp.bc.app.control.ControlFactory;
import com.kingdee.eas.cp.bc.app.control.IControl;
import com.kingdee.eas.cp.bc.app.control.util.ControlUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class EvectionStandardControllerBean
extends AbstractEvectionStandardControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.EvectionStandardControllerBean");
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        super._update(ctx, pk, model);
    }

    private void checkInfo(Context ctx, IObjectValue model) throws EASBizException {
        EvectionStandardInfo info = (EvectionStandardInfo)model;
        if (StringUtils.isBlank((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (StringUtils.isBlank((String)info.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
    }

    protected List initCus(Context ctx, List cuIds) throws BOSException {
        ArrayList cus = new ArrayList();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("longNumber");
        entityViewInfo.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(cuIds), CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        CtrlUnitCollection ctrlUnits = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(entityViewInfo);
        int is = ctrlUnits.size();
        for (int i = 0; i < is; ++i) {
            HashMap<String, String> cuMap = new HashMap<String, String>();
            CtrlUnitInfo ctrlUnitInfo = ctrlUnits.get(i);
            cuMap.put("id", ctrlUnitInfo.getId().toString());
            cuMap.put("name", ctrlUnitInfo.getName());
            cuMap.put("longNumber", ctrlUnitInfo.getLongNumber());
            cus.add(cuMap);
        }
        return cus;
    }

    @Override
    protected List _assignCu(Context ctx, List evectionStandards, List cus, String queryUUId) throws BOSException, EASBizException {
        Set assignCuIds = new HashSet(cus);
        if (!cus.isEmpty() && !(cus.get(0) instanceof String)) {
            assignCuIds = CommonDataWebUtils.getIds(cus);
        }
        List cuInfos = this.initCus(ctx, new ArrayList(assignCuIds));
        ArrayList errorList = new ArrayList();
        IEvectionStandardAssignCU evectionStAssignCuFactory = EvectionStandardAssignCUFactory.getLocalInstance(ctx);
        CoreBaseCollection assignCus = new CoreBaseCollection();
        Set assignStandardIds = CommonDataWebUtils.getIds(evectionStandards);
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)assignStandardIds, CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("name"));
        selectors.add(new SelectorItemInfo("currencyType.id"));
        selectors.add(new SelectorItemInfo("area.id"));
        selectors.add(new SelectorItemInfo("area.name"));
        selectors.add(new SelectorItemInfo("area.CU.id"));
        selectors.add(new SelectorItemInfo("area.CU.longNumber"));
        selectors.add(new SelectorItemInfo("reimburseLevel.id"));
        selectors.add(new SelectorItemInfo("reimburseLevel.name"));
        selectors.add(new SelectorItemInfo("reimburseLevel.CU.id"));
        selectors.add(new SelectorItemInfo("reimburseLevel.CU.longNumber"));
        entityView.setSelector(selectors);
        EvectionStandardCollection evectionStandardCollection = this.getEvectionStandardCollection(ctx, entityView);
        int is = evectionStandardCollection.size();
        for (int i = 0; i < is; ++i) {
            EvectionStandardInfo evectionStandard = evectionStandardCollection.get(i);
            String evectionStId = evectionStandard.getId().toString();
            String evectionStName = evectionStandard.getName();
            TravelAreaInfo area = evectionStandard.getArea();
            String travelAreaId = area.getId().toString();
            String areaCULongNumber = area.getCU().getLongNumber();
            String currencyTypeId = evectionStandard.getCurrencyType().getId().toString();
            ReimburseLevelInfo reimburseLevel = evectionStandard.getReimburseLevel();
            String reimburseLevelId = reimburseLevel.getId().toString();
            String rLCULongNumber = reimburseLevel.getCU().getLongNumber();
            EvectionStandardInfo evectionSt = new EvectionStandardInfo();
            evectionSt.setId(BOSUuid.read((String)evectionStId));
            FilterInfo queryExistFilter = new FilterInfo();
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            queryExistFilter.getFilterItems().add(new FilterItemInfo("assignCU.id", assignCuIds, CompareType.INCLUDE));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.currencyType.id", (Object)currencyTypeId, CompareType.EQUALS));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.area.id", (Object)travelAreaId, CompareType.EQUALS));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.reimburseLevel.id", (Object)reimburseLevelId, CompareType.EQUALS));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStId, CompareType.NOTEQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("assignCU.id"));
            entityViewInfo.setSelector(selector);
            entityViewInfo.setFilter(queryExistFilter);
            CoreBaseCollection existAssignCus = evectionStAssignCuFactory.getCollection(entityViewInfo);
            Set<String> existCuIds = CommonDataWebUtils.getPropIds((AbstractObjectCollection)existAssignCus, "assignCU");
            ArrayList<String> errorCuList = new ArrayList<String>();
            Locale locale = ctx.getLocale();
            int js = cuInfos.size();
            for (int j = 0; j < js; ++j) {
                Map cu = (Map)cuInfos.get(j);
                String cuId = (String)cu.get("id");
                String cuName = (String)cu.get("name");
                String longNumber = (String)cu.get("longNumber");
                if (longNumber.indexOf(areaCULongNumber) == -1 || longNumber.indexOf(rLCULongNumber) == -1) {
                    errorCuList.add(ResourceBase.getString((String)RESBIZCOLL, (String)"STANDARD_ASSIGN_FAILURE_AREA", (Locale)locale, (Object[])new Object[]{evectionStName, cuName}));
                    continue;
                }
                if (existCuIds.contains(cuId)) {
                    errorCuList.add(ResourceBase.getString((String)RESBIZCOLL, (String)"STANDARD_ASSIGN_FAILURE_SAME", (Locale)locale, (Object[])new Object[]{evectionStName, cuName}));
                    continue;
                }
                EvectionStandardAssignCUInfo evectionStAssignCu = new EvectionStandardAssignCUInfo();
                evectionStAssignCu.setEvectionStandard(evectionSt);
                CtrlUnitInfo assignCu = new CtrlUnitInfo();
                assignCu.setId(BOSUuid.read((String)cuId));
                evectionStAssignCu.setAssignCU(assignCu);
                assignCus.add((CoreBaseInfo)evectionStAssignCu);
            }
            if (errorCuList.size() == 0) continue;
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("standardName", evectionStName);
            errorMap.put("cuList", errorCuList);
            errorList.add(errorMap);
        }
        FilterInfo delFilterInfo = new FilterInfo();
        delFilterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)assignStandardIds, CompareType.INCLUDE));
        evectionStAssignCuFactory.delete(delFilterInfo);
        if (assignCus.size() != 0) {
            evectionStAssignCuFactory.addnewBatchData(assignCus);
        }
        return errorList;
    }

    @Override
    @Deprecated
    protected List _assignPerson(Context ctx, Map evectionStandard, List persons) throws BOSException, EASBizException {
        ArrayList errorList = new ArrayList();
        IEvectionStandardAssignPerson evectionStAssignPersonFactory = EvectionStandardAssignPersonFactory.getLocalInstance(ctx);
        FilterInfo queryExistFilter = new FilterInfo();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        String evectionStId = (String)evectionStandard.get("id");
        String evectionStName = (String)evectionStandard.get("name");
        String currencyType = (String)evectionStandard.get("currencyType.id");
        String travelArea = (String)evectionStandard.get("area.id");
        Set assignPersonIds = CommonDataWebUtils.getIds(persons);
        queryExistFilter.getFilterItems().add(new FilterItemInfo("person.id", (Object)assignPersonIds, CompareType.INCLUDE));
        queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.currencyType.id", (Object)currencyType, CompareType.EQUALS));
        queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.area.id", (Object)travelArea, CompareType.EQUALS));
        queryExistFilter.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStId, CompareType.NOTEQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.id"));
        entityViewInfo.setFilter(queryExistFilter);
        entityViewInfo.setSelector(selector);
        EvectionStandardAssignPersonCollection evecStAssignPersons = evectionStAssignPersonFactory.getEvectionStandardAssignPersonCollection(entityViewInfo);
        Set<String> existAssignPersonIds = CommonDataWebUtils.getPropIds(evecStAssignPersons, "person");
        ArrayList<String> errorPersonList = new ArrayList<String>();
        EvectionStandardInfo evectionStandardInfo = new EvectionStandardInfo();
        evectionStandardInfo.setId(BOSUuid.read((String)evectionStId));
        CoreBaseCollection assignPersons = new CoreBaseCollection();
        int is = persons.size();
        for (int i = 0; i < is; ++i) {
            String personId = ((Map)persons.get(i)).get("id").toString();
            if (existAssignPersonIds.contains(personId)) {
                String personName = (String)((Map)persons.get(i)).get("name");
                errorPersonList.add(personName);
                continue;
            }
            EvectionStandardAssignPersonInfo assignPerson = new EvectionStandardAssignPersonInfo();
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            assignPerson.setPerson(person);
            assignPerson.setEvectionStandard(evectionStandardInfo);
            assignPersons.add((CoreBaseInfo)assignPerson);
        }
        if (errorPersonList.size() != 0) {
            HashMap<String, Object> errorMap = new HashMap<String, Object>();
            errorMap.put("standardName", evectionStName);
            errorMap.put("personList", errorPersonList);
            errorList.add(errorMap);
        }
        FilterInfo delFilterInfo = new FilterInfo();
        delFilterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStId, CompareType.EQUALS));
        evectionStAssignPersonFactory.delete(delFilterInfo);
        if (assignPersons.size() != 0) {
            evectionStAssignPersonFactory.addnewBatchData(assignPersons);
        }
        return errorList;
    }

    @Override
    protected void _cancelEvectionStandardAssign(Context ctx, String type, String evectionStandardId, String assignId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if ("cu".equals(type)) {
            IEvectionStandardAssignCU evectionStandardFacotry = EvectionStandardAssignCUFactory.getLocalInstance(ctx);
            filterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStandardId));
            filterInfo.getFilterItems().add(new FilterItemInfo("assignCU.id", (Object)assignId));
            filterInfo.setMaskString("#0 And #1");
            evectionStandardFacotry.delete(filterInfo);
        } else if ("person".equals(type)) {
            IEvectionStandardAssignPerson evectionStandardFactory = EvectionStandardAssignPersonFactory.getLocalInstance(ctx);
            filterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStandardId));
            filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)assignId));
            filterInfo.setMaskString("#0 And #1");
            evectionStandardFactory.delete(filterInfo);
        }
    }

    @Override
    @Deprecated
    protected void _delGroup(Context ctx, String groupId) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)groupId)) {
            return;
        }
        CoreBaseCollection existEvectionSts = EvectionStandardFactory.getLocalInstance(ctx).getCollection("where group.id = '" + groupId + "'");
        if (existEvectionSts.size() > 0) {
            throw new StandardException(StandardException.EVECTIONSTANDARD_GROUP_EXIST_ST);
        }
        EvectionStandardGroupFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(groupId));
    }

    @Override
    protected List _enableEvectionStandard(Context ctx, List evectionStandards, boolean enable, String orgId) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        if (evectionStandards == null || evectionStandards.size() == 0) {
            return resultList;
        }
        StringBuffer queryExistSql = new StringBuffer();
        String querySql = "SELECT FID WHERE ";
        String whereSql = "CURRENCYTYPE.ID = '%s' AND REIMBURSELEVEL.ID = '%s' AND AREA.ID = '%s' AND STATE = 1 AND ID != '%s' AND CU.ID = '%s'";
        IEvectionStandard evectionStInstance = EvectionStandardFactory.getLocalInstance(ctx);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("state"));
        for (Object evectionStandard : evectionStandards) {
            Map evectionStandardMap = (Map)evectionStandard;
            String evectionStId = evectionStandardMap.get("id").toString();
            EvectionStandardInfo evectionStInfo = new EvectionStandardInfo();
            evectionStInfo.setId(BOSUuid.read((String)evectionStId));
            if (!enable) {
                evectionStInfo.setState(EnableStateEnum.DISABLE);
                evectionStInstance.updatePartial(evectionStInfo, selector);
                continue;
            }
            queryExistSql = new StringBuffer();
            queryExistSql.append(querySql);
            queryExistSql.append(String.format(whereSql, evectionStandardMap.get("currencyType.id"), evectionStandardMap.get("reimburseLevel.id"), evectionStandardMap.get("area.id"), evectionStId, orgId));
            CoreBaseCollection existCollection = evectionStInstance.getCollection(queryExistSql.toString());
            if (existCollection.size() != 0) {
                HashMap<String, String> failEvectionst = new HashMap<String, String>();
                failEvectionst.put("id", evectionStId);
                failEvectionst.put("name", evectionStandardMap.get("name").toString());
                resultList.add(failEvectionst);
                continue;
            }
            evectionStInfo.setState(EnableStateEnum.ENABLE);
            evectionStInstance.updatePartial(evectionStInfo, selector);
        }
        return resultList;
    }

    @Override
    protected List _fetchEvectionStandard(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        IControl travelControl = ControlFactory.createTravelControl();
        HashMap<String, IObjectValue> paramMap = new HashMap<String, IObjectValue>();
        paramMap.put("billinfo", billInfo);
        List<Map> resultList = travelControl.check(ctx, StaffLevelAttriEnum.USERDEFINED, paramMap);
        return resultList;
    }

    private Set getAssignCuIds(Context ctx, List evectionStandardIds) throws BOSException {
        HashSet<String> resultSet = new HashSet<String>();
        List<CtrlUnitInfo> assignCus = this.getAssignCus(ctx, evectionStandardIds);
        int is = assignCus.size();
        for (int i = 0; i < is; ++i) {
            resultSet.add(assignCus.get(i).getId().toString());
        }
        return resultSet;
    }

    private List<CtrlUnitInfo> getAssignCus(Context ctx, List evectionStandardIds) throws BOSException {
        if (evectionStandardIds == null || evectionStandardIds.size() == 0) {
            return null;
        }
        ArrayList<CtrlUnitInfo> assignCus = new ArrayList<CtrlUnitInfo>();
        IEvectionStandardAssignCU evectionSTAssignCUFactory = EvectionStandardAssignCUFactory.getLocalInstance(ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard", new HashSet(evectionStandardIds), CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("assignCU.id"));
        selector.add(new SelectorItemInfo("assignCU.name"));
        entityViewInfo.setSelector(selector);
        EvectionStandardAssignCUCollection evectionSTAssignCUs = evectionSTAssignCUFactory.getEvectionStandardAssignCUCollection(entityViewInfo);
        int is = evectionSTAssignCUs.size();
        for (int i = 0; i < is; ++i) {
            assignCus.add(evectionSTAssignCUs.get(i).getAssignCU());
        }
        return assignCus;
    }

    @Override
    protected List _getGroupFilter(Context ctx, String cuId) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        HashMap<String, Object> reimburseLevelGroup = new HashMap<String, Object>();
        reimburseLevelGroup.put("field", "reimburseLevel.id");
        reimburseLevelGroup.put("dataType", "ObjectValue");
        reimburseLevelGroup.put("title", ResourceBase.getString((String)RESBIZCOLL, (String)"workerGrade", (Locale)ctx.getLocale()));
        reimburseLevelGroup.put("mitiSelect", "false");
        reimburseLevelGroup.put("displayCount", 8);
        reimburseLevelGroup.put("unlimited", true);
        ArrayList filterItems = new ArrayList();
        String[] cuIds = CommonDataWebUtils.getParentCuIds(ctx, cuId);
        HashSet<String> cuIdSet = new HashSet<String>(Arrays.asList(cuIds));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.number", cuIdSet, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        ReimburseLevelCollection reimburseLevelCollection = ReimburseLevelFactory.getLocalInstance(ctx).getReimburseLevelCollection(entityViewInfo);
        int is = reimburseLevelCollection.size();
        for (int i = 0; i < is; ++i) {
            ReimburseLevelInfo reimburseLevelInfo = reimburseLevelCollection.get(i);
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("alias", reimburseLevelInfo.getName());
            filterMap.put("value", reimburseLevelInfo.getId().toString());
            filterMap.put("isDefault", false);
            filterItems.add(filterMap);
        }
        reimburseLevelGroup.put("filterItems", filterItems);
        resultList.add(reimburseLevelGroup);
        HashMap<String, Object> travelAreaGroup = new HashMap<String, Object>();
        travelAreaGroup.put("field", "area.id");
        travelAreaGroup.put("dataType", "ObjectValue");
        travelAreaGroup.put("title", ResourceBase.getString((String)"com.kingdee.eas.cp.bc.WebCommonUtilResource", (String)"BUSINESS_AREA", (Locale)ctx.getOriginLocale()));
        travelAreaGroup.put("mitiSelect", ResourceBase.getString((String)"com.kingdee.eas.cp.bc.WebCommonUtilResource", (String)"workerGrade", (Locale)ctx.getLocale()));
        travelAreaGroup.put("displayCount", 8);
        travelAreaGroup.put("unlimited", true);
        filterItems = new ArrayList();
        EntityViewInfo travelAreaViewInfo = new EntityViewInfo();
        FilterInfo travelAreaFilterInfo = new FilterInfo();
        travelAreaFilterInfo.getFilterItems().add(new FilterItemInfo("CU.id = '00000000-0000-0000-0000-000000000000CCE7AED4'"));
        travelAreaFilterInfo.getFilterItems().add(new FilterItemInfo("CU.id = '" + cuId + "'"));
        travelAreaFilterInfo.setMaskString("#0 or #1");
        travelAreaViewInfo.setFilter(travelAreaFilterInfo);
        TravelAreaCollection travelAreaCollection = TravelAreaFactory.getLocalInstance(ctx).getTravelAreaCollection(travelAreaViewInfo);
        int is2 = travelAreaCollection.size();
        for (int i = 0; i < is2; ++i) {
            TravelAreaInfo travelAreaInfo = travelAreaCollection.get(i);
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("alias", travelAreaInfo.getName());
            filterMap.put("value", travelAreaInfo.getId().toString());
            filterMap.put("isDefault", false);
            filterItems.add(filterMap);
        }
        travelAreaGroup.put("filterItems", filterItems);
        resultList.add(travelAreaGroup);
        return resultList;
    }

    @Override
    protected Map _initEvectionStandardAssign(Context ctx, List evectionStandardIds, String orgId) throws BOSException, EASBizException {
        if (evectionStandardIds == null || evectionStandardIds.size() == 0) {
            return null;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Set assignCUIds = this.getAssignCuIds(ctx, evectionStandardIds);
        resultMap.put("assignCUIds", new ArrayList(assignCUIds));
        List<String> eqAndChildCuIds = CommonDataWebUtils.getEqAndChildCuIds(ctx, orgId);
        resultMap.put("cuIds", eqAndChildCuIds);
        ObjectUuidPK orgPK = new ObjectUuidPK(orgId);
        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)orgPK);
        resultMap.put("orgNumber", ctrlUnitInfo.getNumber());
        return resultMap;
    }

    @Override
    protected IObjectValue _initEvectionStandardCreate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HashMap<String, String[]> initData = new HashMap<String, String[]>();
        EvectionStandardInfo evectionStandardInfo = (EvectionStandardInfo)model;
        String[] cus = null;
        if (evectionStandardInfo.getCU() != null) {
            cus = CommonDataWebUtils.getParentCuIds(ctx, evectionStandardInfo.getCU().getId().toString());
        }
        initData.put("cuIdsFilter", cus);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String oql = "select baseCurrency.id, baseCurrency.name where id = '" + company.getId().toString() + "'";
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
        CurrencyInfo baseCurrency = companyOrgUnitInfo.getBaseCurrency();
        evectionStandardInfo.setCurrencyType(baseCurrency);
        evectionStandardInfo.put("initData", initData);
        return evectionStandardInfo;
    }

    @Override
    @Deprecated
    protected IObjectValue _initEvectionStandardEdit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HashMap initData = new HashMap();
        model.put("initData", initData);
        return model;
    }

    @Override
    protected Map _initEvectionStandardView(Context ctx, String evectionStandardId, String orgId) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ObjectUuidPK orgPK = new ObjectUuidPK(orgId);
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(currentUserInfo.getId());
        if (StringUtils.isEmpty((String)evectionStandardId)) {
            return resultMap;
        }
        OrgUnitInfo orgUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)orgPK);
        resultMap.put("orgNumber", orgUnitInfo.getNumber());
        List<String> childCuIds = CommonDataWebUtils.getEqAndChildCuIds(ctx, orgId);
        resultMap.put("cuIds", childCuIds);
        ArrayList<String> evectionStandardIds = new ArrayList<String>();
        evectionStandardIds.add(evectionStandardId);
        List<CtrlUnitInfo> assignCus = this.getAssignCus(ctx, evectionStandardIds);
        resultMap.put("assignCUIds", assignCus);
        return resultMap;
    }

    @Override
    @Deprecated
    protected List _initGroupTree(Context ctx) throws BOSException, EASBizException {
        EvectionStandardGroupCollection evectionStandardGroupCollection = EvectionStandardGroupFactory.getLocalInstance(ctx).getEvectionStandardGroupCollection();
        ArrayList treeList = new ArrayList();
        for (int i = 0; i < evectionStandardGroupCollection.size(); ++i) {
            EvectionStandardGroupInfo evectionStandardGroupInfo = evectionStandardGroupCollection.get(i);
            HashMap<String, String> nodeMap = new HashMap<String, String>();
            nodeMap.put("id", evectionStandardGroupInfo.getId().toString());
            nodeMap.put("name", evectionStandardGroupInfo.getName());
            nodeMap.put("pId", "root");
            treeList.add(nodeMap);
        }
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("id", "root");
        rootMap.put("tId", "root");
        rootMap.put("name", ResourceBase.getString((String)RESBIZCOLL, (String)"travelStandard", (Locale)ctx.getLocale()));
        rootMap.put("open", true);
        treeList.add(rootMap);
        return treeList;
    }

    @Override
    @Deprecated
    protected List _queryAssignPerson(Context ctx, String evectionStandardId) throws BOSException, EASBizException {
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.EvectionStandardAssignPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evectionStandard.id", (Object)evectionStandardId));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)1));
        filterInfo.setMaskString("#0 AND #1");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        ArrayList resultList = new ArrayList();
        try {
            while (rowSet.next()) {
                HashMap<String, String> personMap = new HashMap<String, String>();
                personMap.put("id", (String)rowSet.getObject("person.id"));
                personMap.put("name", (String)rowSet.getObject("person.name"));
                personMap.put("number", (String)rowSet.getObject("person.number"));
                personMap.put("AdminOrgUnit.name", (String)rowSet.getObject("adminOrgUnit.name"));
                resultList.add(personMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return resultList;
    }

    @Override
    protected List _queryPersonEvectionSt(Context ctx) throws BOSException, EASBizException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String personId = user.getPerson().getId().toString();
        try {
            List<Map<String, Object>> queryPersonEvectionSt = ControlUtil.queryPersonEvectionSt(ctx, personId);
            return queryPersonEvectionSt;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected String _saveEvectionStandard(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        EvectionStandardInfo info = (EvectionStandardInfo)model;
        String cuId = info.getCU().getId().toString();
        String reimburseLevelId = info.getReimburseLevel().getId().toString();
        String currencyTypeId = info.getCurrencyType().getId().toString();
        String travelAreaId = info.getArea().getId().toString();
        String id = info.getId().toString();
        String oql = "select id, cu.name where reimburseLevel = '%s' and currencyType.id = '%s' and area.id = '%s' and id != '%s' and cu.id = '%s' and state = %s";
        oql = String.format(oql, reimburseLevelId, currencyTypeId, travelAreaId, id, cuId, 1);
        EvectionStandardCollection existEvectionSts = EvectionStandardFactory.getLocalInstance(ctx).getEvectionStandardCollection(oql);
        if (existEvectionSts.size() > 0) {
            throw new StandardException(StandardException.ACCOUNTSTANDARD_UNIQUE, new Object[]{existEvectionSts.get(0).getCU().getName()});
        }
        IObjectPK objectPk = EvectionStandardFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        id = objectPk.toString();
        return id;
    }

    @Deprecated
    public void assignPerson(Context ctx, String evectionStandardId, List<String> personIds) throws BOSException, EASBizException {
        if (StringUtils.isBlank((String)evectionStandardId)) {
            return;
        }
        FilterInfo delFilter = new FilterInfo();
        delFilter.getFilterItems().add(new FilterItemInfo("evectionStandard", (Object)evectionStandardId));
        EvectionStandardAssignPersonFactory.getLocalInstance(ctx).delete(delFilter);
        if (personIds == null || personIds.size() == 0) {
            return;
        }
        CoreBaseCollection evectionStandardAssigns = new CoreBaseCollection();
        EvectionStandardInfo evectionStandardInfo = new EvectionStandardInfo();
        evectionStandardInfo.setId(BOSUuid.read((String)evectionStandardId));
        for (String personId : personIds) {
            EvectionStandardAssignPersonInfo evectionStandardAssignPersonInfo = new EvectionStandardAssignPersonInfo();
            evectionStandardAssignPersonInfo.setEvectionStandard(evectionStandardInfo);
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            evectionStandardAssignPersonInfo.setPerson(personInfo);
            evectionStandardAssigns.add((CoreBaseInfo)evectionStandardAssignPersonInfo);
        }
        EvectionStandardAssignPersonFactory.getLocalInstance(ctx).addnewBatchData(evectionStandardAssigns);
    }
}

