/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BudgetBalanceCollection;
import com.kingdee.eas.cp.bc.BudgetBalanceInfo;
import com.kingdee.eas.cp.bc.BudgetControlCollection;
import com.kingdee.eas.cp.bc.BudgetControlException;
import com.kingdee.eas.cp.bc.BudgetControlFactory;
import com.kingdee.eas.cp.bc.BudgetControlInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBaseBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.IBudgetControl;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractExpenseAccountBaseBillControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class ExpenseAccountBaseBillControllerBean
extends AbstractExpenseAccountBaseBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ExpenseAccountBaseBillControllerBean");
    private static int OLDSTATE = -1;

    protected void addnewCheck(Context ctx, ExpenseAccountBillInfo info) throws BOSException, EASBizException {
        ExpenseAccountBaseBillInfo model = (ExpenseAccountBaseBillInfo)info;
        StateEnum state = model.getState();
        if (StateEnum.CLOSED.equals((Object)state)) {
            throw new ExpAccException(ExpAccException.CLOSE_NOT_DO);
        }
        if (this.objectIsNull(model.getNumber())) {
            throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
        }
        if (this.objectIsNull(model.getName())) {
            throw new ExpAccException(ExpAccException.NAME_NOT_NULL);
        }
        if (model.getName().length() > 80) {
            throw new ExpAccException(ExpAccException.NAME_TOO_LONG);
        }
        if (model.getApplier() == null) {
            throw new ExpAccException(ExpAccException.APPLIER_NOT_NULL);
        }
        if (model.getOrgUnit() == null) {
            throw new ExpAccException(ExpAccException.ORGUNIT_NOT_NULL);
        }
        if (model.getCostedDept() == null) {
            throw new ExpAccException(ExpAccException.REQDEPARTMENT_NOT_NULL);
        }
        if (model.getPayMode() == null) {
            throw new ExpAccException(ExpAccException.PAYMODE_NOT_NULL);
        }
        if (model.getSortName() == null) {
            throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
        }
        if (model.getPrior() == null) {
            throw new ExpAccException(ExpAccException.PRIOR_NOT_NULL);
        }
        if (model.getEntryNumber() <= 0) {
            throw new ExpAccException(ExpAccException.ENTRY_NUMBER_LARGER_ZERO);
        }
        if (model.getDescription() != null && model.getDescription().length() > 200) {
            throw new ExpAccException(ExpAccException.COMMENT_TOO_LONG);
        }
        if (model.getAmountApproved() == null) {
            model.setAmountApproved(model.getAmount());
        }
        this.checkEntry(model);
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 2);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, pk)) {
            ExpenseAccountBaseBillInfo info = (ExpenseAccountBaseBillInfo)model;
            BigDecimal tempValue = null;
            int oldState = OLDSTATE;
            oldState = this.getOldState(ctx, pk);
            tempValue = 20 == oldState ? info.getAmountApproved() : this.getBudgetValue(ctx, pk, model);
            this.setBudgetValue(ctx, pk, model, tempValue);
            super.update(ctx, pk, coreBaseInfo);
        } else {
            this.checkBudgetControl(ctx, (ExpenseAccountBaseBillInfo)model);
            super.addnew(ctx, pk, coreBaseInfo);
        }
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 2);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
            ExpenseAccountBaseBillInfo info = (ExpenseAccountBaseBillInfo)model;
            BigDecimal tempValue = null;
            int oldState = OLDSTATE;
            oldState = this.getOldState(ctx, (IObjectPK)retValue);
            tempValue = 20 == oldState ? info.getAmountApproved() : this.getBudgetValue(ctx, (IObjectPK)retValue, model);
            this.setBudgetValue(ctx, (IObjectPK)retValue, model, tempValue);
            super.update(ctx, (IObjectPK)retValue, coreBaseInfo);
            return retValue;
        }
        this.checkBudgetControl(ctx, (ExpenseAccountBaseBillInfo)model);
        IObjectPK retValue = super.addnew(ctx, coreBaseInfo);
        return retValue;
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 1);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            super.update(ctx, pk, coreBaseInfo);
        } else {
            super.addnew(ctx, pk, coreBaseInfo);
        }
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 1);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
            super.update(ctx, (IObjectPK)retValue, coreBaseInfo);
            return retValue;
        }
        IObjectPK retValue = super.addnew(ctx, coreBaseInfo);
        return retValue;
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected void setBudgetValue(Context ctx, IObjectPK pk, IObjectValue model, BigDecimal updateValue) throws BOSException, EASBizException {
        if (updateValue == null || updateValue.compareTo(new BigDecimal(0.0)) == 0) {
            return;
        }
        ExpenseAccountBaseBillInfo info = (ExpenseAccountBaseBillInfo)model;
        Date date = new Date();
        int currentYear = date.getYear() + 1900;
        int currentMonth = date.getMonth();
        Date createTime = info.getBillDate();
        int year = createTime.getYear() + 1900;
        int month = createTime.getMonth();
        ExpenseSortInfo esInfo = info.getSortName();
        CostCenterOrgUnitInfo ccouInfo = info.getCostedDept();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("yearTime", (Object)new Integer(currentYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlObj.id", (Object)ccouInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expenseSort.id", (Object)esInfo.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("(#0 or #1) and #2 and #3 and #4 and #5");
        ev.setFilter(filter);
        BudgetControlCollection tempCollection = BudgetControlFactory.getLocalInstance(ctx).getBudgetControlCollection(ev);
        if (tempCollection.size() <= 0) {
            return;
        }
        BudgetControlInfo bcInfo = tempCollection.get(0);
        BudgetBalanceCollection bbcCollection = bcInfo.getEntries();
        BudgetBalanceInfo bbInfo = bbcCollection.get(currentMonth);
        BudgetBalanceInfo tempInfo = null;
        BudgetBalanceInfo foreMonthInfo = null;
        BigDecimal tempBD = null;
        if (year == currentYear) {
            IBudgetControl ibc = BudgetControlFactory.getLocalInstance(ctx);
            if (!bcInfo.isIsCumulate()) {
                tempInfo = bbcCollection.get(month);
                bbcCollection.get(month).setMonthBalance(tempInfo.getMonthBalance().subtract(updateValue));
                bbcCollection.get(month).setFreezeAccount(tempInfo.getFreezeAccount().add(updateValue));
                tempInfo = bbcCollection.get(month);
                BigDecimal tempBig = tempInfo.getMonthAccount().multiply(new BigDecimal(String.valueOf(11 - currentMonth)));
                tempBig = tempBig.add(tempInfo.getMonthBalance().subtract(updateValue));
                bcInfo.setYearBalance(tempBig);
                ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
            } else {
                bcInfo.setYearBalance(bcInfo.getYearBalance().subtract(updateValue));
                if (month == currentMonth) {
                    tempInfo = bbcCollection.get(month);
                    bbcCollection.get(month).setMonthBalance(tempInfo.getMonthBalance().subtract(updateValue));
                    bbcCollection.get(month).setFreezeAccount(tempInfo.getFreezeAccount().add(updateValue));
                    ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
                } else {
                    for (int i = month; i <= currentMonth; ++i) {
                        if (i == month) {
                            tempInfo = bbcCollection.get(i);
                            bbcCollection.get(i).setMonthBalance(tempInfo.getMonthBalance().subtract(updateValue));
                            bbcCollection.get(i).setFreezeAccount(tempInfo.getFreezeAccount().add(updateValue));
                        } else {
                            tempInfo = bbcCollection.get(i);
                            if (!tempInfo.isIsAdd()) {
                                foreMonthInfo = bbcCollection.get(i - 1);
                                tempBD = foreMonthInfo.getMonthBalance();
                                bbcCollection.get(i).setMonthBalance(tempInfo.getMonthBalance().add(tempBD));
                                bbcCollection.get(i).setIsAdd(true);
                            } else {
                                bbcCollection.get(i).setMonthBalance(tempInfo.getMonthBalance().subtract(updateValue));
                                bbcCollection.get(i).setFreezeAccount(tempInfo.getFreezeAccount().add(updateValue));
                            }
                        }
                        ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
                    }
                }
            }
        } else {
            throw new BudgetControlException(BudgetControlException.AUDIT_PASS_YEAR);
        }
    }

    protected int getOldState(Context ctx, IObjectPK pk) {
        return OLDSTATE;
    }

    protected BigDecimal getBudgetValue(Context ctx, IObjectPK pk, IObjectValue model) {
        return null;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    protected void checkBudgetControl(Context ctx, ExpenseAccountBaseBillInfo info) throws BOSException, EASBizException {
        BigDecimal bd = info.getAmountApproved();
        if (bd == null) {
            return;
        }
        if (20 == info.getState().getValue()) {
            return;
        }
        Date date = new Date();
        int currentYear = date.getYear() + 1900;
        int currentMonth = date.getMonth();
        ExpenseSortInfo esInfo = info.getSortName();
        CostCenterOrgUnitInfo ccouInfo = info.getCostedDept();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("yearTime", (Object)new Integer(currentYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlObj.id", (Object)ccouInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expenseSort.id", (Object)esInfo.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("(#0 or #1) and #2 and #3 and #4 and #5");
        ev.setFilter(filter);
        BudgetControlCollection tempCollection = BudgetControlFactory.getLocalInstance(ctx).getBudgetControlCollection(ev);
        if (tempCollection.size() <= 0) {
            return;
        }
        BudgetControlInfo bcInfo = tempCollection.get(0);
        BudgetBalanceCollection bbcCollection = bcInfo.getEntries();
        BudgetBalanceInfo bbInfo = bbcCollection.get(currentMonth);
        boolean isAdd = bbInfo.isIsAdd();
        boolean isCumulate = bcInfo.isIsCumulate();
        BudgetBalanceInfo tempInfo = null;
        Object tempBD = null;
        IBudgetControl ibc = BudgetControlFactory.getLocalInstance(ctx);
        if (isAdd) {
            bcInfo.setYearBalance(bcInfo.getYearBalance().subtract(bd));
            tempInfo = bbcCollection.get(currentMonth);
            bbcCollection.get(currentMonth).setMonthBalance(tempInfo.getMonthBalance().subtract(bd));
            bbcCollection.get(currentMonth).setFreezeAccount(tempInfo.getFreezeAccount().add(bd));
            ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
        } else if (isCumulate) {
            bcInfo.setYearBalance(bcInfo.getYearBalance().subtract(bd));
            if (currentMonth == 0) {
                tempInfo = bbcCollection.get(currentMonth);
                bbcCollection.get(currentMonth).setMonthBalance(tempInfo.getMonthBalance().subtract(bd));
                bbcCollection.get(currentMonth).setFreezeAccount(tempInfo.getFreezeAccount().add(bd));
                bbcCollection.get(currentMonth).setIsAdd(true);
                ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
            } else {
                BudgetBalanceInfo foreMonthInfo = null;
                for (int i = 0; i <= currentMonth; ++i) {
                    if (i == 0) {
                        tempInfo = bbcCollection.get(i);
                        if (tempInfo.isIsAdd()) continue;
                        bbcCollection.get(i).setIsAdd(true);
                        ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
                        continue;
                    }
                    if (i == currentMonth) {
                        tempInfo = bbcCollection.get(i);
                        foreMonthInfo = bbcCollection.get(i - 1);
                        if (tempInfo.isIsAdd()) {
                            bbcCollection.get(i).setMonthBalance(bbcCollection.get(i).getMonthBalance().subtract(bd));
                            bbcCollection.get(i).setFreezeAccount(bbcCollection.get(i).getFreezeAccount().add(bd));
                            ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
                            continue;
                        }
                        bbcCollection.get(i).setMonthBalance(bbcCollection.get(i).getMonthBalance().add(foreMonthInfo.getMonthBalance()).subtract(bd));
                        bbcCollection.get(i).setFreezeAccount(bbcCollection.get(i).getFreezeAccount().add(bd));
                        bbcCollection.get(i).setIsAdd(true);
                        ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
                        continue;
                    }
                    tempInfo = bbcCollection.get(i);
                    foreMonthInfo = bbcCollection.get(i - 1);
                    if (tempInfo.isIsAdd()) continue;
                    bbcCollection.get(i).setMonthBalance(bbcCollection.get(i).getMonthBalance().add(foreMonthInfo.getMonthBalance()));
                    bbcCollection.get(i).setIsAdd(true);
                    ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
                }
            }
        } else {
            tempInfo = bbcCollection.get(currentMonth);
            bbcCollection.get(currentMonth).setMonthBalance(tempInfo.getMonthBalance().subtract(bd));
            bbcCollection.get(currentMonth).setFreezeAccount(tempInfo.getFreezeAccount().add(bd));
            BigDecimal tempBig = tempInfo.getMonthAccount().multiply(new BigDecimal(String.valueOf(11 - currentMonth)));
            tempBig = tempBig.add(tempInfo.getMonthBalance().subtract(bd));
            bcInfo.setYearBalance(tempBig);
            ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
        }
    }

    protected boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }
}

