/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AmountControlTypeEnum;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.IBizAccountBill;
import com.kingdee.eas.cp.bc.IBizAccountOutBill;
import com.kingdee.eas.cp.bc.IDailyPurchaseAccountBill;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.ITravelAccountBill;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.app.AbstractExpenseAccountBillControllerBean;
import com.kingdee.eas.cp.bc.app.invoicepool.util.BizInvoicePoolUtil;
import com.kingdee.eas.cp.bc.app.reverse.util.VoucherReverseUtil;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.ma.pca.PcVoucherInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ExpenseAccountBillControllerBean
extends AbstractExpenseAccountBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ExpenseAccountBillControllerBean");
    public static String bizCollResource = "com.kingdee.eas.cp.bc.BizCollResource";
    private BigDecimal ZERO = new BigDecimal("0.00");
    private static final BOSObjectType FI_AR_OTHER_BILL_INFO_BOS_OBJECT_TYPE = new BOSObjectType("FC910EF3");
    private static final BOSObjectType FI_AP_OTHER_BILL_INFO_BOS_OBJECT_TYPE = new BOSObjectType("48DA3A71");

    @Override
    protected BigDecimal _sumBudgetBalance(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected BigDecimal _sumAmountRefunded(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBillBaseInfo dataBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
            filter.setMaskString("#0 and #1");
        }
        if (super._exists(ctx, filter)) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"29_ExpenseAccountBillControllerBean", (Locale)ctx.getOriginLocale()) + filter.toSql()));
            throw new ExpAccException(ExpAccException.NUMBER_NOT_DUP);
        }
    }

    private void recycleRuleNumber(Context ctx, IObjectPK pk, CoreBillBaseInfo info) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String orgId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        if (BizCollUtil.objectIsNull(orgId)) {
            orgId = BizCollUtil.getNextCompanyId(ctx);
        }
        if (iCodingRuleManager.isExist((IObjectValue)info, orgId) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, orgId)) {
            iCodingRuleManager.recycleNumber((IObjectValue)info, orgId, info.getNumber());
        }
    }

    private boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    protected void checkBill(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        ExpenseAccountBillInfo model = (ExpenseAccountBillInfo)info;
        StateEnum state = model.getState();
        if (StateEnum.CLOSED.equals((Object)state)) {
            throw new ExpAccException(ExpAccException.CLOSE_NOT_DO);
        }
        if (this.objectIsNull(model.getNumber())) {
            throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
        }
        if (!this.objectIsNull(model.getName()) && model.getName().length() > 80) {
            throw new ExpAccException(ExpAccException.NAME_TOO_LONG);
        }
        if (model.getBizReqDate() == null) {
            throw new ExpAccException(ExpAccException.EXPENSEDATE_NOT_NULL);
        }
        if (model.getApplier() == null) {
            throw new ExpAccException(ExpAccException.APPLIER_NOT_NULL);
        }
        if (model.getOrgUnit() == null) {
            throw new ExpAccException(ExpAccException.ORGUNIT_NOT_NULL);
        }
        if (model.getCostedDept() == null && !info.getBoolean("isfromwaf2")) {
            throw new ExpAccException(ExpAccException.REQDEPARTMENT_NOT_NULL);
        }
        if (!BizCollUtil.isBizUnitCostCenter(ctx, model.getCostedDept())) {
            throw new ExpAccException(ExpAccException.COSTCENTER_NOT_BIZUNIT);
        }
        if (!BizCollUtil.isBizUnitCompany(model.getApplierCompany())) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTBIZUNIT);
        }
        if (model.getCurrencyType() == null) {
            throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
        }
        if (model.getPrior() == null) {
            throw new ExpAccException(ExpAccException.PRIOR_NOT_NULL);
        }
        if (model.getTel() != null && model.getTel().length() > 50) {
            throw new ExpAccException(ExpAccException.TEL_TOO_LONG);
        }
        this.checkEntry(model);
    }

    protected void checkEntry(ExpenseAccountBillInfo model) throws BOSException, EASBizException {
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.bizRuleBind(ctx, (ExpenseAccountBillInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BizCollUtil.isNumberDup(ctx, model);
        this.bizRuleBind(ctx, (ExpenseAccountBillInfo)model);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected void checkAddNew(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        if ("submit".equals(action)) {
            this.checkBill(ctx, (IObjectValue)((ExpenseAccountBillInfo)model));
        } else if ("save".equals(action)) {
            this.checkBill(ctx, (IObjectValue)((ExpenseAccountBillInfo)model));
            this.checkSaveEntry((ExpenseAccountBillInfo)model);
        }
    }

    @Override
    protected void checkUpdate(Context ctx, IObjectValue model, String action) throws BOSException, EASBizException {
        if ("submit".equals(action)) {
            this.checkBill(ctx, (IObjectValue)((ExpenseAccountBillInfo)model));
        } else if ("save".equals(action)) {
            this.checkBill(ctx, (IObjectValue)((ExpenseAccountBillInfo)model));
            this.checkSaveEntry((ExpenseAccountBillInfo)model);
        }
    }

    protected void checkSaveEntry(ExpenseAccountBillInfo info) throws BOSException, EASBizException {
        if (this.objectIsNull(info.getNumber())) {
            throw new ExpAccException(ExpAccException.NUMBER_NOT_NULL);
        }
    }

    protected void bizRuleBind(Context ctx, ExpenseAccountBillInfo model) {
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.bizRuleBind(ctx, (ExpenseAccountBillInfo)model);
        super._update(ctx, pk, model);
    }

    protected void checkDelete(Context ctx, CoreBillBaseInfo info) throws BOSException, EASBizException {
        ExpenseAccountBillInfo accountInfo = (ExpenseAccountBillInfo)info;
        StateEnum state = accountInfo.getState();
        if (StateEnum.DRAFT.equals((Object)state) || StateEnum.CANCELED.equals((Object)state) || StateEnum.NEW.equals((Object)state) || StateEnum.SUBMIT.equals((Object)state) || StateEnum.ALREADYABANDON.equals((Object)state)) {
            return;
        }
        throw new ExpAccException(ExpAccException.DEL_ONLY_STATE);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBillBaseInfo info = (CoreBillBaseInfo)this.getValue(ctx, pk);
        this.checkDelete(ctx, info);
        this.abortWorkingWf(ctx, pk);
        CompanyOrgUnitInfo applierCompany = this.getApplierCompany(ctx, info.getId());
        if (!BizCollUtil.objectIsNull(applierCompany) && BizInvoicePoolUtil.getCpbcParams(ctx, applierCompany)) {
            BizInvoicePoolUtil.deleteInvoicePool(ctx, info.getId());
        }
        super._delete(ctx, pk);
        this.recycleRuleNumber(ctx, pk, info);
        logger.error((Object)"---------start del image-----");
        logger.error((Object)("---------billId-----" + info.getId().toString()));
        logger.error((Object)("---------imageNo-----" + info.get("imageNo")));
        if (BizCollUtil.objectIsNull(info.getId()) || !BizCollUtil.objectIsNull(info.get("imageNo"))) {
            // empty if block
        }
    }

    private CompanyOrgUnitInfo getApplierCompany(Context ctx, BOSUuid billid) throws BOSException {
        ObjectUuidPK billPK = new ObjectUuidPK(billid);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("applierCompany.name"));
        sic.add(new SelectorItemInfo("applierCompany.number"));
        BizCollBillBaseInfo billInfo = null;
        billInfo = BizCollUtil.objectIsNull(ctx) ? (BizCollBillBaseInfo)DynamicObjectFactory.getRemoteInstance().getValue(billPK.getObjectType(), (IObjectPK)billPK, sic) : (BizCollBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billPK.getObjectType(), (IObjectPK)billPK, sic);
        return billInfo.getApplierCompany();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDoPayment(Context ctx, BOSUuid billId) throws BOSException {
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billId, CompareType.EQUALS));
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            ORMappingDAO dao = new ORMappingDAO(iBOTRelation.getType(), ctx, cn);
            boolean bl = dao.exists(filter);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected void _wfPayment(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (!this.isDoPayment(ctx, billId)) {
            return;
        }
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(billId, StateEnum.ALREADYPAYMENT);
    }

    private boolean isDoVoucher(Context ctx, BOSUuid billId) throws BOSException {
        return true;
    }

    @Override
    protected void _wfGenVoucher(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        if (!this.isDoVoucher(ctx, billId)) {
            return;
        }
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(billId, StateEnum.CLOSED);
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, List bOTRelationInfos, List destBillVOs) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        BOSObjectType type = BizCollUtil.getBOSType(((IObjectCollection)destBillVOs.get(0)).getObject(0).get("id").toString());
        if (!new VoucherInfo().getBOSType().equals((Object)type)) {
            return;
        }
        BOTRelationCollection bOTRelationCon = new BOTRelationCollection();
        if (bOTRelationInfos != null) {
            int size = bOTRelationInfos.size();
            for (int i = 0; i < size; ++i) {
                bOTRelationCon.addCollection((BOTRelationCollection)bOTRelationInfos.get(i));
            }
        }
        if (srcBillPKs != null && srcBillPKs.length > 0) {
            srcBillVOs = VoucherReverseUtil.getBillInfos(ctx, srcBillPKs);
        }
        Map reverseBillMap = VoucherReverseUtil.convertBOTRelationToMap(ctx, bOTRelationInfos, srcBillVOs, destBillVOs);
        VoucherReverseUtil.voucherBatchReverseSave(ctx, reverseBillMap, bOTBillOperStateEnum, bOTRelationCon);
        logger.error((Object)("cp.bc _batchReverseSave finished ,OperState=" + bOTBillOperStateEnum + ",time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos, IObjectCollection destBillVOs) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        BOTRelationInfo botObj = bOTRelationInfos.get(0);
        BOSObjectType type = BizCollUtil.getBOSType(botObj.getDestObjectID());
        if (!new VoucherInfo().getBOSType().equals((Object)type) && !new PcVoucherInfo().getBOSType().equals((Object)type)) {
            return;
        }
        if (srcBillPKs != null && srcBillPKs.length > 0) {
            srcBillVOs = VoucherReverseUtil.getBillInfos(ctx, srcBillPKs);
        }
        Map reverseBillMap = VoucherReverseUtil.convertBOTRelationToMap(ctx, bOTRelationInfos, srcBillVOs, destBillVOs);
        if (!new VoucherInfo().getBOSType().equals((Object)type)) {
            if (new PcVoucherInfo().getBOSType().equals((Object)type)) {
                VoucherReverseUtil.paVoucherBatchReverseSave(ctx, reverseBillMap, bOTBillOperStateEnum, bOTRelationInfos);
            }
            return;
        }
        VoucherReverseUtil.voucherBatchReverseSave(ctx, reverseBillMap, bOTBillOperStateEnum, bOTRelationInfos);
        logger.error((Object)("cp.bc _batchReverseSaved finished ,OperState=" + bOTBillOperStateEnum + ",time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
    }

    protected boolean isSourceBillClose(Context ctx, BizCollBillBaseInfo info) throws BOSException {
        boolean isSourceBillClose = false;
        String sourceBillId = info.getSourceBillId();
        if (sourceBillId != null) {
            ObjectUuidPK objpk = new ObjectUuidPK(sourceBillId);
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            BizCollBillBaseInfo sourceInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, sic);
            if (sourceInfo != null && sourceInfo instanceof LoanBillInfo && StateEnum.CLOSED.equals((Object)sourceInfo.getState())) {
                isSourceBillClose = true;
            }
        }
        return isSourceBillClose;
    }

    protected void setLoanState(Context ctx, String srcBillId) throws BOSException, EASBizException {
        if (BizCollUtil.isLoanBill(srcBillId)) {
            ObjectUuidPK objpk = new ObjectUuidPK(srcBillId);
            IObjectValue billInfo = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(objpk.getObjectType(), (IObjectPK)objpk);
            if (AmountControlTypeEnum.oneTOone.equals((Object)((LoanBillInfo)billInfo).getAmountControlType()) || ((LoanBillInfo)billInfo).getAmountUsed() != null && ((LoanBillInfo)billInfo).getAmountBalance().doubleValue() == 0.0) {
                LoanBillInfo loanInfo = null;
                if (billInfo instanceof DailyLoanBillInfo) {
                    loanInfo = (DailyLoanBillInfo)billInfo;
                    loanInfo.setLoanState("N");
                    loanInfo.setReturnAmount(new BigDecimal("0.00"));
                    loanInfo.setAmountUsed(new BigDecimal("0.00"));
                    loanInfo.setAmountBalance(loanInfo.getAmountApproved());
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("loanState"));
                    sic.add(new SelectorItemInfo("returnAmount"));
                    sic.add(new SelectorItemInfo("amountUsed"));
                    sic.add(new SelectorItemInfo("amountBalance"));
                    DailyLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)loanInfo, sic);
                } else if (billInfo instanceof EvectionLoanBillInfo) {
                    loanInfo = (EvectionLoanBillInfo)billInfo;
                    loanInfo.setLoanState("N");
                    loanInfo.setReturnAmount(new BigDecimal("0.00"));
                    loanInfo.setAmountUsed(new BigDecimal("0.00"));
                    loanInfo.setAmountBalance(loanInfo.getAmountApproved());
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("loanState"));
                    sic.add(new SelectorItemInfo("returnAmount"));
                    sic.add(new SelectorItemInfo("amountUsed"));
                    sic.add(new SelectorItemInfo("amountBalance"));
                    EvectionLoanBillFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)loanInfo, sic);
                }
            }
        }
    }

    protected boolean isSourceBillRelatedBill(Context ctx, BizCollBillBaseInfo info) {
        boolean isSourceBillRelatedBill = false;
        try {
            if (BizCollUtil.checkBillHasTracDown(ctx, info)) {
                isSourceBillRelatedBill = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return isSourceBillRelatedBill;
    }

    protected boolean isSourceBillRelatedBill(Context ctx, BizCollBillBaseInfo info, String destObjectID) {
        boolean isSourceBillRelatedBill = false;
        try {
            if (BizCollUtil.checkBillHasTracDown(ctx, info, destObjectID)) {
                isSourceBillRelatedBill = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return isSourceBillRelatedBill;
    }

    protected void setBillfiVouchered(ExpenseAccountBillInfo srcObj, Context ctx, boolean flag) throws BOSException, EASBizException {
        if (srcObj instanceof BizAccountBillInfo) {
            BizAccountBillInfo bizAccountBillInfo = (BizAccountBillInfo)srcObj;
            bizAccountBillInfo.setFiVouchered(flag);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("fiVouchered"));
            IBizAccountBill iBizAccountBill = null;
            iBizAccountBill = BizAccountBillFactory.getLocalInstance(ctx);
            iBizAccountBill.updatePartial((CoreBaseInfo)bizAccountBillInfo, sic);
        } else if (srcObj instanceof BizAccountOutBillInfo) {
            BizAccountOutBillInfo bizAccountOutBillInfo = (BizAccountOutBillInfo)srcObj;
            bizAccountOutBillInfo.setFiVouchered(flag);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("fiVouchered"));
            IBizAccountOutBill iBizAccountOutBill = null;
            iBizAccountOutBill = BizAccountOutBillFactory.getLocalInstance(ctx);
            iBizAccountOutBill.updatePartial((CoreBaseInfo)bizAccountOutBillInfo, sic);
        } else if (srcObj instanceof TravelAccountBillInfo) {
            TravelAccountBillInfo travelAccountBillInfo = (TravelAccountBillInfo)srcObj;
            travelAccountBillInfo.setFiVouchered(flag);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("fiVouchered"));
            ITravelAccountBill iTravelAccountBill = null;
            iTravelAccountBill = TravelAccountBillFactory.getLocalInstance(ctx);
            iTravelAccountBill.updatePartial((CoreBaseInfo)travelAccountBillInfo, sic);
        } else if (srcObj instanceof DailyPurchaseAccountBillInfo) {
            DailyPurchaseAccountBillInfo dailyPurchaseAccountBillInfo = (DailyPurchaseAccountBillInfo)srcObj;
            dailyPurchaseAccountBillInfo.setFiVouchered(flag);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("fiVouchered"));
            IDailyPurchaseAccountBill iDailyPurchaseAccountBill = null;
            iDailyPurchaseAccountBill = DailyPurchaseAccountBillFactory.getLocalInstance(ctx);
            iDailyPurchaseAccountBill.updatePartial((CoreBaseInfo)dailyPurchaseAccountBillInfo, sic);
        }
    }

    public void savaAccesoryCount(Context ctx, ExpenseAccountBillInfo info) throws BOSException {
        AttachmentServerManager asm;
        int attachCount;
        if (info.getId() != null && (attachCount = (asm = AttachmentManagerFactory.getServerManager((Context)ctx)).getAttachmentCountByBoID(info.getId().toString())) != 0) {
            info.setAccessoryCount(attachCount);
        }
    }
}

