/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpenseReqBgParam;
import com.kingdee.eas.cp.bc.ExpenseReqBillInfo;
import com.kingdee.eas.cp.bc.IExpenseReqBill;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractExpenseReqFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.ma.bg.BgControlFactory;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgControl;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class ExpenseReqFacadeControllerBean
extends AbstractExpenseReqFacadeControllerBean {
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final String EXPTYPE = "CS003";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ExpenseReqFacadeControllerBean");

    @Override
    protected void _budgetControl(Context ctx, IObjectValue expenseReqInfo, boolean isBudgetOK) throws BOSException, EASBizException {
    }

    @Override
    protected void _audit(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _unAudit(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
    }

    @Override
    protected BgCtrlParam[] _getBgParams(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        return new BgCtrlParam[]{this.getBgParam(ctx, billInfo)};
    }

    @Override
    protected BgDataCollection _getBgDataCollection(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        BgCtrlParam[] result = new BgCtrlParam[]{this.getBgParam(ctx, billInfo)};
        IBgControl bgctrl = BgControlFactory.getLocalInstance((Context)ctx);
        BgDataCollection bgDataColl = bgctrl.bgGetBgDataCollection(result);
        return bgDataColl;
    }

    @Override
    protected void _setAuditOK(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this._setState(ctx, billID, (Enum)StateEnum.CHECKED);
    }

    @Override
    protected void _setAuditNG(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this._setState(ctx, billID, (Enum)StateEnum.CHECKFAILD);
    }

    @Override
    protected void _setInAudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, (Enum)StateEnum.CHECKING);
    }

    @Override
    protected void _setCancelState(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        this._setState(ctx, billID, (Enum)StateEnum.CANCELED);
    }

    @Override
    protected void _setCloseState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, (Enum)StateEnum.CLOSED);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, Enum state) throws BOSException, EASBizException {
        IExpenseReqBill iExpenseReqBill = (IExpenseReqBill)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billId);
        ObjectUuidPK pk = new ObjectUuidPK(billId);
        ExpenseReqBillInfo info = iExpenseReqBill.getExpenseReqBillInfo((IObjectPK)pk);
        info.setState((StateEnum)state);
        if (StateEnum.CHECKING.equals(state) || StateEnum.CHECKED.equals(state) || StateEnum.CHECKFAILD.equals(state)) {
            info.setAuditDate(new Date());
            info.setAuditor((UserInfo)ctx.get((Object)"UserInfo"));
        }
        iExpenseReqBill.update((IObjectPK)pk, (CoreBaseInfo)info);
    }

    private BgCtrlParam getBgParam(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        ExpenseReqBillInfo info = (ExpenseReqBillInfo)billInfo;
        BgCtrlParam param = new BgCtrlParam();
        BgTypeInfo bgTypeInfo = BgTypeFactory.getLocalInstance((Context)ctx).getValueByNumber("ExpenseBudget");
        param.setBgTypeId(bgTypeInfo.getId());
        PeriodInfo period = this.getPeriod(ctx, info);
        if (period != null) {
            param.setPeriodId(period.getId());
        }
        param.setBizOrgUnitId(info.getCostedDept().getId());
        param.setCurrencyId(info.getCurrencyType().getId());
        param.setCompanyId(info.getCompany().getId());
        param.setCtrlSystem(SystemEnum.BUSINESS_COLLABORATION);
        param.setSrcBillId(info.getId());
        param.setSrcBillNumber(info.getNumber());
        param.setBizDate(info.getBizReqDate());
        AccountViewInfo exp = new AccountViewInfo();
        exp.setId(info.getExpenseType().getId());
        param.addDimension(BgDimensionEnum.ACCOUNT, (IObjectValue)exp);
        if (info.getSupportedObj() != null) {
            BOSUuid costId = info.getSupportedObj().getId();
            ICostObject iCost = CostObjectFactory.getLocalInstance((Context)ctx);
            CostObjectInfo costInfo = iCost.getCostObjectInfo((IObjectPK)new ObjectUuidPK(costId));
            MaterialInfo mat = new MaterialInfo();
            mat.setId(costInfo.getRelatedId());
            param.addDimension(BgDimensionEnum.PRODUCT, (IObjectValue)mat);
        }
        BgCtrlData data = new BgCtrlData();
        data.setDataType(BgDataTypeEnum.Amount);
        data.setValue(info.getAmount());
        param.addData(BgElementEnum.AMT, data);
        return param;
    }

    @Override
    protected BgCtrlParam[] _getBgParams(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        IExpenseReqBill iExpenseReqBill = (IExpenseReqBill)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billID);
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        ExpenseReqBillInfo info = iExpenseReqBill.getExpenseReqBillInfo((IObjectPK)pk);
        return new BgCtrlParam[]{this.getBgParam(ctx, (IObjectValue)info)};
    }

    private PeriodInfo getPeriod(Context ctx, ExpenseReqBillInfo info) throws BOSException, EASBizException {
        PeriodInfo perInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)info.getBizReqDate()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)info.getBizReqDate()), CompareType.GREATER_EQUALS));
        filter.setMaskString("#0 and #1");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            perInfo = periodc.get(0);
        }
        if (perInfo.getId() == null) {
            perInfo = null;
        }
        return perInfo;
    }

    @Override
    protected boolean _isNeedBudget(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        return BizCollUtil.isNeedBudgetControl(ctx, billID);
    }

    @Override
    protected void _sendBackBudget(Context ctx, BOSUuid id) throws BOSException, EASBizException {
        ExpenseReqBgParam dlBgParam = new ExpenseReqBgParam();
        BgCtrlParam[] params = dlBgParam.getBgParam(ctx, id);
        IBgControl iBgControl = BgControlFactory.getLocalInstance((Context)ctx);
        iBgControl.bgCancelAudit(params);
    }
}

