/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.ExpenseTypeAsstActTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeAsstActTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseTypeAsstActType;
import com.kingdee.eas.cp.bc.app.AbstractExpenseTypeAsstActTypeControllerBean;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class ExpenseTypeAsstActTypeControllerBean
extends AbstractExpenseTypeAsstActTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ExpenseTypeAsstActTypeControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExpenseTypeAsstActTypeInfo expenseTypeAsstInfo = (ExpenseTypeAsstActTypeInfo)model;
        if (expenseTypeAsstInfo == null || expenseTypeAsstInfo.getAsstActType1() == null && expenseTypeAsstInfo.getAsstActType2() == null && expenseTypeAsstInfo.getAsstActType3() == null && expenseTypeAsstInfo.getAsstActType4() == null) {
            throw new BizCollException(BizCollException.ACOUNT_OR_LOAN_NOT_NULL);
        }
        IObjectPK pk = super._addnew(ctx, model);
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"_addnew", (BOSObjectType)new ExpenseTypeAsstActTypeInfo().getBOSType(), (IObjectPK)pk, (String)pk.toString(), (String)"\u6838\u7b97\u9879\u76ee\u6620\u5c04\u65b0\u589e");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ExpenseTypeAsstActTypeInfo expenseTypeAsstInfo = (ExpenseTypeAsstActTypeInfo)model;
        if (expenseTypeAsstInfo == null || expenseTypeAsstInfo.getAsstActType1() == null && expenseTypeAsstInfo.getAsstActType2() == null && expenseTypeAsstInfo.getAsstActType3() == null && expenseTypeAsstInfo.getAsstActType4() == null) {
            throw new BizCollException(BizCollException.ACOUNT_OR_LOAN_NOT_NULL);
        }
        super._update(ctx, pk, model);
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"_update", (BOSObjectType)new ExpenseTypeAsstActTypeInfo().getBOSType(), (IObjectPK)pk, (String)model.getObjectValue("expenseType").getString("number"), (String)"\u6838\u7b97\u9879\u76ee\u6620\u5c04\u66f4\u65b0");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"_delete", (BOSObjectType)new ExpenseTypeAsstActTypeInfo().getBOSType(), (IObjectPK)pk, (String)pk.toString(), (String)"\u6838\u7b97\u9879\u76ee\u6620\u5c04\u5220\u9664");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected Result _submit(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        int j = colls.size();
        for (int i = 0; i < j; ++i) {
            IObjectValue value = colls.getObject(i);
            if (this.checkExpenseType(ctx, value)) continue;
            throw new BOSException("expenseTypeRepeatedException");
        }
        return super._submit(ctx, colls);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (!this.checkExpenseType(ctx, model)) {
            throw new BOSException("expenseTypeRepeatedException");
        }
        super._submit(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.checkExpenseType(ctx, model)) {
            return super._submit(ctx, model);
        }
        throw new BOSException("expenseTypeRepeatedException");
    }

    private boolean checkExpenseType(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ExpenseTypeAsstActTypeInfo info = (ExpenseTypeAsstActTypeInfo)model;
        ExpenseTypeInfo expenseTypeInfo = info.getExpenseType();
        if (expenseTypeInfo != null) {
            String expenseTypeId = expenseTypeInfo.getId().toString();
            CompanyOrgUnitInfo unitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("expenseType.id", (Object)expenseTypeId));
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)unitInfo.getId().toString()));
            boolean isExist = super._exists(ctx, fi);
            if (info.getId() == null && !isExist) {
                return true;
            }
            if (info.getId() != null && isExist) {
                IExpenseTypeAsstActType factory = ExpenseTypeAsstActTypeFactory.getLocalInstance(ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("expenseType.id"));
                ExpenseTypeAsstActTypeInfo oldInfo = factory.getExpenseTypeAsstActTypeInfo((IObjectPK)new ObjectUuidPK(info.getId()), sic);
                if (oldInfo.getExpenseType() == null) {
                    return true;
                }
                return expenseTypeId.equals(oldInfo.getExpenseType().getId().toString());
            }
            return false;
        }
        return true;
    }
}

