/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.CostCenterType;
import com.kingdee.eas.cp.bc.ExpSortException;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingInfo;
import com.kingdee.eas.cp.bc.app.AbstractExpenseTypeSubjectMappingControllerBean;
import org.apache.log4j.Logger;

public class ExpenseTypeSubjectMappingControllerBean
extends AbstractExpenseTypeSubjectMappingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ExpenseTypeSubjectMappingControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameSame(ctx, model);
        ExpenseTypeSubjectMappingInfo info = (ExpenseTypeSubjectMappingInfo)model;
        if (!(info != null && info.getAccountId() != null || info != null && info.getLoanAccountID() != null)) {
            throw new ExpSortException(ExpSortException.ACOUNT_OR_LOAN_NOT_NULL);
        }
        IObjectPK pk = super._addnew(ctx, model);
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"_addnew", (BOSObjectType)new ExpenseTypeSubjectMappingInfo().getBOSType(), (IObjectPK)pk, (String)pk.toString(), (String)"\u79d1\u76ee\u6620\u5c04\u65b0\u589e");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameSame(ctx, model);
        super._addnew(ctx, pk, model);
    }

    private void checkNameSame(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExpenseTypeSubjectMappingInfo info = (ExpenseTypeSubjectMappingInfo)model;
        CompanyOrgUnitInfo company = info.getCompany();
        ExpenseTypeInfo expenseTypeInfo = info.getExpenseTypeId();
        CostCenterType costCenterType = info.getCostCenterType();
        CostCenterOrgUnitInfo costCenterInfo = info.getCostCenterID();
        if (company == null || company.getId() == null || expenseTypeInfo == null || expenseTypeInfo.getId() == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expenseTypeId", (Object)expenseTypeInfo.getId().toString(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        if (costCenterType != null) {
            filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)costCenterType.getValue(), CompareType.EQUALS));
            if (costCenterInfo == null) {
                filter.getFilterItems().add(new FilterItemInfo("costCenterID", null, CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("costCenterID", (Object)costCenterInfo.getId().toString(), CompareType.EQUALS));
            }
        }
        if (super._exists(ctx, filter)) {
            throw new BizCollException(BizCollException.EXPENSETYPE_SUBMAP_DUP);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameSame(ctx, model);
        ExpenseTypeSubjectMappingInfo info = (ExpenseTypeSubjectMappingInfo)model;
        if (info == null || info.getCompany() == null) {
            return;
        }
        super._update(ctx, pk, model);
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"_update", (BOSObjectType)new ExpenseTypeSubjectMappingInfo().getBOSType(), (IObjectPK)pk, (String)pk.toString(), (String)"\u79d1\u76ee\u6620\u5c04\u4fee\u6539");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
        IObjectPK logPK = LogUtil.beginLogWithDescription((Context)ctx, (String)"_delete", (BOSObjectType)new ExpenseTypeSubjectMappingInfo().getBOSType(), (IObjectPK)pk, (String)pk.toString(), (String)"\u79d1\u76ee\u6620\u5c04\u5220\u9664");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }
}

