/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillException;
import com.kingdee.eas.cp.bc.IInvoiceTypeEntry;
import com.kingdee.eas.cp.bc.InvoiceException;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryCollection;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryInfo;
import com.kingdee.eas.cp.bc.app.AbstractInvoiceTypeEntryControllerBean;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class InvoiceTypeEntryControllerBean
extends AbstractInvoiceTypeEntryControllerBean {
    private static Logger logger = Logger.getLogger(InvoiceTypeEntryControllerBean.class);
    private static final int MAX_NUMBUER_LENGTH = 80;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceTypeEntryInfo invoiceType2 = (InvoiceTypeEntryInfo)model;
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        invoiceType2.setCompany(companyOrgUnitInfo);
        if (BizCollUtil.objectIsNull(companyOrgUnitInfo)) {
            BizCollBillBaseInfo baseInfo = null;
            try {
                baseInfo = CommonUtilFacadeFactory.getLocalInstance(ctx).forLoanBillCreateNewData();
                invoiceType2.setCompany(baseInfo.getCompany());
                companyOrgUnitInfo = baseInfo.getCompany();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        if (!BizCollUtil.objectIsNull(invoiceType2.getNumber())) {
            invoiceType2.setName(invoiceType2.getNumber());
        } else if (!BizCollUtil.objectIsNull(invoiceType2.getTicketTypeId())) {
            invoiceType2.setName(invoiceType2.getTicketTypeId().getNumber());
        }
        this.checkModelValidate(ctx, model);
        this._checkNumberDup(ctx, model);
        return super._save(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceTypeEntryInfo invoiceTypeEntryInfo = (InvoiceTypeEntryInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)invoiceTypeEntryInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (invoiceTypeEntryInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)invoiceTypeEntryInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, invoiceTypeEntryInfo, "number") + invoiceTypeEntryInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    private boolean isExit(boolean ishead, IInvoiceTypeEntry invoiceService, String invoicetype, InvoiceTypeEntryInfo invoiceTypeEntryInfo, HashSet lnUps, String likeStr, BOSUuid id) throws BOSException {
        boolean isExit = false;
        logger.error((Object)"#####cpbc runner #######################");
        logger.error((Object)("#####cpbc runner invoicetype=" + invoicetype));
        logger.error((Object)("#####cpbc runner likeStr=" + likeStr));
        logger.error((Object)("#####cpbc runner lnUps=" + lnUps));
        logger.error((Object)("#####cpbc runner invoicetype=" + invoicetype));
        logger.error((Object)"#####cpbc runner #######################");
        StringBuffer sql = new StringBuffer("select id,number,name where ");
        if (ishead) {
            sql.append(" invoiceType = '" + likeStr + "'");
        } else {
            sql.append(" number like '" + likeStr.replaceAll("(0){1,}$", "%") + "'");
        }
        sql.append(" and invoicetype='" + invoicetype + "'");
        sql.append(" and company in ('" + BizCollUtil.convertSetToString(lnUps) + ")'");
        logger.error((Object)("#####cpbc runner sql.toString=" + sql.toString()));
        InvoiceTypeEntryCollection invoiceTypeEntryInfos = invoiceService.getInvoiceTypeEntryCollection(sql.toString());
        if (invoiceTypeEntryInfos.size() > 0) {
            isExit = !id.toString().equals(invoiceTypeEntryInfos.get(0).get("id").toString());
        }
        return isExit;
    }

    protected void checkModelValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceTypeEntryInfo info = (InvoiceTypeEntryInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (info.getNumber().trim().length() > 80) {
            throw new EvectionLoanBillException(EvectionLoanBillException.NUMBER_TOO_LONG);
        }
        if (!StringUtils.isEmpty((String)info.getTaxClassCode()) && info.getTaxClassCode().trim().length() > 80) {
            throw new InvoiceException(InvoiceException.TAXCLASSCODE_TOO_LONG);
        }
    }
}

