/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.IItemApprovedTree;
import com.kingdee.eas.cp.bc.IVoucherTemplate;
import com.kingdee.eas.cp.bc.ItemApprovedTreeCollection;
import com.kingdee.eas.cp.bc.ItemApprovedTreeException;
import com.kingdee.eas.cp.bc.ItemApprovedTreeFactory;
import com.kingdee.eas.cp.bc.ItemApprovedTreeInfo;
import com.kingdee.eas.cp.bc.VoucherTemplateCollection;
import com.kingdee.eas.cp.bc.VoucherTemplateFactory;
import com.kingdee.eas.cp.bc.VoucherTemplateInfo;
import com.kingdee.eas.cp.bc.app.AbstractItemApprovedFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ItemApprovedFacadeControllerBean
extends AbstractItemApprovedFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ItemApprovedFacadeControllerBean");

    @Override
    protected boolean _synchroItem(Context ctx, Properties types) throws BOSException, EASBizException {
        return false;
    }

    @Override
    protected boolean _synchroItem(Context ctx, String[] types) throws BOSException, EASBizException {
        return true;
    }

    private void moveTree(Context ctx, int fItemClassID, int fParentID, ItemApprovedTreeInfo tempInfo, Connection conn) {
        String getItemSql = "select * from t_Item where FItemClassID = ? and FParentID = ? and  FDetail = '0' order by FItemClassID ";
        String getItemSqlLeaf = "select * from t_Item where FItemClassID = ? and FParentID = ? and  FDetail = '1' order by FItemClassID ";
        ResultSet rs1 = null;
        ResultSet rs = null;
        PreparedStatement pStmt = null;
        PreparedStatement pStmt1 = null;
        boolean itemClassId = false;
        try {
            pStmt = conn.prepareStatement(getItemSql);
            pStmt.setInt(1, fItemClassID);
            pStmt.setInt(2, fParentID);
            rs = pStmt.executeQuery();
            ItemApprovedTreeInfo info = null;
            ItemApprovedTreeInfo returnInfo = null;
            IItemApprovedTree iInfo = ItemApprovedTreeFactory.getLocalInstance(ctx);
            Object pk = null;
            int tempItemId = -1;
            while (rs.next()) {
                info = new ItemApprovedTreeInfo();
                info.setName(rs.getString("FName"));
                info.setNumber(rs.getString("FShortNumber"));
                info.setLongNumber(rs.getString("FFullNumber"));
                info.setIsLeaf(false);
                info.setLevel(rs.getInt("FLevel") + 1);
                info.setDisplayName(rs.getString("FFullName"));
                tempItemId = rs.getInt("FItemID");
                info.setItemID(tempItemId);
                info.setItemClassID(rs.getInt("FItemClassID"));
                info.setIsDelete(false);
                info.setParent(tempInfo);
                returnInfo = this.checkBudgetExist(ctx, info, false);
                if (returnInfo != null) {
                    if (this.checkBudgetUpdate(ctx, info, false)) {
                        returnInfo.setItemID(info.getItemClassID());
                        returnInfo.setItemClassID(info.getItemClassID());
                        returnInfo.setItemNumber(info.getItemNumber());
                        returnInfo.setIsLeaf(info.isIsLeaf());
                        returnInfo.setLevel(info.getLevel());
                        iInfo.update((IObjectPK)new ObjectUuidPK(returnInfo.getId()), (CoreBaseInfo)returnInfo);
                    }
                } else {
                    iInfo.addnew((CoreBaseInfo)info);
                }
                this.moveTree(ctx, fItemClassID, tempItemId, info, conn);
            }
            pStmt1 = conn.prepareStatement(getItemSqlLeaf);
            pStmt1.setInt(1, fItemClassID);
            pStmt1.setInt(2, fParentID);
            rs1 = pStmt1.executeQuery();
            while (rs1.next()) {
                info = new ItemApprovedTreeInfo();
                info.setName(rs1.getString("FName"));
                info.setNumber(rs1.getString("FShortNumber"));
                info.setLongNumber(rs1.getString("FFullNumber"));
                info.setIsLeaf(true);
                info.setLevel(rs1.getInt("FLevel") + 1);
                info.setDisplayName(rs1.getString("FFullName"));
                tempItemId = rs1.getInt("FItemID");
                info.setItemID(tempItemId);
                info.setItemClassID(rs1.getInt("FItemClassID"));
                info.setIsDelete(false);
                info.setParent(tempInfo);
                returnInfo = this.checkBudgetExist(ctx, info, false);
                if (returnInfo != null) {
                    if (!this.checkBudgetUpdate(ctx, info, false)) continue;
                    returnInfo.setItemID(info.getItemClassID());
                    returnInfo.setItemClassID(info.getItemClassID());
                    returnInfo.setItemNumber(info.getItemNumber());
                    returnInfo.setIsLeaf(info.isIsLeaf());
                    returnInfo.setLevel(info.getLevel());
                    iInfo.update((IObjectPK)new ObjectUuidPK(returnInfo.getId()), (CoreBaseInfo)returnInfo);
                    continue;
                }
                iInfo.addnew((CoreBaseInfo)info);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private ItemApprovedTreeInfo checkBudgetExist(Context ctx, ItemApprovedTreeInfo info, boolean boo) {
        ItemApprovedTreeInfo tempInfo = null;
        try {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (boo) {
                filter.getFilterItems().add(new FilterItemInfo("itemClassID", (Object)new Integer(info.getItemClassID()), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(info.getLevel() + 1), CompareType.EQUALS));
                filter.setMaskString(" #0 and #1 ");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("itemID", (Object)new Integer(info.getItemID()), CompareType.EQUALS));
                filter.setMaskString("#0");
            }
            ev.setFilter(filter);
            IItemApprovedTree iTree = ItemApprovedTreeFactory.getLocalInstance(ctx);
            ItemApprovedTreeCollection iTreeCollection = iTree.getItemApprovedTreeCollection(ev);
            if (iTreeCollection.size() > 0) {
                tempInfo = iTreeCollection.get(0);
            }
        }
        catch (Exception e) {
            tempInfo = null;
        }
        return tempInfo;
    }

    private boolean checkBudgetUpdate(Context ctx, ItemApprovedTreeInfo info, boolean boo) {
        boolean isUpdate = true;
        FilterInfo filter = new FilterInfo();
        try {
            EntityViewInfo ev = new EntityViewInfo();
            if (boo) {
                filter.getFilterItems().add(new FilterItemInfo("itemClassID", (Object)new Integer(info.getItemClassID()), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(boo ? info.getLevel() + 1 : info.getLevel()), CompareType.EQUALS));
                filter.setMaskString("#0 and #1  ");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("itemID", (Object)new Integer(info.getItemID()), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("itemClassID", (Object)new Integer(info.getItemClassID()), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(info.isIsLeaf()), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(boo ? info.getLevel() + 1 : info.getLevel()), CompareType.EQUALS));
                filter.setMaskString("#0 and #1 and #2 and #3 ");
            }
            ev.setFilter(filter);
            IItemApprovedTree iTree = ItemApprovedTreeFactory.getLocalInstance(ctx);
            ItemApprovedTreeCollection iTreeCollection = iTree.getItemApprovedTreeCollection(ev);
            if (iTreeCollection.size() > 0) {
                isUpdate = false;
            }
        }
        catch (Exception e) {
            isUpdate = false;
        }
        return isUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTreeNode(Connection conn) throws ItemApprovedTreeException {
        if (conn == null) {
            throw new ItemApprovedTreeException(ItemApprovedTreeException.CONN_NOT_NULL);
        }
        String k3Sql = "select * from select * from t_ItemClass where FItemClassID = ? ";
        String easSql = " select FItemClassID from t_bc_itemApprovedtree  where flevel = '1' and fisdelete = '0' and (fitemId is null or fitemId = '0') ";
        ResultSet easRS = null;
        ResultSet k3RS = null;
        Statement easStmt = null;
        Statement k3Stmt = null;
        try {
            easStmt = conn.createStatement();
            easRS = easStmt.executeQuery(easSql);
            String tempStr = null;
            k3Stmt = conn.prepareStatement(k3Sql);
            while (easRS.next()) {
                tempStr = easRS.getString("FItemClassID");
                k3Stmt.setString(1, tempStr);
                k3RS = k3Stmt.executeQuery();
                if (!k3RS.next()) {
                    this.removeMainNode(tempStr);
                    continue;
                }
                this.removeLeaf(tempStr);
            }
        }
        catch (SQLException e) {
        }
        finally {
            if (k3RS != null) {
                try {
                    k3RS.close();
                }
                catch (Exception e) {
                    k3RS = null;
                }
            }
            if (k3Stmt != null) {
                try {
                    k3Stmt.close();
                }
                catch (Exception e) {
                    k3Stmt = null;
                }
            }
            if (easRS != null) {
                try {
                    easRS.close();
                }
                catch (Exception e) {
                    easRS = null;
                }
            }
            if (easStmt != null) {
                try {
                    easStmt.close();
                }
                catch (Exception e) {
                    easStmt = null;
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    conn = null;
                }
            }
        }
    }

    private void removeMainNode(String str) {
        if (str == null || str.length() <= 0) {
            return;
        }
    }

    private void removeNotExistNode(String str) {
        if (str == null || str.length() <= 0) {
            return;
        }
        String notLeafSql = "";
    }

    private void removeLeaf(String fItemID) {
    }

    private Connection getConn(Context ctx) {
        String dbIp = null;
        String dbPort = null;
        String dbName = null;
        String dbUser = null;
        String dbPwd = null;
        Connection conn = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        IVoucherTemplate iVouTemplate = null;
        VoucherTemplateCollection vouTemplateCollection = null;
        try {
            iVouTemplate = VoucherTemplateFactory.getLocalInstance(ctx);
            vouTemplateCollection = iVouTemplate.getVoucherTemplateCollection(ev);
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage());
        }
        VoucherTemplateInfo vouTemplateInfo = null;
        if (vouTemplateCollection.size() > 0) {
            vouTemplateInfo = vouTemplateCollection.get(0);
        }
        if (vouTemplateInfo == null) {
            return null;
        }
        dbIp = vouTemplateInfo.getK3dbIP();
        dbPort = vouTemplateInfo.getK3dbPort();
        dbName = vouTemplateInfo.getDbName();
        dbUser = vouTemplateInfo.getK3dbUser();
        dbPwd = vouTemplateInfo.getK3dbPwd();
        String dbDriver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        String url = "jdbc:microsoft:sqlserver://" + dbIp + ":" + dbPort + ";DatabaseName=" + dbName;
        try {
            Class.forName(dbDriver).newInstance();
            conn = DriverManager.getConnection(url, dbUser, dbPwd);
        }
        catch (Exception e) {
            return null;
        }
        return conn;
    }

    private void closeConn(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            conn = null;
        }
        finally {
            conn = null;
        }
    }
}

