/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.CPBCPersonInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.app.CPBCPersonUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ModelInitUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ModelInitUtil");

    protected IObjectValue forLoanBillCreateNewData(Context ctx) throws BOSException, EASBizException {
        PersonInfo personInfo;
        DailyLoanBillInfo baseInfo = new DailyLoanBillInfo();
        CompanyOrgUnitInfo currentCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        OrgUnitCollection currentCompanyFromAdminColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(currentCompanyOrgUnitInfo.getId().toString(), 1, 0);
        boolean isCanExpense = this.isPersonBelongToCurrentCompany(ctx, currentCompanyFromAdminColl, (personInfo = this.getPersonInfo(ctx)).getId().toString());
        if (!isCanExpense) {
            baseInfo.setApplier(null);
            baseInfo.setPosition(null);
            baseInfo.setOrgUnit(null);
            baseInfo.setCostedDept(null);
            baseInfo.setCompany(null);
            return baseInfo;
        }
        Date now = new Date();
        baseInfo.setBizReqDate(now);
        baseInfo.setBillDate(now);
        baseInfo.setCurrencyType(this.initCurrencyType(ctx));
        baseInfo.setPayMode(this.initPayMode(ctx));
        baseInfo.setApplierCompany(currentCompanyOrgUnitInfo);
        AdminOrgUnitInfo personAdminOrgUnitInfo = null;
        PositionInfo personPosition = null;
        CPBCPersonInfo cpbcPersonInfo = CPBCPersonUtil.getPrimaryAdminOrgUnit(ctx, personInfo.getId());
        AdminOrgUnitInfo primaryAdminOrgUnitInfo = cpbcPersonInfo == null ? null : cpbcPersonInfo.getPersonAdminUnit();
        PositionInfo primaryPosition = cpbcPersonInfo == null ? null : cpbcPersonInfo.getPersonPosition();
        personAdminOrgUnitInfo = primaryAdminOrgUnitInfo;
        personPosition = primaryPosition;
        if (primaryAdminOrgUnitInfo == null) {
            List cpbcPersonList = CPBCPersonUtil.getAllAdminOrgUnit(ctx, personInfo.getId());
            boolean adminFlag = false;
            boolean isDeputy = false;
            for (int i = cpbcPersonList.size() - 1; i >= 0; --i) {
                cpbcPersonInfo = (CPBCPersonInfo)cpbcPersonList.get(i);
                personAdminOrgUnitInfo = cpbcPersonInfo.getPersonAdminUnit();
                personPosition = cpbcPersonInfo.getPersonPosition();
                adminFlag = this.isAdminOrgBelongToCurrentCompany(ctx, currentCompanyFromAdminColl, personAdminOrgUnitInfo);
                if (!adminFlag) continue;
                isDeputy = true;
                break;
            }
        }
        if (personAdminOrgUnitInfo == null) {
            baseInfo.setApplier(null);
            baseInfo.setPosition(null);
            baseInfo.setOrgUnit(null);
            baseInfo.setCostedDept(null);
            baseInfo.setCompany(null);
            return baseInfo;
        }
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = this.getCostCenterOrgUnit(ctx, personAdminOrgUnitInfo);
        CompanyOrgUnitInfo companyInfo = ModelInitUtil.getCompanyByCostCenter(ctx, costCenterOrgUnitInfo);
        baseInfo.setApplier(personInfo);
        baseInfo.setPosition(personPosition);
        baseInfo.setOrgUnit(personAdminOrgUnitInfo);
        if (costCenterOrgUnitInfo != null) {
            String companyId = companyInfo.getId().toString();
            if (this.isInUserOrgScope(ctx, companyId)) {
                baseInfo.setCompany(companyInfo);
                baseInfo.setCostedDept(costCenterOrgUnitInfo);
            } else {
                baseInfo.setCompany(null);
                baseInfo.setCostedDept(null);
            }
        } else {
            baseInfo.setCostedDept(null);
            baseInfo.setCompany(null);
        }
        return baseInfo;
    }

    private PersonInfo getPersonInfo(Context ctx) throws BOSException, EASBizException {
        PersonInfo personInfo = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
        return personInfo;
    }

    private void setBizReqDate(DailyLoanBillInfo baseInfo) {
        Date now = new Date();
        baseInfo.setBizReqDate(now);
        baseInfo.setBillDate(now);
    }

    private CurrencyInfo initCurrencyType(Context ctx) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = null;
        currencyInfo = ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency();
        return currencyInfo;
    }

    private SettlementTypeInfo initPayMode(Context ctx) throws BOSException, EASBizException {
        ISettlementType iSettle = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        SettlementTypeCollection collPay = iSettle.getSettlementTypeCollection(viewInfo);
        SettlementTypeInfo settle = null;
        if (collPay != null && collPay.size() > 0) {
            settle = collPay.get(0);
        }
        return settle;
    }

    private CostCenterOrgUnitInfo getCostCenterOrgUnit(Context ctx, AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException, EASBizException {
        CostCenterOrgUnitInfo retInfo = null;
        CostCenterOrgUnitInfo tmpCostCenterInfo = null;
        try {
            tmpCostCenterInfo = ModelInitUtil.getCostCenterByAdmin(ctx, adminOrgUnitInfo);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (tmpCostCenterInfo == null) {
            return null;
        }
        if (tmpCostCenterInfo != null) {
            retInfo = tmpCostCenterInfo;
        } else {
            try {
                retInfo = ModelInitUtil.getCostCenterOrgUnitByRelation(ctx, adminOrgUnitInfo.getId().toString(), 0, 5);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return retInfo;
    }

    public static CostCenterOrgUnitInfo getCostCenterOrgUnitByRelation(Context ctx, String toUnitId, int fromType, int toType) throws BOSException, SQLException, EASBizException {
        StringBuffer querySql = new StringBuffer();
        querySql.append(" select costCenter.fid as costId,costCenter.fname_l2,costCenter.fnumber,costCenter.flongnumber from T_ORG_UnitRelation  unitRela ");
        querySql.append(" inner join T_ORG_TypeRelation typeRela on unitRela.ftypeRelationId = typeRela.fid ");
        querySql.append(" inner join T_ORG_CostCenter costCenter on unitRela.ffromunitid = costCenter.fid ");
        querySql.append(" where  unitRela.ftounitid =  '").append(toUnitId).append("' ");
        querySql.append(" and typeRela.ffromtype =").append((Object)fromType);
        querySql.append(" and typeRela.ftotype=").append((Object)toType);
        querySql.append(" and costCenter.fisbizunit = 1 ");
        querySql.append(" and costCenter.fissealup = 0 ");
        IRowSet resultSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        String costCenterId = null;
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        if (resultSet != null && resultSet.next()) {
            costCenterId = resultSet.getString("costId");
        }
        if (costCenterId != null) {
            costCenterOrgUnitInfo = (CostCenterOrgUnitInfo)CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(costCenterId));
        }
        return costCenterOrgUnitInfo;
    }

    public static CompanyOrgUnitInfo getCompanyByCostCenter(Context ctx, CostCenterOrgUnitInfo costCenterInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        CostCenterOrgUnitInfo parentCost = null;
        parentCost = costCenterInfo;
        while (parentCost != null) {
            String id;
            OrgUnitCollection unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(parentCost.getId().toString(), 5, 1);
            if (unitColl != null && unitColl.size() > 0) {
                companyOrgUnitInfo = (CompanyOrgUnitInfo)unitColl.get(0);
                break;
            }
            if (parentCost.isIsCompanyOrgUnit()) {
                id = parentCost.getId().toString();
                if (id == null) continue;
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                companyOrgUnitInfo = (CompanyOrgUnitInfo)iCompany.getValue((IObjectPK)new ObjectUuidPK(id));
                break;
            }
            if ((parentCost = parentCost.getParent()) == null || (id = parentCost.getId().toString()) == null) continue;
            ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            parentCost = (CostCenterOrgUnitInfo)iCostCenterOrgUnit.getValue((IObjectPK)new ObjectUuidPK(id));
        }
        return companyOrgUnitInfo;
    }

    public static CompanyOrgUnitInfo getCompanyByCostCenter_old(Context ctx, CostCenterOrgUnitInfo costCenterInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        CostCenterOrgUnitInfo parentCost = null;
        parentCost = costCenterInfo;
        while (parentCost != null) {
            String id;
            OrgUnitCollection unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(parentCost.getId().toString(), 5, 1);
            if (unitColl != null && unitColl.size() > 0) {
                companyOrgUnitInfo = (CompanyOrgUnitInfo)unitColl.get(0);
                break;
            }
            if (parentCost.isIsCompanyOrgUnit()) {
                id = parentCost.getId().toString();
                if (id == null) continue;
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                companyOrgUnitInfo = (CompanyOrgUnitInfo)iCompany.getValue((IObjectPK)new ObjectUuidPK(id));
                break;
            }
            if ((parentCost = parentCost.getParent()) == null || (id = parentCost.getId().toString()) == null) continue;
            ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            parentCost = (CostCenterOrgUnitInfo)iCostCenterOrgUnit.getValue((IObjectPK)new ObjectUuidPK(id));
        }
        return companyOrgUnitInfo;
    }

    protected boolean isPersonBelongToCurrentCompany(Context ctx, OrgUnitCollection unitColl, String perId) {
        if (ctx == null || unitColl == null || perId == null) {
            return false;
        }
        int size = unitColl.size();
        if (size <= 0) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            idSet.add(unitColl.get(i).getId().toString());
        }
        fic.add(new FilterItemInfo("AdminOrgUnit.id", idSet, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("id", (Object)perId));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        String queryStr = new String("com.kingdee.eas.basedata.person.app.PersonQuery");
        MetaDataPK queryPK = new MetaDataPK(queryStr);
        IQueryExecutor query = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        query.setObjectView(evi);
        IRowSet rowSet = null;
        try {
            rowSet = query.executeQuery();
        }
        catch (BOSException e) {
            logger.error((Object)e.getCause());
            logger.error((Object)e.getMessage());
        }
        return rowSet != null && rowSet.size() > 0;
    }

    protected boolean isAdminOrgBelongToCurrentCompany(Context ctx, OrgUnitCollection unitColl, AdminOrgUnitInfo adminOrgUnitInfo) {
        if (ctx == null || unitColl == null || adminOrgUnitInfo == null) {
            return false;
        }
        int size = unitColl.size();
        if (size <= 0) {
            return false;
        }
        String adminId = adminOrgUnitInfo.getId().toString();
        for (int i = 0; i < size; ++i) {
            if (!unitColl.get(i).getId().toString().equals(adminId)) continue;
            return true;
        }
        return false;
    }

    private PositionInfo initPrimaryPosition(Context ctx, PersonInfo personInfo) throws BOSException, EASBizException {
        PositionInfo poInfo = null;
        poInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryPosition(personInfo.getId());
        if (poInfo != null) {
            poInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(poInfo.getId().toString()));
        }
        return poInfo;
    }

    private boolean isInCostCenterCollectionByRule(Context ctx, String orgId) {
        IRowSet rs;
        IQueryExecutor exec = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer markString = new StringBuffer("");
        FilterItemCollection fiterItems = filter.getFilterItems();
        fiterItems.add(new FilterItemInfo("id", (Object)orgId, CompareType.EQUALS));
        fiterItems.add(new FilterItemInfo("isBizUnit", (Object)true));
        markString.append("#0 and #1");
        filter.setMaskString(markString.toString());
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery4AsstAcct"));
        exec.setObjectView(viewInfo);
        try {
            rs = exec.executeQuery();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
            return false;
        }
        if (rs != null && rs.size() > 0) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage());
            }
            return true;
        }
        return false;
    }

    public boolean isInUserOrgScope(Context ctx, String orgId) {
        boolean isUnderUserOrgScope = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP019");
        try {
            boolean isDelimitOrgScope;
            Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
            boolean bl = isDelimitOrgScope = paramMap.get("CP019") == null ? false : new Boolean(paramMap.get("CP019").toString());
            if (isDelimitOrgScope) {
                String userId = ctx.getCaller().toString();
                StringBuffer querySql = new StringBuffer();
                querySql.append("select user1.fid from T_PM_User user1 ");
                querySql.append(" inner join T_PM_OrgRange range1 on user1.fid = range1.FUserID ");
                querySql.append(" where user1.fnumber = ?");
                querySql.append(" and range1.forgid= ? ");
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])new Object[]{userId, orgId});
                if (result != null && result.next()) {
                    isUnderUserOrgScope = true;
                }
            } else {
                isUnderUserOrgScope = true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return isUnderUserOrgScope;
    }

    public static CostCenterOrgUnitInfo getCostCenterByAdmin(Context ctx, AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException, EASBizException, SQLException {
        CostCenterOrgUnitInfo costCenterOrgUnitInfo = null;
        if (adminOrgUnitInfo != null && adminOrgUnitInfo.isIsCostOrgUnit() && !adminOrgUnitInfo.isIsSealUp()) {
            costCenterOrgUnitInfo = (CostCenterOrgUnitInfo)CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(adminOrgUnitInfo.getId().toString()));
            return costCenterOrgUnitInfo;
        }
        String adminLongNumber = adminOrgUnitInfo.getLongNumber();
        if (adminLongNumber != null) {
            String[] tempNumber = adminLongNumber.split("!");
            StringBuffer filterNumber = null;
            StringBuffer filter = new StringBuffer();
            String costCenterId = null;
            for (int i = 0; i < tempNumber.length; ++i) {
                filterNumber = new StringBuffer();
                for (int j = 0; j < i; ++j) {
                    if (j == 0) {
                        filterNumber.append(tempNumber);
                        continue;
                    }
                    filterNumber.append("!").append(tempNumber);
                }
                if (i == 0) {
                    filter.append(" admin.flongnumber ='").append(filterNumber).append("' ");
                    continue;
                }
                filter.append(" or ").append(" admin.flongnumber ='").append(filterNumber).append("' ");
            }
            StringBuffer querySql = new StringBuffer();
            querySql.append(" select cost.fid as costId,cost.fname_l2,cost.fnumber,cost.flongnumber from T_ORG_Admin admin ");
            querySql.append(" inner join  T_ORG_CostCenter cost on admin.fid = cost.fid ");
            querySql.append(" where (").append(filter).append(" ) ");
            querySql.append(" and admin.fissealup = 0 and admin.fiscostorgunit = 1 ");
            querySql.append(" and cost.fissealup=0 ");
            querySql.append(" and cost.fisbizunit = 1 ");
            IRowSet resultSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            if (resultSet != null && resultSet.next()) {
                costCenterId = resultSet.getString("costId");
            }
            if (costCenterId != null) {
                costCenterOrgUnitInfo = (CostCenterOrgUnitInfo)CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(costCenterId));
            }
        }
        return costCenterOrgUnitInfo;
    }
}

