/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizBaseDataWebFacadeFactory;
import com.kingdee.eas.cp.bc.ExpSortException;
import com.kingdee.eas.cp.bc.IOperationType;
import com.kingdee.eas.cp.bc.OperationException;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.app.AbstractOperationTypeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OperationTypeControllerBean
extends AbstractOperationTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.OperationTypeControllerBean");

    @Override
    protected void _setUsable(Context ctx, List ids, boolean enable) throws BOSException, EASBizException {
        String id = null;
        IOperationType operationType = OperationTypeFactory.getLocalInstance(ctx);
        OperationTypeInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isEnable"));
        if (ids == null) {
            return;
        }
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            id = (String)ids.get(i);
            info = operationType.getOperationTypeInfo((IObjectPK)new ObjectUuidPK(id));
            Object[] params = new String[]{info.getNumber()};
            CompanyOrgUnitInfo unitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (!ContextUtil.getCurrentFIUnit((Context)ctx).getId().equals((Object)unitInfo.getId())) {
                throw new OperationException(OperationException.OPRTTYPE_CANNOT_SETUSABEL_NOT_CURRENTCOMPANY, params);
            }
            info.setIsEnable(enable);
            operationType.updatePartial((CoreBaseInfo)info, sic);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        OperationTypeInfo info = OperationTypeFactory.getLocalInstance(ctx).getOperationTypeInfo(pk);
        Object[] params = new String[]{info.getNumber()};
        String[] operationTypeId = new String[]{info.getId().toString()};
        CompanyOrgUnitInfo unitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (!ContextUtil.getCurrentFIUnit((Context)ctx).getId().equals((Object)unitInfo.getId())) {
            throw new OperationException(OperationException.OPRTTYPE_CANNOT_DELETE_NOT_CURRENTCOMPANY, params);
        }
        if (this._checkExpenseRelated(ctx, operationTypeId[0])) {
            throw new OperationException(OperationException.OPRTTYPE_CANNOT_DELETE_EXIT_EXPTYPE, params);
        }
        super._delete(ctx, pk);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void checkInfo(Context ctx, IObjectValue model) throws ExpSortException {
        OperationTypeInfo info = (OperationTypeInfo)model;
        if (StringUtils.isBlank((String)info.getNumber())) {
            throw new ExpSortException(ExpSortException.TYPENUMBER_NOT_NULL);
        }
        if (StringUtils.isBlank((String)info.getName())) {
            throw new ExpSortException(ExpSortException.TYPENAME_NOT_NULL);
        }
        if (info.getCompany() == null || info.getCompany().getId() == null) {
            throw new ExpSortException(ExpSortException.COMPANY_NOTNULL);
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        this._checkNumberDup(ctx, model);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        return super._submit(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber().trim(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected boolean _checkExpenseRelated(Context ctx, String id) throws BOSException, EASBizException {
        String sql = "select 1 from T_BC_ExpenseType where FOperationTypeID = '" + id + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException exc) {
            logger.info((Object)("SQLException:" + exc.getMessage()));
        }
        return false;
    }

    @Override
    protected List _getGroupFilter(Context ctx) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        Set operationIds = BizBaseDataWebFacadeFactory.getRemoteInstance().getOperationIdsByCompany(company.getId().toString(), null, null);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)operationIds, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        sorter.add(new SorterItemInfo("name"));
        sorter.add(new SorterItemInfo("number"));
        entityViewInfo.setSorter(sorter);
        CoreBaseCollection operationTypes = OperationTypeFactory.getLocalInstance(ctx).getCollection(entityViewInfo);
        HashMap<String, Object> operationTypeGroup = new HashMap<String, Object>();
        operationTypeGroup.put("field", "operationType.id");
        operationTypeGroup.put("dataType", "ObjectValue");
        operationTypeGroup.put("title", ResourceBase.getString((String)"com.kingdee.eas.cp.bc.WebCommonUtilResource", (String)"BUSINESSTYPE", (Locale)ctx.getOriginLocale()));
        operationTypeGroup.put("miltiSelect", true);
        operationTypeGroup.put("displayCount", 8);
        operationTypeGroup.put("unlimited", true);
        ArrayList filterItems = new ArrayList();
        operationTypeGroup.put("filterItems", filterItems);
        int is = operationTypes.size();
        for (int i = 0; i < is; ++i) {
            OperationTypeInfo operationTypeInfo = (OperationTypeInfo)operationTypes.get(i);
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("alias", operationTypeInfo.getName());
            filterMap.put("value", operationTypeInfo.getId().toString());
            filterMap.put("isDefault", false);
            filterItems.add(filterMap);
        }
        resultList.add(operationTypeGroup);
        return resultList;
    }
}

