/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.CallSSCInterfaceFacadeFactory;
import com.kingdee.eas.base.wssc.SSCTaskCenterBaseSeviceFacadeFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountLimitCollection;
import com.kingdee.eas.cp.bc.AccountLimitFactory;
import com.kingdee.eas.cp.bc.AccountLimitInfo;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizBaseDataWebFacadeFactory;
import com.kingdee.eas.cp.bc.BizBillUtil;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.ControlMethod;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeCommonCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeCommonFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeCommonInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseTypeCommon;
import com.kingdee.eas.cp.bc.OperationException;
import com.kingdee.eas.cp.bc.ProxyReimburseFactory;
import com.kingdee.eas.cp.bc.app.AbstractReimburseMainPageFacadeControllerBean;
import com.kingdee.eas.cp.bc.app.ModelWebUtils;
import com.kingdee.eas.cp.bc.app.control.util.ControlUtil;
import com.kingdee.eas.cp.eip.de.web.DocumentOperater;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ReimburseMainPageFacadeControllerBean
extends AbstractReimburseMainPageFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ReimburseMainPageFacadeControllerBean");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    protected static String PRINT = "1";
    protected static String EVALUATION = "2";
    protected static Integer EXPENSE_SHOW_MAX_NUM = 7;
    protected static Integer EXPENSE_ADD_MAX_NUM = 10;
    protected static Integer DATEINTERVAL_MONTH = 12;
    private static Map<String, String[]> DOMIDSMAP = new HashMap<String, String[]>(){
        {
            String[] billCenterDomIds = new String[]{"otherExpenseBill_List", "dailyLoanBill_List", "bizAccountBill_List", "evectionReqBill_List", "evectionLoanBill_List", "travelAccountBill_List", "bizAccountOutBill_List", "purchaseAccountBill_List", "rePaymentBill_loanList"};
            this.put("billCenterDomIds", billCenterDomIds);
        }
    };
    private static String commonUtilResource = "com.kingdee.eas.cp.bc.CommonUtilResource";
    private static Map<String, String> DOMIDSANDPERMISSIONITEMMAP = new HashMap<String, String>(){
        {
            this.put("otherExpenseBill_List", "cp_bc_Expense_View");
            this.put("dailyLoanBill_List", "cp_bc_DailyLoan_View");
            this.put("bizAccountBill_List", "cp_bc_ExpenseAccount_View");
            this.put("evectionReqBill_List", "cp_bc_EvectionReq_View");
            this.put("evectionLoanBill_List", "cp_bc_EvectionLoan_View");
            this.put("travelAccountBill_List", "cp_bc_TravelAccount_View");
            this.put("bizAccountOutBill_List", "cp_bc_BizAccountOutBill_View");
            this.put("purchaseAccountBill_List", "cp_bc_DailyAccount_View");
            this.put("rePaymentBill_loanList", "cp_bc_RePaymentBill_View");
        }
    };
    protected String[] EXPENSING_BILLTABLE = new String[]{"T_BC_BIZACCOUNTBILL", "T_BC_TRAVELACCOUNTBILL", "T_BC_BIZACCOUNTOUTBILL", "T_BC_DAILYPURCHASEACCOUNTBILL"};
    protected static Map<String, String> TICKETINFOTABLEMAP = new HashMap<String, String>(){
        {
            this.put("T_BC_BIZACCOUNTOUTBILL", "T_BC_BIZOUTTICKETENTRY");
            this.put("T_BC_BIZACCOUNTBILL", "T_BC_TICKETENTRY");
            this.put("T_BC_DAILYPURCHASEACCOUNTBILL", "T_BC_PURTICKETENTRY");
            this.put("T_BC_TRAVELACCOUNTBILL", "T_BC_TRATICKETENTRY");
        }
    };

    @Override
    protected Map _getReimburseMainPageAllInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (paramMap == null) {
            paramMap = new HashMap();
        }
        if (paramMap.get("company") == null) {
            returnMap.put("companyIsNull", true);
            return returnMap;
        }
        if (paramMap.get("isLimitCardHide") == null) {
            Map accountLimitMap = this._getAccountLimitInfo(ctx, paramMap);
            returnMap.put("accountLimitMap", accountLimitMap);
        }
        if (paramMap.get("isAllLoanCardHide") == null) {
            Map loanAndReturnMap = this._getloanAndReturnInfo(ctx, paramMap);
            returnMap.put("loanAndReturnMap", loanAndReturnMap);
        }
        if (paramMap.get("iswaitCardHide") == null) {
            Map waitGatheringCardMap = this.getTicketInfo(ctx, paramMap);
            returnMap.put("waitGatheringCardMap", waitGatheringCardMap);
        }
        if (paramMap.get("isEveCardHide") == null) {
            Map initEvectionStandardMap = this._initEvectionStandardInfo(ctx, paramMap);
            returnMap.put("initEvectionStandardMap", initEvectionStandardMap);
        }
        return returnMap;
    }

    @Override
    protected Map _getReimburseMainPageAllInfoAfter(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        if (paramMap == null) {
            paramMap = new HashMap();
        }
        if (paramMap.get("company") == null) {
            returnMap.put("companyIsNull", true);
            return returnMap;
        }
        if (paramMap.get("isChangYongCardHide") == null) {
            Map initQuickLaunchMap = this.getQuickLaunchInfo(ctx, paramMap);
            returnMap.put("initQuickLaunchMap", initQuickLaunchMap);
        }
        if (paramMap.get("isMyReimCardHide") == null) {
            Map countBillMap = this._getReimburseMainPageCountBill(ctx, paramMap);
            returnMap.put("countBillMap", countBillMap);
        }
        if (paramMap.get("isMenuCardHide") == null) {
            Map leftMenuHasPermMap = this.getLeftMenuHasPermMap(ctx, paramMap);
            returnMap.put("leftMenuHasPermMap", leftMenuHasPermMap);
        }
        if (paramMap.get("isNotificCardHide") == null) {
            String notificStr = this._getNotific(ctx, paramMap);
            returnMap.put("notificStr", notificStr);
        }
        return returnMap;
    }

    protected Map getWaitGatheringInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String userId = user.getPerson().getId().toString();
        BigDecimal amount = ZERO;
        try {
            StringBuilder querySql = new StringBuilder();
            querySql.append(" select sum(FAMOUNT) as amount from (");
            querySql.append(" select sum(T_BC_BizAccountBCE.FAmount) AS FAMOUNT ");
            querySql.append(" from T_BC_BizAccountBCE  inner join T_BC_BizAccountBill  on T_BC_BizAccountBCE.FBillID =   T_BC_BizAccountBill.FID ");
            querySql.append(" where T_BC_BizAccountBCE.FAmount > 0 and   T_BC_BizAccountBill.FState in (25,30,60,65)  and   T_BC_BizAccountBill.FApplierId=? ");
            querySql.append(" UNION ALL ");
            querySql.append(" select sum(T_BC_TravelAccountBCE.FAmount) AS FAMOUNT ");
            querySql.append(" from T_BC_TravelAccountBCE  inner join T_BC_TravelAccountBill  on T_BC_TravelAccountBCE.FBillID =   T_BC_TravelAccountBill.FID ");
            querySql.append(" where T_BC_TravelAccountBCE.FAmount > 0  and   T_BC_TravelAccountBill.FState in (25,30,60,65)  and   T_BC_TravelAccountBill.FApplierId=? ");
            querySql.append(" ) temp ");
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])new Object[]{userId, userId});
            if (set.next()) {
                amount = set.getBigDecimal("amount");
            }
            logger.info((Object)("getWaitGatheringInfo query sql:" + querySql.toString() + "\r userId=" + userId + "\r query result(amount):" + amount));
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (amount == null) {
            amount = ZERO;
        }
        returnMap.put("waitGatheringAmount", amount);
        return returnMap;
    }

    protected Map getTicketInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String userId = user.getPerson().getId().toString();
        String creatorId = user.getId().toString();
        String companyId = "";
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)paramMap.get("company");
        if (company != null) {
            companyId = company.getId().toString();
        }
        BigDecimal amount = ZERO;
        try {
            StringBuilder querySql = new StringBuilder();
            querySql.append(" select sum(FAMOUNT) as amount from ( ");
            int len = this.EXPENSING_BILLTABLE.length;
            for (int x = 0; x < len; ++x) {
                if (TICKETINFOTABLEMAP.get(this.EXPENSING_BILLTABLE[x]) == null) continue;
                querySql.append(this.getTicketInfoSql(this.EXPENSING_BILLTABLE[x], TICKETINFOTABLEMAP));
                if (x >= len - 1) continue;
                querySql.append("\n UNION ALL \n");
            }
            querySql.append(" ) temp  ");
            List dateFilter = this.getTicketInfoFilter(this.EXPENSING_BILLTABLE.length, DATEINTERVAL_MONTH, userId, creatorId, companyId);
            Object[] param = new Object[dateFilter.size()];
            int size = dateFilter.size();
            for (int x = 0; x < size; ++x) {
                param[x] = dateFilter.get(x);
            }
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])param);
            if (set.next()) {
                amount = set.getBigDecimal("amount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (amount == null) {
            amount = ZERO;
        }
        returnMap.put("waitGatheringAmount", amount);
        return returnMap;
    }

    protected String getTicketInfoSql(String tableName, Map<String, String> TICKETINFOTABLEMAP) {
        StringBuilder querySql = new StringBuilder();
        querySql.append(" select tbt.FAmout AS FAMOUNT  ");
        querySql.append(" from " + TICKETINFOTABLEMAP.get(tableName) + " tbt inner join " + tableName + " tbb on tbt.FBillID = tbb.FID ");
        querySql.append(" where tbt.FAmout > 0 and   ((tbt.FBillingDate>=? ) and (tbt.FBillingDate<? )) and ( (tbb.FApplierId=?) or (tbb.fcreatorid = ? ) ) and (tbb.fapplierCompanyid = ? )");
        return querySql.toString();
    }

    protected Map getQuickLaunchInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, CoreBaseCollection> returnMap = new HashMap<String, CoreBaseCollection>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        CoreBaseCollection expenseTypeCollection = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("creator.id", (Object)user.getId().toString(), CompareType.EQUALS));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)paramMap.get("company");
        if (company != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
            Set operationIds = BizBaseDataWebFacadeFactory.getLocalInstance(ctx).getOperationIdsByCompany(company.getId().toString(), null, null);
            filterInfo.getFilterItems().add(new FilterItemInfo("expenseType.operationType.id", (Object)operationIds, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("expenseType.isStart", (Object)true, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("expenseType.operationType.isEnable", (Object)true, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection setor = new SelectorItemCollection();
        setor.add(new SelectorItemInfo("isAddCommon"));
        setor.add(new SelectorItemInfo("countUseNum"));
        setor.add(new SelectorItemInfo("expenseType.id"));
        setor.add(new SelectorItemInfo("expenseType.name"));
        setor.add(new SelectorItemInfo("expenseType.number"));
        setor.add(new SelectorItemInfo("expenseType.imageUrl"));
        setor.add(new SelectorItemInfo("expenseType.operationType.id"));
        setor.add(new SelectorItemInfo("expenseType.operationType.name"));
        setor.add(new SelectorItemInfo("expenseType.operationType.number"));
        setor.add(new SelectorItemInfo("expenseType.company.number"));
        SorterItemCollection sortItemCollection = new SorterItemCollection();
        SorterItemInfo sorterItemInfoAutoAdd = new SorterItemInfo();
        sorterItemInfoAutoAdd.setPropertyName("isAddCommon");
        sorterItemInfoAutoAdd.setSortType(SortType.ASCEND);
        sortItemCollection.add(sorterItemInfoAutoAdd);
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setPropertyName("countUseNum");
        sorterItemInfo.setSortType(SortType.DESCEND);
        SorterItemInfo sorterItemInfoTime = new SorterItemInfo();
        sorterItemInfoTime.setPropertyName("createTime");
        sorterItemInfoTime.setSortType(SortType.DESCEND);
        sortItemCollection.add(sorterItemInfoTime);
        sortItemCollection.add(sorterItemInfo);
        entityViewInfo.setSorter(sortItemCollection);
        entityViewInfo.setSelector(setor);
        CoreBaseCollection expenseTypeCommonCollection = ExpenseTypeCommonFactory.getLocalInstance(ctx).getCollection(entityViewInfo);
        expenseTypeCollection = new CoreBaseCollection();
        CoreBaseCollection autoAddCollection = new CoreBaseCollection();
        HashSet<String> inCompanyOrgUnitNumber = this.getCompanyOrgUnitNumber(ctx, paramMap);
        int size = expenseTypeCommonCollection.size();
        for (int x = 0; x < size; ++x) {
            ExpenseTypeCommonInfo expenseTypeCommonInfo = (ExpenseTypeCommonInfo)expenseTypeCommonCollection.get(x);
            ExpenseTypeInfo expenseType = expenseTypeCommonInfo.getExpenseType();
            boolean contains = this.isContains(expenseType, inCompanyOrgUnitNumber);
            if (contains) {
                if (!expenseTypeCommonInfo.isIsAddCommon()) {
                    autoAddCollection.add((CoreBaseInfo)expenseType);
                    continue;
                }
                expenseTypeCollection.add((CoreBaseInfo)expenseType);
                continue;
            }
            logger.info((Object)("getQuickLaunchInfo  filter data ,expenseType not in " + inCompanyOrgUnitNumber));
        }
        if (expenseTypeCollection.size() <= EXPENSE_SHOW_MAX_NUM) {
            expenseTypeCollection.addCollection(autoAddCollection);
            int tempSize = EXPENSE_SHOW_MAX_NUM - expenseTypeCollection.size();
            if (autoAddCollection.size() < tempSize) {
                expenseTypeCollection.addCollection(autoAddCollection);
            } else {
                for (int x = 0; x < tempSize; ++x) {
                    expenseTypeCollection.add(autoAddCollection.get(x));
                }
            }
        }
        returnMap.put("initQuickLaunchMap", expenseTypeCollection);
        return returnMap;
    }

    public boolean isContains(ExpenseTypeInfo expenseType, HashSet inCompanyOrgUnitNumber) {
        boolean contains;
        if (expenseType == null) {
            return false;
        }
        CompanyOrgUnitInfo company = expenseType.getCompany();
        if (company == null) {
            contains = false;
        } else {
            String number = company.getNumber();
            contains = inCompanyOrgUnitNumber.contains(number);
        }
        return contains;
    }

    public HashSet<String> getCompanyOrgUnitNumber(Context ctx, Map paramMap) {
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)paramMap.get("company");
        String ln = currentCompany.getLongNumber();
        String[] lnSecs = ln.split("!");
        int length = lnSecs.length;
        HashSet<String> inCompanyOrgUnitNumber = new HashSet<String>();
        for (int i = 0; i < length; ++i) {
            inCompanyOrgUnitNumber.add(lnSecs[i]);
        }
        return inCompanyOrgUnitNumber;
    }

    protected Map getLeftMenuHasPermMap(Context context, Map paramMap) throws BOSException, EASBizException {
        HashMap returnMap = new HashMap();
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)context.get((Object)"CompanyInfo");
        HashMap hasPermMap = new HashMap();
        Set<String> domIdSet = DOMIDSMAP.keySet();
        Iterator<String> iterator = domIdSet.iterator();
        boolean showRePaymentMenuInfo = this.isShowRePaymentMenuInfo(context, paramMap);
        ArrayList<String> permItemList = new ArrayList<String>();
        ArrayList<String> pageIdList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String domIds = iterator.next();
            String[] domIdsArr = DOMIDSMAP.get(domIds);
            HashMap<String, Boolean> valueMap = new HashMap<String, Boolean>();
            int index = domIdsArr.length;
            for (int x = 0; x < index; ++x) {
                permItemList.add(DOMIDSANDPERMISSIONITEMMAP.get(domIdsArr[x]));
                pageIdList.add(domIdsArr[x]);
                valueMap.put(domIdsArr[x], false);
            }
            hasPermMap.put(domIds, valueMap);
        }
        Iterator permItemListIte = permItemList.iterator();
        String[] permItemArr = new String[permItemList.size()];
        int index = 0;
        while (permItemListIte.hasNext()) {
            String next;
            permItemArr[index] = next = (String)permItemListIte.next();
            ++index;
        }
        boolean[] domIdsPermissionResult = BizBillUtil.hasPermission(context, permItemArr, user.getId().toString(), currentCompany.getId().toString());
        if (domIdsPermissionResult != null) {
            int size = domIdsPermissionResult.length;
            block3: for (int x = 0; x < size; ++x) {
                String pageId = (String)pageIdList.get(x);
                boolean permissionFlag = domIdsPermissionResult[x];
                Set set = hasPermMap.keySet();
                Iterator ite = set.iterator();
                while (ite.hasNext()) {
                    Map valueMap = (Map)hasPermMap.get(ite.next());
                    boolean pageIdFlag = valueMap.containsKey(pageId);
                    if (!pageIdFlag) continue;
                    if ("rePaymentBill_loanList".equalsIgnoreCase(pageId) && !showRePaymentMenuInfo) {
                        valueMap.put(pageId, false);
                        continue block3;
                    }
                    valueMap.put(pageId, permissionFlag);
                }
            }
        }
        returnMap.put("leftMenuHasPermMap", hasPermMap);
        return returnMap;
    }

    @Override
    protected Map _getUserInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        if (user == null || user.getPerson() == null) {
            logger.error((Object)"_getUserInfo person is null");
            return returnMap;
        }
        String userName = user.getName();
        String userId = user.getId().toString();
        String personId = user.getPerson().getId().toString();
        BizAccountBillInfo baseInfo = new BizAccountBillInfo();
        CollectionAccountInfo collectionAccount = null;
        String bankAccount = null;
        String userCreditUrl = null;
        Map creditMap = null;
        CompanyOrgUnitInfo company = null;
        try {
            BizBillUtil.getOrgUnitPositionByApplier(ctx, baseInfo);
            company = baseInfo.getApplierCompany();
            if (company != null && company.getBaseCurrency() != null && company.getBaseCurrency().getBaseUnit() == null) {
                CurrencyInfo currency = company.getBaseCurrency();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("baseUnit"));
                CurrencyInfo currencyTmp = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()), sic);
                currency.setBaseUnit(currencyTmp.getBaseUnit());
            }
            if ((collectionAccount = BizBillUtil.getDefaultCollectionAccount(ctx, personId)) != null) {
                bankAccount = collectionAccount.getBankAccount();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        String creditScore = null;
        try {
            userCreditUrl = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).getPersonalCreditUrl(userId, "EAS");
            try {
                Class.forName("com.kingdee.eas.base.wssc.app.CallSSCInterfaceFacadeControllerBean").getDeclaredMethod("_getPersonalCredit", Context.class, String.class);
                String creditjson = CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx).getPersonalCredit(userId);
                if (creditjson != null && (creditMap = JSONUtils.convertJsonToObject((Context)ctx, (String)creditjson)) != null && creditMap.get("creditScore") != null) {
                    creditScore = creditMap.get("creditScore").toString();
                }
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)("_getUserInfo NoSuchMethod getPersonalCredit. " + e.getMessage()));
                creditMap = SSCTaskCenterBaseSeviceFacadeFactory.getLocalInstance((Context)ctx).getCreditFilesUtil(userId, null);
                if (creditMap != null && creditMap.get("creditScore") != null) {
                    creditScore = creditMap.get("creditScore").toString();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        returnMap.put("creditScore", creditScore);
        returnMap.put("userCreditUrl", userCreditUrl);
        returnMap.put("bankAccount", bankAccount);
        returnMap.put("userId", userId);
        returnMap.put("userName", userName);
        returnMap.put("userPhone", baseInfo.getApplier() == null ? "" : baseInfo.getApplier().getCell());
        company = (CompanyOrgUnitInfo)ModelWebUtils.simpleClone((CoreBaseInfo)company, "bosType", "longNumber", "baseCurrency", "baseExchangeTable", "isBizUnit", "isSealUp", "isStart", "isLeaf", "cU", "parent");
        returnMap.put("company", (String)company);
        if (paramMap != null) {
            paramMap.put("company", company);
        }
        if (company != null) {
            returnMap.put("currCompanyName", company.getName());
        }
        if (baseInfo.getOrgUnit() != null) {
            returnMap.put("orgUnitName", baseInfo.getOrgUnit().getName());
        }
        if (baseInfo.getOrgUnit() != null) {
            returnMap.put("positionName", baseInfo.getPosition().getName());
        }
        return returnMap;
    }

    @Override
    protected Map _getEvectionStandardInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        List cityIds = (List)paramMap.get("cityIds");
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)paramMap.get("companyOrgUnitInfo");
        String cuId = null;
        String currencyId = null;
        if (cityIds == null || cityIds.size() == 0 || companyOrgUnitInfo == null || companyOrgUnitInfo.getCU() == null || companyOrgUnitInfo.getBaseCurrency() == null) {
            return null;
        }
        String companyId = companyOrgUnitInfo.getId().toString();
        if (StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        currencyId = companyOrgUnitInfo.getBaseCurrency().getId().toString();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String personId = user.getPerson().getId().toString();
        cuId = companyOrgUnitInfo.getCU().getId().toString();
        logger.info((Object)("_getEvectionStandardInfo get cityIds=" + cityIds + "cu id=" + cuId));
        return ControlUtil.getEvectionStandardInfoCommon(ctx, personId, companyOrgUnitInfo, currencyId, cityIds, cuId);
    }

    @Override
    protected Map _initEvectionStandardInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        boolean showEvectionStandInfo = this.isShowEvectionStandInfo(ctx, paramMap);
        if (showEvectionStandInfo) {
            CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)paramMap.get("company");
            if (currentCompany == null) {
                logger.info((Object)"_initEvectionStandardInfo currentCompany is null");
                return null;
            }
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            if (user.getPerson() == null) {
                logger.info((Object)"_initEvectionStandardInfo person is null");
                return null;
            }
            String personId = user.getPerson().getId().toString();
            String currencyId = null;
            String cuId = null;
            CurrencyInfo baseCurrency = currentCompany.getBaseCurrency();
            CtrlUnitInfo cu = currentCompany.getCU();
            if (baseCurrency != null && cu != null) {
                currencyId = baseCurrency.getId().toString();
                cuId = cu.getId().toString();
                return ControlUtil.initEvectionStandardInfo(ctx, personId, currentCompany, currencyId, cuId);
            }
            logger.info((Object)"_initEvectionStandardInfo currentCompany's baseCurrency is null");
            return null;
        }
        logger.info((Object)"_initEvectionStandardInfo showEvectionStandInfo is false");
        return null;
    }

    public static List<String> getParentOrgNumber(Context ctx, String orgId) {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("longNumber"));
        CtrlUnitInfo cu = null;
        try {
            cu = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(orgId), selector);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return BizCollUtil.splitLongNumber(cu.getLongNumber());
    }

    public static String getReimburseLevel(Context ctx, String personId) {
        StringBuilder sqlString = new StringBuilder();
        sqlString.append("select lv.fid from T_BC_StaffReimburseLevelSet levelset");
        sqlString.append(" inner join T_BC_ReimburseLevel lv on lv.fid=levelset.FReimburseLevelID ");
        sqlString.append(" where levelset.FPersonID=? and lv.FState=1 and levelset.FState=20 ");
        try {
            logger.info((Object)("getReimburseLevel:" + sqlString.toString() + ", personId=" + personId));
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString(), (Object[])new Object[]{personId});
            if (set.next()) {
                return set.getString("fid");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected boolean isShowEvectionStandInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        boolean showFlag = paramMap != null && paramMap.get("CP045") != null ? Boolean.valueOf(paramMap.get("CP045").toString()) : false;
        return showFlag;
    }

    protected boolean isShowRePaymentMenuInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        boolean showFlag = false;
        if (paramMap != null && paramMap.get("CP034") != null && Boolean.valueOf(paramMap.get("CP034").toString()).booleanValue()) {
            showFlag = Boolean.valueOf(paramMap.get("CP034").toString());
        }
        return showFlag;
    }

    protected boolean getParamValue(Context ctx, Map paramMap, List<String> paramList) throws BOSException {
        boolean paramValue = false;
        try {
            Map params = null;
            CompanyOrgUnitInfo currentCompany = this.getAccountLimitCompany(ctx, paramMap);
            if (paramList != null && paramList.size() > 0) {
                if (currentCompany == null) {
                    logger.info((Object)"getParamValue currentCompany is null");
                    params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
                } else {
                    params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, currentCompany.getId().toString());
                }
                paramValue = Boolean.valueOf((String)params.get(paramList.get(0)));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return paramValue;
    }

    @Override
    protected Map _getAccountLimitInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Serializable> returnMap = new HashMap<String, Serializable>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        if (user.getPerson() == null) {
            logger.info((Object)"_getAccountLimitInfo person is null");
            return returnMap;
        }
        String personId = user.getPerson().getId().toString();
        CompanyOrgUnitInfo currentCompany = null;
        currentCompany = this.getAccountLimitCompany(ctx, paramMap);
        if (currentCompany == null) {
            logger.info((Object)"_getAccountLimitInfo currentCompany is null");
            return returnMap;
        }
        String companyId = currentCompany.getId().toString();
        CurrencyInfo baseCurrency = currentCompany.getBaseCurrency();
        Calendar now = Calendar.getInstance();
        int curYear = now.get(1);
        int curMonth = now.get(2);
        String oql = "select id, expenseType.name, expenseType.controlMethod, currency.id, currency.name, one,two,three,four,five,six,seven,eight,nine,ten,eleven,twelve  where isStart = 1 and year ='" + curYear + "' and person.id ='" + personId + "' and companyOrgUnit.id ='" + companyId + "' order by createTime desc";
        AccountLimitCollection accountLimitColl = AccountLimitFactory.getLocalInstance(ctx).getAccountLimitCollection(oql);
        ArrayList<String> limitIds = new ArrayList<String>();
        HashSet<String> limitCurrencyIds = new HashSet<String>();
        CurrencyInfo limitCurrency = null;
        int size = accountLimitColl.size();
        for (int i = 0; i < size; ++i) {
            limitIds.add(accountLimitColl.get(i).getId().toString());
            limitCurrency = accountLimitColl.get(i).getCurrency();
            if (limitCurrency == null || limitCurrency.getId().equals((Object)baseCurrency.getId())) continue;
            limitCurrencyIds.add(limitCurrency.getId().toString());
        }
        if (limitIds.size() == 0) {
            logger.info((Object)"_getAccountLimitInfo limitIds is null");
            return returnMap;
        }
        String limitCurrencyId2 = null;
        ExchangeRateInfo exRateInfo = null;
        HashMap<String, ExchangeRateInfo> exRateMap = new HashMap<String, ExchangeRateInfo>();
        if (limitCurrencyIds.size() > 0) {
            for (String limitCurrencyId2 : limitCurrencyIds) {
                exRateInfo = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRate((IObjectPK)new ObjectUuidPK(currentCompany.getBaseExchangeTable().getId()), (IObjectPK)new ObjectUuidPK(limitCurrencyId2), (IObjectPK)new ObjectUuidPK(baseCurrency.getId()), DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()));
                exRateMap.put(limitCurrencyId2, exRateInfo);
            }
        }
        java.util.Date beginDate = null;
        java.util.Date endDate = null;
        java.util.Date beginDate1 = null;
        java.util.Date endDate1 = null;
        Calendar ca = Calendar.getInstance();
        ca.set(5, 1);
        beginDate = ca.getTime();
        ca.add(2, 1);
        ca.add(5, -1);
        endDate = ca.getTime();
        endDate1 = ca.getTime();
        ca.clear();
        ca.set(1, curYear);
        beginDate1 = ca.getTime();
        try {
            Map monthAmountMap = AccountLimitFactory.getLocalInstance(ctx).countAmountByLimitIds(limitIds, beginDate, endDate, companyId);
            Map totalAmountMap = AccountLimitFactory.getLocalInstance(ctx).countAmountByLimitIds(limitIds, beginDate1, endDate1, companyId);
            String[] months = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve"};
            StringBuilder currencyLog = null;
            ArrayList accountLimitList = new ArrayList();
            AccountLimitInfo accountLimitInfo = null;
            HashMap<String, Object> tempMap = null;
            BigDecimal limitMonthi = null;
            BigDecimal limitTotalAmount = ZERO;
            BigDecimal limitMonthAmount = ZERO;
            BigDecimal monthAmount = null;
            BigDecimal totalAmount = null;
            BigDecimal balanceAmountOri = ZERO;
            BigDecimal balanceAmount = null;
            BigDecimal totalBalanceAmount = ZERO;
            ExpenseTypeInfo expenseType = null;
            ControlMethod controlMethod = null;
            String currencyName = null;
            String limitId = null;
            int size2 = accountLimitColl.size();
            for (int j = 0; j < size2; ++j) {
                accountLimitInfo = accountLimitColl.get(j);
                tempMap = new HashMap<String, Object>();
                limitTotalAmount = ZERO;
                for (int i = 0; i <= curMonth; ++i) {
                    limitMonthi = accountLimitInfo.getBigDecimal(months[i]) == null ? ZERO : accountLimitInfo.getBigDecimal(months[i]);
                    limitTotalAmount = limitTotalAmount.add(limitMonthi);
                    limitMonthAmount = accountLimitInfo.getBigDecimal(months[curMonth]) == null ? ZERO : accountLimitInfo.getBigDecimal(months[curMonth]);
                }
                limitId = accountLimitInfo.getString("id");
                monthAmount = monthAmountMap.get(limitId) == null ? ZERO : new BigDecimal(monthAmountMap.get(limitId).toString());
                totalAmount = totalAmountMap.get(limitId) == null ? ZERO : new BigDecimal(totalAmountMap.get(limitId).toString());
                expenseType = accountLimitInfo.getExpenseType();
                controlMethod = expenseType.getControlMethod();
                if (ControlMethod.total.equals((Object)controlMethod)) {
                    balanceAmountOri = limitTotalAmount.subtract(totalAmount).compareTo(ZERO) < 0 ? ZERO : limitTotalAmount.subtract(totalAmount);
                    balanceAmount = balanceAmountOri;
                } else {
                    balanceAmountOri = limitMonthAmount.subtract(monthAmount).compareTo(ZERO) < 0 ? ZERO : limitMonthAmount.subtract(monthAmount);
                    balanceAmount = balanceAmountOri;
                }
                if (currencyLog == null) {
                    currencyLog = new StringBuilder(60);
                }
                currencyName = accountLimitInfo.getCurrency().getName();
                limitCurrencyId2 = accountLimitInfo.getCurrency().getId().toString();
                if (!baseCurrency.getId().toString().equals(limitCurrencyId2)) {
                    exRateInfo = (ExchangeRateInfo)exRateMap.get(limitCurrencyId2);
                    BigDecimal rate = ZERO;
                    ConvertModeEnum convertMode = null;
                    if (exRateInfo != null) {
                        rate = exRateInfo.getConvertRate();
                        convertMode = exRateInfo.getConvertMode();
                    }
                    balanceAmount = BizCollUtil.computeAmount(balanceAmountOri, convertMode, rate);
                    currencyLog.append("\u5e01\u522b:" + accountLimitInfo.getCurrency().getName() + "," + rate + ",\u539f\u5e01:" + balanceAmountOri + ",\u672c\u4f4d\u5e01:" + balanceAmount + "; ");
                } else {
                    currencyLog.append("\u5e01\u522b:" + currencyName + ",\u672c\u4f4d\u5e01:" + balanceAmount + "; ");
                }
                balanceAmountOri = balanceAmountOri.setScale(2, 4);
                tempMap.put("balanceAmount", balanceAmountOri);
                tempMap.put("curMonthAmount", monthAmount);
                tempMap.put("totalAmount", totalAmount);
                tempMap.put("expenseTypeId", expenseType.getId().toString());
                tempMap.put("currencyId", limitCurrencyId2);
                tempMap.put("tips", expenseType.getName() + ":" + balanceAmountOri + "(" + currencyName + ")");
                totalBalanceAmount = totalBalanceAmount.add(balanceAmount);
                accountLimitList.add(tempMap);
            }
            returnMap.put("accountLimitList", accountLimitList);
            returnMap.put("totalBalanceAmount", totalBalanceAmount);
            if (currencyLog != null) {
                logger.info((Object)("_getAccountLimitInfo " + currencyLog));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnMap;
    }

    protected CompanyOrgUnitInfo getAccountLimitCompany(Context ctx, Map paramMap) {
        return (CompanyOrgUnitInfo)paramMap.get("company");
    }

    @Override
    protected Map _getloanAndReturnInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        BigDecimal amountBalance = BigDecimal.ZERO;
        returnMap.put("loanTotalAmount", amountBalance);
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        if (user == null || user.getPerson() == null) {
            return returnMap;
        }
        String applierId = user.getPerson().getId().toString();
        try {
            StringBuffer querySql = new StringBuffer();
            querySql.append(" SELECT SUM(FAMOUNTBALANCE) as amountBalance FROM (").append(" SELECT SUM(FAMOUNTBALANCE) as FAMOUNTBALANCE FROM T_BC_DAILYLOANBILL ").append(" WHERE FSTATE IN (60, 70) AND FAMOUNTBALANCE > 0 AND FAPPLIERID = ? ").append(" UNION ALL ").append(" SELECT SUM(FAMOUNTBALANCE) as FAMOUNTBALANCE FROM T_BC_EVECTIONLOANBILL ").append(" WHERE FSTATE IN (60, 70) AND FAMOUNTBALANCE > 0 AND FAPPLIERID = ? ) TEMP");
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])new Object[]{applierId, applierId});
            if (set.next()) {
                amountBalance = set.getBigDecimal("amountBalance");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (amountBalance == null) {
            amountBalance = BigDecimal.ZERO;
        }
        returnMap.put("loanTotalAmount", amountBalance);
        return returnMap;
    }

    @Override
    protected Map _getReimburseMainPageCountBill(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String myReimState;
        HashMap<String, Integer> returnMap = new HashMap<String, Integer>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String personId = userInfo.getPerson().getId().toString();
        List proxyPersonIds = null;
        if (paramMap != null && paramMap.get("CP04401") != null && !Boolean.valueOf(paramMap.get("CP04401").toString()).booleanValue()) {
            proxyPersonIds = ProxyReimburseFactory.getLocalInstance(ctx).queryReimbursePerson(personId);
            List proxyOrgs = ProxyReimburseFactory.getLocalInstance(ctx).queryAdminOrgUnit(personId);
            if (proxyOrgs != null && proxyOrgs.size() > 0) {
                List proxyOrgPersonIds = ProxyReimburseFactory.getLocalInstance(ctx).getPersonIdsByAdminOrg(proxyOrgs);
                proxyPersonIds.addAll(proxyOrgPersonIds);
            }
            if (proxyPersonIds.size() > 0) {
                proxyPersonIds.add(personId);
                paramMap.put("proxyPersonIds", proxyPersonIds);
            }
        }
        logger.info((Object)("_getReimburseMainPageCountBill uerId=" + userInfo.getId() + ",personId =" + personId + (proxyPersonIds == null ? "" : ",proxyPersonIds =" + proxyPersonIds + "")));
        String string = myReimState = paramMap.get("myReimState") == null ? null : paramMap.get("myReimState").toString().toLowerCase();
        if (myReimState == null || myReimState.indexOf("draft") != -1) {
            int countDraft = this._getCountBillByState(ctx, String.valueOf(20), paramMap);
            returnMap.put("countDraft", countDraft);
        }
        if (myReimState == null || myReimState.indexOf("checking") != -1) {
            int countChecking = this._getCountBillByState(ctx, "25,30", paramMap);
            returnMap.put("countChecking", countChecking);
        }
        if (myReimState == null || myReimState.indexOf("checked") != -1) {
            int countChecked = this._getCountBillByState(ctx, String.valueOf(60), paramMap);
            returnMap.put("countChecked", countChecked);
        }
        if (myReimState == null || myReimState.indexOf("paying") != -1) {
            int countPaying = this._getCountBillByState(ctx, String.valueOf(65), paramMap);
            returnMap.put("countPaying", countPaying);
        }
        if (myReimState == null || myReimState.indexOf("payed") != -1) {
            int countPayed = this._getCountBillByState(ctx, String.valueOf(70), paramMap);
            returnMap.put("countPayed", countPayed);
        }
        if (myReimState == null || myReimState.indexOf("printcover") != -1) {
            int countPrint = this._getCountBillByState(ctx, PRINT, paramMap);
            returnMap.put("countPrint", countPrint);
        }
        if (myReimState == null || myReimState.indexOf("evaluation") != -1) {
            int countEvaluation = this._getCountBillByState(ctx, EVALUATION, paramMap);
            returnMap.put("countEvaluation", countEvaluation);
        }
        if (myReimState == null || myReimState.indexOf("closed") != -1) {
            int countClosed = this._getCountBillByState(ctx, String.valueOf(80), paramMap);
            returnMap.put("countClosed", countClosed);
        }
        return returnMap;
    }

    @Override
    protected int _getCountBillByState(Context ctx, String state, Map paramMap) throws BOSException, EASBizException {
        int count = 0;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        String personId = userInfo.getPerson().getId().toString();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        if (paramMap != null && paramMap.size() > 0) {
            queryMap.putAll(paramMap);
        }
        queryMap.put("userId", userId);
        queryMap.put("personId", personId);
        queryMap.put("state", state);
        ArrayList paramList = new ArrayList(80);
        queryMap.put("paramList", paramList);
        String[] queryTables = null;
        if (paramMap != null && paramMap.get("countBillTables") != null) {
            queryTables = (String[])paramMap.get("countBillTables");
        }
        if (queryTables == null) {
            queryTables = PRINT.equals(state) ? this.getCountBillTable(PRINT) : (String.valueOf(65).equals(state) || String.valueOf(70).equals(state) ? this.getCountBillTable("pay") : this.getCountBillTable(""));
        }
        StringBuilder querySql = new StringBuilder(500);
        StringBuilder billSql = new StringBuilder(500);
        int len = queryTables.length;
        for (int i = 0; i < len; ++i) {
            queryMap.put("table", queryTables[i]);
            billSql.append(this.getCountBillByStatSql(queryTables[i], queryMap));
            if (i >= len - 1) continue;
            billSql.append("\n UNION ALL \n");
        }
        if (PRINT.equals(state)) {
            querySql.append(" SELECT count(1) FROM (\n ").append(" SELECT A.FID FROM (\n ").append((CharSequence)billSql).append(" ) as A \n").append(" LEFT JOIN T_PI_PRINTINTEGRATION PR ON PR.FPRINTBILLID = A.FID ").append(" WHERE PR.FPRINTEDNUMBER = 0 OR PR.FPRINTEDNUMBER IS NULL ").append(" ) as B \n");
        } else {
            querySql.append(" SELECT count(1) FROM (\n ").append((CharSequence)billSql).append(" ) as A \n");
        }
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])paramList.toArray());
            while (set.next()) {
                count += set.getInt(1);
            }
            paramList = null;
            queryMap = null;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return count;
    }

    protected String[] getCountBillTable(String type) {
        if ("pay".equals(type)) {
            return new String[]{"T_BC_BIZACCOUNTBILL", "T_BC_TRAVELACCOUNTBILL", "T_BC_BIZACCOUNTOUTBILL", "T_BC_DAILYPURCHASEACCOUNTBILL", "T_BC_DAILYLOANBILL", "T_BC_EVECTIONLOANBILL"};
        }
        if (PRINT.equals(type)) {
            return new String[]{"T_BC_BIZACCOUNTBILL", "T_BC_TRAVELACCOUNTBILL", "T_BC_BIZACCOUNTOUTBILL", "T_BC_DAILYPURCHASEACCOUNTBILL"};
        }
        return new String[]{"T_BC_BIZACCOUNTBILL", "T_BC_TRAVELACCOUNTBILL", "T_BC_BIZACCOUNTOUTBILL", "T_BC_DAILYPURCHASEACCOUNTBILL", "T_BC_DAILYLOANBILL", "T_BC_EVECTIONLOANBILL", "T_BC_OTHEREXPENSEBILL", "T_BC_EVECTIONREQBILL", "T_BC_REPAYMENTBILL"};
    }

    protected String getCountBillByStatSql(String table, Map<String, Object> queryMap) {
        StringBuilder sql = new StringBuilder(64);
        sql.append("( SELECT FID FROM " + table + " WHERE ").append(this.getStateWhere(queryMap)).append(this.getDateWhere(queryMap)).append(this.getPersonWhere(queryMap));
        sql.append(" UNION ");
        sql.append(" SELECT FID FROM " + table + " WHERE ").append(this.getStateWhere(queryMap)).append(this.getDateWhere(queryMap)).append(this.getCreatorWhere(queryMap) + ")");
        return sql.toString();
    }

    protected String getStateWhere(Map<String, Object> queryMap) {
        String state = (String)queryMap.get("state");
        String stateWhere = "";
        if (EVALUATION.equals(state)) {
            stateWhere = " (FISEVALUATION = 0 AND FSTATE IN (60, 65, 70)) ";
        } else if (PRINT.equals(state)) {
            stateWhere = " (FSTATE IN (25, 30)) ";
        } else if (String.valueOf(20).equals(state)) {
            boolean CP035;
            boolean bl = CP035 = queryMap.get("CP035") != null ? Boolean.valueOf(queryMap.get("CP035").toString()) : false;
            stateWhere = CP035 ? " (FSTATE IN (20, 40)) " : " (FSTATE = 20) ";
        } else {
            stateWhere = String.valueOf(80).equals(state) ? this.getCloseStateWhere(queryMap) : (state.indexOf(",") == -1 ? " (FSTATE = " + state + ") " : " (FSTATE IN (" + state + ")) ");
        }
        return stateWhere;
    }

    public String getCloseStateWhere(Map<String, Object> queryMap) {
        boolean CP035;
        StringBuilder stateWhere = new StringBuilder();
        String table = (String)queryMap.get("table");
        stateWhere.append(" ( FSTATE IN (27, 80");
        boolean bl = CP035 = queryMap.get("CP035") != null ? Boolean.valueOf(queryMap.get("CP035").toString()) : false;
        if (!CP035) {
            stateWhere.append(",40");
        }
        if ("T_BC_REPAYMENTBILL".equalsIgnoreCase(table)) {
            stateWhere.append(",140");
        }
        stateWhere.append(") ");
        stateWhere.append(") ");
        return stateWhere.toString();
    }

    protected String getCloseOtherWhere(Map<String, Object> queryMap) {
        StringBuilder returnWhere = new StringBuilder();
        String table = (String)queryMap.get("table");
        if ("T_BC_REPAYMENTBILL".equalsIgnoreCase(table)) {
            return "";
        }
        returnWhere.append(" ( FSTATE in (60, 70)");
        if ("T_BC_OTHEREXPENSEBILL".equalsIgnoreCase(table) || "T_BC_EVECTIONREQBILL".equalsIgnoreCase(table)) {
            returnWhere.append(" AND FAMOUNTBALANCE = 0 ");
        } else if ("T_BC_BIZACCOUNTBILL".equalsIgnoreCase(table) || "T_BC_TRAVELACCOUNTBILL".equalsIgnoreCase(table) || "T_BC_BIZACCOUNTOUTBILL".equalsIgnoreCase(table) || "T_BC_DAILYPURCHASEACCOUNTBILL".equalsIgnoreCase(table)) {
            returnWhere.append(" AND FAMOUNTNOTPAID = 0 ");
        } else if ("T_BC_DailyLoanBill".equalsIgnoreCase(table) || "T_BC_EvectionLoanBill".equalsIgnoreCase(table)) {
            returnWhere.append(" AND FAMOUNTBALANCE=0 AND FAMOUNTNOTPAID =0 ");
        }
        returnWhere.append(") ");
        return returnWhere.toString();
    }

    protected String getCreatorWhere(Map<String, Object> queryMap) {
        String userId = (String)queryMap.get("userId");
        List paramList = (List)queryMap.get("paramList");
        String creatorWhere = " AND FCREATORID = ? ";
        paramList.add(userId);
        return creatorWhere;
    }

    protected String getPersonWhere(Map<String, Object> queryMap) {
        String personId = (String)queryMap.get("personId");
        List paramList = (List)queryMap.get("paramList");
        List proxyPersonIds = (List)queryMap.get("proxyPersonIds");
        if (proxyPersonIds != null && proxyPersonIds.size() > 0) {
            StringBuilder personWhere = new StringBuilder();
            personWhere.append(" AND FAPPLIERID in (");
            int size = proxyPersonIds.size();
            for (int i = 0; i < size; ++i) {
                personWhere.append("?,");
            }
            personWhere.deleteCharAt(personWhere.length() - 1);
            personWhere.append(")");
            paramList.addAll(proxyPersonIds);
            return personWhere.toString();
        }
        String personWhere = " AND FAPPLIERID = ?  ";
        paramList.add(personId);
        return personWhere;
    }

    protected String getDateWhere(Map<String, Object> queryMap) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.add(5, 1);
        cal.set(12, 59);
        cal.set(13, 59);
        java.util.Date now = cal.getTime();
        Date nowDate = new Date(now.getTime());
        cal.set(1, cal.get(1) - 1);
        cal.add(5, -1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        java.util.Date beforeYear = cal.getTime();
        Date beforeYearDate = new Date(beforeYear.getTime());
        List paramList = (List)queryMap.get("paramList");
        String dateWhere = " AND (FBIZREQDATE >= ? AND FBIZREQDATE < ?) ";
        paramList.add(beforeYearDate);
        paramList.add(nowDate);
        return dateWhere;
    }

    protected List getDateFilter(int forCountNum, int dataInterval) {
        ArrayList<Date> params = new ArrayList<Date>();
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        java.util.Date now = cal.getTime();
        Date nowDate = new Date(now.getTime());
        if (dataInterval == 0) {
            dataInterval = DATEINTERVAL_MONTH;
        }
        cal.set(2, cal.get(2) - dataInterval);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        java.util.Date beforeYear = cal.getTime();
        Date beforeYearDate = new Date(beforeYear.getTime());
        for (int i = 0; i < forCountNum; ++i) {
            params.add(beforeYearDate);
            params.add(nowDate);
        }
        return params;
    }

    protected List getTicketInfoFilter(int forCountNum, int dataInterval, String userId, String creatorId, String companyId) {
        ArrayList<Object> params = new ArrayList<Object>();
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        java.util.Date now = cal.getTime();
        Date nowDate = new Date(now.getTime());
        if (dataInterval == 0) {
            dataInterval = DATEINTERVAL_MONTH;
        }
        cal.set(2, cal.get(2) - dataInterval);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        java.util.Date beforeYear = cal.getTime();
        Date beforeYearDate = new Date(beforeYear.getTime());
        for (int i = 0; i < forCountNum; ++i) {
            params.add(beforeYearDate);
            params.add(nowDate);
            params.add(userId);
            params.add(creatorId);
            params.add(companyId);
        }
        return params;
    }

    @Override
    protected int _updateExpenseTypeCommon(Context ctx, int dateInterval) throws BOSException, EASBizException {
        int updateResult = 0;
        String deleteExpenseTypeCommon = "DELETE T_BC_ExpenseTypeCommon WHERE FIsAddCommon=0";
        DbUtil.execute((Context)ctx, (String)deleteExpenseTypeCommon);
        StringBuilder querySql = this.getUpdateExpenseTypeCommonSql();
        List params = this.getDateFilter(this.EXPENSING_BILLTABLE.length, dateInterval);
        HashMap<String, Integer> countNumberMap = new HashMap<String, Integer>(1000);
        String key = null;
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])params.toArray());
            logger.info((Object)("_updateExpenseTypeCommon query result:" + result.size()));
            if (result != null && result.size() > 0) {
                CoreBaseCollection collection = new CoreBaseCollection();
                while (result.next() && result.getString("fexpensetypeid") != null && result.getString("fcreatorid") != null && result.getString("FCompanyId") != null) {
                    Integer countNumber;
                    String expenseTypeId = result.getString("fexpensetypeid");
                    String creatorId = result.getString("fcreatorid");
                    String companyId = result.getString("FCompanyId");
                    int countUseNum = result.getInt("c");
                    key = creatorId + "-" + companyId;
                    if (countNumberMap.containsKey(key)) {
                        countNumberMap.put(key, (Integer)countNumberMap.get(key) + 1);
                    } else {
                        countNumberMap.put(key, 1);
                    }
                    if ((countNumber = (Integer)countNumberMap.get(key)) > EXPENSE_ADD_MAX_NUM) continue;
                    this.addCollection(expenseTypeId, creatorId, companyId, countUseNum, collection);
                }
                IObjectPK[] iObjectPKS = ExpenseTypeCommonFactory.getLocalInstance(ctx).addnewBatchData(collection);
                if (iObjectPKS != null) {
                    updateResult = iObjectPKS.length;
                }
                logger.info((Object)("_updateExpenseTypeCommon update result:" + updateResult));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return updateResult;
    }

    protected void haveMoreThanMaxNum(Context ctx, String userId, String companyId) throws BOSException, EASBizException {
        String queryOql = " where creator.id = '%s'   and company='%s' and isAddCommon=1 ";
        ExpenseTypeCommonCollection expenseTypeCommonCollection = ExpenseTypeCommonFactory.getLocalInstance(ctx).getExpenseTypeCommonCollection(String.format(queryOql, userId, companyId));
        if (expenseTypeCommonCollection.size() >= EXPENSE_ADD_MAX_NUM) {
            throw new OperationException(OperationException.MORETHANMAXNUM, new Object[]{EXPENSE_ADD_MAX_NUM});
        }
    }

    protected StringBuilder getUpdateExpenseTypeCommonSql() {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select  entry.fexpensetypeid,entry.fcreatorid,entry.FCompanyId,count(entry.fexpensetypeid) c\nfrom (select b.fexpensetypeid,a.fcreatorid,b.FCompanyId\n      from t_bc_bizaccountbill a\n               left join t_bc_bizaccountbillentry b on a.fid = b.fbillid\n               left join t_bc_expensetype e on b.fexpensetypeid = e.fid\n      where  e.fisstart = 1 and a.FBIZREQDATE >= ? AND a.FBIZREQDATE <= ? \n      union all\n      select b.fexpensetypeid,a.fcreatorid,b.FCompanyId\n      from t_bc_dailypurchaseaccountbill a\n               left join t_bc_dailypurchaseaccontentry b on a.fid = b.fbillid\n               left join t_bc_expensetype e on b.fexpensetypeid = e.fid\n      where e.fisstart = 1 and a.FBIZREQDATE >= ? AND a.FBIZREQDATE <= ? \n      union all\n      select b.fexpensetypeid,a.fcreatorid,b.FCompanyId\n      from t_bc_bizaccountoutbill a\n               left join t_bc_bizaccountoutbillentry b on a.fid = b.fbillid\n               left join t_bc_expensetype e on b.fexpensetypeid = e.fid\n      where  e.fisstart = 1 and a.FBIZREQDATE >= ? AND a.FBIZREQDATE <= ? \n      union all\n      select b.fexpensetypeid,a.fcreatorid,b.FCompanyId\n      from t_bc_travelaccountbill a\n               left join t_bc_travelaccountbillentry b on a.fid = b.fbillid\n               left join t_bc_expensetype e on b.fexpensetypeid = e.fid\n      where e.fisstart = 1 and a.FBIZREQDATE >= ? AND a.FBIZREQDATE <= ? ) entry\ngroup by entry.fexpensetypeid,entry.fcreatorid, entry.FCompanyId\norder by c desc");
        return querySql;
    }

    @Override
    protected boolean _addExpenseTypeCommon(Context ctx, Map paramMap) throws BOSException, EASBizException {
        IExpenseTypeCommon expenseTypeCommon = ExpenseTypeCommonFactory.getLocalInstance(ctx);
        String queryOql = " where   creator.id = '%s' and company='%s'  and expenseType.id = '%s' and isAddCommon=1 ";
        String userId = (String)paramMap.get("userId");
        String expenseTypeId = (String)paramMap.get("expenseTypeId");
        String companyId = (String)paramMap.get("companyId");
        this.haveMoreThanMaxNum(ctx, userId, companyId);
        ExpenseTypeCommonCollection expenseTypeCommonCollection = expenseTypeCommon.getExpenseTypeCommonCollection(String.format(queryOql, userId, companyId, expenseTypeId));
        if (expenseTypeCommonCollection.size() == 0) {
            ExpenseTypeInfo typeInfo = new ExpenseTypeInfo();
            typeInfo.setId(BOSUuid.read((String)expenseTypeId));
            ExpenseTypeCommonInfo typeCommonInfo = new ExpenseTypeCommonInfo();
            typeCommonInfo.setExpenseType(typeInfo);
            typeCommonInfo.setIsAddCommon(true);
            CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
            companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
            typeCommonInfo.setCompany(companyOrgUnitInfo);
            expenseTypeCommon.addnew((CoreBaseInfo)typeCommonInfo);
        }
        return true;
    }

    @Override
    protected boolean _deleteExpenseTypeCommon(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String userId = (String)paramMap.get("userId");
        String expenseTypeId = (String)paramMap.get("expenseTypeId");
        String companyId = (String)paramMap.get("companyId");
        String deleteExpenseTypeCommon = "DELETE T_BC_ExpenseTypeCommon WHERE FCreatorID=? AND FExpenseTypeId=? AND \tFIsAddCommon=1 AND FCompanyId=?";
        DbUtil.execute((Context)ctx, (String)deleteExpenseTypeCommon, (Object[])new Object[]{userId, expenseTypeId, companyId});
        return true;
    }

    public void addCollection(String expenseTypeId, String creatorId, String companyId, int countUseNum, CoreBaseCollection collection) {
        ExpenseTypeInfo info = new ExpenseTypeInfo();
        UserInfo userInfo = new UserInfo();
        info.setId(BOSUuid.read((String)expenseTypeId));
        userInfo.setId(BOSUuid.read((String)creatorId));
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
        ExpenseTypeCommonInfo typeCommonInfo = new ExpenseTypeCommonInfo();
        typeCommonInfo.setExpenseType(info);
        typeCommonInfo.setCreator(userInfo);
        typeCommonInfo.setIsAddCommon(false);
        typeCommonInfo.setCountUseNum(countUseNum);
        typeCommonInfo.setCompany(companyOrgUnitInfo);
        collection.add((CoreBaseInfo)typeCommonInfo);
    }

    public void addUpdateCollection(ExpenseTypeCommonInfo typeCommonInfo, int countUseNum, CoreBaseCollection updateCollection) {
        typeCommonInfo.setCountUseNum(countUseNum);
        updateCollection.add((CoreBaseInfo)typeCommonInfo);
    }

    @Override
    protected String _getNotific(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String docContent = "";
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        String cpbcName = EASResource.getString((String)commonUtilResource, (String)"bizAccountMsg", (Locale)ctx.getLocale());
        String Fname = "Fname_" + ctx.getLocale().getLanguage();
        String contentId = null;
        String classId = null;
        String columnId = null;
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select FID, FCOLUMNID from T_CM_Class where " + Fname + " = ? ");
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{cpbcName});
            if (dataSet.size() == 0) {
                logger.info((Object)"_getNotific \u8d39\u7528\u62a5\u9500\u901a\u77e5\u7c7b\u522b\u4e0d\u5b58\u5728");
                return docContent;
            }
            while (dataSet.next()) {
                classId = dataSet.getString("FID");
                columnId = dataSet.getString("FCOLUMNID");
            }
            sql = new StringBuilder();
            sql.append(" select A.FID  ");
            sql.append(" from T_CM_Column  A    ");
            sql.append(" left join T_CM_ColumnReadRight B on B.FCOLUMNID=A.FID ");
            sql.append(" left join T_PM_UserRoleOrg C on C.FROLEID=B.FROLEID ");
            sql.append(" where C.FUSERID = ? and A.FID = ? ");
            dataSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId, columnId});
            if (dataSet.size() == 0) {
                logger.info((Object)"_getNotific \u6ca1\u6709\u8d39\u7528\u62a5\u9500\u901a\u77e5\u7c7b\u522b\u6240\u5728\u680f\u76ee\u89d2\u8272\u7684\u6743\u9650");
                return docContent;
            }
            sql = new StringBuilder();
            sql.append(" select TOP 1 A.FID  ");
            sql.append("   from T_CM_Content  A    ");
            sql.append("  where A.fstatus = 2 and A.FCLASSID = ? order by A.FLASTUPDATETIME desc ");
            dataSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{classId});
            while (dataSet.next()) {
                contentId = dataSet.getString("FID");
            }
            logger.info((Object)("_getNotific contentId=" + contentId));
            if (contentId != null) {
                DocumentOperater docOp = new DocumentOperater();
                docOp.setContext(ctx);
                byte[] docBodyContent = docOp.getDocBodyContent(contentId);
                if (docBodyContent != null) {
                    docContent = new String(docBodyContent, "UTF-8");
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return docContent;
    }

    @Override
    protected Map _getBillType(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, ExpenseTypeEntryCollection> returnMap = new HashMap<String, ExpenseTypeEntryCollection>();
        String expenseTypeId = (String)paramMap.get("expenseTypeId");
        if (expenseTypeId == null) {
            return null;
        }
        String sql = this.getBillTypeSql();
        ExpenseTypeEntryCollection collection = ExpenseTypeEntryFactory.getLocalInstance(ctx).getExpenseTypeEntryCollection(String.format(sql, expenseTypeId));
        returnMap.put("collection", collection);
        return returnMap;
    }

    protected String getBillTypeSql() {
        String sql = "select billType.id ,billType.name ,billType.number where expenseType.id = '%s' and billType.number in ('OtherExpenseBill','DailyLoanBill','BizAccountBill','EvectionReqBill','EvectionLoanBill','TravelAccountBill','BizAccountOutBill','DailyPurchaseAccountBill') order by billType.number desc";
        return sql;
    }
}

