/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingInfo;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.app.AbstractStaffReimburseLevelSettingControllerBean;
import com.kingdee.eas.cp.bc.app.CommonDataWebUtils;
import com.kingdee.eas.cp.bc.app.ReimburseLevelStateEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class StaffReimburseLevelSettingControllerBean
extends AbstractStaffReimburseLevelSettingControllerBean {
    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        StaffReimburseLevelSettingInfo info = (StaffReimburseLevelSettingInfo)model;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)new StaffReimburseLevelSettingInfo().getBOSType(), (IObjectPK)pk, (String)("\u5dee\u65c5\u7ea7\u522b\u8bbe\u7f6e\u65b0\u589e:personId:" + info.getPerson().getId() + (info.getReimburseLevel() != null ? ",reimburseLevel:" + info.getReimburseLevel().getId() : "")));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
        StaffReimburseLevelSettingInfo info = (StaffReimburseLevelSettingInfo)model;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_update", (BOSObjectType)new StaffReimburseLevelSettingInfo().getBOSType(), (IObjectPK)pk, (String)("\u5dee\u65c5\u7ea7\u522b\u8bbe\u7f6e\u66f4\u65b0:personId:" + info.getPerson().getId() + (info.getReimburseLevel() != null ? ",reimburseLevel:" + info.getReimburseLevel().getId() : "")));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdminOrgUnitInfo adminOrgUnitInfo;
        StaffReimburseLevelSettingInfo srbSetInfo = (StaffReimburseLevelSettingInfo)model;
        this.validateParam(srbSetInfo);
        String id = null;
        String personId = srbSetInfo.getPerson().getId().toString();
        String companyOrgUnitId = srbSetInfo.getCompanyOrgUnit().getId().toString();
        String companyOrgUnitName = srbSetInfo.getCompanyOrgUnit().getName();
        BOSUuid uuid = srbSetInfo.getId();
        if (uuid != null) {
            id = uuid.toString();
        }
        if (srbSetInfo.getAdminOrgUnit() == null && (adminOrgUnitInfo = this.getAdminOrgUnitByPersonAndCompanyOrgUnit(ctx, personId, companyOrgUnitId)) != null) {
            model.put("adminOrgUnit", (Object)adminOrgUnitInfo);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgUnitId, CompareType.EQUALS));
        if (id != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        }
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        CoreBaseCollection con = super.getCollection(ctx, viewInfo);
        if (con != null && con.size() > 0) {
            throw new StandardException(StandardException.STAFFREIMUBRSELEVELSET_NOT_REPEAT, new Object[]{companyOrgUnitName});
        }
        BOSObjectType bosType = new StaffReimburseLevelSettingInfo().getBOSType();
        if (uuid != null && !bosType.equals((Object)uuid.getType())) {
            BOSUuid bosUuid = BOSUuid.create((BOSObjectType)bosType);
            String idNew = bosUuid.toString();
            String sql = "UPDATE T_BC_StaffReimburseLevelSet SET FID = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{idNew, id});
            srbSetInfo.setId(bosUuid);
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_save", (BOSObjectType)bosType, null, (String)("\u5dee\u65c5\u7ea7\u522b\u8bbe\u7f6e\u66f4\u65b0Id:" + id + " > " + idNew));
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        model.put("state", (Object)ReimburseLevelStateEnum.UnSubmit);
        return super._save(ctx, model);
    }

    private void validateParam(StaffReimburseLevelSettingInfo srbSetInfo) throws StandardException {
        if (srbSetInfo.getPerson() == null || StringUtils.isEmpty((String)srbSetInfo.getPerson().getId().toString())) {
            throw new StandardException(StandardException.PERSON_NOT_EMPTY);
        }
        if (srbSetInfo.getReimburseLevel() == null || StringUtils.isEmpty((String)srbSetInfo.getReimburseLevel().getId().toString())) {
            throw new StandardException(StandardException.REIMBURSELEVEL_NOT_EMPTY);
        }
        if (srbSetInfo.getCompanyOrgUnit() == null || StringUtils.isEmpty((String)srbSetInfo.getCompanyOrgUnit().getId().toString())) {
            throw new StandardException(StandardException.COMPANYORGUNIT_NOT_EMPTY);
        }
    }

    protected AdminOrgUnitInfo getAdminOrgUnitByPersonAndCompanyOrgUnit(Context ctx, String personId, String companyOrgUnitId) throws BOSException, EASBizException {
        String adminOrgIdStr;
        String queryPositionOql;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection adminOrgUnits = iOrgUnitRelation.getFromUnit(companyOrgUnitId, 1, 0);
        HashSet<String> adminOrgIds = new HashSet<String>();
        int is = adminOrgUnits.size();
        for (int i = 0; i < is; ++i) {
            adminOrgIds.add(adminOrgUnits.get(i).getId().toString());
        }
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection positionMembers = iPositionMember.getPositionMemberCollection(String.format(queryPositionOql = "SELECT POSITION.*, POSITION.ADMINORGUNIT.ID, POSITION.ADMINORGUNIT.NAME, POSITION.ADMINORGUNIT.PARENT, POSITION.ADMINORGUNIT.ISCOSTORGUNIT, POSITION.ADMINORGUNIT.LONGNUMBER WHERE PERSON.ID = '%s' AND POSITION.ADMINORGUNIT.ID IN ('%s') AND POSITION.ADMINORGUNIT.ISSEALUP = 0 ORDER BY ISPRIMARY DESC, POSITION.NUMBER ASC", personId, adminOrgIdStr = StringUtils.join((Object[])adminOrgIds.toArray(), (String)"','")));
        if (positionMembers != null && positionMembers.size() > 0) {
            PositionInfo position = positionMembers.get(0).getPosition();
            adminOrgUnitInfo = position.getAdminOrgUnit();
        }
        return adminOrgUnitInfo;
    }

    protected boolean isPrimaryPositionCompany(Context ctx, String personId, String companyOrgUnitId) throws BOSException, EASBizException {
        String queryPositionOql;
        boolean isPrimary = false;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection adminOrgUnits = iOrgUnitRelation.getFromUnit(companyOrgUnitId, 1, 0);
        HashSet<String> adminOrgIds = new HashSet<String>();
        int is = adminOrgUnits.size();
        for (int i = 0; i < is; ++i) {
            adminOrgIds.add(adminOrgUnits.get(i).getId().toString());
        }
        IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
        PositionMemberCollection positionMembers = iPositionMember.getPositionMemberCollection(String.format(queryPositionOql = "SELECT POSITION.*, POSITION.ADMINORGUNIT.ID, POSITION.ADMINORGUNIT.NAME, POSITION.ADMINORGUNIT.PARENT, POSITION.ADMINORGUNIT.ISCOSTORGUNIT, POSITION.ADMINORGUNIT.LONGNUMBER WHERE PERSON.ID = '%s' AND POSITION.ADMINORGUNIT.ISSEALUP = 0 AND ISPRIMARY = 1 ORDER BY ISPRIMARY DESC, POSITION.NUMBER ASC", personId));
        if (positionMembers != null && positionMembers.size() > 0) {
            int pms = positionMembers.size();
            for (int x = 0; x < pms; ++x) {
                PositionInfo position = positionMembers.get(x).getPosition();
                String adminOrgId = position.getAdminOrgUnit().getId().toString();
                if (!adminOrgIds.contains(adminOrgId)) continue;
                isPrimary = true;
                break;
            }
        }
        return isPrimary;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StaffReimburseLevelSettingInfo info = (StaffReimburseLevelSettingInfo)this.getValue(ctx, pk);
        ReimburseLevelStateEnum state = info.getState();
        if (ReimburseLevelStateEnum.Submit.equals((Object)state)) {
            throw new StandardException(StandardException.SUBMITDATA_NOT_DELETE);
        }
        super._delete(ctx, pk);
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)new StaffReimburseLevelSettingInfo().getBOSType(), (IObjectPK)pk, (String)("\u5dee\u65c5\u7ea7\u522b\u8bbe\u7f6e\u5220\u9664\uff0cpk:" + pk + ",personId:" + info.getPerson().getId() + (info.getReimburseLevel() != null ? ",reimburseLevel:" + info.getReimburseLevel().getId() : "")));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] pks = super._delete(ctx, filter);
        String log = "\u5dee\u65c5\u7ea7\u522b\u8bbe\u7f6e\u5220\u9664," + filter.toString();
        if (log.length() > 150) {
            log = log.substring(0, 149);
        }
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)new StaffReimburseLevelSettingInfo().getBOSType(), null, (String)log);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        return pks;
    }

    @Override
    protected void _updateStaffReimburseLevelSet(Context ctx, String reimburseLevelSetId, String reimburseLevelId) throws BOSException, EASBizException {
        if (reimburseLevelSetId == null || reimburseLevelId == null) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append("T_BC_STAFFREIMBURSELEVELSET ");
        sql.append(" SET FREIMBURSELEVELID=? ");
        sql.append(" WHERE FID=?");
        String sql_state = sql.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql_state);
            stmt.setString(++index, reimburseLevelId);
            stmt.setString(++index, reimburseLevelSetId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected Set _getAdminOrgUnitIdsByCompany(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        Set adminOrgUnitIds = null;
        if (company != null) {
            adminOrgUnitIds = CommonDataWebUtils.getApplierAdminOrgUnitIds(ctx, company);
        }
        return adminOrgUnitIds;
    }
}

