/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.datatask;

import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.ExternalStructInfo;
import com.kingdee.eas.tools.datatask.task.FileUtil;
import com.kingdee.eas.tools.datatask.task.ReaderUtil;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BCBlockDataReader {
    private AbstractExternalDataReader reader = null;
    private InputStream file = null;
    private TaskExternalCode taskCode = null;
    private static Logger logger = SysLog.getLogger(BCBlockDataReader.class);
    int blockSize = 50;

    public BCBlockDataReader(TaskExternalCode taskCode, Locale l) throws Exception {
        this.buildReader(taskCode, l);
    }

    private void buildReader(TaskExternalCode taskCode, Locale l) throws Exception {
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        String fileType = dp.getFileType();
        InputStream file = FileUtil.getServerTmpFileStream((String)dp.getOpenFileName());
        this.reader = ReaderUtil.buildReader((String)fileType, (String)dp.getOpenFileName(), (Locale)l, (String)dp.alias, (InputStream)file, (ExternalStructInfo)taskCode.getExternalStructInfo());
        this.setBlockSize(taskCode.getDIETemplateInfo().getCountEachTime() <= 0 ? 1 : (int)taskCode.getDIETemplateInfo().getCountEachTime());
        this.taskCode = taskCode;
    }

    public int getBiginIndex() {
        return this.reader.getExternalDataRowInfo().getRowOfDataStart();
    }

    public boolean hasNextBlock() throws TaskRunnerException {
        return this.reader.hasNextRecord();
    }

    public RecordCollection getNextBlock() throws TaskRunnerException {
        RecordCollection coll = new RecordCollection();
        int count = 0;
        while (count < this.getBlockSize()) {
            IRecord rec = null;
            if (count == 0) {
                rec = this.reader.getNextRecord();
                ++count;
            } else {
                if (!this.reader.hasNextRecord()) break;
                rec = this.reader.getNextRecord();
                ++count;
            }
            coll.add(rec);
        }
        return coll;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
            this.file = null;
        }
        DatataskParameter dp = (DatataskParameter)this.taskCode.getTaskParameter();
        FileUtil.removeFile((String)dp.getOpenFileName());
    }
}

