/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ICollectionAccount;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.app.datatask.AbstractBatchDataImport;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.be.OpenAreaCollection;
import com.kingdee.eas.fm.be.OpenAreaFactory;
import com.kingdee.eas.fm.be.OpenAreaInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CollectionAccountDataImport
extends AbstractBatchDataImport {
    private static final Logger logger = Logger.getLogger(CollectionAccountDataImport.class);
    public boolean CP078 = true;
    public boolean CP053 = true;
    public Set<String> tempSet = new HashSet<String>();

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.CollectionAccountQuery";
    }

    @Override
    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        sql.append("     FCreatorID varchar(44), \n");
        sql.append("     FLastUpdateUserID varchar(44), \n");
        sql.append("     FControlUnitID varchar(44), \n");
        sql.append("     CFApplierID varchar(44), \n");
        sql.append("     CFOpenAreaID varchar(44), \n");
        sql.append("     CFOpenAreaNumber NVARCHAR(80), \n");
        sql.append("     CFBebankID varchar(44), \n");
        sql.append("     CFBebankNumber NVARCHAR(80), \n");
        sql.append("     FNumber NVARCHAR(88), \n");
        sql.append("     FName NVARCHAR(255), \n");
        sql.append("     FDescription NVARCHAR(255), \n");
        sql.append("     FCreateTime DateTime, \n");
        sql.append("     FLastUpdateTime DateTime, \n");
        sql.append("     CFPayee NVARCHAR(100), \n");
        sql.append("     CFBankAccount NVARCHAR(100), \n");
        sql.append("     FBebankStr NVARCHAR(100), \n");
        sql.append("     FCompanyId varchar(44),  \n");
        sql.append("     CFIsShare INT, \n");
        sql.append("     CFIsDefault INT, \n");
        sql.append("     CFIsPublicAccount INT, \n");
        sql.append("     CFState INT, \n");
        sql.append("     FIndex int default(0) \n");
        sql.append(") \n");
        return sql.toString();
    }

    @Override
    protected void doBeforeProcessData(Context ctx) throws Exception {
        super.doBeforeProcessData(ctx);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP078");
        paramList.add("CP053");
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, this.companyId);
        this.CP078 = paramMap.get("CP078") == null ? true : new Boolean(paramMap.get("CP078").toString());
        this.CP053 = paramMap.get("CP053") == null ? true : new Boolean(paramMap.get("CP053").toString());
    }

    @Override
    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        Set numberSet = this.getNumberOfDefaultAccount(ctx);
        Object tempHashString = null;
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("INSERT INTO ").append(this.tempTable).append(" ( \n").append("FID,FCreatorID,FLastUpdateUserID,FControlUnitID,CFApplierID, \n").append("CFOpenAreaID,CFOpenAreaNumber,CFBebankID,CFBebankNumber, \n").append("FNumber,FName,FDescription,FCreateTime,FLastUpdateTime, \n").append("CFPayee,CFBankAccount,FBebankStr,FCompanyId,CFIsDefault,CFIsPublicAccount,CFState,FIndex,CFIsShare ) \n").append(" values (newbosid('A62F9111'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            for (int rowIndex = 0; rowIndex < coll.size(); ++rowIndex) {
                ++this.index;
                IRecord rowData = coll.get(rowIndex);
                if (rowData == null) continue;
                this.rowNum = rowData.getRowNum();
                String FPayerName = this.getData((SimpleRecord)rowData, "FPayerName");
                String FBebankStr = this.getData((SimpleRecord)rowData, "FPayerBank");
                String CFBankAccount = this.getData((SimpleRecord)rowData, "FPayerAccount");
                String CFOpenAreaNumber = this.getData((SimpleRecord)rowData, "FOpenAreaNumber");
                String FPublicAccount = this.getData((SimpleRecord)rowData, "FPublicAccount");
                String CFBebankNumber = this.getData((SimpleRecord)rowData, "FBebank_number");
                String FApplier_number = this.getData((SimpleRecord)rowData, "FApplier_number");
                String FIsDefault = this.getData((SimpleRecord)rowData, "FIsDefault");
                String FIsShare = this.getData((SimpleRecord)rowData, "FIsShare");
                int CFIsDefault = 0;
                int CFIsShare = 0;
                int CFState = 1;
                int CFIsPublicAccount = FPublicAccount != null && FPublicAccount.equals(this.getResource(ctx, "FPUBLICACCOUNTISTRUE", null)) ? 1 : 0;
                if (FIsDefault != null && FIsDefault.equals(this.getResource(ctx, "FPUBLICACCOUNTISTRUE", null))) {
                    CFIsDefault = 1;
                }
                if (FIsShare != null && FIsShare.equals(this.getResource(ctx, "FPUBLICACCOUNTISTRUE", null))) {
                    CFIsShare = 1;
                }
                PersonInfo applier = this.getPersonInfoByNumber(ctx, FApplier_number);
                if (FApplier_number != null && applier == null) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "NOSUCHPAYER", new Object[]{FApplier_number}));
                    continue;
                }
                if (FApplier_number != null && applier != null && this.CP078 && !applier.getName().equals(FPayerName)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "NUMBERNOTEQUALSNAME", new Object[]{FApplier_number, FPayerName}));
                    continue;
                }
                String isTrue = this.getResource(ctx, "FPUBLICACCOUNTISTRUE", null);
                if (FApplier_number == null && FIsDefault != null && FIsDefault.equals(isTrue)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "APPLIERNUMBEREMPTY", null));
                    continue;
                }
                if (FApplier_number != null && FIsDefault != null && FIsDefault.equals(isTrue) && numberSet.contains(FApplier_number)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "HADDEFAULTACCOUNT", new Object[]{FApplier_number}));
                    continue;
                }
                if (FPayerName == null || FPayerName.length() <= 0) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPAYERNAMEISNULL", null));
                    continue;
                }
                if (CFBankAccount == null || CFBankAccount.length() <= 0) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "ACCOUNTISNULL", null));
                    continue;
                }
                if (this.accountIsExit(ctx, FPayerName, CFBankAccount, applier) && !this.isSltImportUpdate()) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "NOT_ALLOW_REPEAT", new Object[0]));
                    continue;
                }
                if (this.verifyTempData(FPayerName, CFBankAccount, applier)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "EXCElDATA_REPEAT", new Object[0]));
                    continue;
                }
                String state = this.getData((SimpleRecord)rowData, "CFState");
                if (state != null && (state.equals("0") || state.equals("1"))) {
                    CFState = Integer.valueOf(state);
                }
                if (FBebankStr == null || "".equals(FBebankStr)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FBEBANKSTRISNULL", null));
                    continue;
                }
                OpenAreaInfo openArea = this.getOpenAreaInfoByNumber(ctx, CFOpenAreaNumber);
                if (StringUtils.isNotEmpty((CharSequence)CFOpenAreaNumber) && openArea == null) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "GETOPENAREAERROR", new Object[]{CFOpenAreaNumber}));
                    continue;
                }
                if (!this.CP053 && StringUtils.isEmpty((CharSequence)CFBebankNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FBEBANKNUMBERISNULL", null));
                    continue;
                }
                BEBankInfo beBank = this.getBEBankInfoByNumber(ctx, CFBebankNumber, FBebankStr);
                if (StringUtils.isNotEmpty((CharSequence)CFBebankNumber) && beBank == null) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "GETBEBANKERROR", new Object[]{CFBebankNumber}));
                    continue;
                }
                if (beBank != null && !FBebankStr.equals(beBank.getName())) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "NAME_NOTMATCH_NUMbER", new Object[]{FBebankStr, CFBebankNumber}));
                    continue;
                }
                if (beBank != null && beBank.getState().getValue() == 2) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "BEBANK_DISABLED", new Object[]{CFBebankNumber}));
                    continue;
                }
                pstmtInsert.setString(1, this.userId);
                pstmtInsert.setString(2, this.userId);
                pstmtInsert.setString(3, this.cuId);
                pstmtInsert.setString(4, applier != null ? applier.getId().toString() : null);
                pstmtInsert.setString(5, openArea != null ? openArea.getId().toString() : null);
                pstmtInsert.setString(6, CFOpenAreaNumber);
                pstmtInsert.setString(7, beBank != null ? beBank.getId().toString() : null);
                pstmtInsert.setString(8, CFBebankNumber);
                pstmtInsert.setString(9, "");
                pstmtInsert.setString(10, "");
                pstmtInsert.setString(11, "");
                pstmtInsert.setString(12, "");
                java.util.Date utilDate = new java.util.Date();
                Date sqlDate = new Date(utilDate.getTime());
                pstmtInsert.setDate(12, sqlDate);
                pstmtInsert.setDate(13, sqlDate);
                pstmtInsert.setString(14, FPayerName);
                pstmtInsert.setString(15, CFBankAccount);
                pstmtInsert.setString(16, beBank != null ? beBank.getName().toString() : FBebankStr);
                pstmtInsert.setString(17, ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
                pstmtInsert.setInt(18, CFIsDefault);
                pstmtInsert.setInt(19, CFIsPublicAccount);
                pstmtInsert.setInt(20, CFState);
                pstmtInsert.setInt(21, this.index);
                pstmtInsert.setInt(22, CFIsShare);
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e1) {
            try {
                throw new TaskExternalException(e1.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }

    protected OpenAreaInfo getOpenAreaInfoByNumber(Context ctx, String number) throws Exception {
        if (number == null || number.length() <= 0) {
            return null;
        }
        OpenAreaInfo openArea = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        OpenAreaCollection coll = OpenAreaFactory.getLocalInstance((Context)ctx).getOpenAreaCollection(view);
        if (coll != null && coll.size() > 0) {
            openArea = coll.get(0);
        }
        return openArea;
    }

    protected PersonInfo getPersonInfoByNumber(Context ctx, String number) throws Exception {
        if (number == null || number.length() <= 0) {
            return null;
        }
        PersonInfo applier = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        PersonCollection coll = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        if (coll != null && coll.size() > 0) {
            applier = coll.get(0);
        }
        return applier;
    }

    protected BEBankInfo getBEBankInfoByNumber(Context ctx, String number, String bankStr) throws Exception {
        if (number == null || number.length() <= 0) {
            return null;
        }
        BEBankInfo bank = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        view.setSelector(this.getInportSic());
        BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
        if (coll != null && coll.size() > 0) {
            bank = coll.get(0);
        }
        return bank;
    }

    private SelectorItemCollection getInportSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    private String getFieldValue(boolean isCanNUll, IRecord rowData, String fieldName, String messageName) throws TaskRunnerException {
        String returnValue = rowData.get(fieldName).toString();
        if (isCanNUll) {
            return returnValue;
        }
        if (returnValue == null || returnValue.length() == 0) {
            if (messageName == null) {
                messageName = fieldName;
            }
            this.onDataErrorForWeb(this.rowNum, messageName + "is null");
        }
        return returnValue;
    }

    protected Set getBankAccount(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        String number = null;
        sql.setLength(0);
        sql.append("select DISTINCT CFBankAccount from T_BC_COLLECTIONACCOUNT \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            number = rs.getString("CFBankAccount");
            if (set.contains(number)) continue;
            set.add(number);
        }
        return set;
    }

    protected Set getNumberOfDefaultAccount(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        String number = null;
        sql.setLength(0);
        sql.append("SELECT \"APPLIER\".FNumber from T_BC_COLLECTIONACCOUNT AS \"COLLECTIONACCOUNT\" \n");
        sql.append("LEFT OUTER JOIN T_BD_Person AS \"APPLIER\" \n");
        sql.append("ON \"COLLECTIONACCOUNT\".CFApplierID = \"APPLIER\".FID \n");
        sql.append("WHERE \"COLLECTIONACCOUNT\".CFIsDefault=1 \n");
        sql.append("ORDER BY \"COLLECTIONACCOUNT\".FID ASC ;");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            number = rs.getString("FNumber");
            if (set.contains(number)) continue;
            set.add(number);
        }
        return set;
    }

    @Override
    protected int doProcessData(Context ctx) throws Exception {
        return this.submitData(ctx);
    }

    private void updateData(Context ctx) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(this.tempTable).append(" where fid in ( \n");
        sql.append("\tselect fid from ").append(this.tempTable).append(" m join ( \n");
        sql.append("\tselect max(FIndex) FIndex, k.CFBankAccount from ( \n");
        sql.append("\t\tselect FID,CFBankAccount,FIndex from  \n").append(this.tempTable).append("\n");
        sql.append("\t\twhere  CFBankAccount in ( \n");
        sql.append("\t\t\t\tselect CFBankAccount from ").append(this.tempTable).append("\n");
        sql.append("\t\t\t\t\tgroup by CFBankAccount having count(CFBankAccount) > 1 ) k \n");
        sql.append("\t) group by k.CFBankAccount ) n  \n");
        sql.append("\ton m.CFBankAccount = n.CFBankAccount where m.FIndex <> n.FIndex \n");
        sql.append("); \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select max(FIndex),Fid from ").append(this.tempTable).append(" where CFIsDefault = 1 group by fid; \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next() && rs.size() == 1) {
            String id = rs.getString("Fid");
            sql.setLength(0);
            CollectionAccountDataImport.BatchSqlExecute(ctx, sql.toString(), ";");
        }
    }

    private int submitData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        if (this.isSltImportUpdate()) {
            sql.append("delete from  T_BC_COLLECTIONACCOUNT where fid in  ( \n");
            sql.append("    select collection.Fid from T_BC_COLLECTIONACCOUNT collection ");
            sql.append("    inner join " + this.tempTable + " t ON collection.CFBankAccount = t.CFBankAccount \n");
            sql.append("                                       AND collection.CFApplierID = t.CFApplierID); \n");
        }
        sql.append("insert into T_BC_COLLECTIONACCOUNT ( \n");
        sql.append("    FID, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FControlUnitID, \n");
        sql.append("    CFApplierID, \n");
        sql.append("    CFOpenAreaID, \n");
        sql.append("    CFBebankID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    CFPayee, \n");
        sql.append("    CFBankAccount, \n");
        sql.append("    FBebankStr, \n");
        sql.append("    FCompanyId, \n");
        sql.append("    CFIsDefault, \n");
        sql.append("    CFIsPublicAccount, \n");
        sql.append("    CFState, \n");
        sql.append("    FIsShare \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    t.FID, \n");
        sql.append("    t.FCreatorID, \n");
        sql.append("    t.FLastUpdateUserID, \n");
        sql.append("    t.FControlUnitID, \n");
        sql.append("    t.CFApplierID, \n");
        sql.append("    t.CFOpenAreaID, \n");
        sql.append("    t.CFBebankID, \n");
        sql.append("    t.FCreateTime, \n");
        sql.append("    t.FLastUpdateTime, \n");
        sql.append("    t.CFPayee, \n");
        sql.append("    t.CFBankAccount, \n");
        sql.append("    t.FBebankStr, \n");
        sql.append("    t.FCompanyId, \n");
        sql.append("    t.CFIsDefault, \n");
        sql.append("    t.CFIsPublicAccount, \n");
        sql.append("    t.CFState, \n");
        sql.append("    t.CFIsShare \n");
        sql.append("from ").append(this.tempTable).append(" t ;\n");
        CollectionAccountDataImport.BatchSqlExecute(ctx, sql.toString(), ";");
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FPayerName", this.getNotBlankString(rs.getString("payee")));
            result.put("FApplier_number", this.getNotBlankString(rs.getString("applier.number")));
            result.put("FBebank_number", this.getNotBlankString(rs.getString("Bebank.number")));
            String isDefault = this.getNotBlankString(rs.getString("isDefault"));
            String isTrue = this.getResource(ctx, "FPUBLICACCOUNTISTRUE", null);
            String isFalse = this.getResource(ctx, "FPUBLICACCOUNTISFALSE", null);
            if ("true".equals(isDefault)) {
                result.put("FIsDefault", isTrue);
            } else {
                result.put("FIsDefault", isFalse);
            }
            String isShare = this.getNotBlankString(rs.getString("isShare"));
            if ("true".equals(isShare)) {
                result.put("FIsShare", isTrue);
            } else {
                result.put("FIsShare", isFalse);
            }
            result.put("FPayerBank", this.getNotBlankString(rs.getString("BebankStr")));
            result.put("FPayerAccount", this.getNotBlankString(rs.getString("bankAccount")));
            result.put("FOpenAreaNumber", this.getNotBlankString(rs.getString("openArea.number")));
            result.put("FOpenAreaName", this.getNotBlankString(rs.getString("openArea.name")));
            String publicAccount = this.getNotBlankString(rs.getString("isPublicAccountTemp"));
            if ("true".equals(publicAccount)) {
                result.put("FPublicAccount", this.getResource(ctx, "FPUBLICACCOUNTISTRUE", null));
            } else if ("false".equals(publicAccount)) {
                result.put("FPublicAccount", this.getResource(ctx, "FPUBLICACCOUNTISFALSE", null));
            } else {
                result.put("FPublicAccount", publicAccount);
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Map paramMap = this.getContextMap();
        if (paramMap != null && paramMap.get("filterItems") != null) {
            String filterItems = (String)paramMap.get("filterItems");
            try {
                filter = new FilterInfo(filterItems);
            }
            catch (ParserException e) {
                logger.error((Object)e);
            }
        } else if (paramMap != null && paramMap.get("context") != null) {
            Context context = (Context)paramMap.get("context");
            filter.getFilterItems().add(new FilterItemInfo("company.id", context.get((Object)"CurCompanyId")));
        }
        if (filter.getFilterItems().isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("applier.id", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString()));
        }
        return filter;
    }

    public boolean accountIsExit(Context ctx, String payee, String bankAccount, PersonInfo applier) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        String mask = "#0 and #1";
        filterInfo.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)bankAccount));
        filterInfo.getFilterItems().add(new FilterItemInfo("creator.id", (Object)this.userId));
        filterInfo.getFilterItems().add(new FilterItemInfo("payee", (Object)payee));
        if (applier != null && applier.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("applier.id", (Object)applier.getId().toString()));
            mask = mask + " and (#2 or #3)";
        } else {
            mask = mask + " and #2";
        }
        filterInfo.setMaskString(mask);
        ICollectionAccount collectionAccountFactory = CollectionAccountFactory.getLocalInstance(ctx);
        boolean ifExist = collectionAccountFactory.exists(filterInfo);
        return ifExist;
    }

    private boolean verifyTempData(String fPayerName, String cFBankAccount, PersonInfo applier) {
        boolean isExist = false;
        String key = cFBankAccount + fPayerName;
        if (applier != null && applier.getId() != null) {
            String key1 = cFBankAccount + applier.getId().toString();
            if (this.tempSet.contains(key) || this.tempSet.contains(key1)) {
                isExist = true;
            } else {
                this.tempSet.add(key);
                this.tempSet.add(key1);
                isExist = false;
            }
        } else if (this.tempSet.contains(key)) {
            isExist = true;
        } else {
            this.tempSet.add(key);
            isExist = false;
        }
        return isExist;
    }
}

