/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.InvoiceTypeCollection;
import com.kingdee.eas.cp.bc.InvoiceTypeFactory;
import com.kingdee.eas.cp.bc.InvoiceTypeInfo;
import com.kingdee.eas.cp.bc.app.datatask.AbstractBatchDataImport;
import com.kingdee.eas.cp.bc.util.InvoiceUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class InvoiceTypeEntryListDataImport
extends AbstractBatchDataImport {
    private HashMap<String, ArrayList<String>> map = new HashMap();
    private String FNumber;
    private String FTaxClassCode;
    private String FName;
    private String FTicketTypeID;
    private String FTicketTypeNumber;
    private String FExpenseTypeID;
    private String FExpensetypeNumber;
    private String FCompanyNumber;
    private String FCompanyOrgUnitId;
    private String FIsDeduction;
    private static final Logger logger = Logger.getLogger(InvoiceTypeEntryListDataImport.class);

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo exportFilter = new FilterInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String longNumber = company.getLongNumber();
        String[] numbers = StringUtils.split((String)longNumber, (String)"!");
        HashSet<String> numberSet = new HashSet<String>(Arrays.asList(numbers));
        exportFilter.getFilterItems().add(new FilterItemInfo("company.number", numberSet, CompareType.INCLUDE));
        return exportFilter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.InvoiceTypeEntryQueryForDatatask";
    }

    @Override
    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        sql.append("     FNumber NVARCHAR(80), \n");
        sql.append("     FTaxClassCode NVARCHAR(80), \n");
        sql.append("     FNAME_l2 NVARCHAR(255), \n");
        sql.append("     FExpenseTypeID VARCHAR(44), \n");
        sql.append("     FLastUpdateTime DateTime, \n");
        sql.append("     FLastUpdateUserID varchar(44), \n");
        sql.append("     FCreateTime DateTime, \n");
        sql.append("     FCreatorID varchar(44), \n");
        sql.append("     FTicketTypeID varchar(44), \n");
        sql.append("     FCompanyId VARCHAR(44), \n");
        sql.append("     FIsDeduction INT, \n");
        sql.append("     FControlUnitID varchar(44) \n");
        sql.append(") \n");
        return sql.toString();
    }

    protected boolean checkNumber(Context ctx, String fNumber) throws BOSException {
        StringBuffer sqlString = new StringBuffer();
        sqlString.append("select FNumber from T_BC_InvoiceTypeEntry \n");
        sqlString.append(" where FNumber='" + fNumber + "' \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString());
        return rs.size() > 0;
    }

    protected boolean checkNumAndCom(Context ctx, String fNumber, String fCompanyNumber) throws BOSException {
        StringBuffer sqlString = new StringBuffer();
        sqlString.append("select InvoiceTypeEntry.FNumber from T_BC_InvoiceTypeEntry InvoiceTypeEntry \n");
        sqlString.append(" inner join T_ORG_Company Company on Company.fId=InvoiceTypeEntry.FCompanyId \n");
        sqlString.append(" where InvoiceTypeEntry.FNumber='" + fNumber + "' \n");
        sqlString.append(" and Company.FNumber='" + fCompanyNumber + "' \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString());
        return rs.size() > 0;
    }

    @Override
    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        HashMap map = new HashMap();
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        CtrlUnitInfo currentCu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("INSERT INTO ").append(this.tempTable).append(" ( \n").append("FID,FNumber,FName_l2,FExpenseTypeID, \n").append("FLastUpdateTime,FLastUpdateUserID,FCreateTime,FCreatorID, \n").append("FTicketTypeID,FCompanyId,FControlUnitID,FIsDeduction,FTaxClassCode ) \n").append(" values (newbosid('7080FD09'),?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            java.util.Date utilDate = new java.util.Date();
            Date sqlDate = new Date(utilDate.getTime());
            for (int rowIndex = 0; rowIndex < coll.size(); ++rowIndex) {
                ++this.index;
                IRecord rowData = coll.get(rowIndex);
                if (rowData == null) continue;
                this.rowNum = rowData.getRowNum();
                this.FNumber = this.getData((SimpleRecord)rowData, "FNumber");
                this.FTaxClassCode = this.getData((SimpleRecord)rowData, "FTaxClassCode");
                this.FName = this.getData((SimpleRecord)rowData, "FName_l2");
                this.FTicketTypeNumber = this.getData((SimpleRecord)rowData, "FTicketTypeId_number");
                this.FExpensetypeNumber = this.getData((SimpleRecord)rowData, "FExpenseType_number");
                this.FCompanyNumber = this.getData((SimpleRecord)rowData, "FCompany_number");
                this.FIsDeduction = this.getData((SimpleRecord)rowData, "FIsDeduction");
                if ("true".equals(this.FIsDeduction) || "\u662f".equals(this.FIsDeduction)) {
                    this.FIsDeduction = "1";
                } else if ("false".equals(this.FIsDeduction) || "\u5426".equals(this.FIsDeduction) || this.FIsDeduction == null) {
                    this.FIsDeduction = "0";
                } else {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "INVOICETYPEENTRYISDEDUCTIONLEGAL", null));
                    continue;
                }
                if (this.FTicketTypeNumber == null || "".equals(this.FTicketTypeNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "INVOICETYPEISNOTNULL", null));
                    continue;
                }
                if (this.FNumber == null || this.FNumber.length() <= 0) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "INVOICENUMBERISNOTNULL", null));
                    continue;
                }
                if (BizCollUtil.objectIsNull(this.FName)) {
                    if (!BizCollUtil.objectIsNull(this.FTaxClassCode)) {
                        this.FName = this.FTaxClassCode;
                    } else if (!BizCollUtil.objectIsNull(this.FTicketTypeNumber)) {
                        this.FName = this.FTicketTypeNumber;
                    }
                }
                if (this.FCompanyNumber == null || "".equals(this.FCompanyNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FCOMPANYNUMBERISNULL", null));
                    continue;
                }
                if (this.checkNumber(ctx, this.FNumber) && !this.isSltImportUpdate()) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "INVOICETYPEENTRYNUMBERCHECK", new Object[]{this.FNumber}));
                    continue;
                }
                if (!this.checkNumAndCom(ctx, this.FNumber, this.FCompanyNumber) && this.isSltImportUpdate()) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "INVOICETYPEENTRYISNUMBERANDCOMPANY", new Object[]{this.FNumber, this.FCompanyNumber}));
                    continue;
                }
                if (this.checkHasDuplicateInExcel(ctx, this.FNumber, this.FCompanyNumber)) continue;
                if (!BizCollUtil.objectIsNull(this.FTaxClassCode) && InvoiceUtil.isHeadByInvoiceType(this.FTicketTypeNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "NOTINVOICETAXCLASSCODEISNULL", null));
                    continue;
                }
                if (this.FExpensetypeNumber == null || "".equals(this.FExpensetypeNumber)) {
                    this.FExpenseTypeID = null;
                } else {
                    ExpenseTypeInfo expenseTypeInfo = this.getExpenseTypeInfoByNumber(ctx, this.FExpensetypeNumber);
                    if (expenseTypeInfo != null) {
                        this.FExpenseTypeID = expenseTypeInfo.getId().toString();
                    } else {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FEXPENSETYPENUMBERISNOTEXISTINBASEINFO", new Object[]{this.FExpensetypeNumber}));
                        continue;
                    }
                }
                InvoiceTypeInfo invoceTypeInfo = this.getInvoceTypeInfoByNumber(ctx, this.FTicketTypeNumber);
                if (invoceTypeInfo == null) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FINVOICETYPENUMBERISNOTEXISTINBASEINFO", new Object[]{this.FTicketTypeNumber}));
                    continue;
                }
                this.FTicketTypeID = invoceTypeInfo.getId().toString();
                CompanyOrgUnitInfo companyOrgUnitInfo = this.getCompanyInfoByNumber(ctx, this.FCompanyNumber);
                if (companyOrgUnitInfo == null) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FCOMPANYNUMBERISNOTEXISTINBASEINFO", new Object[]{this.FCompanyNumber}));
                    continue;
                }
                this.FCompanyOrgUnitId = companyOrgUnitInfo.getId().toString();
                pstmtInsert.setString(1, this.FNumber);
                pstmtInsert.setString(2, this.FName);
                pstmtInsert.setString(3, this.FExpenseTypeID);
                pstmtInsert.setDate(4, sqlDate);
                pstmtInsert.setString(5, this.userId);
                pstmtInsert.setDate(6, sqlDate);
                pstmtInsert.setString(7, this.userId);
                pstmtInsert.setString(8, this.FTicketTypeID);
                pstmtInsert.setString(9, this.FCompanyOrgUnitId);
                pstmtInsert.setString(10, this.cuId);
                pstmtInsert.setString(11, this.FIsDeduction);
                pstmtInsert.setString(12, this.FTaxClassCode);
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e1) {
            try {
                throw new TaskExternalException(e1.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }

    private CompanyOrgUnitInfo getCompanyInfoByNumber(Context ctx, String fCompanyNumber) throws TaskExternalException, TaskRunnerException, EASBizException, BOSException {
        CompanyOrgUnitInfo CompanyOrgUnitInfo2 = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fCompanyNumber, CompareType.EQUALS));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (companyOrgUnitCollection != null && companyOrgUnitCollection.size() > 0) {
            CompanyOrgUnitInfo2 = companyOrgUnitCollection.get(0);
        }
        return CompanyOrgUnitInfo2;
    }

    private InvoiceTypeInfo getInvoceTypeInfoByNumber(Context ctx, String finvoiceTypeNumber) throws TaskExternalException, TaskRunnerException, BOSException {
        InvoiceTypeInfo invoiceTypeInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)finvoiceTypeNumber, CompareType.EQUALS));
        view.setFilter(filter);
        InvoiceTypeCollection coll = InvoiceTypeFactory.getLocalInstance(ctx).getInvoiceTypeCollection(view);
        if (coll != null && coll.size() > 0) {
            invoiceTypeInfo = coll.get(0);
        }
        return invoiceTypeInfo;
    }

    private ExpenseTypeInfo getExpenseTypeInfoByNumber(Context ctx, String fExpensetypeNumber) throws TaskExternalException, TaskRunnerException, BOSException {
        ExpenseTypeInfo expenseTypeInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String longNumber = company.getLongNumber();
        String[] numbers = StringUtils.split((String)longNumber, (String)"!");
        HashSet<String> numberSet = new HashSet<String>(Arrays.asList(numbers));
        filter.getFilterItems().add(new FilterItemInfo("company.number", numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fExpensetypeNumber));
        view.setFilter(filter);
        ExpenseTypeCollection coll = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeCollection(view);
        if (coll != null && coll.size() > 0) {
            expenseTypeInfo = coll.get(0);
        }
        return expenseTypeInfo;
    }

    private boolean checkHasDuplicateInExcel(Context ctx, String fNumber, String fCompanyNumber) throws TaskExternalException, TaskRunnerException {
        if (!this.isSltImportUpdate() && this.map.containsKey(fNumber)) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FINVOICETPYEDUPLICATENUMBER", new Object[]{fNumber}));
            return true;
        }
        if (this.isSltImportUpdate() && this.map.containsKey(fNumber + fCompanyNumber)) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "INVOICETPYEDUPLICATENUMANDCOM", new Object[]{fNumber, fCompanyNumber}));
            return true;
        }
        this.map.put(fNumber, null);
        this.map.put(fNumber + fCompanyNumber, null);
        return false;
    }

    @Override
    protected int doProcessData(Context ctx) throws Exception {
        return this.submitData(ctx);
    }

    private int submitData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        if (this.isSltImportUpdate()) {
            sql.append("delete from  T_BC_InvoiceTypeEntry where fid in  ( \n");
            sql.append("    select collection.Fid from T_BC_InvoiceTypeEntry collection ");
            sql.append("    inner join " + this.tempTable + " t ON collection.FNumber = t.FNumber \n");
            sql.append("    AND  collection.FCOMPANYID = t.FCOMPANYID ) \n");
        }
        sql.append("insert into T_BC_InvoiceTypeEntry ( \n");
        sql.append("    FID, \n");
        sql.append("    FNumber, \n");
        sql.append("    FTaxClassCode, \n");
        sql.append("    FName_l2, \n");
        sql.append("    FExpenseTypeID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FTicketTypeID, \n");
        sql.append("    FCompanyId, \n");
        sql.append("    FIsDeduction, \n");
        sql.append("    FControlUnitID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    t.FID, \n");
        sql.append("    t.FNumber, \n");
        sql.append("    FTaxClassCode, \n");
        sql.append("    t.FName_l2, \n");
        sql.append("    t.FExpenseTypeID, \n");
        sql.append("    t.FLastUpdateTime, \n");
        sql.append("    t.FLastUpdateUserID, \n");
        sql.append("    t.FCreateTime, \n");
        sql.append("    t.FCreatorID, \n");
        sql.append("    t.FTicketTypeID, \n");
        sql.append("    t.FCompanyId, \n");
        sql.append("    t.FIsDeduction, \n");
        sql.append("    t.FControlUnitID \n");
        sql.append("from ").append(this.tempTable).append(" t ;\n");
        InvoiceTypeEntryListDataImport.BatchSqlExecute(ctx, sql.toString(), ";");
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    public Hashtable<String, String> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", this.getNotBlankString(rs.getString("number")));
            result.put("FTaxClassCode", this.getNotBlankString(rs.getString("taxClassCode")));
            result.put("FName_l2", this.getNotBlankString(rs.getString("name")));
            result.put("FExpenseType_number", this.getNotBlankString(rs.getString("expenseType.number")));
            result.put("FTicketTypeId_number", this.getNotBlankString(rs.getString("ticketTypeId.number")));
            result.put("FCompany_number", this.getNotBlankString(rs.getString("company.number")));
            result.put("FIsDeduction", this.getNotBlankString(rs.getString("isDeduction")));
            String isDeduction = null;
            isDeduction = "true".equals(rs.getString("isDeduction")) ? "\u662f" : "\u5426";
            result.put("FIsDeduction", this.getNotBlankString(isDeduction));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        return result;
    }
}

