/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.app.datatask.AbstractBatchDataImport;
import com.kingdee.eas.cp.bc.app.datatask.ReimburseLevelSettingListDataImport;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ProxyReimburseListDataImport
extends AbstractBatchDataImport {
    private HashSet<String> personOrgSet = new HashSet();
    private HashMap<String, PersonInfo> personMap = new HashMap();
    private HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap();
    private HashMap<String, String> ProxyCompanyMap = new HashMap();
    private HashMap<String, AdminOrgUnitInfo> AdminOrgUnitMap = new HashMap();
    private HashMap<String, Boolean> personAdminOrgMap = new HashMap();
    private HashSet<String> permissionSet = new HashSet();
    private String fProxyType;
    private String FProxyPersonNumber;
    private String FProxyPersonID;
    private String FPersonOrOrgUnitNumber;
    private String FReimbursePersonID;
    private String FReimburseCompanyNumber;
    private String FReimburseCompanyId;
    private String FCostCenterId;
    private String FProxyCompanyId;
    private int FProxyType;
    private static final Logger logger = Logger.getLogger(ReimburseLevelSettingListDataImport.class);
    private static final String WebCommonUtilResource = "com.kingdee.eas.cp.bc.WebCommonUtilResource";

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        if (this.getContextParameter("reiburseCompanyId") != null) {
            String reimburseCompanyId = (String)this.getContextParameter("reiburseCompanyId");
            filter.getFilterItems().add(new FilterItemInfo("reiburseCompany.id", (Object)reimburseCompanyId));
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.ProxyReimburseBillListQuery";
    }

    @Override
    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        sql.append("     FCostCenterId varchar(44), \n");
        sql.append("     FProxyType int, \n");
        sql.append("     FControlUnitID varchar(44), \n");
        sql.append("     FLastUpdateTime DateTime, \n");
        sql.append("     FLastUpdateUserID VARCHAR(44), \n");
        sql.append("     FCreateTime DateTime, \n");
        sql.append("     FCreatorID VARCHAR(44), \n");
        sql.append("     FState int, \n");
        sql.append("     FProxyPersonID VARCHAR(44), \n");
        sql.append("     FReimbursePersonID VARCHAR(44), \n");
        sql.append("     FREIMBURSECOMPANYID VARCHAR(44), \n");
        sql.append("     FCompanyID VARCHAR(44) \n");
        sql.append(") \n");
        return sql.toString();
    }

    @Override
    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        CtrlUnitInfo currentCu = (CtrlUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("INSERT INTO ").append(this.tempTable).append(" ( \n").append("FID,FCostCenterId,FProxyType,FControlUnitID, \n").append("FLastUpdateTime,FLastUpdateUserID,FCreateTime,FCreatorID, \n").append("FState,FProxyPersonID,FReimbursePersonID,FREIMBURSECOMPANYID,FCompanyID) \n").append(" values (newbosid('491425EA'),?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            for (int rowIndex = 0; rowIndex < coll.size(); ++rowIndex) {
                IRecord rowData = coll.get(rowIndex);
                if (rowData == null) continue;
                this.rowNum = rowData.getRowNum();
                this.FProxyPersonID = null;
                this.FReimbursePersonID = null;
                this.FCostCenterId = null;
                this.FReimburseCompanyId = null;
                this.FProxyCompanyId = null;
                this.fProxyType = this.getData((SimpleRecord)rowData, "FProxyType");
                this.FProxyPersonNumber = this.getData((SimpleRecord)rowData, "FProxyPersonNumber");
                this.FPersonOrOrgUnitNumber = this.getData((SimpleRecord)rowData, "FPersonOrOrgUnitNumber");
                this.FReimburseCompanyNumber = this.getData((SimpleRecord)rowData, "FReimburseCompanyNumber");
                if (this.fProxyType == null || "".equals(this.fProxyType)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FProxyType", null));
                    continue;
                }
                if (this.FProxyPersonNumber == null || "".equals(this.FProxyPersonNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FProxyPersonNumber", null));
                    continue;
                }
                if (this.FPersonOrOrgUnitNumber == null || "".equals(this.FPersonOrOrgUnitNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPersonOrOrgUnitNumber", null));
                    continue;
                }
                if (StringUtils.isEmpty((String)this.FReimburseCompanyNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FREIMBURSECOMPANYNUMBER", null));
                    continue;
                }
                if (this.FProxyPersonNumber.equals(this.FPersonOrOrgUnitNumber)) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "PROXYEQUALSREIMBURSEPERSON", null));
                    continue;
                }
                if (this.fProxyType.equals(ResourceBase.getString((String)WebCommonUtilResource, (String)"ORGUNIT", (Locale)ctx.getOriginLocale()))) {
                    this.FProxyType = 1;
                } else if (this.fProxyType.equals(ResourceBase.getString((String)WebCommonUtilResource, (String)"PERSON", (Locale)ctx.getOriginLocale()))) {
                    this.FProxyType = 0;
                } else {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "PROXYTYPEISERROR", new Object[]{this.fProxyType}));
                    continue;
                }
                if (this.checkDuplicateDataInExcel(ctx, this.FProxyPersonNumber, this.FPersonOrOrgUnitNumber, this.FReimburseCompanyNumber)) continue;
                PersonInfo proxyPersonInfo = this.getPersonInfoByNumber(ctx, this.FProxyPersonNumber);
                if (proxyPersonInfo != null) {
                    if (proxyPersonInfo.getDeletedStatus() == DeletedStatusEnum.DELETED) {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONDELETED", new Object[]{this.FProxyPersonNumber}));
                        continue;
                    }
                } else {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISNOTEXIST", new Object[]{this.FProxyPersonNumber}));
                    continue;
                }
                this.FProxyPersonID = proxyPersonInfo.getId().toString();
                this.FProxyCompanyId = this.queryCompanyOrgUnitInfo(ctx, this.FProxyPersonID);
                CompanyOrgUnitInfo reimburseCompany = this.getCompanyInfoIdByNumber(ctx, this.FReimburseCompanyNumber);
                if (reimburseCompany == null) continue;
                if (reimburseCompany.isIsSealUp()) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "REIMBURSECOMPANYISSEALUP", new Object[]{this.FReimburseCompanyNumber}));
                    continue;
                }
                if (!reimburseCompany.isIsBizUnit()) {
                    this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "REIMBURSECOMPANYISBIZUNIT", new Object[]{this.FReimburseCompanyNumber}));
                    continue;
                }
                this.FReimburseCompanyId = reimburseCompany.getId().toString();
                if (this.FProxyType == 0) {
                    PersonInfo reimbursePersonInfo = this.getPersonInfoByNumber(ctx, this.FPersonOrOrgUnitNumber);
                    if (reimbursePersonInfo == null) {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONNUMBERISNOTEXIST", new Object[]{this.FPersonOrOrgUnitNumber}));
                        continue;
                    }
                    if (reimbursePersonInfo.getDeletedStatus() == DeletedStatusEnum.DELETED) {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPERSONDELETED", new Object[]{this.FPersonOrOrgUnitNumber}));
                        continue;
                    }
                    this.FReimbursePersonID = reimbursePersonInfo.getId().toString();
                    if (!this.checkPersonInCompany(ctx, this.FReimbursePersonID, this.FReimburseCompanyId)) {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "PERSONNOTINREIMBURSECOMPANY", new Object[]{this.FPersonOrOrgUnitNumber, this.FReimburseCompanyNumber}));
                        continue;
                    }
                } else {
                    AdminOrgUnitInfo adminOrgUnitInfo = this.getAdminOrgUnitByNumber(ctx, this.FPersonOrOrgUnitNumber);
                    if (adminOrgUnitInfo == null) {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FADMINNUMBERISNOTEXISTINBASEINFO", new Object[]{this.FPersonOrOrgUnitNumber}));
                        continue;
                    }
                    if (adminOrgUnitInfo.isIsOUSealUp()) {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FADMINNUMBERISSEALUP", new Object[]{this.FPersonOrOrgUnitNumber}));
                        continue;
                    }
                    this.FCostCenterId = adminOrgUnitInfo.getId().toString();
                    if (!this.checkAdminOrgInCompany(ctx, this.FCostCenterId, this.FReimburseCompanyId)) {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "ADMINORGNOTINREIMBURSECOMPANY", new Object[]{this.FPersonOrOrgUnitNumber, this.FReimburseCompanyNumber}));
                        continue;
                    }
                }
                if (!this.isSltImportUpdate() && this.checkProxyReimburseByThreeNumber(ctx, this.FProxyType, this.FProxyPersonID, this.FReimbursePersonID, this.FCostCenterId, this.FReimburseCompanyId)) continue;
                if (!this.permissionSet.contains(this.companyId)) {
                    boolean hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(this.userId), (IObjectPK)new ObjectUuidPK(this.companyId), "cp_bc_ProxyReimburse_ImportExport");
                    if (hasFunctionPermission) {
                        this.permissionSet.add(this.companyId);
                    } else {
                        this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "HASNOTFUNCTIONPERMISSION", new Object[]{this.personId}));
                        continue;
                    }
                }
                java.util.Date utilDate = new java.util.Date();
                Date sqlDate = new Date(utilDate.getTime());
                pstmtInsert.setString(1, this.FCostCenterId);
                pstmtInsert.setInt(2, this.FProxyType);
                pstmtInsert.setString(3, this.cuId);
                pstmtInsert.setDate(4, sqlDate);
                pstmtInsert.setString(5, this.userId);
                pstmtInsert.setDate(6, sqlDate);
                pstmtInsert.setString(7, this.userId);
                pstmtInsert.setInt(8, 1);
                pstmtInsert.setString(9, this.FProxyPersonID);
                pstmtInsert.setString(10, this.FReimbursePersonID);
                pstmtInsert.setString(11, this.FReimburseCompanyId);
                pstmtInsert.setString(12, this.FProxyCompanyId);
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e1) {
            try {
                throw new TaskExternalException(e1.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }

    private boolean checkPersonInCompany(Context ctx, String personId, String companyId) throws EASBizException, BOSException, UuidException {
        boolean isInCompany = false;
        Boolean isInCompanyBln = this.personAdminOrgMap.get(personId + companyId);
        if (isInCompanyBln == null) {
            IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
            String queryPositionOql = "SELECT POSITION.ID WHERE POSITION.ADMINORGUNIT.ID IN (SELECT DISTINCT RELATION.FFROMUNITID FROM T_ORG_UNITRELATION RELATION INNER JOIN T_ORG_TYPERELATION TYPE ON TYPE.FID=RELATION.FTYPERELATIONID WHERE RELATION.FTOUNITID='%s' AND TYPE.FFROMTYPE=0 AND TYPE.FTOTYPE=1) AND POSITION.ADMINORGUNIT.ISSEALUP = 0  AND ISPRIMARY = 1 AND PERSON.ID = '%s'";
            if (iPositionMember.exists(String.format(queryPositionOql, companyId, personId))) {
                isInCompany = true;
                this.personAdminOrgMap.put(personId + companyId, isInCompany);
            }
        } else {
            isInCompany = isInCompanyBln;
        }
        return isInCompany;
    }

    private boolean checkAdminOrgInCompany(Context ctx, String AdminOrgId, String companyId) throws EASBizException, BOSException {
        boolean isInCompany = false;
        OrgUnitCollection appliyerComColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(AdminOrgId, 0, 1);
        for (int i = 0; i < appliyerComColl.size(); ++i) {
            if (!companyId.equals(((CompanyOrgUnitInfo)appliyerComColl.get(i)).getId().toString())) continue;
            isInCompany = true;
            break;
        }
        return isInCompany;
    }

    private String queryCompanyOrgUnitInfo(Context ctx, String personId) throws BOSException, EASBizException {
        OrgUnitCollection appliyerComColl;
        String adminOrgUnitInfoId = "";
        String companyInfoId = this.ProxyCompanyMap.get(personId);
        if (StringUtils.isEmpty((String)companyInfoId)) {
            AdminOrgUnitInfo adminOrgUnitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
            if (adminOrgUnitInfo != null && adminOrgUnitInfo.size() > 0) {
                adminOrgUnitInfoId = adminOrgUnitInfo.getId().toString();
            } else {
                String sql = "SELECT DISTINCT ADMINORGUNIT.FID FID FROM T_BD_Person PERSON LEFT OUTER JOIN T_HR_BDEmployeeType EMPLOYEETYPE ON PERSON.FEmployeeTypeID = EMPLOYEETYPE.FID LEFT OUTER JOIN T_ORG_PositionMember PM ON PERSON.FID = PM.FPersonID LEFT OUTER JOIN T_HR_PersonPosition PP ON PERSON.FID = PP.FPersonID LEFT OUTER JOIN T_ORG_Position POSITION ON PM.FPositionID = POSITION.FID LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ON PP.FPersonDep = ADMINORGUNIT.FID LEFT OUTER JOIN T_ORG_CtrlUnit CU2 ON ADMINORGUNIT.FControlUnitID = CU2.FID LEFT OUTER JOIN T_PM_OrgRange ORGRANGE ON PP.FPersonDep = ORGRANGE.FOrgID LEFT OUTER JOIN T_PM_User PMUSER ON ORGRANGE.FUserID = PMUSER.FID WHERE (PM.FPositionID IS NULL AND PERSON.FID =  '%s')";
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)String.format(sql, personId));
                try {
                    while (result.next()) {
                        adminOrgUnitInfoId = result.getString("FID");
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        logger.error((Object)("---cpbc---ProxyReimburseControllerBean---personId: " + personId + ",adminOrgUnitInfoId: " + adminOrgUnitInfoId));
        if (!StringUtils.isEmpty((String)adminOrgUnitInfoId) && (appliyerComColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(adminOrgUnitInfoId, 0, 1)) != null && appliyerComColl.size() > 0) {
            companyInfoId = ((CompanyOrgUnitInfo)appliyerComColl.get(0)).getId().toString();
            this.ProxyCompanyMap.put(personId, companyInfoId);
        }
        return companyInfoId;
    }

    private boolean checkDuplicateDataInExcel(Context ctx, String FProxyPersonNumber, String FPersonOrOrgUnitNumber, String FReimburseCompanyId) throws TaskExternalException, TaskRunnerException {
        boolean isDuplicate = false;
        StringBuilder sb = new StringBuilder();
        if (this.FProxyType == 0) {
            sb.append("PERSON").append(FProxyPersonNumber).append(FPersonOrOrgUnitNumber).append(FReimburseCompanyId);
        } else {
            sb.append("COSTCENTER").append(FProxyPersonNumber).append(FPersonOrOrgUnitNumber);
        }
        String uniqueStr = sb.toString();
        if (this.personOrgSet.contains(uniqueStr) && !this.isSltImportUpdate()) {
            this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FPROXYNUMBERISBEING", new Object[]{this.fProxyType, FProxyPersonNumber, FPersonOrOrgUnitNumber}));
            isDuplicate = true;
        } else {
            this.personOrgSet.add(uniqueStr);
        }
        return isDuplicate;
    }

    private AdminOrgUnitInfo getAdminOrgUnitByNumber(Context ctx, String FOrgUnitNumber) throws Exception {
        AdminOrgUnitCollection coll;
        AdminOrgUnitInfo adminOrgUnitInfo = this.AdminOrgUnitMap.get(FOrgUnitNumber);
        if (adminOrgUnitInfo == null && (coll = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("select id, isOUSealUp where number='" + this.FPersonOrOrgUnitNumber + "'")) != null && coll.size() > 0) {
            adminOrgUnitInfo = coll.get(0);
            this.AdminOrgUnitMap.put(FOrgUnitNumber, adminOrgUnitInfo);
        }
        return adminOrgUnitInfo;
    }

    private PersonInfo getPersonInfoByNumber(Context ctx, String fPersonNumber) throws Exception {
        PersonInfo personInfo = this.personMap.get(fPersonNumber);
        if (personInfo == null) {
            String oql = "select id, number, deletedStatus where number = '%s'";
            PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(String.format(oql, fPersonNumber));
            if (personCollection.size() > 0) {
                personInfo = personCollection.get(0);
                this.personMap.put(fPersonNumber, personInfo);
            }
        }
        return personInfo;
    }

    private boolean checkProxyReimburseByThreeNumber(Context ctx, int FProxyType, String FProxyPersonID, String FReimbursePersonID, String FCostCenterId, String FReimburseCompanyId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_BC_ProxyReimburse \n");
        if (FProxyType == 0) {
            sql.append("where  FProxyType = '" + FProxyType + "' and  FProxyPersonID = '" + FProxyPersonID + "' and FReimbursePersonID = '" + FReimbursePersonID + "' and FReimburseCompanyId ='" + FReimburseCompanyId + "' ;\n");
        } else {
            sql.append("where  FProxyType = '" + FProxyType + "' and  FProxyPersonID = '" + FProxyPersonID + "' and FCostCenterId = '" + FCostCenterId + "';\n");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() != 0) {
            if (FProxyType == 0) {
                this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "PROXYREIMBURESNUMBERISBEINGINDB", new Object[]{this.fProxyType, this.FProxyPersonNumber, this.FPersonOrOrgUnitNumber, this.FReimburseCompanyNumber}));
            } else {
                this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "PROXYADMINNUMBERISBEINGINDB", new Object[]{this.fProxyType, this.FProxyPersonNumber, this.FPersonOrOrgUnitNumber}));
            }
            return true;
        }
        return false;
    }

    @Override
    protected int doProcessData(Context ctx) throws Exception {
        return this.submitData(ctx);
    }

    private int submitData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        if (this.isSltImportUpdate()) {
            sql.append("delete from  T_BC_ProxyReimburse where fid in  ( \n");
            sql.append("    select collection.Fid from T_BC_ProxyReimburse collection ");
            sql.append("    inner join " + this.tempTable + " t ON collection.FProxyType = t.FProxyType \n");
            sql.append("    AND collection.FProxyPersonID = t.FProxyPersonID \n");
            sql.append("    AND collection.FREIMBURSECOMPANYID = t.FREIMBURSECOMPANYID \n");
            sql.append("    AND (collection.FReimbursePersonID = t.FReimbursePersonID OR collection.FCostCenterId = t.FCostCenterId )); \n");
        }
        sql.append("insert into T_BC_ProxyReimburse ( \n");
        sql.append("    FID, \n");
        sql.append("    FCostCenterId, \n");
        sql.append("    FProxyType, \n");
        sql.append("    FControlUnitID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FState, \n");
        sql.append("    FProxyPersonID, \n");
        sql.append("    FReimbursePersonID, \n");
        sql.append("    FREIMBURSECOMPANYID, \n");
        sql.append("    FCompanyID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    t.FID, \n");
        sql.append("    t.FCostCenterId, \n");
        sql.append("    t.FProxyType, \n");
        sql.append("    t.FControlUnitID, \n");
        sql.append("    t.FLastUpdateTime, \n");
        sql.append("    t.FLastUpdateUserID, \n");
        sql.append("    t.FCreateTime, \n");
        sql.append("    t.FCreatorID, \n");
        sql.append("    t.FState, \n");
        sql.append("    t.FProxyPersonID, \n");
        sql.append("    t.FReimbursePersonID, \n");
        sql.append("    t.FREIMBURSECOMPANYID, \n");
        sql.append("    t.FCompanyID \n");
        sql.append("from ").append(this.tempTable).append(" t ;\n");
        ProxyReimburseListDataImport.BatchSqlExecute(ctx, sql.toString(), ";");
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    public Hashtable<String, String> exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String proxyType = rs.getString("proxyType");
            if ("0".equals(proxyType)) {
                result.put("FProxyType", this.getNotBlankString(ResourceBase.getString((String)WebCommonUtilResource, (String)"PERSON", (Locale)ctx.getOriginLocale())));
                result.put("FPersonOrOrgUnitNumber", this.getNotBlankString(rs.getString("reimbursePerson.number")));
                result.put("FPersonOrOrgUnitName", this.getNotBlankString(rs.getString("reimbursePerson.name")));
            } else {
                result.put("FProxyType", this.getNotBlankString(ResourceBase.getString((String)WebCommonUtilResource, (String)"ORGUNIT", (Locale)ctx.getOriginLocale())));
                result.put("FPersonOrOrgUnitName", this.getNotBlankString(rs.getString("costCenter.name")));
                result.put("FPersonOrOrgUnitNumber", this.getNotBlankString(rs.getString("costCenter.number")));
            }
            result.put("FProxyPersonNumber", this.getNotBlankString(rs.getString("proxyPerson.number")));
            result.put("FProxyPersonName", this.getNotBlankString(rs.getString("proxyPerson.name")));
            result.put("FReimburseCompanyNumber", this.getNotBlankString(rs.getString("reiburseCompany.number")));
            result.put("FReimburseCompanyName", this.getNotBlankString(rs.getString("reiburseCompany.name")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        return result;
    }

    public CompanyOrgUnitInfo getCompanyInfoByPersonId(Context ctx, String personId) throws EASBizException, BOSException, UuidException {
        AdminOrgUnitInfo admin = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
        String fAdminOrgUnitId = "";
        CompanyOrgUnitInfo companyInfo = null;
        if (admin != null) {
            fAdminOrgUnitId = admin.getId().toString();
            OrgUnitCollection unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(fAdminOrgUnitId, 0, 1);
            if (unitColl.size() != 0) {
                companyInfo = (CompanyOrgUnitInfo)unitColl.get(0);
            }
        }
        return companyInfo;
    }

    public CompanyOrgUnitInfo getCompanyInfoByAdminId(Context ctx, String adminId) throws EASBizException, BOSException, UuidException {
        CompanyOrgUnitInfo companyInfo = null;
        OrgUnitCollection unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(adminId, 0, 1);
        if (unitColl.size() != 0) {
            companyInfo = (CompanyOrgUnitInfo)unitColl.get(0);
        }
        return companyInfo;
    }

    public CompanyOrgUnitInfo getCompanyInfoIdByNumber(Context ctx, String reimburseCompanyNumber) throws BOSException, TaskExternalException, TaskRunnerException {
        CompanyOrgUnitInfo companyOrgUnitInfo = this.companyMap.get(reimburseCompanyNumber);
        if (companyOrgUnitInfo == null) {
            String oql = "select id, isSealUp, isBizUnit where number = '%s'";
            CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(String.format(oql, reimburseCompanyNumber));
            if (companyOrgUnitCollection.size() > 0) {
                companyOrgUnitInfo = companyOrgUnitCollection.get(0);
                this.companyMap.put(reimburseCompanyNumber, companyOrgUnitInfo);
            } else {
                this.onDataErrorForWeb(this.rowNum, this.getResource(ctx, "FREIMBURSECOMPANYISNOTEXIST", new Object[]{reimburseCompanyNumber}));
            }
        }
        return companyOrgUnitInfo;
    }
}

