/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.reverse.agent;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AdjustStateEnum;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountBillPayEntryFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillPayEntryFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollPayEntryInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CommonWebUtilFacadeFactory;
import com.kingdee.eas.cp.bc.CreateToException;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillPayEntryFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillPayEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillPayEntryFactory;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.IBizCollPayEntry;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillPayEntryFactory;
import com.kingdee.eas.cp.bc.app.invoicepool.util.BizInvoicePoolUtil;
import com.kingdee.eas.cp.bc.app.reverse.payment.BillReverseHandler;
import com.kingdee.eas.fi.cas.AgentPayBillEntryCollection;
import com.kingdee.eas.fi.cas.AgentPayBillEntryInfo;
import com.kingdee.eas.fi.cas.AgentPayBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AgentBillReverseHandler {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.reverse.agent.AgentAgentBillReverseHandler");
    public static final String bizCollResource = "com.kingdee.eas.cp.bc.BizCollResource";
    public static final String Save = "Save";
    public static final String Submit = "Submit";
    public static final String payment = "payment";
    public static final String Delete = "Delete";
    public static final String SubmitPay = "SubmitPay";
    public static final String Pay = "Pay";
    public static final String CancelPay = "CancelPay";
    public static final String COUNTERAUDIT = "CounterAudit";
    public static final String SubmitReturn = "SubmitReturn";
    public static final String Return = "Return";
    public static final String CancelReturn = "CancelReturn";
    public static final BigDecimal prec = new BigDecimal("0.5");

    public static void paymentHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, AgentPayBillInfo agentPayBillInfo, String mode, boolean isPay, boolean isCreatePrePaymentBill) throws BOSException, EASBizException {
        int count = BizCollUtil.getAgentMentSrcBillCount(ctx, agentPayBillInfo, false);
        if (count > 1) {
            if (BizCollUtil.getAgentMentSrcBillCount(ctx, agentPayBillInfo, true) > 0) {
                throw new BizCollException(BizCollException.MULTIPAYCANNOTADD);
            }
            AgentBillReverseHandler.agentMultiHandler(ctx, iservice, agentPayBillInfo, mode, isPay, isCreatePrePaymentBill);
        } else {
            iservice.updatePartial((CoreBaseInfo)baseInfo, AgentBillReverseHandler.getBillSic("id"));
            baseInfo = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(baseInfo.getId()), BizCollUtil.getBillPaySic(mode));
            AgentBillReverseHandler.agentSingleHandler(ctx, iservice, baseInfo, agentPayBillInfo.getAmount(), mode, isPay, null, agentPayBillInfo, isCreatePrePaymentBill, true, null);
        }
    }

    public static BizCollBillBaseInfo agentSingleHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, BigDecimal payAmount, String mode, boolean isPay, String RowNumber, AgentPayBillInfo agentPayBillInfo, boolean isCreatePrePaymentBill, boolean isFromSingle, ArrayList<AgentPayBillEntryInfo> agentEntryies) throws BOSException, EASBizException {
        BigDecimal payPrec;
        ArrayList<String> agentEntryIds = new ArrayList<String>();
        if (agentEntryies != null) {
            for (AgentPayBillEntryInfo agentEntryInfo : agentEntryies) {
                agentEntryIds.add(agentEntryInfo.getId().toString());
                payAmount = payAmount.add(agentEntryInfo.getAmount());
            }
            logger.error((Object)("####agentSingleHandler \u4ee3\u53d1\u5206\u5f55\u5206\u7ec4" + agentEntryIds.toString()));
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"agentSingleHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u4ee3\u53d1\u5355\u4ed8\u6b3ebegin \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",\u7533\u8bf7\u91d1\u989d\uff1a" + baseInfo.getAmount() + ",payAmount:" + payAmount + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState()) + ",mode:" + mode + ",isPay:" + isPay + ",isFromSingle:" + isFromSingle));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP070");
        paramList.add("CP080");
        String applierCompanyId = baseInfo.getApplierCompany().getId().toString();
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, applierCompanyId);
        Boolean isTm = (boolean)new Boolean(paramMap.get("CP070").toString());
        BigDecimal bigDecimal = payPrec = paramMap.get("CP080") == null ? new BigDecimal("0.00") : new BigDecimal(paramMap.get("CP080").toString());
        if (payAmount != null) {
            payAmount = payAmount.setScale(2, 4);
        }
        boolean isPayment = AgentBillReverseHandler.getPayMentOperation(payAmount);
        if (Save.equals(mode) || Submit.equals(mode)) {
            AdjustStateEnum adjustState;
            StateEnum billState = baseInfo.getState();
            if (!(billState == null || billState.getValue() != 80 && (!isPayment || billState.getValue() != 70 || baseInfo instanceof LoanBillInfo && Save.equals(mode)))) {
                throw new CreateToException(CreateToException.STATE_CANNOT_PAYBILL, new Object[]{baseInfo.getState().getAlias()});
            }
            if (!isPayment && baseInfo instanceof ExpenseAccountBillInfo) {
                throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
            }
            if (baseInfo instanceof BizAccountOutBillInfo && ((adjustState = ((BizAccountOutBillInfo)baseInfo).getAdjustState()) == AdjustStateEnum.EDIT || adjustState == AdjustStateEnum.SUBMIT || adjustState == AdjustStateEnum.CHECKING)) {
                throw new BizCollException(BizCollException.ADJUST_CREATETO);
            }
            if ((baseInfo instanceof DailyPurchaseAccountBillInfo || baseInfo instanceof BizAccountOutBillInfo) && baseInfo.getBoolean("isCreateOtherBill")) {
                throw new CreateToException(CreateToException.CANNOT_OTHERBILL_AGENTBILL);
            }
            boolean isCreatePayPlan = baseInfo.getBoolean("isCreatePayPlanBill");
            if (baseInfo.isIsPaySchedule() || isCreatePayPlan) {
                throw new CreateToException(CreateToException.AGENT_BILL_PS);
            }
            if (baseInfo instanceof DailyLoanBillInfo) {
                AgentBillReverseHandler.checkBillCanCreate(ctx, isCreatePrePaymentBill, (DailyLoanBillInfo)baseInfo);
            }
            if (!baseInfo.getBoolean("isCreatePayBill")) {
                BillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreatePayBill", true);
            }
            if (AgentBillReverseHandler.getPayMentOperation(payAmount) && baseInfo.getState().equals((Object)StateEnum.CHECKED)) {
                AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
            }
        }
        if (Submit.equals(mode)) {
            if (AgentBillReverseHandler.getPayMentOperation(payAmount)) {
                payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, isFromSingle);
                AgentBillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount, SubmitPay, RowNumber, agentPayBillInfo, paramMap);
                AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
            } else {
                if (baseInfo instanceof ExpenseAccountBillInfo) {
                    throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
                }
                payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, isFromSingle);
                AgentBillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), SubmitReturn, RowNumber, agentPayBillInfo.getId().toString(), paramMap);
            }
        } else if (payment.equals(mode)) {
            if (!isPay) {
                AgentBillReverseHandler.checkSourceBillHasClose(ctx, baseInfo, RowNumber);
                if (!BizCollUtil.checkRepayDelVoucher(agentPayBillInfo.getId().toString(), ctx)) {
                    throw new BizCollException(BizCollException.PAYEXREPAY);
                }
                if (baseInfo instanceof ExpenseAccountBillInfo || baseInfo instanceof LoanBillInfo) {
                    AgentBillReverseHandler.handlePayEntry(ctx, baseInfo, agentPayBillInfo, "delPayEntry", agentEntryies, isFromSingle);
                }
            } else if (baseInfo instanceof ExpenseAccountBillInfo || baseInfo instanceof LoanBillInfo) {
                AgentBillReverseHandler.handlePayEntry(ctx, baseInfo, agentPayBillInfo, "addPayEntry", agentEntryies, isFromSingle);
            }
            if (AgentBillReverseHandler.getPayMentOperation(payAmount)) {
                if (isPay) {
                    if (StateEnum.ISPAYBILL.equals((Object)(baseInfo = AgentBillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, isFromSingle), Pay, RowNumber, agentPayBillInfo, paramMap)).getState()) && baseInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) == 0) {
                        if (isTm.booleanValue()) {
                            BizInvoicePoolUtil.updateIspayment(ctx, baseInfo, true);
                        }
                        AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYPAYMENT);
                        AgentBillReverseHandler.reWriteBillPayDate(iservice, baseInfo, new Date());
                    }
                    if (baseInfo instanceof ExpenseAccountBillInfo && BizCollUtil.checkPayBillCanNotCreateVoucher(ctx, baseInfo.getApplierCompany().getId().toString())) {
                        BizCollUtil.addAccountRecords(ctx, baseInfo, agentPayBillInfo.getId().toString(), payAmount, agentPayBillInfo.getPayerAccount());
                    }
                } else {
                    payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, isFromSingle);
                    if (baseInfo instanceof ExpenseAccountBillInfo && BizCollUtil.checkPayBillCanNotCreateVoucher(ctx, baseInfo.getApplierCompany().getId().toString())) {
                        if (BizCollUtil.checkAccountRecordsHasAccounted(ctx, baseInfo, agentPayBillInfo.getId().toString())) {
                            if (RowNumber != null) {
                                throw new BizCollException(BizCollException.CANNOTREPAYHASACCOUNTEDWITHNUMBER, new Object[]{RowNumber});
                            }
                            throw new BizCollException(BizCollException.CANNOTREPAYHASACCOUNTED);
                        }
                        BizCollUtil.deleteAccountRecords(ctx, baseInfo, agentPayBillInfo.getId().toString());
                    }
                    if (baseInfo instanceof LoanBillInfo && baseInfo.getAmountBalance().add(payPrec).add(BizCollUtil.getReturenAmountCount(ctx, baseInfo, "", agentPayBillInfo.getId().toString())).compareTo(payAmount) < 0) {
                        if (RowNumber != null) {
                            throw new BizCollException(BizCollException.CANCELPAYCANNOTBIGGERTHANREALAMOUNTBALANCEWITHNUM, new Object[]{RowNumber});
                        }
                        throw new BizCollException(BizCollException.CANCELPAYCANNOTBIGGERTHANREALAMOUNTBALANCE);
                    }
                    if (StateEnum.ALREADYPAYMENT.equals((Object)(baseInfo = AgentBillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount, CancelPay, RowNumber, agentPayBillInfo, paramMap)).getState())) {
                        if (isTm.booleanValue()) {
                            BizInvoicePoolUtil.updateIspayment(ctx, baseInfo, false);
                        }
                        AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
                        AgentBillReverseHandler.reWriteBillPayDate(iservice, baseInfo, null);
                    }
                }
                iservice.updatePartial((CoreBaseInfo)baseInfo, AgentBillReverseHandler.getBillSic("pay"));
            } else {
                if (baseInfo instanceof ExpenseAccountBillInfo) {
                    throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
                }
                payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, isFromSingle);
                baseInfo = isPay ? AgentBillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), Return, RowNumber, agentPayBillInfo.getId().toString(), paramMap) : AgentBillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), CancelReturn, RowNumber, agentPayBillInfo.getId().toString(), paramMap);
                iservice.updatePartial((CoreBaseInfo)baseInfo, AgentBillReverseHandler.getBillSic("return"));
            }
        } else if (Delete.equals(mode)) {
            AgentBillReverseHandler.checkSourceBillHasClose(ctx, baseInfo, RowNumber);
            if (AgentBillReverseHandler.getPayMentOperation(payAmount) && StateEnum.ISPAYBILL.equals((Object)baseInfo.getState()) && BizCollUtil.checkTracDownAgentbill(ctx, baseInfo.getId().toString(), "false") == 0 && BizCollUtil.checkTracDownPaybill(ctx, baseInfo.getId().toString(), "false") == 0) {
                AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CHECKED);
                AgentBillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreatePayBill", false);
            }
        }
        return baseInfo;
    }

    public static BigDecimal getAgentPayAmount(Context ctx, BizCollBillBaseInfo baseInfo, AgentPayBillInfo agentPayBill, BigDecimal payAmount, boolean isFromSingle) throws EASBizException, BOSException {
        if (agentPayBill.getCurrency() != null && baseInfo.getCurrencyType() != null && baseInfo.getApplierCompany().getId() != null) {
            BigDecimal agentPayAmountOri = AgentBillReverseHandler.getTotalEntAmount(baseInfo, agentPayBill, isFromSingle);
            String agentPayCurrencyId = agentPayBill.getCurrency().getId().toString();
            if (agentPayCurrencyId != null && !agentPayCurrencyId.equals(baseInfo.getCurrencyType().getId().toString())) {
                IObjectValue entryCoreBaseInfo = BizCollUtil.getEntryCoreBaseInfo(baseInfo, agentPayCurrencyId);
                payAmount = BizCollUtil.getAmountByAmountOriAndInfo(ctx, baseInfo, entryCoreBaseInfo, agentPayAmountOri, agentPayCurrencyId);
            } else {
                payAmount = agentPayAmountOri;
            }
            logger.error((Object)("---getAgentPayAmount payAmount=" + payAmount + ",payAmountOri=" + agentPayAmountOri));
        }
        return payAmount.setScale(2, 4);
    }

    public static BigDecimal getTotalEntAmount(BizCollBillBaseInfo baseInfo, AgentPayBillInfo agentPayBill, boolean isFromSingle) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        BigDecimal tmpAmount = new BigDecimal("0.00");
        AgentPayBillEntryCollection agentPayEntryCon = agentPayBill.getEntrys();
        if (agentPayEntryCon != null) {
            int size = agentPayEntryCon.size();
            for (int i = 0; i < size; ++i) {
                if (baseInfo.getId().toString().equals(agentPayEntryCon.get(i).getSourceBillId())) {
                    tmpAmount = tmpAmount.add(agentPayEntryCon.get(i).getAmount());
                }
                totalAmount = totalAmount.add(agentPayEntryCon.get(i).getAmount());
            }
        }
        logger.error((Object)("---getTotalEntAmount totalAmount=" + totalAmount));
        if (isFromSingle) {
            return totalAmount;
        }
        return tmpAmount;
    }

    private static void handlePayEntry(Context ctx, BizCollBillBaseInfo baseInfo, AgentPayBillInfo agentPayBill, String operation, ArrayList<AgentPayBillEntryInfo> agentPayEntryies, boolean isFromSingle) throws BOSException, EASBizException {
        IBizCollPayEntry iBizCollPayEntry = null;
        if (baseInfo instanceof DailyLoanBillInfo) {
            iBizCollPayEntry = DailyLoanBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof EvectionLoanBillInfo) {
            iBizCollPayEntry = EvectionLoanBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof BizAccountBillInfo) {
            iBizCollPayEntry = BizAccountBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof TravelAccountBillInfo) {
            iBizCollPayEntry = TravelAccountBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof BizAccountOutBillInfo) {
            iBizCollPayEntry = BizAccountOutBillPayEntryFactory.getLocalInstance(ctx);
        } else if (baseInfo instanceof DailyPurchaseAccountBillInfo) {
            iBizCollPayEntry = DailyPurchaseAccountBillPayEntryFactory.getLocalInstance(ctx);
        }
        if (iBizCollPayEntry == null) {
            logger.error((Object)"##### handlePayEntry IBizCollPayEntry is null");
            return;
        }
        String payNumber = agentPayBill.getNumber();
        FilterInfo delFilter = new FilterInfo();
        delFilter.getFilterItems().add(new FilterItemInfo("payBillNumber", (Object)payNumber));
        delFilter.getFilterItems().add(new FilterItemInfo("bill.id", (Object)baseInfo.getId().toString()));
        if (operation.equals("addPayEntry")) {
            AccountViewInfo payerAccount = agentPayBill.getPayerAccount();
            AccountBankInfo payerAccountBank = agentPayBill.getPayBankAccount();
            CurrencyInfo payCurrency = agentPayBill.getCurrency();
            CompanyOrgUnitInfo company = agentPayBill.getCompany();
            BigDecimal exchangeRate = new BigDecimal(1);
            ConvertModeEnum convertMode = ConvertModeEnum.DIRECTEXCHANGERATE;
            int exchangeRatePrecision = 4;
            if (!agentPayBill.getCurrency().getId().toString().equals(baseInfo.getCurrencyType().getId().toString())) {
                IObjectValue entryCoreBaseInfo = BizCollUtil.getEntryCoreBaseInfo(baseInfo, agentPayBill.getCurrency().getId().toString());
                if (entryCoreBaseInfo != null) {
                    if (entryCoreBaseInfo.get("exchangeRate") != null) {
                        exchangeRate = (BigDecimal)entryCoreBaseInfo.get("exchangeRate");
                    }
                    if (entryCoreBaseInfo.get("convertMode") != null) {
                        convertMode = ConvertModeEnum.getEnum((int)((Integer)entryCoreBaseInfo.get("convertMode")));
                    }
                    if (entryCoreBaseInfo.get("exchangeRatePrecision") != null) {
                        exchangeRatePrecision = (Integer)entryCoreBaseInfo.get("exchangeRatePrecision");
                    }
                } else {
                    ExchangeRateInfo exRateInfo = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(agentPayBill.getCurrency().getId().toString(), null, baseInfo.getApplierCompany().getId().toString(), baseInfo.getBizReqDate());
                    if (exRateInfo != null) {
                        exchangeRate = exRateInfo.getConvertRate();
                        convertMode = exRateInfo.getConvertMode();
                        exchangeRatePrecision = exRateInfo.getPrecision();
                    }
                }
            }
            AgentPayBillEntryCollection payBillEntries = agentPayBill.getEntrys();
            EntityViewInfo queryEntity = new EntityViewInfo();
            BigDecimal totalPayAmount = new BigDecimal(0);
            int is = isFromSingle ? payBillEntries.size() : agentPayEntryies.size();
            for (int i = 0; i < is; ++i) {
                BizCollPayEntryInfo bizCollPayEntryInfo = new BizCollPayEntryInfo();
                AgentPayBillEntryInfo paymentBillEntryInfo = null;
                paymentBillEntryInfo = isFromSingle ? payBillEntries.get(i) : agentPayEntryies.get(i);
                String payBillEntryId = paymentBillEntryInfo.getId().toString();
                FilterInfo queryFilter = new FilterInfo();
                queryFilter.getFilterItems().add(new FilterItemInfo("payBillEntry.id", (Object)payBillEntryId));
                queryEntity.setFilter(queryFilter);
                bizCollPayEntryInfo.put("bill", baseInfo);
                bizCollPayEntryInfo.setPayBillNumber(payNumber);
                bizCollPayEntryInfo.setPayerAccount(payerAccount);
                bizCollPayEntryInfo.setPayerAccountBank(payerAccountBank);
                bizCollPayEntryInfo.setCurrencyType(payCurrency);
                BigDecimal payAmountOri = paymentBillEntryInfo.getAmount();
                bizCollPayEntryInfo.setPayAmountOri(payAmountOri);
                bizCollPayEntryInfo.setPayerName(paymentBillEntryInfo.getRecName());
                BigDecimal payAmount = convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? payAmountOri.multiply(exchangeRate).setScale(2, 4) : payAmountOri.divide(exchangeRate, 2, 4).setScale(2, 4);
                totalPayAmount = totalPayAmount.add(payAmount);
                bizCollPayEntryInfo.setPayAmount(payAmount);
                bizCollPayEntryInfo.setPayCompany(company);
                bizCollPayEntryInfo.setExchangeRate(exchangeRate);
                bizCollPayEntryInfo.setExchangeRatePrecision(exchangeRatePrecision);
                bizCollPayEntryInfo.setConvertMode(convertMode);
                bizCollPayEntryInfo.setPayDate(new Date());
                bizCollPayEntryInfo.setPayBank(agentPayBill.getPayerBank());
                iBizCollPayEntry.addnew(bizCollPayEntryInfo);
            }
        } else if (operation.equals("delPayEntry")) {
            iBizCollPayEntry.delete(delFilter);
        }
    }

    public static void agentMultiHandler(Context ctx, IBizCollBillBase iservice, AgentPayBillInfo agentPayBillInfo, String mode, boolean isPay, boolean isCreatePrePaymentBill) throws BOSException, EASBizException {
        AgentPayBillEntryCollection agentPayEntryCon = agentPayBillInfo.getEntrys();
        AgentPayBillEntryInfo agentPayEntryInfo = null;
        String sourceBillId = null;
        BizCollBillBaseInfo baseInfo = null;
        BizCollUtil.sortCollection(new String[]{"sourceBillID"}, (AbstractObjectCollection)agentPayBillInfo.get("entrys"));
        if (agentPayEntryCon != null) {
            LinkedHashMap agentPayEntryGroups = new LinkedHashMap();
            ArrayList<AgentPayBillEntryInfo> list = null;
            int size = agentPayEntryCon.size();
            for (int i = 0; i < size; ++i) {
                agentPayEntryInfo = agentPayEntryCon.get(i);
                sourceBillId = agentPayEntryInfo.getSourceBillId();
                if (!agentPayEntryGroups.containsKey(sourceBillId)) {
                    list = new ArrayList<AgentPayBillEntryInfo>();
                    list.add(agentPayEntryInfo);
                    agentPayEntryGroups.put(sourceBillId, list);
                    continue;
                }
                ((ArrayList)agentPayEntryGroups.get(sourceBillId)).add(agentPayEntryInfo);
            }
            for (String billId : agentPayEntryGroups.keySet()) {
                ArrayList agentPayEntries = (ArrayList)agentPayEntryGroups.get(billId);
                baseInfo = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), AgentBillReverseHandler.getBillSic("id"));
                iservice.updatePartial((CoreBaseInfo)baseInfo, AgentBillReverseHandler.getBillSic("id"));
                baseInfo = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), BizCollUtil.getBillPaySic(mode));
                baseInfo = AgentBillReverseHandler.agentSingleHandler(ctx, iservice, baseInfo, BizCollUtil.ZERO, mode, isPay, String.valueOf(((AgentPayBillEntryInfo)agentPayEntries.get(0)).getSeq()), agentPayBillInfo, isCreatePrePaymentBill, false, agentPayEntries);
            }
        }
    }

    public static BizCollBillBaseInfo payHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, BigDecimal payAmount, String mode, String RowNumber, AgentPayBillInfo agentPayBillInfo, Map paramMap) throws BOSException, EASBizException {
        BigDecimal payPrec = paramMap.get("CP080") == null ? new BigDecimal("0.00") : new BigDecimal(paramMap.get("CP080").toString());
        BigDecimal amountNotPaid = null;
        BigDecimal amountPaid = null;
        BigDecimal amountBalance = null;
        if (payAmount != null) {
            amountNotPaid = baseInfo.getAmountNotPaid();
            amountPaid = baseInfo.getAmountPaid();
            BigDecimal bigDecimal = amountBalance = baseInfo.getAmountBalance() == null ? BizCollUtil.ZERO : baseInfo.getAmountBalance();
            if (mode.equals(SubmitPay)) {
                BigDecimal submitAmount = BizCollUtil.getPayAmountCount(ctx, baseInfo, null, agentPayBillInfo, "submit", paramMap);
                logger.error((Object)("--payHandler submitAmount=" + submitAmount + ";amountNotPaid=" + amountNotPaid + ";payAmount=" + payAmount + ";number=" + baseInfo.getNumber()));
                if (submitAmount != null && (submitAmount = submitAmount.add(payAmount).setScale(2, 4)).compareTo(amountNotPaid.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.NOTPAIDNOTENOUGHWITHNUM, new Object[]{RowNumber, amountNotPaid, submitAmount});
                    }
                    throw new BizCollException(BizCollException.NOTPAIDNOTENOUGH, new Object[]{amountNotPaid, submitAmount});
                }
                if (payAmount.compareTo(amountNotPaid.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAYWITHNUM, new Object[]{RowNumber, payAmount, amountNotPaid});
                    }
                    throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAY, new Object[]{payAmount, amountNotPaid});
                }
            } else if (mode.equals(Pay)) {
                if (payAmount.compareTo(amountNotPaid.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAYWITHNUM, new Object[]{RowNumber, payAmount, amountNotPaid});
                    }
                    throw new BizCollException(BizCollException.PAYBIGGERTHANNOTPAY, new Object[]{payAmount, amountNotPaid});
                }
                BigDecimal amountDif = amountNotPaid.subtract(payAmount);
                if (amountDif.abs().compareTo(payPrec) <= 0) {
                    baseInfo.setAmountNotPaid(new BigDecimal(0));
                    baseInfo.setAmountPaid(amountPaid.add(payAmount).add(amountDif));
                    baseInfo.setAmountBalance(amountBalance.add(payAmount).add(amountDif));
                } else {
                    baseInfo.setAmountNotPaid(amountNotPaid.subtract(payAmount));
                    baseInfo.setAmountPaid(amountPaid.add(payAmount));
                    baseInfo.setAmountBalance(amountBalance.add(payAmount));
                }
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"payHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u4ee3\u53d1\u5355\u4ed8\u6b3ePay \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",payAmount:" + payAmount + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            } else if (mode.equals(CancelPay)) {
                if (BizCollUtil.checkHasTracDownExpensebill(ctx, baseInfo.getId().toString()) > 0) {
                    throw new BizCollException(BizCollException.CANNOTREPAYWITHEXPENSE);
                }
                if (baseInfo instanceof LoanBillInfo && payAmount.compareTo(amountBalance.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.CANCELPAYBIGGERTHANNOTPAYWITHNUM, new Object[]{RowNumber});
                    }
                    throw new BizCollException(BizCollException.CANCELPAYBIGGERTHANNOTPAY);
                }
                BigDecimal amountDif = amountPaid.subtract(payAmount);
                if (amountDif.abs().compareTo(payPrec) <= 0) {
                    baseInfo.setAmountNotPaid(amountNotPaid.add(payAmount).add(amountDif));
                    baseInfo.setAmountPaid(amountPaid.subtract(payAmount).subtract(amountDif));
                    baseInfo.setAmountBalance(amountBalance.subtract(payAmount).subtract(amountDif));
                } else {
                    baseInfo.setAmountNotPaid(amountNotPaid.add(payAmount));
                    baseInfo.setAmountPaid(amountPaid.subtract(payAmount));
                    baseInfo.setAmountBalance(amountBalance.subtract(payAmount));
                }
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"payHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u4ee3\u53d1\u5355\u53d6\u6d88\u4ed8\u6b3e CancelPay \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",payAmount:" + payAmount + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            }
        }
        return baseInfo;
    }

    public static LoanBillInfo returnHandler(Context ctx, IBizCollBillBase iservice, LoanBillInfo loanBillInfo, BigDecimal payAmount, String mode, String RowNumber, String paybillid, Map paramMap) throws BOSException, EASBizException {
        BigDecimal payPrec = paramMap.get("CP080") == null ? new BigDecimal("0.00") : new BigDecimal(paramMap.get("CP080").toString());
        BigDecimal amountBalance = null;
        BigDecimal returnAmount = null;
        if (payAmount != null) {
            amountBalance = loanBillInfo.getAmountBalance();
            returnAmount = loanBillInfo.getReturnAmount();
            if (amountBalance != null) {
                amountBalance = amountBalance.setScale(2, 4);
            }
            if (returnAmount == null) {
                returnAmount = BizCollUtil.ZERO;
            }
            returnAmount = returnAmount.setScale(2, 4);
            if (mode.equals(SubmitReturn)) {
                BigDecimal doingAmount = BizCollUtil.ZERO;
                if (paybillid != null) {
                    doingAmount = BizCollUtil.getReturenAmountCount(ctx, loanBillInfo, "", paybillid);
                }
                logger.error((Object)("--returnHandler returnAmount=" + returnAmount + ";amountBalance=" + amountBalance + ";doingAmount=" + doingAmount + ";payAmount=" + payAmount + ";number=" + loanBillInfo.getNumber()));
                if (payAmount.compareTo(amountBalance.add(doingAmount).add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCEWITHNUM, new Object[]{RowNumber, loanBillInfo.getNumber(), payAmount, amountBalance, doingAmount.abs()});
                    }
                    throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCE, new Object[]{loanBillInfo.getNumber(), payAmount, amountBalance, doingAmount.abs()});
                }
            } else if (mode.equals(Return)) {
                if (payAmount.compareTo(amountBalance.add(payPrec)) > 0) {
                    if (RowNumber != null) {
                        throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCEWITHNUM, new Object[]{RowNumber, loanBillInfo.getNumber(), payAmount, amountBalance, "0"});
                    }
                    throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCE, new Object[]{loanBillInfo.getNumber(), payAmount, amountBalance, "0"});
                }
                BigDecimal amountDif = amountBalance.subtract(payAmount);
                if (amountDif.abs().compareTo(payPrec) <= 0) {
                    loanBillInfo.setReturnAmount(returnAmount.add(payAmount).add(amountDif));
                    loanBillInfo.setAmountBalance(new BigDecimal(0));
                } else {
                    loanBillInfo.setReturnAmount(returnAmount.add(payAmount));
                    loanBillInfo.setAmountBalance(amountBalance.subtract(payAmount));
                }
                loanBillInfo.setReturnDate(new Date());
                AgentBillReverseHandler.returnLoanBillEntry(ctx, loanBillInfo, payAmount, mode);
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"returnHandler", (BOSObjectType)loanBillInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(loanBillInfo.getId()), (String)("\u4ee3\u53d1\u5355\u8fd8\u6b3eReturn \u5355\u636e\u7f16\u7801\uff1a" + loanBillInfo.getNumber() + ",payAmount:" + payAmount + ",\u672a\u4ed8\u91d1\u989d\uff1a" + loanBillInfo.getReturnAmount() + ",\u53ef\u7528\u4f59\u989d\uff1a" + loanBillInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)loanBillInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            } else if (mode.equals(CancelReturn)) {
                if (returnAmount.add(payPrec).subtract(payAmount).compareTo(BizCollUtil.ZERO) <= 0) {
                    loanBillInfo.setReturnDate(null);
                }
                loanBillInfo.setReturnAmount(returnAmount.subtract(payAmount));
                loanBillInfo.setAmountBalance(amountBalance.add(payAmount));
                AgentBillReverseHandler.returnLoanBillEntry(ctx, loanBillInfo, payAmount, mode);
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"returnHandler", (BOSObjectType)loanBillInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(loanBillInfo.getId()), (String)("\u4ee3\u53d1\u5355\u8fd8\u6b3eCancelReturn \u5355\u636e\u7f16\u7801\uff1a" + loanBillInfo.getNumber() + ",payAmount:" + payAmount + ",\u672a\u4ed8\u91d1\u989d\uff1a" + loanBillInfo.getReturnAmount() + ",\u53ef\u7528\u4f59\u989d\uff1a" + loanBillInfo.getAmountBalance() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)loanBillInfo.getState())));
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            }
        }
        return loanBillInfo;
    }

    private static boolean getPayMentOperation(BigDecimal payAmount) {
        if (payAmount != null && payAmount.compareTo(BizCollUtil.ZERO) >= 0) {
            return true;
        }
        if (payAmount != null && payAmount.compareTo(BizCollUtil.ZERO) < 0) {
            return false;
        }
        return false;
    }

    private static void checkTracDownPaybillState(Context ctx, String billid) throws BOSException, EASBizException {
        if (BizCollUtil.checkTracDownAgentbill(ctx, billid, "true") > 0) {
            throw new BizCollException(BizCollException.CANNOTPAY);
        }
    }

    private static void checkSourceBillHasClose(Context ctx, BizCollBillBaseInfo baseInfo, String RowNumber) throws BOSException, EASBizException {
        if (StateEnum.CLOSED.equals((Object)baseInfo.getState())) {
            if (RowNumber != null) {
                throw new BizCollException(BizCollException.ISSOURCEBILLCLOSEWITHNUM, new Object[]{RowNumber});
            }
            throw new BizCollException(BizCollException.ISSOURCEBILLCLOSE);
        }
    }

    private static void setActionFlag(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, String actionFlag) throws BOSException, EASBizException {
        billInfo.setString("actionFlag", actionFlag);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("actionFlag"));
        iservice.updatePartial((CoreBaseInfo)billInfo, sic);
    }

    protected static void reWriteBillState(IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, StateEnum state) throws BOSException, EASBizException {
        billInfo.setState(state);
        iservice.updatePartial((CoreBaseInfo)billInfo, AgentBillReverseHandler.getBillSic("state"));
    }

    protected static void reWriteBillPayDate(IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, Date date) throws BOSException, EASBizException {
        billInfo.setPayDate(date);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("payDate"));
        iservice.updatePartial((CoreBaseInfo)billInfo, sic);
    }

    private static void checkAmountEncashed(Context ctx, BizCollBillBaseInfo baseInfo, String checkType) throws BOSException, EASBizException {
        ExpenseAccountBillInfo info = (ExpenseAccountBillInfo)baseInfo;
        if (checkType.equals("isPay") && (info.getAmountEncashed() == null || info.getAmountEncashed().compareTo(BizCollUtil.ZERO) <= 0)) {
            throw new BizCollException(BizCollException.CANNOTVOUCHERBYEXPENSETOPAY);
        }
    }

    public static SelectorItemCollection getBillSic(String type) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        if ("id".equals(type)) {
            return sic;
        }
        if (type.equals("return") || type.equals("bill")) {
            sic.add(new SelectorItemInfo("returnAmount"));
            sic.add(new SelectorItemInfo("returnDate"));
            sic.add(new SelectorItemInfo("amountBalance"));
        }
        if (type.equals("pay") || type.equals("bill")) {
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountBalance"));
        }
        return sic;
    }

    public static SelectorItemCollection getPayMentSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("payerAccount.*"));
        sic.add(new SelectorItemInfo("payBankAccount.id"));
        sic.add(new SelectorItemInfo("entrys.amount"));
        sic.add(new SelectorItemInfo("entrys.sourceBillId"));
        return sic;
    }

    public static void returnLoanBillEntry(Context ctx, LoanBillInfo loanBillInfo, BigDecimal payAmount, String mode) throws EASBizException, BOSException {
        AbstractObjectCollection con = (AbstractObjectCollection)loanBillInfo.get("entries");
        if (con != null) {
            CoreBillEntryBaseInfo entryInfo = null;
            BigDecimal amountPaid = null;
            BigDecimal amountPaidOri = null;
            BigDecimal amountBalance = null;
            BigDecimal amountBalanceOri = null;
            BigDecimal exchangeRate = null;
            BigDecimal payAmountOri = null;
            int convertModeEnum = 0;
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                if (payAmount.compareTo(BizCollUtil.ZERO) <= 0) continue;
                entryInfo = (CoreBillEntryBaseInfo)con.getObject(i);
                convertModeEnum = (Integer)entryInfo.get("convertMode");
                exchangeRate = entryInfo.getBigDecimal("exchangeRate");
                if (entryInfo.getBigDecimal("amountPaid") == null) {
                    entryInfo.setBigDecimal("amountPaid", BizCollUtil.ZERO);
                }
                payAmountOri = convertModeEnum == 0 ? payAmount.divide(exchangeRate, 2, 4) : payAmount.multiply(exchangeRate).setScale(2, 4);
                if (mode.equals(Return)) {
                    amountBalance = entryInfo.getBigDecimal("amountBalance");
                    amountBalanceOri = entryInfo.getBigDecimal("amountBalanceOri");
                    if (payAmount.compareTo(amountBalance) >= 0) {
                        entryInfo.setBigDecimal("amountBalance", BizCollUtil.ZERO);
                        entryInfo.setBigDecimal("amountBalanceOri", BizCollUtil.ZERO);
                        entryInfo.setBigDecimal("amountUsed", entryInfo.getBigDecimal("amountUsed").add(amountBalance));
                        entryInfo.setBigDecimal("amountUsedOri", entryInfo.getBigDecimal("amountUsedOri").add(amountBalanceOri));
                        entryInfo.setBigDecimal("amountPaid", entryInfo.getBigDecimal("amountPaid").add(amountBalance));
                        payAmount = payAmount.subtract(amountBalance);
                    } else {
                        entryInfo.setBigDecimal("amountBalance", amountBalance.subtract(payAmount));
                        entryInfo.setBigDecimal("amountUsed", entryInfo.getBigDecimal("amountUsed").add(payAmount));
                        entryInfo.setBigDecimal("amountBalanceOri", amountBalanceOri.subtract(payAmountOri));
                        entryInfo.setBigDecimal("amountUsedOri", entryInfo.getBigDecimal("amountUsedOri").add(payAmountOri));
                        entryInfo.setBigDecimal("amountPaid", entryInfo.getBigDecimal("amountPaid").add(payAmount));
                        payAmount = BizCollUtil.ZERO;
                    }
                } else if (mode.equals(CancelReturn)) {
                    amountPaid = entryInfo.getBigDecimal("amountPaid");
                    amountPaidOri = convertModeEnum == 0 ? amountPaid.divide(exchangeRate, 2, 4) : amountPaid.multiply(exchangeRate).setScale(2, 4);
                    if (payAmount.compareTo(amountPaid) >= 0) {
                        entryInfo.setBigDecimal("amountBalance", entryInfo.getBigDecimal("amountBalance").add(entryInfo.getBigDecimal("amountPaid")));
                        entryInfo.setBigDecimal("amountUsed", entryInfo.getBigDecimal("amountUsed").subtract(entryInfo.getBigDecimal("amountPaid")));
                        entryInfo.setBigDecimal("amountBalanceOri", entryInfo.getBigDecimal("amountBalanceOri").add(amountPaidOri));
                        entryInfo.setBigDecimal("amountUsedOri", entryInfo.getBigDecimal("amountUsedOri").subtract(amountPaidOri));
                        entryInfo.setBigDecimal("amountPaid", BizCollUtil.ZERO);
                        payAmount = payAmount.subtract(amountPaid);
                    } else {
                        entryInfo.setBigDecimal("amountBalanceOri", entryInfo.getBigDecimal("amountBalanceOri").add(payAmountOri));
                        entryInfo.setBigDecimal("amountUsedOri", entryInfo.getBigDecimal("amountUsedOri").subtract(payAmountOri));
                        entryInfo.setBigDecimal("amountBalance", entryInfo.getBigDecimal("amountBalance").add(payAmount));
                        entryInfo.setBigDecimal("amountUsed", entryInfo.getBigDecimal("amountUsed").subtract(payAmount));
                        entryInfo.setBigDecimal("amountPaid", entryInfo.getBigDecimal("amountPaid").subtract(payAmount));
                        payAmount = BizCollUtil.ZERO;
                    }
                }
                if (loanBillInfo instanceof DailyLoanBillInfo) {
                    DailyLoanBillEntryFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)entryInfo, AgentBillReverseHandler.getReturnLoanEntrySic());
                    continue;
                }
                if (!(loanBillInfo instanceof EvectionLoanBillInfo)) continue;
                EvectionLoanBillEntryFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)entryInfo, AgentBillReverseHandler.getReturnLoanEntrySic());
            }
        }
    }

    public static SelectorItemCollection getReturnLoanEntrySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("amountBalance"));
        sic.add(new SelectorItemInfo("amountBalanceOri"));
        sic.add(new SelectorItemInfo("amountUsed"));
        sic.add(new SelectorItemInfo("amountUsedOri"));
        sic.add(new SelectorItemInfo("amountPaid"));
        return sic;
    }

    public static void checkBillCanCreate(Context context, Boolean isCreatePrePaymentBill, DailyLoanBillInfo dailyLoanBillInfo) throws DailyLoanBillException, BOSException {
        if (isCreatePrePaymentBill.booleanValue() && dailyLoanBillInfo.isIsCreatePrePaymentBill()) {
            throw new DailyLoanBillException(DailyLoanBillException.NOTALLOWEDGENERATEPAYMENTANDAGENTPAYMENT);
        }
    }

    public static void updateBillProperty(Context ctx, BizCollBillBaseInfo billInfo, String fieldName, Object fieldValue) throws EASBizException, BOSException {
        billInfo.put(fieldName, fieldValue);
        billInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        billInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        ICoreBase iCoreBase = BizCollUtil.getBizInterfaceByBOSUuid(ctx, billInfo.getId());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(fieldName));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        iCoreBase.updatePartial((CoreBaseInfo)billInfo, sic);
    }

    @Deprecated
    public static BizCollBillBaseInfo agentSingleHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, BigDecimal payAmount, String mode, boolean isPay, String RowNumber, AgentPayBillInfo agentPayBillInfo, boolean isCreatePrePaymentBill, AgentPayBillEntryInfo payEntryInfo, boolean isFromSingle) throws BOSException, EASBizException {
        String payEntryId;
        BigDecimal payPrec;
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"agentSingleHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)("\u4ee3\u53d1\u5355\u4ed8\u6b3ebegin \u5355\u636e\u7f16\u7801\uff1a" + baseInfo.getNumber() + ",\u7533\u8bf7\u91d1\u989d\uff1a" + baseInfo.getAmount() + ",payAmount:" + payAmount + ",\u53ef\u7528\u4f59\u989d\uff1a" + baseInfo.getAmountBalance() + ",\u672a\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountNotPaid() + ",\u5df2\u4ed8\u91d1\u989d\uff1a" + baseInfo.getAmountPaid() + ",\u5355\u636e\u72b6\u6001\uff1a" + (Object)((Object)baseInfo.getState()) + ",mode:" + mode + ",isPay:" + isPay + ",isFromSingle:" + isFromSingle));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP070");
        paramList.add("CP080");
        String applierCompanyId = baseInfo.getApplierCompany().getId().toString();
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, applierCompanyId);
        Boolean isTm = (boolean)new Boolean(paramMap.get("CP070").toString());
        BigDecimal bigDecimal = payPrec = paramMap.get("CP080") == null ? new BigDecimal("0.00") : new BigDecimal(paramMap.get("CP080").toString());
        if (payAmount != null) {
            payAmount = payAmount.setScale(2, 4);
        }
        String string = payEntryId = payEntryInfo == null ? null : payEntryInfo.getId().toString();
        if (Save.equals(mode) || Submit.equals(mode)) {
            AdjustStateEnum adjustState;
            if (baseInfo instanceof BizAccountOutBillInfo && ((adjustState = ((BizAccountOutBillInfo)baseInfo).getAdjustState()) == AdjustStateEnum.EDIT || adjustState == AdjustStateEnum.SUBMIT || adjustState == AdjustStateEnum.CHECKING)) {
                throw new BizCollException(BizCollException.ADJUST_CREATETO);
            }
            if ((baseInfo instanceof DailyPurchaseAccountBillInfo || baseInfo instanceof BizAccountOutBillInfo) && baseInfo.getBoolean("isCreateOtherBill")) {
                throw new CreateToException(CreateToException.CANNOT_OTHERBILL_AGENTBILL);
            }
            boolean isCreatePayPlan = baseInfo.getBoolean("isCreatePayPlanBill");
            if (baseInfo.isIsPaySchedule() || isCreatePayPlan) {
                throw new CreateToException(CreateToException.AGENT_BILL_PS);
            }
            if (baseInfo instanceof DailyLoanBillInfo) {
                AgentBillReverseHandler.checkBillCanCreate(ctx, isCreatePrePaymentBill, (DailyLoanBillInfo)baseInfo);
            }
            if (!baseInfo.getBoolean("isCreatePayBill")) {
                BillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreatePayBill", true);
            }
            if (AgentBillReverseHandler.getPayMentOperation(payAmount) && baseInfo.getState().equals((Object)StateEnum.CHECKED)) {
                AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
            }
        }
        if (Submit.equals(mode)) {
            if (AgentBillReverseHandler.getPayMentOperation(payAmount)) {
                payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, payEntryId);
                AgentBillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount, SubmitPay, RowNumber, agentPayBillInfo, paramMap);
                AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
            } else {
                if (baseInfo instanceof ExpenseAccountBillInfo) {
                    throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
                }
                payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, payEntryId);
                AgentBillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), SubmitReturn, RowNumber, agentPayBillInfo.getId().toString(), paramMap);
            }
        } else if (payment.equals(mode)) {
            if (!isPay) {
                AgentBillReverseHandler.checkSourceBillHasClose(ctx, baseInfo, RowNumber);
                if (!BizCollUtil.checkRepayDelVoucher(agentPayBillInfo.getId().toString(), ctx)) {
                    throw new BizCollException(BizCollException.PAYEXREPAY);
                }
                if (baseInfo instanceof ExpenseAccountBillInfo || baseInfo instanceof LoanBillInfo) {
                    ArrayList<AgentPayBillEntryInfo> agentPayEntries = new ArrayList<AgentPayBillEntryInfo>();
                    agentPayEntries.add(payEntryInfo);
                    AgentBillReverseHandler.handlePayEntry(ctx, baseInfo, agentPayBillInfo, "delPayEntry", agentPayEntries, isFromSingle);
                }
            } else if (baseInfo instanceof ExpenseAccountBillInfo || baseInfo instanceof LoanBillInfo) {
                ArrayList<AgentPayBillEntryInfo> agentPayEntries = new ArrayList<AgentPayBillEntryInfo>();
                agentPayEntries.add(payEntryInfo);
                AgentBillReverseHandler.handlePayEntry(ctx, baseInfo, agentPayBillInfo, "addPayEntry", agentPayEntries, isFromSingle);
            }
            if (AgentBillReverseHandler.getPayMentOperation(payAmount)) {
                if (isPay) {
                    if (StateEnum.ISPAYBILL.equals((Object)(baseInfo = AgentBillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, payEntryId), Pay, RowNumber, agentPayBillInfo, paramMap)).getState()) && baseInfo.getAmountNotPaid().compareTo(BizCollUtil.ZERO) == 0) {
                        if (isTm.booleanValue()) {
                            BizInvoicePoolUtil.updateIspayment(ctx, baseInfo, true);
                        }
                        AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ALREADYPAYMENT);
                        AgentBillReverseHandler.reWriteBillPayDate(iservice, baseInfo, new Date());
                    }
                    if (baseInfo instanceof ExpenseAccountBillInfo && BizCollUtil.checkPayBillCanNotCreateVoucher(ctx, baseInfo.getApplierCompany().getId().toString())) {
                        BizCollUtil.addAccountRecords(ctx, baseInfo, agentPayBillInfo.getId().toString(), payAmount, agentPayBillInfo.getPayerAccount());
                    }
                } else {
                    payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, payEntryId);
                    if (baseInfo instanceof ExpenseAccountBillInfo && BizCollUtil.checkPayBillCanNotCreateVoucher(ctx, baseInfo.getApplierCompany().getId().toString())) {
                        if (BizCollUtil.checkAccountRecordsHasAccounted(ctx, baseInfo, agentPayBillInfo.getId().toString())) {
                            if (RowNumber != null) {
                                throw new BizCollException(BizCollException.CANNOTREPAYHASACCOUNTEDWITHNUMBER, new Object[]{RowNumber});
                            }
                            throw new BizCollException(BizCollException.CANNOTREPAYHASACCOUNTED);
                        }
                        BizCollUtil.deleteAccountRecords(ctx, baseInfo, agentPayBillInfo.getId().toString());
                    }
                    if (baseInfo instanceof LoanBillInfo && baseInfo.getAmountBalance().add(payPrec).add(BizCollUtil.getReturenAmountCount(ctx, baseInfo, "", agentPayBillInfo.getId().toString())).compareTo(payAmount) < 0) {
                        if (RowNumber != null) {
                            throw new BizCollException(BizCollException.CANCELPAYCANNOTBIGGERTHANREALAMOUNTBALANCEWITHNUM, new Object[]{RowNumber});
                        }
                        throw new BizCollException(BizCollException.CANCELPAYCANNOTBIGGERTHANREALAMOUNTBALANCE);
                    }
                    if (StateEnum.ALREADYPAYMENT.equals((Object)(baseInfo = AgentBillReverseHandler.payHandler(ctx, iservice, baseInfo, payAmount, CancelPay, RowNumber, agentPayBillInfo, paramMap)).getState())) {
                        if (isTm.booleanValue()) {
                            BizInvoicePoolUtil.updateIspayment(ctx, baseInfo, false);
                        }
                        AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.ISPAYBILL);
                        AgentBillReverseHandler.reWriteBillPayDate(iservice, baseInfo, null);
                    }
                }
                iservice.updatePartial((CoreBaseInfo)baseInfo, AgentBillReverseHandler.getBillSic("pay"));
            } else {
                if (baseInfo instanceof ExpenseAccountBillInfo) {
                    throw new BizCollException(BizCollException.EXPENSECANOTRETURN);
                }
                payAmount = AgentBillReverseHandler.getAgentPayAmount(ctx, baseInfo, agentPayBillInfo, payAmount, payEntryId);
                baseInfo = isPay ? AgentBillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), Return, RowNumber, agentPayBillInfo.getId().toString(), paramMap) : AgentBillReverseHandler.returnHandler(ctx, iservice, (LoanBillInfo)baseInfo, payAmount.abs(), CancelReturn, RowNumber, agentPayBillInfo.getId().toString(), paramMap);
                iservice.updatePartial((CoreBaseInfo)baseInfo, AgentBillReverseHandler.getBillSic("return"));
            }
        } else if (Delete.equals(mode)) {
            AgentBillReverseHandler.checkSourceBillHasClose(ctx, baseInfo, RowNumber);
            if (AgentBillReverseHandler.getPayMentOperation(payAmount) && StateEnum.ISPAYBILL.equals((Object)baseInfo.getState()) && BizCollUtil.checkTracDownAgentbill(ctx, baseInfo.getId().toString(), "false") == 0 && BizCollUtil.checkTracDownPaybill(ctx, baseInfo.getId().toString(), "false") == 0) {
                AgentBillReverseHandler.reWriteBillState(iservice, baseInfo, StateEnum.CHECKED);
                AgentBillReverseHandler.updateBillProperty(ctx, baseInfo, "isCreatePayBill", false);
            }
        }
        return baseInfo;
    }

    @Deprecated
    public static BigDecimal getTotalEntAmount(BizCollBillBaseInfo baseInfo, AgentPayBillInfo agentPayBill, String payEntryId) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        BigDecimal tmpAmount = new BigDecimal("0.00");
        AgentPayBillEntryCollection payEntryCon = agentPayBill.getEntrys();
        boolean hasNullSrc = false;
        if (payEntryCon != null) {
            int size = payEntryCon.size();
            for (int i = 0; i < size; ++i) {
                if (payEntryCon.get(i).getSourceBillId() == null || payEntryCon.get(i).getSourceBillId().isEmpty() || payEntryId == null) {
                    hasNullSrc = true;
                }
                if (payEntryCon.get(i).getSourceBillId() != null && payEntryCon.get(i).getSourceBillId().equals(baseInfo.getId().toString()) && payEntryCon.get(i).getId().toString().equals(payEntryId)) {
                    tmpAmount = tmpAmount.add(payEntryCon.get(i).getAmount());
                }
                totalAmount = totalAmount.add(payEntryCon.get(i).getAmount());
            }
        }
        if (hasNullSrc) {
            return totalAmount;
        }
        return tmpAmount;
    }

    @Deprecated
    public static BigDecimal getAgentPayAmount(Context ctx, BizCollBillBaseInfo baseInfo, AgentPayBillInfo agentPayBill, BigDecimal payAmount, String payEntryId) throws EASBizException, BOSException {
        if (agentPayBill.getCurrency() != null && baseInfo.getCurrencyType() != null && baseInfo.getApplierCompany().getId() != null) {
            BigDecimal payAmountOri = AgentBillReverseHandler.getTotalEntAmount(baseInfo, agentPayBill, payEntryId);
            String payCurrencyId = agentPayBill.getCurrency().getId().toString();
            if (payCurrencyId != null && !payCurrencyId.equals(baseInfo.getCurrencyType().getId().toString())) {
                IObjectValue entryCoreBaseInfo = BizCollUtil.getEntryCoreBaseInfo(baseInfo, payCurrencyId);
                payAmount = BizCollUtil.getAmountByAmountOriAndInfo(ctx, baseInfo, entryCoreBaseInfo, payAmountOri, payCurrencyId);
            } else {
                payAmount = payAmountOri;
            }
            logger.error((Object)("---getPayAmount getTotalEntAmount payAmount=" + payAmount + ",payAmountOri=" + payAmountOri));
        }
        return payAmount.setScale(2, 4);
    }
}

