/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.image;

import com.kingdee.eas.cp.bc.ImageHandleTaskInfo;
import com.kingdee.eas.cp.bc.image.BaseImageInfo;
import com.kingdee.eas.cp.bc.image.BaseImageList;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.util.client.EASResource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.time.DateFormatUtils;

public class SSCImageUtils {
    public static final String TRAVEL_ACCOUNT_BILL = "TA";
    public static final String BIZ_ACCOUNT_BILL = "BA";
    public static final String DAILYACC_ACCOUNT_BILL = "DA";
    public static final String IMAGE_ALLOW_SCAN = "AllowScan";
    public static final String EXISTS_IMAGES = "Exists";
    public static final String NOT_DEAL = "0";
    public static final String HAS_DEAL = "1";
    public static final String DEAL_WAY = "NUMBER";
    private static String res = "com.kingdee.eas.cp.bc.CommonUtilResource";

    public static String getImageNo(String billNumber, String billType) {
        if (billNumber.length() > 2) {
            String prefix = billNumber.substring(0, 2);
            return prefix + billType + billNumber.substring(2);
        }
        return billType + billNumber;
    }

    public static String getBarCodeSpec(String imageNo) {
        return "*" + imageNo + "*";
    }

    public static Map getImageNoMap(BaseImageList baseList) {
        HashMap<String, HashSet> imageMap = new HashMap<String, HashSet>();
        BaseImageInfo imageInfo2 = null;
        String imageNo = null;
        String prefix = null;
        HashSet noSet = null;
        for (BaseImageInfo imageInfo2 : baseList.getImageList()) {
            imageNo = imageInfo2.getImageNo();
            prefix = SSCImageUtils.getPrefix(imageNo);
            if (!imageMap.containsKey(prefix)) {
                noSet = new HashSet();
                noSet.add(imageNo);
                imageMap.put(prefix, noSet);
                continue;
            }
            noSet = (HashSet)imageMap.get(prefix);
            noSet.add(imageNo);
        }
        return imageMap;
    }

    public static String getPrefix(String imageNo) {
        if (imageNo.indexOf(TRAVEL_ACCOUNT_BILL) > -1) {
            return TRAVEL_ACCOUNT_BILL;
        }
        if (imageNo.indexOf(BIZ_ACCOUNT_BILL) > -1) {
            return BIZ_ACCOUNT_BILL;
        }
        return "ERROR";
    }

    public static void addErrorImageList(BaseImageList baseList, BaseImageList newList, String clsName) {
        String imageNo = null;
        boolean exists = false;
        Iterator it1 = baseList.getImageList().iterator();
        while (it1.hasNext()) {
            exists = false;
            imageNo = ((BaseImageInfo)it1.next()).getImageNo();
            Iterator it2 = newList.getImageList().iterator();
            while (it2.hasNext()) {
                if (!imageNo.equals(((BaseImageInfo)it2.next()).getImageNo())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            try {
                BaseImageInfo imageInfo = (BaseImageInfo)Class.forName(clsName).newInstance();
                imageInfo.setImageNo(imageNo);
                newList.addImageList(imageInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getStrFromList(List list) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }

    public static String getStrFromSet(Set set) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        Iterator it = set.iterator();
        while (it.hasNext()) {
            sb.append("'");
            sb.append(it.next());
            sb.append("'");
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        if (set.size() > 0) {
            sb.append(")");
        } else {
            sb.append("'')");
        }
        return sb.toString();
    }

    public static String getStrFromArray(String[] arr) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int j = arr.length;
        for (int i = 0; i < j; ++i) {
            sb.append("'");
            sb.append(arr[i]);
            sb.append("'");
            if (i == j - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public static Date convertStr2Date(String dateStr) {
        try {
            SimpleDateFormat sdf = (SimpleDateFormat)MultilingualUtil.getDateTimeFormat();
            return sdf.parse(dateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject getTaskJosnObj(ImageHandleTaskInfo taskInfo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("taskId", (Object)taskInfo.getTaskId());
        jsonObj.put("taskHandler", (Object)taskInfo.getTaskHandler());
        String msg = new StringBuffer().append(EASResource.getString((String)res, (String)"imageNo")).append("[").append(taskInfo.getBarcode()).append("]").append(EASResource.getString((String)res, (String)"imageReadyInfo")).append(DateFormatUtils.format((Date)new Date(), (String)"yyyy-mm-dd hh:mm:ss")).toString();
        jsonObj.put("message", (Object)msg);
        return jsonObj;
    }

    public static JSONObject getImageJosnObj(String imageNo) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("imageNo", (Object)imageNo);
        return jsonObj;
    }
}

