/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.upgrade.datatask;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.bc.upgrade.datatask.IUpgradeAdapter;
import com.kingdee.eas.cp.bc.upgrade.datatask.UpgradeTaskSchedule;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UpgradeTaskParse
implements Callable<Boolean> {
    private static final Logger logger = Logger.getLogger(UpgradeTaskParse.class);
    private String taskId;
    private Context ctx;
    private Map upgradeParam;

    public UpgradeTaskParse(Context ctx, String taskId, Map upgradeParam) {
        this.taskId = taskId;
        this.ctx = ctx;
        this.upgradeParam = upgradeParam;
        UpgradeTaskSchedule.updateProcessMap(taskId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        boolean result = true;
        try {
            String upgradeAdapter = (String)this.upgradeParam.get("upgradeAdapter");
            IUpgradeAdapter billUpgradeAdapter = this.getBillUpgradeAdapter(upgradeAdapter);
            billUpgradeAdapter.upgrade(this.ctx, this.taskId, this.upgradeParam);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            UpgradeTaskSchedule.stopTask(this.taskId);
        }
        return result;
    }

    public IUpgradeAdapter getBillUpgradeAdapter(String upgradeAdapter) {
        IUpgradeAdapter billUpgradeAdapter = null;
        if (StringUtils.isBlank((String)upgradeAdapter)) {
            return billUpgradeAdapter;
        }
        try {
            Class<?> c = Class.forName(upgradeAdapter);
            billUpgradeAdapter = (IUpgradeAdapter)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return billUpgradeAdapter;
    }
}

