/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.upgrade.datatask;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.bc.upgrade.datatask.UpgradeTaskParse;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class UpgradeTaskSchedule {
    private static Logger logger = Logger.getLogger(UpgradeTaskSchedule.class);
    private static final ExecutorService exec = Executors.newCachedThreadPool();
    private static final ConcurrentHashMap<String, Object> taskMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Object> processMap = new ConcurrentHashMap();

    public static void addUpgradeTask(Context ctx, String taskId, Map upgradeParam) {
        if (taskMap.containsKey(taskId)) {
            return;
        }
        Future<Boolean> fu = exec.submit(new UpgradeTaskParse(ctx, taskId, upgradeParam));
        taskMap.putIfAbsent(taskId, fu);
    }

    public static void updateProcessMap(String taskId, Integer percent) {
        processMap.put(taskId, percent);
    }

    public static int getProcess(String taskId) {
        if (processMap.get(taskId) == null) {
            return 100;
        }
        return (Integer)processMap.get(taskId);
    }

    public static void stopTask(String taskId) {
        processMap.remove(taskId);
        taskMap.remove(taskId);
    }
}

