/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.ExpenseSortCollection;
import com.kingdee.eas.cp.bc.ExpenseSortFactory;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.FixExpenseAccountBillCollection;
import com.kingdee.eas.cp.bc.FixExpenseAccountBillFactory;
import com.kingdee.eas.cp.bc.FixExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.FixExpenseAccountEntryCollection;
import com.kingdee.eas.cp.bc.FixExpenseAccountEntryInfo;
import com.kingdee.eas.cp.bc.IExpenseSort;
import com.kingdee.eas.cp.bc.IFixExpenseAccountBill;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;

public class FixExpenseAccountAddByExcel
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.FixExpenseAccountAddByExcel");
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FAmount"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"amount"};
    String[] STRING_FIELDS = new String[]{"FTel", "FCause", "FName"};
    String[] STRING_OBJS = new String[]{"tel", "cause", "name"};
    String[] DATE_FIELDS = new String[]{"FHappenTime"};
    String[] DATE_OBJS = new String[]{"happenTime"};
    String[] ENUM_FIELDS = new String[]{"FState", "FPrior"};
    String[] ENUM_OBJS = new String[]{"state", "prior"};
    String[] DATE_FIELDS_EN = new String[]{"FHappenTime"};
    String[] DATE_OBJS_EN = new String[]{"happenTime"};
    String[] STRING_FIELDS_EN = new String[]{"FPurpose", "FComment"};
    String[] STRING_OBJS_EN = new String[]{"purpose", "comment"};
    private IObjectPK TEMPPK = null;
    private static String TEMPNUMBER = null;
    private static String DEFNUMBER = "####vanke2006####";
    private static String solution = "com.kingdee.eas.cp.bc.app.ExportFixExpenseAccountQuery";
    private static final String RES = "com.kingdee.eas.cp.bc.ImportDataResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return FixExpenseAccountBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase ipurReturns = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !ipurReturns.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.TEMPPK = ipurReturns.addnew(coreBaseInfo);
            } else {
                FixExpenseAccountBillInfo info = (FixExpenseAccountBillInfo)coreBaseInfo;
                ipurReturns.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        FixExpenseAccountBillInfo fixExpenseAccInfo = new FixExpenseAccountBillInfo();
        Object data = null;
        Object numberdata = ((DataToken)hsData.get((Object)"FNumber")).data;
        String str = null;
        if (numberdata == null) throw new TaskExternalException("number  not found!!!!");
        str = numberdata.toString();
        if (str == null || str.trim().length() <= 0) throw new TaskExternalException("number  not found!!!!");
        if (str.equals(TEMPNUMBER)) {
            try {
                IFixExpenseAccountBill iFixBill = FixExpenseAccountBillFactory.getLocalInstance(ctx);
                FixExpenseAccountBillInfo fixExpenseInfo = iFixBill.getFixExpenseAccountBillInfo(this.TEMPPK);
                if (fixExpenseInfo != null) {
                    fixExpenseAccInfo = fixExpenseInfo;
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
        } else {
            Object value;
            Object o;
            int i;
            fixExpenseAccInfo.setNumber(str);
            TEMPNUMBER = str;
            DateFormat formater = MultilingualUtil.getDateFormat();
            for (i = 0; i < this.DATE_FIELDS.length; ++i) {
                o = ((DataToken)hsData.get((Object)this.DATE_FIELDS[i])).data;
                if (o != null && o instanceof java.util.Date) {
                    value = (java.util.Date)o;
                    if (value == null) continue;
                    fixExpenseAccInfo.setDate(this.DATE_OBJS[i], (java.util.Date)value);
                    continue;
                }
                if (o == null || o.toString() != null) continue;
                throw new TaskExternalException(this.DATE_FIELDS[i] + " format error, it must be a date String, xxxx-xx-xx!!!");
            }
            for (i = 0; i < this.STRING_FIELDS.length; ++i) {
                o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
                if (o == null) continue;
                value = o.toString();
                fixExpenseAccInfo.setString(this.STRING_OBJS[i], (String)value);
            }
            data = ((DataToken)hsData.get((Object)"FPrior")).data;
            String value2 = null;
            if (data != null && (value2 = data.toString()) != null) {
                fixExpenseAccInfo.setPrior(this.getPriorValue(value2));
            }
            try {
                ICurrency icurreny;
                CompanyOrgUnitInfo info;
                ICompanyOrgUnit icompany;
                CompanyOrgUnitCollection collection;
                CostCenterOrgUnitInfo info2;
                FilterInfo filter;
                EntityViewInfo viewInfo;
                IUser iuser = UserFactory.getLocalInstance((Context)ctx);
                UserInfo userInfo = null;
                userInfo = iuser.getUserInfo(ctx.getCaller());
                fixExpenseAccInfo.setBiller(userInfo);
                PersonInfo personInfo = null;
                Object tempData = ((DataToken)hsData.get((Object)"FApplierName")).data;
                if (tempData == null) {
                    throw new TaskExternalException(EASResource.getString((String)RES, (String)"USER_NAME_NOT_NULL"));
                }
                str = tempData.toString();
                if (str != null && str.trim().length() > 0) {
                    IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                    PersonCollection perCollection = iPerson.getPersonCollection("where  name = '" + str + "'");
                    if (perCollection == null || perCollection.size() <= 0) throw new TaskExternalException(EASResource.getString((String)RES, (String)"NOT_EXIST_USERNAME"));
                    if (perCollection.size() > 1) {
                        throw new TaskExternalException(EASResource.getString((String)RES, (String)"EXIST_SAME_USERNAME"));
                    }
                    personInfo = perCollection.get(0);
                    if (personInfo != null) {
                        fixExpenseAccInfo.setApplier(personInfo);
                        IPersonFacade ipf = PersonFacadeFactory.getLocalInstance((Context)ctx);
                        AdminOrgUnitCollection aouc = ipf.getAdminOrgUnitByPerson(personInfo.getId());
                        AdminOrgUnitInfo aouInfo = null;
                        if (aouc != null && aouc.size() > 0) {
                            aouInfo = aouc.get(0);
                        }
                        fixExpenseAccInfo.setOrgUnit(aouInfo);
                        IPositionMember iPoMe = PositionMemberFactory.getLocalInstance((Context)ctx);
                        PositionMemberCollection poCol = iPoMe.getPositionsByPerson(personInfo.getId());
                        if (poCol != null && poCol.size() > 0) {
                            fixExpenseAccInfo.setPosition(poCol.get(0).getPosition());
                        }
                    }
                }
                if ((data = ((DataToken)hsData.get((Object)"FCostedDeptID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                    ICostCenterOrgUnit iCost = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0 or #1");
                    viewInfo.setFilter(filter);
                    CostCenterOrgUnitCollection costCollection = iCost.getCostCenterOrgUnitCollection(viewInfo);
                    if (costCollection == null || costCollection.size() <= 0) throw new TaskExternalException(EASResource.getString((String)RES, (String)"COSTDEPT_ERROR"));
                    info2 = costCollection.get(0);
                    if (personInfo != null) {
                        fixExpenseAccInfo.setCostedDept(info2);
                    }
                }
                if ((data = ((DataToken)hsData.get((Object)"FSortName")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                    FilterInfo filter2 = new FilterInfo();
                    filter2.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
                    filter2.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
                    filter2.setMaskString("#0 or #1");
                    IExpenseSort iSortName = ExpenseSortFactory.getLocalInstance(ctx);
                    ExpenseSortCollection exCollection = iSortName.getExpenseSortCollection("where (sortName ='" + str + "') and (" + filter2.toString() + ")");
                    if (exCollection != null && exCollection.size() > 0) {
                        ExpenseSortInfo info3 = exCollection.get(0);
                        if (info3 == null) throw new TaskExternalException(EASResource.getString((String)RES, (String)"SORT_NOT_EXIST"));
                        fixExpenseAccInfo.setSortName(info3);
                    }
                }
                if ((data = ((DataToken)hsData.get((Object)"FCompanyID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    fixExpenseAccInfo.setCompany(info);
                }
                if ((data = ((DataToken)hsData.get((Object)"FPayMent")).data) != null && (str = data.toString()) != null && str.trim().length() > 0) {
                    ISettlementType iSet = SettlementTypeFactory.getLocalInstance((Context)ctx);
                    viewInfo = new EntityViewInfo();
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("name", (Object)str, CompareType.EQUALS));
                    filter.setMaskString("#0 or #1");
                    viewInfo.setFilter(filter);
                    SettlementTypeCollection collection2 = iSet.getSettlementTypeCollection(viewInfo);
                    if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(EASResource.getString((String)RES, (String)"PAYMODE_ERROR"));
                    info2 = collection2.get(0);
                    if (info2 != null) {
                        fixExpenseAccInfo.setPayMode((SettlementTypeInfo)info2);
                    }
                }
                if ((data = ((DataToken)hsData.get((Object)"FCurrencyID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (icurreny = CurrencyFactory.getLocalInstance((Context)ctx)).getCurrencyCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    fixExpenseAccInfo.setCurrencyType((CurrencyInfo)info);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
            data = ((DataToken)hsData.get((Object)"FEntryNumber")).data;
            if (data != null) {
                str = data.toString();
                if (str != null) {
                    fixExpenseAccInfo.setEntryNumber(Integer.parseInt(str));
                } else {
                    fixExpenseAccInfo.setEntryNumber(0);
                }
            } else {
                fixExpenseAccInfo.setEntryNumber(0);
            }
            fixExpenseAccInfo.setBillTypeCode(BizCollBillTypeEnum.ALL);
            fixExpenseAccInfo.setState(StateEnum.DRAFT);
            fixExpenseAccInfo.setBizReqDate(new java.util.Date());
            fixExpenseAccInfo.setBillDate(new java.util.Date());
        }
        FixExpenseAccountEntryInfo entryInfo = null;
        boolean isUpdateEntry = false;
        data = ((DataToken)hsData.get((Object)"FSeq")).data;
        if (data != null && data.toString().trim().length() > 0) {
            int seq = Integer.parseInt(data.toString());
            FixExpenseAccountEntryCollection entryCollection = fixExpenseAccInfo.getEntries();
            int num = entryCollection.size();
            for (int i = 0; i < num; ++i) {
                FixExpenseAccountEntryInfo tempentryInfo = entryCollection.get(i);
                if (tempentryInfo.getSeq() != seq) continue;
                entryInfo = tempentryInfo;
                isUpdateEntry = true;
            }
            if (!isUpdateEntry) {
                entryInfo = new FixExpenseAccountEntryInfo();
                entryInfo.setBillID(fixExpenseAccInfo);
                entryInfo.setSeq(seq);
                entryCollection.add(entryInfo);
            }
        } else {
            FixExpenseAccountEntryCollection entryCollection = fixExpenseAccInfo.getEntries();
            int seq = entryCollection.size() + 1;
            entryInfo = new FixExpenseAccountEntryInfo();
            entryInfo.setBillID(fixExpenseAccInfo);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        }
        this.handleEntry(fixExpenseAccInfo, entryInfo, hsData, ctx);
        return fixExpenseAccInfo;
    }

    private void handleEntry(FixExpenseAccountBillInfo info, FixExpenseAccountEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        for (int i2 = 0; i2 < this.BIGDECIMAL_FIELDS_EN.length; ++i2) {
            try {
                BigDecimal value2;
                Object o2 = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS_EN[i2])).data;
                if (o2 == null || o2.toString().trim().length() <= 0 || (value2 = new BigDecimal(o2.toString())) == null) continue;
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i2], value2);
                BigDecimal tempValue = info.getAmount();
                if (tempValue != null) {
                    value2 = value2.add(tempValue);
                }
                info.setAmount(value2);
                info.setAmountApproved(value2);
                continue;
            }
            catch (NumberFormatException nex) {
                logger.error((Object)nex.getMessage());
                throw new TaskExternalException(this.BIGDECIMAL_OBJ_EN[i2] + " format error, it must be a number!!!");
            }
        }
        DateFormat df = MultilingualUtil.getDateFormat();
        for (i = 0; i < this.DATE_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS_EN[i])).data;
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                logger.error((Object)pex.getMessage());
                throw new TaskExternalException(this.DATE_FIELDS_EN[i] + " format error, it must be a date String, xxxx-xx-xx!!!current date is " + o.toString());
            }
            if (o == null || !(o instanceof java.util.Date) || (value = (java.util.Date)o) == null) continue;
            entryInfo.setDate(this.DATE_OBJS_EN[i], (java.util.Date)value);
        }
        for (i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data;
            if (o == null) continue;
            value = o.toString();
            entryInfo.setString(this.STRING_OBJS_EN[i], (String)value);
        }
    }

    private boolean getBooleanValue(String value) {
        return !(value = value.trim()).equalsIgnoreCase("N") && !value.equalsIgnoreCase("NO") && !value.equalsIgnoreCase("0");
    }

    private StateEnum getStateValue(String value) {
        StateEnum tSaved = StateEnum.CHECKED;
        if (value != null) {
            value = value.trim();
            List EnumList = StateEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                StateEnum stateEnum = (StateEnum)((Object)EnumList.get(i));
                String enumValue = String.valueOf(stateEnum.getValue());
                String enumName = stateEnum.getName();
                String enumAlias = stateEnum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = stateEnum;
                break;
            }
        }
        return tSaved;
    }

    private PriorEnum getPriorValue(String value) {
        PriorEnum tSaved = PriorEnum.LOW;
        if (value != null) {
            value = value.trim();
            List EnumList = PriorEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                PriorEnum priorenum = (PriorEnum)((Object)EnumList.get(i));
                String enumValue = String.valueOf(priorenum.getValue());
                String enumName = priorenum.getName();
                String enumAlias = priorenum.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = priorenum;
                break;
            }
        }
        return tSaved;
    }

    private UserInfo getUserFromNumber(IUser iuser, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    private FixExpenseAccountBillInfo checkExist(Context ctx, String billNumber) {
        FixExpenseAccountBillInfo billInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)billNumber, CompareType.EQUALS));
        filter.setMaskString("(#0 or #1) and #2");
        ev.setFilter(filter);
        try {
            IFixExpenseAccountBill iFixBill = FixExpenseAccountBillFactory.getLocalInstance(ctx);
            FixExpenseAccountBillCollection feCollection = iFixBill.getFixExpenseAccountBillCollection(ev);
            if (feCollection.size() == 1) {
                billInfo = feCollection.get(0);
            }
        }
        catch (BOSException e) {
            billInfo = null;
        }
        return billInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        DateFormat df = null;
        try {
            df = MultilingualUtil.getDateFormat(ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        try {
            if (!StringUtils.isEmpty((String)rs.getString("number"))) {
                result.put("FNumber", rs.getString("number"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("name"))) {
                result.put("FName", rs.getString("name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("applier.name"))) {
                result.put("FApplierName", rs.getString("applier.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("costedDept.name"))) {
                result.put("FCostedDeptID", rs.getString("costedDept.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("sortName.sortName"))) {
                result.put("FSortName", rs.getString("sortName.sortName"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("prior"))) {
                result.put("FPrior", rs.getString("prior"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("company.name"))) {
                result.put("FCompanyID", rs.getString("company.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("payMode.name"))) {
                result.put("FPayMent", rs.getString("payMode.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("currencyType.name"))) {
                result.put("FCurrencyID", rs.getString("currencyType.name"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("tel"))) {
                result.put("FTel", rs.getString("tel"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("cause"))) {
                result.put("FCause", rs.getString("cause"));
            }
            result.put("FEntryNumber", new Integer(rs.getInt("entryNumber")).toString());
            result.put("FSeq", new Integer(rs.getInt("entries.seq")).toString());
            if (!StringUtils.isEmpty((String)rs.getString("entries.purpose"))) {
                result.put("FPurpose", rs.getString("entries.purpose"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("entries.happenTime"))) {
                Date date = rs.getDate("entries.happenTime");
                result.put("FHappenTime", df.format(date));
            }
            if (rs.getBigDecimal("entries.amount") != null) {
                result.put("FAmount", rs.getBigDecimal("entries.amount"));
            }
            if (!StringUtils.isEmpty((String)rs.getString("entries.comment"))) {
                result.put("FComment", rs.getString("entries.comment"));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return super.getExportFilterForQuery(ctx);
    }

    public String getExportQueryInfo(Context ctx) {
        return solution;
    }
}

