/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.InvoiceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class InvoiceConfiguration {
    private static Logger logger = Logger.getLogger(InvoiceConfiguration.class);
    private static final String CONFIG_FILE = "cpbc_invoice_config.xml";
    protected static long lastModifiedDate = -1L;
    private String configFile;
    private boolean isInit;
    private String clienturl;
    private String clienturltest;
    private String invoiceUrl;
    private String updateInvoiceState;
    private String delInvoice;
    private String saveInvoice;
    private String saveCacheInvoice;
    private String env;
    private String showInvoice;
    private String invoiceType;
    private String delBillInvoice;
    private String timeOut;
    private String readTimeOut;
    private String checkTicket;
    private String accessToken;
    private String checkStates;
    private String authCode;
    private String apiPiaoZoneProd;
    private String apiPiaoZoneTest;
    private String cqShowInvoice;
    private String invoiceDetail;

    public static InvoiceConfiguration getInstance() {
        return Instance.configuration;
    }

    private InvoiceConfiguration() {
        this((String)null);
    }

    private InvoiceConfiguration(String configFile) {
        this.configFile = configFile;
        if (configFile == null || configFile.length() == 0) {
            String path = System.getProperty("EAS_HOME");
            this.configFile = path + "/server/properties/" + CONFIG_FILE;
        }
        this.init();
    }

    public void init() {
        try {
            boolean isHttp;
            Element root = this.getRoot(this.configFile);
            Element loginInfo = root.getChild("configitem");
            this.invoiceUrl = loginInfo.getChild("invoiceUrl").getText();
            this.env = loginInfo.getChild("env").getText();
            this.timeOut = loginInfo.getChild("timeOut").getText();
            Element readTimeOutEle = loginInfo.getChild("readTimeOut");
            this.readTimeOut = readTimeOutEle != null ? readTimeOutEle.getText() : this.timeOut;
            this.updateInvoiceState = "/m4/fpzs/expense/invoice/status/update";
            this.delInvoice = "/m4/fpzs/expense/invoice/del/entry";
            this.saveInvoice = "/m4/fpzs/expense/entry/save";
            this.saveCacheInvoice = "/m4/fpzs/expense/entry/cache";
            this.showInvoice = "/m4/fpzs/getUserKey";
            this.invoiceType = "/m4/fpzs/expense/query/invoicetype";
            this.delBillInvoice = "/m4/fpzs/expense/invoice/delexpense";
            this.checkTicket = "/m4/fpzs/expense/invoice/status/query";
            this.accessToken = "/base/oauth/token";
            this.checkStates = "/m4/bill/multiple/check/invoice/forexpense/submit";
            this.authCode = "/base/oauth/code";
            this.apiPiaoZoneProd = "https://api.piaozone.com";
            this.apiPiaoZoneTest = "https://api-dev.piaozone.com/test";
            boolean bl = isHttp = this.invoiceUrl.indexOf("https") == -1;
            if (isHttp) {
                this.apiPiaoZoneProd = "http://api.piaozone.com";
                this.apiPiaoZoneTest = "http://api-dev.piaozone.com/test";
            }
            this.cqShowInvoice = "/m4/fpzs/web/importedInvoices";
            this.invoiceDetail = "/m4/bill/fpzs/invoice/verificate/query";
            this.clienturl = "\u6807\u51c6\u5df2\u5e9f\u5f03\u4e0d\u7528\uff0c\u8bf7\u4e8c\u5f00InvoiceConfiguration\u91cd\u5199";
            this.clienturltest = "\u6807\u51c6\u5df2\u5e9f\u5f03\u4e0d\u7528\uff0c\u8bf7\u4e8c\u5f00InvoiceConfiguration\u91cd\u5199";
            this.isInit = true;
        }
        catch (Exception e) {
            this.isInit = false;
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private Element getRoot(String filePath) throws BOSException {
        InputStream is = null;
        try {
            Element root;
            is = new FileInputStream(new File(filePath));
            Document doc = XMLParser.parseXML((InputStream)is);
            Element element = root = doc.getRootElement();
            return element;
        }
        catch (FileNotFoundException e) {
            throw new BOSException("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u6587\u4ef6\uff1a" + this.configFile, (Throwable)e);
        }
        catch (JDOMException e) {
            throw new BOSException("\u914d\u7f6e\u6587\u4ef6\uff1acpbc_invoice_config.xml\u89e3\u6790\u9519\u8bef\uff1a" + e.getMessage());
        }
        catch (IOException e) {
            throw new BOSException("\u8bfb\u53d6\u6d88\u606f\u63a5\u53e3\u914d\u7f6e\u6587\u4ef6\uff1acpbc_invoice_config.xml\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void configChangeUpdateProperties() {
        try {
            File file = new File(this.configFile);
            if (lastModifiedDate != file.lastModified()) {
                Element root = this.getRoot(this.configFile);
                Element loginInfo = root.getChild("configitem");
                this.timeOut = loginInfo.getChild("timeOut").getText();
                Element readTimeOutEle = loginInfo.getChild("readTimeOut");
                this.readTimeOut = readTimeOutEle != null ? readTimeOutEle.getText() : this.timeOut;
                logger.error((Object)("##cpbc##cpbc_invoice_config is changed! timeOut:" + this.timeOut + ";readTimeOut:" + this.readTimeOut));
                lastModifiedDate = file.lastModified();
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public boolean isInitialize() throws EASBizException, BOSException {
        this.isInit();
        return this.isInit;
    }

    public String getInvoiceUrl() throws EASBizException, BOSException {
        this.isInit();
        return this.invoiceUrl;
    }

    public String getUpdateInvoiceState() throws EASBizException, BOSException {
        this.isInit();
        return this.updateInvoiceState;
    }

    public String getDelInvoice() throws EASBizException, BOSException {
        this.isInit();
        return this.delInvoice;
    }

    public String getSaveInvoice() throws EASBizException, BOSException {
        this.isInit();
        return this.saveInvoice;
    }

    public String getSaveCacheInvoice() throws EASBizException, BOSException {
        this.isInit();
        return this.saveCacheInvoice;
    }

    public String getShowInvoice() throws EASBizException, BOSException {
        this.isInit();
        return this.showInvoice;
    }

    public String getInvoiceType() throws EASBizException, BOSException {
        this.isInit();
        return this.invoiceType;
    }

    public String getDelBillInvoice() throws EASBizException, BOSException {
        this.isInit();
        return this.delBillInvoice;
    }

    public String getEnv() throws EASBizException, BOSException {
        this.isInit();
        return this.env;
    }

    public String getTimeOut() throws EASBizException, BOSException {
        this.isInit();
        this.configChangeUpdateProperties();
        return this.timeOut;
    }

    public String getReadTimeOut() throws EASBizException, BOSException {
        this.isInit();
        this.configChangeUpdateProperties();
        return this.readTimeOut;
    }

    public String getCheckTicket() throws EASBizException, BOSException {
        this.isInit();
        return this.checkTicket;
    }

    public String getAccessToken() throws EASBizException, BOSException {
        this.isInit();
        return this.accessToken;
    }

    public String getCheckStates() throws EASBizException, BOSException {
        this.isInit();
        return this.checkStates;
    }

    public String getAuthCode() throws EASBizException, BOSException {
        this.isInit();
        return this.authCode;
    }

    public void isInit() throws BOSException, EASBizException {
        if (!this.isInit) {
            throw new InvoiceException(InvoiceException.INITIALIZATIONERROR);
        }
    }

    public String getApiPiaoZoneProd() throws EASBizException, BOSException {
        this.isInit();
        return this.apiPiaoZoneProd;
    }

    public String getApiPiaoZoneTest() throws EASBizException, BOSException {
        this.isInit();
        return this.apiPiaoZoneTest;
    }

    public String getCqShowInvoice() throws EASBizException, BOSException {
        this.isInit();
        return this.cqShowInvoice;
    }

    public String getClienturl() {
        return this.clienturl;
    }

    public String getClienturltest() {
        return this.clienturltest;
    }

    public String getInvoiceDetail() {
        return this.invoiceDetail;
    }

    private static class Instance {
        private static InvoiceConfiguration configuration = new InvoiceConfiguration();

        private Instance() {
        }
    }
}

