/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.IOperationTypeCompanyEntry;
import com.kingdee.eas.cp.bc.IOperationTypeCostCenterEntry;
import com.kingdee.eas.cp.bc.OperationTypeCompanyEntryCollection;
import com.kingdee.eas.cp.bc.OperationTypeCompanyEntryFactory;
import com.kingdee.eas.cp.bc.OperationTypeCompanyEntryInfo;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryCollection;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryFactory;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryInfo;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OperationTypeUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.OperationTypeUtil");

    public static Map getOperationMappedCostcenter(IOperationTypeCostCenterEntry service, Set operationId, String companyId) throws BOSException {
        logger.error((Object)("############################cpbc runner  companId=" + companyId + "#####################################"));
        logger.error((Object)("############################cpbc runner  operationId=" + operationId + "#####################################"));
        OperationTypeCostCenterEntryCollection con = service.getOperationTypeCostCenterEntryCollection("select operationTypeId,costCenter.name where company.id='" + companyId + "' and operationTypeId in (" + BizCollUtil.convertSetToString(operationId) + ") order by operationTypeId");
        HashMap<String, String> costCenterNameMap = new HashMap<String, String>();
        String operationTypeId = null;
        int size = con.size();
        for (int i = 0; i < size; ++i) {
            if (operationTypeId == null || !costCenterNameMap.containsKey(con.get(i).getOperationTypeId())) {
                operationTypeId = con.get(i).getOperationTypeId();
                costCenterNameMap.put(operationTypeId, "");
            }
            costCenterNameMap.put(operationTypeId, OperationTypeUtil.relationStrSub(con.get(i).getCostCenter().getName() + ";" + costCenterNameMap.get(operationTypeId)));
        }
        return costCenterNameMap;
    }

    public static Map getOperationMappedCompany(IOperationTypeCompanyEntry service, Set operationId, String companyId) throws BOSException {
        CompanyOrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentFIUnit();
        String companyLongNumber = unitInfo.getLongNumber();
        StringBuilder sb = OperationTypeUtil.longNumberSplits(companyLongNumber);
        OperationTypeCompanyEntryCollection con = service.getOperationTypeCompanyEntryCollection("select operationTypeId,companyOrgUnit.name where (company.longNumber like '" + companyLongNumber + "!%' or company.number in (" + sb + ")) and operationTypeId in (" + BizCollUtil.convertSetToString(operationId) + ") order by operationTypeId");
        HashMap<String, String> companyNameMap = new HashMap<String, String>();
        String operationTypeId = null;
        int size = con.size();
        for (int i = 0; i < size; ++i) {
            if (operationTypeId == null || !companyNameMap.containsKey(con.get(i).getOperationTypeId())) {
                operationTypeId = con.get(i).getOperationTypeId();
                companyNameMap.put(operationTypeId, "");
            }
            companyNameMap.put(operationTypeId, OperationTypeUtil.relationStrSub(con.get(i).getCompanyOrgUnit().getName() + ";" + companyNameMap.get(operationTypeId)));
        }
        return companyNameMap;
    }

    public static String relationStrSub(String nameStr) {
        if (nameStr.indexOf(";") == nameStr.length() - 1) {
            nameStr = nameStr.substring(0, nameStr.length() - 1);
        }
        return nameStr;
    }

    public static StringBuilder longNumberSplits(String longnumber) {
        String[] numbers = StringUtils.split((String)longnumber, (String)"!");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numbers.length; ++i) {
            if (i < numbers.length - 1) {
                sb.append("'" + numbers[i] + "',");
                continue;
            }
            sb.append("'" + numbers[i] + "'");
        }
        return sb;
    }

    public static void deleteMappingByOperationId(IDataBase iCostService, String operationId, String companyId) throws EASBizException, BOSException {
        iCostService.delete("where company.id='" + companyId + "' and operationTypeId in(" + operationId + ")");
    }

    public static Set getOperLinkInfoSet(AbstractObjectCollection operationCostCon, String key, String operationId) {
        HashSet<String> linkCostCenterIdSet = new HashSet<String>();
        int size = operationCostCon.size();
        for (int i = 0; i < size; ++i) {
            if (!operationCostCon.getObject(i).getString("operationTypeId").equals(operationId)) continue;
            linkCostCenterIdSet.add(operationCostCon.getObject(i).getObjectValue(key).get("id").toString());
        }
        return linkCostCenterIdSet;
    }

    public static OperationTypeCostCenterEntryCollection getCostCenterEntry(IOperationTypeCostCenterEntry service, Set idSet, String CompanyId) throws BOSException {
        EntityViewInfo entView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("operationTypeId", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)CompanyId));
        entView.setFilter(filter);
        entView.setSelector(OperationTypeUtil.getCostEntrySelector());
        OperationTypeCostCenterEntryCollection operationCostCon = service.getOperationTypeCostCenterEntryCollection(entView);
        return operationCostCon;
    }

    public static OperationTypeCompanyEntryCollection getCompanyEntry(IOperationTypeCompanyEntry service, Set idSet, String CompanyId) throws BOSException {
        EntityViewInfo entView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("operationTypeId", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)CompanyId));
        entView.setFilter(filter);
        entView.setSelector(OperationTypeUtil.getCompanyEntrySelector());
        OperationTypeCompanyEntryCollection operationCompany = service.getOperationTypeCompanyEntryCollection(entView);
        return operationCompany;
    }

    public static SelectorItemCollection getCostEntrySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operationTypeId"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        return sic;
    }

    public static SelectorItemCollection getCompanyEntrySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operationTypeId"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        return sic;
    }

    public static SelectorItemCollection getOperationIdByComAndCost(String companyId, String costCenter) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operationTypeId"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        return sic;
    }

    public static Set getOperationTypeIdsByMapp(IOperationTypeCostCenterEntry service, Set idSet, String costCenterId, String companyId) throws BOSException {
        Set mappIds = OperationTypeUtil.getOperationTypeIdsWithMapp(service, costCenterId, companyId);
        Set noMappIds = OperationTypeUtil.getOperationTypeIdsWithOutMapp(service, idSet, companyId);
        mappIds.addAll(noMappIds);
        return mappIds;
    }

    @Deprecated
    public static Set getOperationTypeIdsByCompanyMapp(IOperationTypeCompanyEntry service, Set idSet, String companyId, List<String> numberList) throws BOSException, SQLException {
        Set mappIds = OperationTypeUtil.getOperationTypeIdsWithOutCompanyMapp(service, companyId, numberList);
        mappIds = OperationTypeUtil.getOperationTypeIdsWithCompanyMapp(service, mappIds, companyId);
        idSet.removeAll(mappIds);
        return idSet;
    }

    @Deprecated
    public static Set getOperationTypeIdsByCompanyMapp(IOperationTypeCompanyEntry service, String companyId, List<String> numberList) throws BOSException, SQLException {
        HashSet isSet = new HashSet();
        Set mappIds = OperationTypeUtil.getOperationTypeIdsWithOutCompanyMapp(service, companyId, numberList);
        mappIds = OperationTypeUtil.getOperationTypeIdsWithCompanyMapp(service, mappIds, companyId);
        return mappIds;
    }

    public static Set getOperationTypeIdsWithOutCompanyMapp(IOperationTypeCompanyEntry service, String companyId, List<String> numberList) throws BOSException {
        HashSet<String> isSet = new HashSet<String>();
        EntityViewInfo entView = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("OPERATIONTYPEID"));
        entView.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.number", new HashSet<String>(numberList), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("COMPANYORGUNIT.ID", (Object)companyId, CompareType.NOTEQUALS));
        entView.setFilter(filter);
        OperationTypeCompanyEntryCollection operationCompany = service.getOperationTypeCompanyEntryCollection(entView);
        int size = operationCompany.size();
        for (int i = 0; i < size; ++i) {
            isSet.add(operationCompany.get(i).getOperationTypeId());
        }
        return isSet;
    }

    public static Set getOperationTypeIdsWithCompanyMapp(IOperationTypeCompanyEntry service, Set mappIds, String companyId) throws BOSException {
        OperationTypeCompanyEntryCollection operationCompany = service.getOperationTypeCompanyEntryCollection("select operationTypeId where companyOrgUnit.id='" + companyId + "'");
        int size = operationCompany.size();
        for (int i = 0; i < size; ++i) {
            mappIds.remove(operationCompany.get(i).getOperationTypeId());
        }
        return mappIds;
    }

    public static Set getOperationIdsNotInCompany(Context ctx, String companyId, List<String> numberList) throws BOSException {
        Long startTime = System.currentTimeMillis();
        HashSet<String> notInSet = new HashSet<String>();
        StringBuilder queryOql = new StringBuilder();
        queryOql.append(" select distinct a.FOperationTypeId as FOperationTypeId from T_BC_OperationTypeCompanyEntry a \n");
        queryOql.append(" INNER JOIN T_ORG_COMPANY b ON a.FCompanyID = b.FID");
        queryOql.append(" and b.fnumber in (");
        int size = numberList.size();
        for (int j = 0; j < size; ++j) {
            queryOql.append("?,");
        }
        queryOql.deleteCharAt(queryOql.toString().length() - 1);
        queryOql.append(")");
        queryOql.append(" and a.FCompanyOrgUnitID != ? \n");
        queryOql.append(" LEFT OUTER JOIN T_BC_OperationTypeCompanyEntry c \n");
        queryOql.append(" on a.FOPERATIONTYPEID = c.FOPERATIONTYPEID and c.FCompanyOrgUnitID = ? \n");
        queryOql.append(" where c.fid is null");
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(numberList);
        params.add(companyId);
        params.add(companyId);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)queryOql.toString(), (Object[])params.toArray());
        try {
            while (result.next()) {
                notInSet.add(result.getString("FOperationTypeId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        Long endTime = System.currentTimeMillis();
        logger.error((Object)("cp.bc getOperationIdsNotInCompany finished companyId=" + companyId + ",time\uff1a" + (endTime - startTime) + "ms"));
        return notInSet;
    }

    public static Set getOperationTypeIdsWithMapp(IOperationTypeCostCenterEntry service, String costCenterId, String companyId) throws BOSException {
        HashSet<String> isSet = new HashSet<String>();
        OperationTypeCostCenterEntryCollection operationCostCon = service.getOperationTypeCostCenterEntryCollection("select operationTypeId where company.id='" + companyId + "' and costCenter.id='" + costCenterId + "'");
        int size = operationCostCon.size();
        for (int i = 0; i < size; ++i) {
            isSet.add(operationCostCon.get(i).getOperationTypeId());
        }
        return isSet;
    }

    public static Set getOperationTypeIdsWithOutMapp(IOperationTypeCostCenterEntry service, Set ids, String companyId) throws BOSException {
        Set idSet = new HashSet();
        idSet = ids;
        OperationTypeCostCenterEntryCollection operationCostCon = service.getOperationTypeCostCenterEntryCollection("select operationTypeId where company.id='" + companyId + "' and operationTypeId in(" + BizCollUtil.convertSetToString(ids) + ")");
        int size = operationCostCon.size();
        for (int i = 0; i < size; ++i) {
            if (!idSet.contains(operationCostCon.get(i).getOperationTypeId())) continue;
            idSet.remove(operationCostCon.get(i).getOperationTypeId());
        }
        return idSet;
    }

    @Deprecated
    public static void updateOperationTypeCostCenterLink(CostCenterOrgUnitCollection kdtEntries, OperationTypeInfo info, CoreBaseCollection costEntryCon, AbstractObjectCollection operationCostCon, boolean isCover) {
        CostCenterOrgUnitInfo costInfo = null;
        int rows = kdtEntries.size();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                costInfo = kdtEntries.get(i);
                if (!isCover && OperationTypeUtil.getOperLinkInfoSet(operationCostCon, "costCenter", info.getId().toString()).contains(costInfo.getId().toString())) continue;
                OperationTypeCostCenterEntryInfo operCostInfo = new OperationTypeCostCenterEntryInfo();
                operCostInfo.setOperationTypeId(info.getId().toString());
                operCostInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
                operCostInfo.setCostCenter(costInfo);
                costEntryCon.add((CoreBaseInfo)operCostInfo);
            }
        }
    }

    public static void updateOperationTypeCompanyLink(CompanyOrgUnitCollection kdtEntries, OperationTypeInfo info, CoreBaseCollection companytEntryCon, AbstractObjectCollection operationCompany, boolean isCover) {
        CompanyOrgUnitInfo companyInfo = null;
        int rows = kdtEntries.size();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                companyInfo = kdtEntries.get(i);
                if (!isCover && OperationTypeUtil.getOperLinkInfoSet(operationCompany, "companyOrgUnit", info.getId().toString()).contains(companyInfo.getId().toString())) continue;
                OperationTypeCompanyEntryInfo operCompanyInfo = new OperationTypeCompanyEntryInfo();
                operCompanyInfo.setOperationTypeId(info.getId().toString());
                operCompanyInfo.setCompany(SysContext.getSysContext().getCurrentFIUnit());
                operCompanyInfo.setCompanyOrgUnit(companyInfo);
                companytEntryCon.add((CoreBaseInfo)operCompanyInfo);
            }
        }
    }

    public static Map<String, Object> getOperLinkInfoMap(AbstractObjectCollection operationLinkCon, String key) {
        HashMap<String, Object> operLinkMap = new HashMap<String, Object>();
        if (operationLinkCon == null) {
            return operLinkMap;
        }
        String operationId = null;
        String linkId = null;
        Set<String> linkIdSet = null;
        int size = operationLinkCon.size();
        for (int i = 0; i < size; ++i) {
            operationId = operationLinkCon.getObject(i).getString("operationTypeId");
            if (StringUtils.isEmpty((String)operationId) || operationLinkCon.getObject(i).getObjectValue(key) == null) continue;
            linkId = operationLinkCon.getObject(i).getObjectValue(key).get("id").toString();
            if (operLinkMap.containsKey(operationId)) {
                linkIdSet = (Set)operLinkMap.get(operationId);
                linkIdSet.add(linkId);
                continue;
            }
            linkIdSet = new HashSet();
            linkIdSet.add(linkId);
            operLinkMap.put(operationId, linkIdSet);
        }
        return operLinkMap;
    }

    public static FilterInfo getOperationFilter(CompanyOrgUnitInfo companyInfo, CostCenterOrgUnitInfo costCenterInfo, String billType) {
        FilterInfo filter;
        block19: {
            String[] numbers = null;
            filter = new FilterInfo();
            try {
                HashSet<String> CUs = new HashSet<String>();
                if (BizCollUtil.objectIsNull(companyInfo)) {
                    return filter;
                }
                numbers = StringUtils.split((String)companyInfo.getLongNumber(), (String)"!");
                for (int i = 0; i < numbers.length; ++i) {
                    CUs.add(numbers[i]);
                }
                filter.getFilterItems().add(new FilterItemInfo("company.number", CUs, CompareType.INCLUDE));
                if (billType != null) {
                    EntityViewInfo operationView = new EntityViewInfo();
                    FilterInfo operationFilter = new FilterInfo();
                    MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.OperationTypeInitTreeQuery");
                    if (!billType.equals("query")) {
                        operationFilter.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE));
                    }
                    operationFilter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)billType));
                    operationFilter.getFilterItems().add(new FilterItemInfo("entry.isFilterControl", (Object)Boolean.TRUE));
                    operationView.setFilter(operationFilter);
                    IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
                    exec.setObjectView(operationView);
                    HashSet<String> operationIds = new HashSet<String>();
                    try {
                        IRowSet rowSet = exec.executeQuery();
                        while (rowSet.next()) {
                            operationIds.add(rowSet.getObject("operationType.id").toString());
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)e);
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                    }
                    FilterInfo filterTemp1 = new FilterInfo();
                    if (!billType.equals("query")) {
                        filterTemp1.getFilterItems().add(new FilterItemInfo("isEnable", (Object)Boolean.TRUE));
                    }
                    if (operationIds != null && operationIds.size() > 0) {
                        filterTemp1.getFilterItems().add(new FilterItemInfo("id", operationIds, CompareType.INCLUDE));
                    } else if (!billType.equals("query")) {
                        filterTemp1.getFilterItems().add(new FilterItemInfo("isEnable", (Object)Boolean.FALSE));
                    }
                    filter.mergeFilter(filterTemp1, "and");
                } else {
                    FilterInfo filterTemp1 = new FilterInfo();
                    filterTemp1.getFilterItems().add(new FilterItemInfo("isEnable", (Object)Boolean.TRUE));
                    filter.mergeFilter(filterTemp1, "and");
                }
                Set operationIdSet = new HashSet<String>();
                if (BizCollUtil.objectIsNull(costCenterInfo) || BizCollUtil.objectIsNull(companyInfo)) break block19;
                String costCenterId = costCenterInfo.getId().toString();
                String companyId = companyInfo.getId().toString();
                EntityViewInfo evi = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                evi.setSelector(sic);
                MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.OperationTypeQuery");
                evi.setFilter(filter);
                IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
                exec.setObjectView(evi);
                IRowSet rowSet = exec.executeQuery();
                try {
                    while (rowSet.next()) {
                        operationIdSet.add(rowSet.getString("id"));
                    }
                    operationIdSet = OperationTypeUtil.getOperationTypeIdsByMapp(OperationTypeCostCenterEntryFactory.getRemoteInstance(), operationIdSet, costCenterId, companyId);
                    if (operationIdSet.size() > 0) {
                        FilterInfo tempFilter = new FilterInfo();
                        tempFilter.getFilterItems().add(new FilterItemInfo("operationType.id", operationIdSet, CompareType.INCLUDE));
                        filter.mergeFilter(tempFilter, "and");
                        break block19;
                    }
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("operationType.id", (Object)"-1", CompareType.EQUALS));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            catch (BOSException e1) {
                logger.error((Object)e1.getMessage());
            }
        }
        return filter;
    }

    public static FilterInfo getExpenseTypeFilter(CompanyOrgUnitInfo companyInfo, CostCenterOrgUnitInfo costCenterInfo, OperationTypeInfo operationTypeInfo, String billType) {
        FilterInfo retFilterInfo = new FilterInfo();
        List<String> numberList = null;
        try {
            if (billType != null) {
                retFilterInfo.mergeFilter(OperationTypeUtil.getExpenseTypeCommonFilter(companyInfo, billType), "and");
            }
            if (!BizCollUtil.objectIsNull(costCenterInfo)) {
                String[] numbers;
                String costCenterId = costCenterInfo.getId().toString();
                String companyId = null;
                if (!BizCollUtil.objectIsNull(companyInfo)) {
                    companyId = companyInfo.getId().toString();
                    numbers = StringUtils.split((String)companyInfo.getLongNumber(), (String)"!");
                    numberList = Arrays.asList(numbers);
                } else if (SysContext.getSysContext().getCurrentFIUnit() != null) {
                    companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
                    numbers = StringUtils.split((String)companyInfo.getLongNumber(), (String)"!");
                    numberList = Arrays.asList(numbers);
                }
                EntityViewInfo evi = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("operationType.id"));
                evi.setSelector(sic);
                MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.F7ExpenseTypeQuery");
                evi.setFilter(retFilterInfo);
                IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
                exec.setObjectView(evi);
                IRowSet rowSet = exec.executeQuery();
                Set operationIdSet = new HashSet<String>();
                try {
                    while (rowSet.next()) {
                        operationIdSet.add(rowSet.getString("operationType.id"));
                    }
                    if (operationIdSet.size() > 0) {
                        operationIdSet = OperationTypeUtil.getOperationTypeIdsByMapp(OperationTypeCostCenterEntryFactory.getRemoteInstance(), operationIdSet, costCenterId, companyId);
                        operationIdSet = OperationTypeUtil.getOperationTypeIdsByCompanyMapp(OperationTypeCompanyEntryFactory.getRemoteInstance(), operationIdSet, companyId, numberList);
                        if (operationIdSet.size() > 0) {
                            FilterInfo tempFilter = new FilterInfo();
                            tempFilter.getFilterItems().add(new FilterItemInfo("operationType.id", operationIdSet, CompareType.INCLUDE));
                            retFilterInfo.mergeFilter(tempFilter, "and");
                        } else {
                            FilterInfo tempFilter = new FilterInfo();
                            tempFilter.getFilterItems().add(new FilterItemInfo("operationType.id", (Object)"-1", CompareType.EQUALS));
                            retFilterInfo.mergeFilter(tempFilter, "and");
                        }
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            FilterInfo tempFilter = new FilterInfo();
            if (!BizCollUtil.objectIsNull(operationTypeInfo)) {
                tempFilter.getFilterItems().add(new FilterItemInfo("operationType.id", (Object)operationTypeInfo.getId().toString(), CompareType.EQUALS));
                retFilterInfo.mergeFilter(tempFilter, "and");
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return retFilterInfo;
    }

    public static FilterInfo getExpenseTypeCommonFilter(CompanyOrgUnitInfo companyInfo, String billType) {
        FilterInfo retFilterInfo = new FilterInfo();
        String companyId = null;
        String companyLongName = null;
        if (!BizCollUtil.objectIsNull(companyInfo)) {
            companyId = companyInfo.getId().toString();
            companyLongName = companyInfo.getLongNumber();
        } else if (SysContext.getSysContext().getCurrentFIUnit() != null) {
            companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            companyLongName = SysContext.getSysContext().getCurrentFIUnit().getLongNumber();
        }
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
            retFilterInfo.mergeFilter(filterInfo, "and");
            if (!BizCollUtil.objectIsNull(companyId)) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
                if (companyLongName != null) {
                    String[] lnSecs = companyLongName.split("!");
                    int size = lnSecs.length;
                    HashSet<String> lnUps = new HashSet<String>();
                    for (int i = 0; i < size; ++i) {
                        lnUps.add(lnSecs[i]);
                    }
                    if (lnUps.size() != 0) {
                        filterInfo.getFilterItems().add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
                        filterInfo.setMaskString("#0 or #1");
                    }
                }
                retFilterInfo.mergeFilter(filterInfo, "and");
            }
            if (!BizCollUtil.objectIsNull(billType)) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("billType.number", (Object)billType, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("entry.isFilterControl", (Object)Boolean.TRUE));
                retFilterInfo.mergeFilter(filterInfo, "and");
                FilterInfo filterTemp = new FilterInfo();
                String expenseTypeIdSql = BizCollUtil.getExpenseTypeIdQuerySql(billType);
                filterTemp.getFilterItems().add(new FilterItemInfo("id in ( " + expenseTypeIdSql + " )"));
                retFilterInfo.mergeFilter(filterTemp, "and");
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return retFilterInfo;
    }
}

