/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.de.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfo;
import com.kingdee.eas.base.attachment.common.ComplexAttachmentInfoSelector;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.attachment.util.Resrcs;
import com.kingdee.eas.base.attachment.util.StringUtil4File;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.de.web.AttechInfoBean;
import com.kingdee.eas.cp.eip.de.web.DAO;
import com.kingdee.eas.cp.eip.de.web.DocumentAttechment;
import com.kingdee.eas.cp.eip.de.web.DocumentBody;
import com.kingdee.eas.cp.eip.de.web.DocumentUrl;
import com.kingdee.eas.cp.eip.de.web.FileHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.Uuid;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class DocumentDAO
extends DAO {
    private static Logger logger = Logger.getLogger((String)DocumentDAO.class.getName());

    public DocumentBody loadDocBody(DocumentBody docBody) {
        if (docBody == null) {
            return null;
        }
        String id = null;
        try {
            id = this.getAttIdByUuid(docBody.getUuid(), "b");
            docBody.setBodyId(id);
            docBody.setContent(this.getByteArrContent(id));
        }
        catch (Exception e) {
            logger.error((Object)("loadDocBody error:" + e.getMessage()));
        }
        return docBody;
    }

    public DocumentAttechment loadAttech(DocumentAttechment docAttech, boolean isSaveToFile) {
        if (docAttech == null) {
            return null;
        }
        String attechLoadTempPath = null;
        String attechId = docAttech.getAttechId();
        boolean isMustZip = false;
        long tempFileSize = 0L;
        Object attechContend = null;
        FileHandler fileHandler = new FileHandler();
        try {
            docAttech = this.getAttechInfo(docAttech.getUuid(), attechId);
            if (isSaveToFile) {
                isMustZip = fileHandler.getIsMustZip(docAttech.getFileSize());
                attechLoadTempPath = fileHandler.getTempFileName(docAttech.getFileName());
                tempFileSize = this.loadAttechToFile(attechId, attechLoadTempPath, isMustZip, docAttech.getFileSize());
                docAttech.setZip(isMustZip);
                docAttech.setTempFileSize(tempFileSize);
                docAttech.setTempFilePath(attechLoadTempPath);
            } else {
                docAttech.setContent(this.getByteArrContent(attechId));
            }
        }
        catch (Exception e) {
            logger.error((Object)("loadAttech error:" + e.getMessage()));
        }
        return docAttech;
    }

    private byte[] getByteArrContent(String attechId) throws EASBizException, BOSException {
        if (attechId == null) {
            return null;
        }
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.context);
        ComplexAttachmentInfo info = asm.getComplexAttachmentInfo(attechId);
        return info.getContent();
    }

    private long loadAttechToFile(String attechId, String loadPath, boolean isZip, long fileSize) throws EASBizException, BOSException {
        if (attechId == null) {
            return 0L;
        }
        long tempFileSize = 0L;
        Object saveFileName = null;
        ByteArrayInputStream in = null;
        FileHandler fileHander = new FileHandler();
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.context);
        ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
        cais.needID();
        cais.needContent();
        ComplexAttachmentInfo info = asm.getComplexAttachmentInfo(attechId, cais);
        in = new ByteArrayInputStream(info.getContent());
        tempFileSize = isZip ? fileHander.saveFile(in, loadPath) : fileHander.saveFile(in, loadPath, fileSize);
        return tempFileSize;
    }

    public boolean saveDocBodyInfo(DocumentBody docBody) {
        if (docBody == null) {
            return false;
        }
        try {
            String id = this.getAttIdByUuid(docBody.getUuid(), "b");
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.context);
            SimpleAttachmentInfo info = new SimpleAttachmentInfo();
            info.setContent(docBody.getContent());
            info.setMainName("docBody_" + Uuid.create().toString());
            info.setExtName("b");
            if (id == null) {
                asm.addNewAttachment(this.context, docBody.getUuid(), info);
            } else {
                asm.updateAttachmentContent(id, docBody.getContent());
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("method :saveDocBodyInfo() error..\uff1a" + e.getMessage()));
            return false;
        }
    }

    private String getAttIdByUuid(String uuid, String docType) {
        if (uuid == null || "".equals(uuid.trim())) {
            return null;
        }
        String id = null;
        Object info = null;
        try {
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.context);
            ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
            cais.needID();
            cais.needExtName();
            String[] idArray = asm.getAttachmentIDsByBoID(uuid);
            ComplexAttachmentInfo cmAttachinfo = null;
            if (idArray != null && idArray.length > 0) {
                for (int i = 0; i < idArray.length; ++i) {
                    cmAttachinfo = asm.getComplexAttachmentInfo(idArray[i], cais);
                    if (!docType.equals(cmAttachinfo.getExtName())) continue;
                    return cmAttachinfo.getId();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return id;
    }

    public DocumentAttechment saveDocAttech(DocumentAttechment docAttech) throws Exception {
        if (docAttech == null) {
            return null;
        }
        String attechId = docAttech.getAttechId();
        try {
            this.saveAttech(docAttech);
            DocumentAttechment attechment = this.getAttechInfo(docAttech.getUuid(), docAttech.getAttechId());
            docAttech.setFileName(attechment.getFileName());
            docAttech.setFileSize(attechment.getFileSize());
            docAttech.setLastUpdate(attechment.getLastUpdate());
            docAttech.setAttechId(attechment.getAttechId());
        }
        catch (Exception e) {
            logger.error((Object)("saveDocAttech error:" + e.getMessage()));
            docAttech = null;
            throw new Exception(e);
        }
        return docAttech;
    }

    private void saveAttech(DocumentAttechment docAttech) throws Exception {
        File file = null;
        FileInputStream fis = null;
        String attachID = null;
        try {
            file = new File(docAttech.getTempFilePath());
            fis = new FileInputStream(file);
            byte[] bt = new byte[(int)file.length()];
            fis.read(bt);
            SimpleAttachmentInfo sAttach = new SimpleAttachmentInfo();
            sAttach.setContent(bt);
            sAttach.setMainName(StringUtil4File.getMainFileName((String)docAttech.getFileName()));
            sAttach.setExtName(StringUtil4File.getExtendedFileName((String)docAttech.getFileName()));
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.context);
            if (docAttech.getAttechId() == null) {
                Object pk = null;
                String sql = "select FID from t_bas_attachment where fname_" + DocumentDAO.getLoc(this.context) + " = '" + sAttach.getMainName() + "'";
                IRowSet set = DbUtil.executeQuery((Context)this.context, (String)sql);
                String fname = sAttach.getMainName();
                if (set != null && set.size() > 0) {
                    sql = "select fname_" + DocumentDAO.getLoc(this.context) + " as fname from t_bas_attachment where fname_" + DocumentDAO.getLoc(this.context) + " like '" + sAttach.getMainName() + "(%)' order by fname desc";
                    set = DbUtil.executeQuery((Context)this.context, (String)sql);
                    if (set.next()) {
                        fname = set.getString("fname");
                    }
                    fname = DocumentDAO.getNewFileName(fname);
                    sAttach.setMainName(fname);
                    attachID = asm.addNewAttachment(this.context, docAttech.getUuid(), sAttach);
                } else {
                    attachID = asm.addNewAttachment(this.context, docAttech.getUuid(), sAttach);
                }
                docAttech.setAttechId(attachID);
            } else {
                asm.updateAttachmentContent(docAttech.getAttechId(), bt);
            }
        }
        catch (Exception e) {
            logger.error((Object)("saveAttech error" + e.getMessage()));
            throw new Exception(e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (file != null) {
                    file.delete();
                }
            }
            catch (Exception e) {
                logger.error((Object)("close stream error" + e.getMessage()));
            }
        }
    }

    public DocumentAttechment getAttechInfo(String uuid, String attechId) throws EASBizException, BOSException {
        DocumentAttechment docAttech = new DocumentAttechment();
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.context);
        ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
        cais.needID();
        cais.needMainName();
        cais.needExtName();
        cais.needSizeInByte();
        cais.needUpdateTime();
        ComplexAttachmentInfo info = asm.getComplexAttachmentInfo(attechId, cais);
        docAttech.setUuid(uuid);
        docAttech.setFileName(info.getMainName() + "." + info.getExtName());
        docAttech.setFileSize(info.getSizeInByte());
        docAttech.setLastUpdate(info.getUpdateTime());
        docAttech.setAttechId(attechId);
        return docAttech;
    }

    public boolean deleteAttechment(DocumentAttechment docAttechment) {
        if (docAttechment == null) {
            logger.warn((Object)"docAttechment is null");
            return false;
        }
        AttachmentServerManager asm = null;
        try {
            asm = AttachmentManagerFactory.getServerManager((Context)this.context);
            asm.deleteOneAssociation(docAttechment.getUuid(), docAttechment.getAttechId());
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("deleteAttechment error\uff1a" + e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector loadList(String uuid) {
        Vector<AttechInfoBean> docList = new Vector<AttechInfoBean>();
        try {
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.context);
            ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
            cais.needID();
            cais.needMainName();
            cais.needExtName();
            cais.needSizeInByte();
            cais.needUpdateTime();
            String[] idArray = asm.getAttachmentIDsByBoID(uuid);
            AttechInfoBean info = null;
            ComplexAttachmentInfo cmAttachinfo = null;
            if (idArray != null && idArray.length > 0) {
                for (int i = 0; i < idArray.length; ++i) {
                    cmAttachinfo = asm.getComplexAttachmentInfo(idArray[i], cais);
                    if ("b".equals(cmAttachinfo.getExtName())) continue;
                    info = new AttechInfoBean();
                    info.setUuid(uuid);
                    info.setId(cmAttachinfo.getId());
                    if (!"url".equals(cmAttachinfo.getExtName())) {
                        info.setAttechName(cmAttachinfo.getMainName() + "." + cmAttachinfo.getExtName());
                        info.setAttechSize(cmAttachinfo.getSizeInByte());
                        info.setUrl(null);
                        info.setAttechType("a");
                    } else {
                        info.setUrl(cmAttachinfo.getMainName());
                        info.setAttechType("u");
                    }
                    info.setLastUpdate(cmAttachinfo.getUpdateTime());
                    docList.add(info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("loadList error:" + e.getMessage()));
            docList = null;
        }
        return docList;
    }

    public String saveDocUrl(DocumentUrl docUrl) {
        if (docUrl == null) {
            return null;
        }
        String urlId = docUrl.getId();
        try {
            String id = docUrl.getId();
            ObjectUuidPK pk = null;
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.context);
            SimpleAttachmentInfo info = new SimpleAttachmentInfo();
            info.setMainName(docUrl.getUrl());
            info.setExtName("url");
            if (id == null) {
                String sql = "select FID from t_bas_attachment where fname_l2 = '" + info.getMainName() + "' or fname_l2 ='" + info.getMainName() + "'";
                IRowSet set = DbUtil.executeQuery((Context)this.context, (String)sql);
                if (set != null && set.size() > 0) {
                    String fid = "";
                    while (set.next()) {
                        urlId = set.getString("FID");
                    }
                    pk = new ObjectUuidPK(BOSUuid.read((String)urlId));
                    AttachmentInfo attachInfo = AttachmentFactory.getLocalInstance((Context)this.context).getAttachmentInfo((IObjectPK)pk);
                    attachInfo.getBoAttchAsso().add(DocumentDAO.makeBoAttchAssoInfo(docUrl.getUuid()));
                    AttachmentFactory.getLocalInstance((Context)this.context).save((CoreBaseInfo)attachInfo);
                    return urlId;
                }
                urlId = asm.addNewAttachment(this.context, docUrl.getUuid(), info);
            } else {
                asm.updateAttachmentMainName(docUrl.getUuid(), docUrl.getId(), docUrl.getUrl());
            }
        }
        catch (Exception e) {
            logger.error((Object)("saveDocUrl error\uff1a" + e.getMessage()));
        }
        return urlId;
    }

    public DocumentUrl loadDocUrl(DocumentUrl docUrl) {
        if (docUrl == null) {
            return null;
        }
        try {
            AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)this.context);
            ComplexAttachmentInfoSelector cais = new ComplexAttachmentInfoSelector();
            cais.needID();
            cais.needMainName();
            ComplexAttachmentInfo info = asm.getComplexAttachmentInfo(docUrl.getId(), cais);
            docUrl.setUrl(info.getMainName());
        }
        catch (Exception e) {
            logger.error((Object)("loadDocUrl error:" + e.getMessage()));
        }
        return docUrl;
    }

    public boolean deleteDocUrl(DocumentUrl docUrl) {
        if (docUrl == null) {
            logger.warn((Object)"docUrl is null");
            return false;
        }
        AttachmentServerManager asm = null;
        try {
            asm = AttachmentManagerFactory.getServerManager((Context)this.context);
            asm.deleteOneAssociation(docUrl.getUuid(), docUrl.getId());
            return true;
        }
        catch (Exception e) {
            logger.error((Object)("deleteDocUrl error\uff1a" + e.getMessage()));
            return false;
        }
    }

    public static BoAttchAssoInfo makeBoAttchAssoInfo(String boID) {
        BoAttchAssoInfo baai = new BoAttchAssoInfo();
        baai.setBoID(boID);
        baai.setAssoType(Resrcs.getString((String)"NewAttachment"));
        baai.setAssoBusObjType(BOSUuid.read((String)boID).getType().toString());
        return baai;
    }

    private static String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private static String getNewFileName(String fileName) {
        String newFileName;
        int i = fileName.lastIndexOf("(");
        int ii = fileName.lastIndexOf(")");
        if (i >= 0 && ii >= 0) {
            String tempStr = fileName.substring(i + 1, ii);
            if (DocumentDAO.isInteger(tempStr)) {
                int index = Integer.valueOf(tempStr);
                newFileName = fileName.substring(0, i + 1) + String.valueOf(++index) + ")";
            } else {
                newFileName = fileName + "(1)";
            }
        } else {
            newFileName = fileName + "(1)";
        }
        return newFileName;
    }

    public static boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

