/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.mc;

import com.kingdee.eas.cp.mc.shape.Circle;
import com.kingdee.eas.cp.mc.shape.Polygon;
import com.kingdee.eas.cp.mc.shape.Rectangle;
import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class MapGenerator {
    private static Logger logger = Logger.getLogger((String)MapGenerator.class.getName());

    public static String loadGenMapData(String path, File file, String portalContextPath) {
        return MapGenerator.loadGenMapData(path, path, file, portalContextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadGenMapData(String path, String etagname, File file, String portalContextPath) {
        if (path.equals("") || file == null) {
            return "";
        }
        FileInputStream fileIn = null;
        ObjectInputStream in = null;
        try {
            fileIn = new FileInputStream(file);
            in = new ObjectInputStream(fileIn);
            Object obj = in.readObject();
            List list = null;
            if (obj != null && obj instanceof List) {
                list = (List)obj;
            }
            if (list != null) {
                String string = MapGenerator.generaterHtml(path, etagname, list, portalContextPath);
                return string;
            }
        }
        catch (FileNotFoundException e) {
            logger.info((Object)("cann't find file " + file));
        }
        catch (InvalidClassException e) {
            logger.info((Object)(file + " \u7248\u672c\u5e8f\u5217\u5316\u9519\u8bef "));
        }
        catch (IOException e) {
            logger.info((Object)(" \u7248\u672c\u5e8f\u5217\u5316\u9519\u8bef " + e));
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return "";
    }

    public static String loadGenMapData(String path, URL url) {
        try {
            ObjectInputStream in = new ObjectInputStream(url.openStream());
            Object obj = in.readObject();
            List list = null;
            if (obj != null && obj instanceof List) {
                list = (List)obj;
            }
            if (list != null) {
                return MapGenerator.generaterHtml(path, list);
            }
        }
        catch (FileNotFoundException e) {
            logger.info((Object)("cann't find file " + url));
        }
        catch (InvalidClassException e) {
            logger.info((Object)(url + " \u7248\u672c\u5e8f\u5217\u5316\u9519\u8bef "));
        }
        catch (IOException e) {
            logger.info((Object)(" \u7248\u672c\u5e8f\u5217\u5316\u9519\u8bef " + e));
        }
        catch (ClassNotFoundException e) {
            logger.info((Object)("Cann't find class from " + url));
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        return "";
    }

    public static String generaterHtml(String imageName, List shapes, String portalContextPath) {
        return MapGenerator.generaterHtml(imageName, imageName, shapes, portalContextPath);
    }

    public static String generaterHtml(String imageName, String etagename, List shapes, String portalContextPath) {
        int height = 0;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<img src=\"").append(etagename).append("\" usemap=\"#" + imageName + "\" alt=\"\" style=\"border-style:none\" ></img>").append("\n\n");
        height += 2;
        buffer.append("<map id=\"" + imageName + "\" name=\"" + imageName + "\">\n");
        ++height;
        for (Object o : shapes) {
            if (o instanceof Rectangle) {
                Rectangle rect = (Rectangle)o;
                buffer.append("<area shape=\"rect\" coords=\"");
                buffer.append(rect.getX()).append(",").append(rect.getY()).append(",").append(rect.getX() + rect.getWidth()).append(",");
                buffer.append(rect.getY() + rect.getHeight()).append("\" ").append(rect.getAttribute().generateHtmlCode(portalContextPath)).append("></area>\n");
                continue;
            }
            if (o instanceof Circle) {
                Circle circle = (Circle)o;
                buffer.append("<area shape=\"circle\" coords=\"");
                buffer.append(circle.getCenter().x).append(",").append(circle.getCenter().y).append(",").append(circle.getRadius());
                buffer.append("\" ").append(circle.getAttribute().generateHtmlCode(portalContextPath)).append("></area>\n");
                continue;
            }
            if (!(o instanceof Polygon)) continue;
            Polygon polygon = (Polygon)o;
            buffer.append("<area shape=\"poly\" coords=\"");
            int[] x = polygon.getXPoints();
            int[] y = polygon.getYPoints();
            for (int i = 0; i < polygon.getNPoints(); ++i) {
                buffer.append(String.valueOf(x[i])).append(",").append(String.valueOf(y[i])).append(" ");
            }
            buffer.append("\" ").append(polygon.getAttribute().generateHtmlCode(portalContextPath)).append("></area>\n");
            ++height;
        }
        buffer.append("</map>");
        ++height;
        return buffer.toString();
    }

    public static String generaterHtml(String imageName, List shapes) {
        int height = 0;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<img src=\"").append(imageName).append("\" usemap=\"#" + imageName + "\" alt=\"\" style=\"border-style:none\" ></img>").append("\n\n");
        height += 2;
        buffer.append("<map id=\"" + imageName + "\" name=\"" + imageName + "\">\n");
        ++height;
        for (Object o : shapes) {
            if (o instanceof Rectangle) {
                Rectangle rect = (Rectangle)o;
                buffer.append("<area shape=\"rect\" coords=\"");
                buffer.append(rect.getX()).append(",").append(rect.getY()).append(",").append(rect.getX() + rect.getWidth()).append(",");
                buffer.append(rect.getY() + rect.getHeight()).append("\" ").append(rect.getAttribute().generateHtmlCode()).append("></area>\n");
                continue;
            }
            if (o instanceof Circle) {
                Circle circle = (Circle)o;
                buffer.append("<area shape=\"circle\" coords=\"");
                buffer.append(circle.getCenter().x).append(",").append(circle.getCenter().y).append(",").append(circle.getRadius());
                buffer.append("\" ").append(circle.getAttribute().generateHtmlCode()).append("></area>\n");
                continue;
            }
            if (!(o instanceof Polygon)) continue;
            Polygon polygon = (Polygon)o;
            buffer.append("<area shape=\"poly\" coords=\"");
            int[] x = polygon.getXPoints();
            int[] y = polygon.getYPoints();
            for (int i = 0; i < polygon.getNPoints(); ++i) {
                buffer.append(String.valueOf(x[i])).append(",").append(String.valueOf(y[i])).append(" ");
            }
            buffer.append("\" ").append(polygon.getAttribute().generateHtmlCode()).append("></area>\n");
            ++height;
        }
        buffer.append("</map>");
        ++height;
        return buffer.toString();
    }

    public static void generateImageMap(String imageName, List shapes) {
        int height = 0;
        StringBuffer buffer = new StringBuffer();
        buffer.append("<img src=\"").append(imageName).append("\" usemap=\"#Sample\" alt=\"\" style=\"border-style:none\" />").append("\n\n");
        height += 2;
        buffer.append("<map id=\"Sample\" name=\"Sample\">\n");
        ++height;
        for (Object o : shapes) {
            if (o instanceof Rectangle) {
                Rectangle rect = (Rectangle)o;
                buffer.append("<area shape=\"rect\" coords=\"");
                buffer.append(rect.getX()).append(",").append(rect.getY()).append(",").append(rect.getX() + rect.getWidth()).append(",");
                buffer.append(rect.getY() + rect.getHeight()).append("\" ").append(rect.getAttribute().generateHtmlCode()).append("/>\n");
                continue;
            }
            if (o instanceof Circle) {
                Circle circle = (Circle)o;
                buffer.append("<area shape=\"circle\" coords=\"");
                buffer.append(circle.getCenter().x).append(",").append(circle.getCenter().y).append(",").append(circle.getRadius());
                buffer.append("\" ").append(circle.getAttribute().generateHtmlCode()).append("/>\n");
                continue;
            }
            if (!(o instanceof Polygon)) continue;
            Polygon polygon = (Polygon)o;
            buffer.append("<area shape=\"poly\" coords=\"");
            int[] x = polygon.getXPoints();
            int[] y = polygon.getYPoints();
            for (int i = 0; i < polygon.getNPoints(); ++i) {
                buffer.append(String.valueOf(x[i])).append(",").append(String.valueOf(y[i])).append(" ");
            }
            buffer.append("\" ").append(polygon.getAttribute().generateHtmlCode()).append("/>\n");
            ++height;
        }
        buffer.append("</map>");
        JFrame frame = new JFrame();
        JTextArea text = new JTextArea(buffer.toString(), ++height, 50);
        text.setEditable(false);
        frame.getContentPane().add((Component)text, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    public static String generateXml(String imageName, List shapes) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File from, File to) {
        if (from.equals(to)) {
            return true;
        }
        FileInputStream fileIn = null;
        BufferedInputStream in = null;
        FileOutputStream fileOut = null;
        FilterOutputStream out = null;
        try {
            fileIn = new FileInputStream(from);
            in = new BufferedInputStream(fileIn);
            fileOut = new FileOutputStream(to);
            out = new BufferedOutputStream(fileOut);
            int len = 0;
            byte[] rd = new byte[4096];
            while ((len = in.read(rd)) >= 0) {
                ((BufferedOutputStream)out).write(rd, 0, len);
            }
            in.close();
            ((BufferedOutputStream)out).flush();
        }
        catch (Exception e) {
            logger.error((Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return true;
    }
}

