/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cpmm.ArticlePoolCollection;
import com.kingdee.eas.cp.cpmm.ArticlePoolFactory;
import com.kingdee.eas.cp.cpmm.ArticlePoolInfo;
import com.kingdee.eas.cp.cpmm.ArticlePoolStateEnum;
import com.kingdee.eas.cp.cpmm.IArticlePool;
import com.kingdee.eas.cp.cpmm.IOutboundBill;
import com.kingdee.eas.cp.cpmm.OutboundBillEntryCollection;
import com.kingdee.eas.cp.cpmm.OutboundBillEntryInfo;
import com.kingdee.eas.cp.cpmm.OutboundBillFactory;
import com.kingdee.eas.cp.cpmm.OutboundBillInfo;
import com.kingdee.eas.cp.cpmm.WarehousingBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import java.util.Date;

public class ArticlePoolHelper {
    public static void addNew(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        IArticlePool iArticlePool = ArticlePoolFactory.getLocalInstance(ctx);
        CoreBaseCollection cbCol = ArticlePoolHelper.getArticlePoolCollection(ctx, billID);
        if (cbCol == null) {
            return;
        }
        iArticlePool.addnew(cbCol);
    }

    private static CoreBaseCollection getArticlePoolCollection(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        IOutboundBill iOutboundBill;
        OutboundBillInfo obInfo;
        ArticlePoolInfo info = null;
        CoreBaseCollection cbCol = new CoreBaseCollection();
        if (billID != null && (obInfo = (iOutboundBill = OutboundBillFactory.getLocalInstance(ctx)).getOutboundBillInfo((IObjectPK)new ObjectUuidPK(billID), ArticlePoolHelper.getOutboundBillselectors())) != null && obInfo.getEntry() != null) {
            OutboundBillEntryCollection obEntryCol = obInfo.getEntry();
            OutboundBillEntryInfo obEntryInfo = null;
            int size = obEntryCol.size();
            for (int i = 0; i < size; ++i) {
                info = new ArticlePoolInfo();
                info.setNumber(obInfo.getNumber());
                info.setAppDate(obInfo.getAppDate());
                info.setApplicant(obInfo.getApplicant());
                info.setOutboundBillId(obInfo.getId());
                obEntryInfo = obEntryCol.get(i);
                info.setAmount(obEntryInfo.getAmount());
                info.setReturnDate(obEntryInfo.getReturnDate());
                info.setMeasureUnit(obEntryInfo.getMeasureUnit());
                info.setMaterialsRecord(obEntryInfo.getMaterial());
                info.setItemDetail(obEntryInfo.getItemDetail());
                info.setState(ArticlePoolStateEnum.UNRETURN);
                cbCol.add((CoreBaseInfo)info);
            }
        }
        return cbCol;
    }

    private static SelectorItemCollection getOutboundBillselectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("appDate"));
        selectors.add(new SelectorItemInfo("outboundBillId"));
        selectors.add(new SelectorItemInfo("applicant.id"));
        selectors.add(new SelectorItemInfo("entry.id"));
        selectors.add(new SelectorItemInfo("entry.amount"));
        selectors.add(new SelectorItemInfo("entry.returnDate"));
        selectors.add(new SelectorItemInfo("entry.measureUnit.id"));
        selectors.add(new SelectorItemInfo("entry.material.id"));
        selectors.add(new SelectorItemInfo("entry.itemDetail.id"));
        return selectors;
    }

    public static void upDate(Context ctx, BOSUuid billID, String number, String sourceBillId) throws BOSException, EASBizException {
        String[] ids = sourceBillId.split(",");
        if (ids != null && ids.length > 0) {
            ArticlePoolInfo apInfo = null;
            IArticlePool iArticlePool = ArticlePoolFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = null;
            int len = ids.length;
            for (int i = 0; i < len; ++i) {
                pk = new ObjectUuidPK(ids[i]);
                apInfo = iArticlePool.getArticlePoolInfo((IObjectPK)pk);
                apInfo.setReturnBillId(billID);
                apInfo.setReturnNumber(number);
                iArticlePool.update((IObjectPK)pk, apInfo);
            }
        }
    }

    public static void upDate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WarehousingBillInfo wbInfo = (WarehousingBillInfo)model;
        String wbId = wbInfo.getId().toString();
        String number = wbInfo.getNumber();
        ArticlePoolInfo apInfo = null;
        ArticlePoolCollection col = null;
        IArticlePool iArticlePool = ArticlePoolFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("returnBillId", (Object)wbId, CompareType.EQUALS));
        view.setFilter(filter);
        col = iArticlePool.getArticlePoolCollection(view);
        if (col != null && col.size() > 0) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                apInfo = col.get(i);
                apInfo.setReturnNumber(number);
                iArticlePool.update((IObjectPK)new ObjectUuidPK(apInfo.getId().toString()), apInfo);
            }
        }
    }

    public static void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArticlePoolInfo apInfo = null;
        ArticlePoolCollection col = null;
        IArticlePool iArticlePool = ArticlePoolFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("returnBillId", (Object)pk.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        col = iArticlePool.getArticlePoolCollection(view);
        if (col != null && col.size() > 0) {
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                apInfo = col.get(i);
                apInfo.setReturnBillId(null);
                apInfo.setReturnNumber(null);
                iArticlePool.update((IObjectPK)new ObjectUuidPK(apInfo.getId().toString()), apInfo);
            }
        }
    }

    public static void upDate(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ArticlePoolInfo apInfo = null;
        ArticlePoolCollection col = null;
        IArticlePool iArticlePool = ArticlePoolFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("returnBillId", (Object)billID.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        col = iArticlePool.getArticlePoolCollection(view);
        if (col != null && col.size() > 0) {
            Date returnDate = null;
            Date factReturnDate = DateTimeUtils.truncateDate((Date)new Date());
            int dates = 0;
            int size = col.size();
            for (int i = 0; i < size; ++i) {
                apInfo = col.get(i);
                apInfo.setFactReturnDate(factReturnDate);
                apInfo.setState(ArticlePoolStateEnum.RETURN);
                returnDate = apInfo.getReturnDate();
                if (returnDate != null) {
                    if (factReturnDate.after(returnDate)) {
                        dates = (int)ArticlePoolHelper.getCompareDate(returnDate, factReturnDate);
                        apInfo.setOverDates(dates);
                    } else {
                        apInfo.setOverDates(0);
                    }
                } else {
                    apInfo.setOverDates(0);
                }
                iArticlePool.update((IObjectPK)new ObjectUuidPK(apInfo.getId().toString()), apInfo);
            }
        }
    }

    public static long getCompareDate(Date startDate, Date endDate) {
        long len = endDate.getTime() - startDate.getTime();
        long days = len / 86400000L;
        return days;
    }
}

