/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.cpmm.CPMMBillBaseInfo;
import com.kingdee.eas.cp.cpmm.CPMMBizException;
import com.kingdee.eas.cp.cpmm.MMBillStateEnum;
import com.kingdee.eas.cp.cpmm.app.AbstractCPMMBillBaseControllerBean;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class CPMMBillBaseControllerBean
extends AbstractCPMMBillBaseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cpmm.app.CPMMBillBaseControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        CPMMBillBaseInfo info = this.getCPMMBillBaseInfo(ctx, (IObjectPK)pk);
        info.setState(MMBillStateEnum.AUDITING);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        CPMMBillBaseInfo info = this.getCPMMBillBaseInfo(ctx, (IObjectPK)pk);
        info.setState(MMBillStateEnum.AUDITED);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        CPMMBillBaseInfo info = this.getCPMMBillBaseInfo(ctx, (IObjectPK)pk);
        info.setState(MMBillStateEnum.UNAUDITED);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setAbandoned(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        CPMMBillBaseInfo info = this.getCPMMBillBaseInfo(ctx, (IObjectPK)pk);
        info.setState(MMBillStateEnum.ABANDONED);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setFinished(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        CPMMBillBaseInfo info = this.getCPMMBillBaseInfo(ctx, (IObjectPK)pk);
        info.setState(MMBillStateEnum.FINISHED);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setTemporary(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        CPMMBillBaseInfo info = this.getCPMMBillBaseInfo(ctx, (IObjectPK)pk);
        info.setState(MMBillStateEnum.TEMPORARY);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ObjectBaseInfo objectBaseInfo = (ObjectBaseInfo)model;
        objectBaseInfo.setCU(this.getCU(ctx, objectBaseInfo));
        this._checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CPMMBillBaseInfo info = (CPMMBillBaseInfo)model;
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(new FilterItemInfo("number", null, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"", CompareType.NOTEQUALS));
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (cu != null) {
            filterItem = new FilterItemInfo("CU.id", (Object)cu.getId(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        if (super._exists(ctx, filter)) {
            String number = info.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected boolean _checkNumberBlank(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CPMMBillBaseInfo info = (CPMMBillBaseInfo)model;
        String number = info.getNumber();
        if (number == null || number.equals("")) {
            throw new CPMMBizException(CPMMBizException.NUMBER_NOT_NULL);
        }
        return true;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CPMMBillBaseInfo info = this.getCPMMBillBaseInfo(ctx, pk);
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)info, null)) {
            this.recycleNumberByOrg(ctx, (IObjectValue)info, "ControlUnit", info.getNumber());
        }
        super._delete(ctx, pk);
    }

    protected void recycleNumberByOrg(Context ctx, IObjectValue model, String orgType, String number) throws BOSException, EASBizException {
        if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty((String)number)) {
            String companyID = null;
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)orgType)) != null) {
                companyID = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((String)orgType)).getId().toString();
            } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            }
            if (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty(companyID) && iCodingRuleManager.isExist(model, companyID) && iCodingRuleManager.isUseIntermitNumber(model, companyID)) {
                iCodingRuleManager.recycleNumber(model, companyID, number);
            }
        }
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        return null;
    }
}

