/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cpmm.ChangeBillStateEnum;
import com.kingdee.eas.cp.cpmm.ChangeStateEnum;
import com.kingdee.eas.cp.cpmm.IInventoryBill;
import com.kingdee.eas.cp.cpmm.IInventoryChangeBill;
import com.kingdee.eas.cp.cpmm.InventoryBillFactory;
import com.kingdee.eas.cp.cpmm.InventoryChangeBillEntryCollection;
import com.kingdee.eas.cp.cpmm.InventoryChangeBillFactory;
import com.kingdee.eas.cp.cpmm.InventoryChangeBillInfo;
import com.kingdee.eas.cp.cpmm.app.AbstractInventoryChangeBillControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class InventoryChangeBillControllerBean
extends AbstractInventoryChangeBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cpmm.app.InventoryChangeBillControllerBean");
    private IInventoryChangeBill service = null;
    private IInventoryBill iibService;

    protected void _setAuditing(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        InventoryChangeBillInfo info = this.getInventoryChangeBillInfo(ctx, (IObjectPK)pk);
        info.setBillState(ChangeBillStateEnum.AUDITING);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setAudited(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        InventoryChangeBillInfo info = this.getInventoryChangeBillInfo(ctx, (IObjectPK)pk);
        info.setBillState(ChangeBillStateEnum.AUDITED);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setAuditEnd(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        InventoryChangeBillInfo info = this.getInventoryChangeBillInfo(ctx, (IObjectPK)pk);
        info.setBillState(ChangeBillStateEnum.UNAUDITED);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setAbandoned(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        InventoryChangeBillInfo info = this.getInventoryChangeBillInfo(ctx, (IObjectPK)pk);
        info.setBillState(ChangeBillStateEnum.ABANDONED);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setFinished(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        InventoryChangeBillInfo info = this.getInventoryChangeBillInfo(ctx, (IObjectPK)pk);
        info.setBillState(ChangeBillStateEnum.FINISHED);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _setTemporary(Context ctx, BOSUuid billID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        InventoryChangeBillInfo info = this.getInventoryChangeBillInfo(ctx, (IObjectPK)pk);
        info.setBillState(ChangeBillStateEnum.TEMPORARY);
        super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.isExistRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
            this._checkNumberBlank(ctx, model);
        }
        this.iibService = InventoryBillFactory.getLocalInstance(ctx);
        InventoryChangeBillInfo info = this.initNewModel(ctx, model);
        super._addnew(ctx, pk, (IObjectValue)info);
        String sID = info.getSourceBillId();
        if (sID != null && !sID.equals("")) {
            BOSUuid sourcebillID = BOSUuid.read((String)sID);
            this.writeBackSourceBill(sourcebillID);
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.isExistRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
            this._checkNumberBlank(ctx, model);
        }
        this.iibService = InventoryBillFactory.getLocalInstance(ctx);
        InventoryChangeBillInfo info = this.initNewModel(ctx, model);
        String sID = info.getSourceBillId();
        if (sID != null && !sID.equals("")) {
            BOSUuid sourcebillID = BOSUuid.read((String)sID);
            this.writeBackSourceBill(sourcebillID);
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    private InventoryChangeBillInfo initNewModel(Context ctx, IObjectValue model) {
        InventoryChangeBillInfo info = (InventoryChangeBillInfo)model;
        if (info.getCreator() == null) {
            info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        if (info.getCreateTime() == null) {
            info.setCreateTime(new Timestamp(DateTimeUtils.truncateDate((Date)new Date()).getTime()));
        }
        if (info.getState() == null) {
            info.setBillState(ChangeBillStateEnum.TEMPORARY);
        }
        return info;
    }

    private void writeBackSourceBill(BOSUuid sourcebillID) {
        try {
            this.iibService.setIsChange(sourcebillID);
        }
        catch (BOSException e) {
            logger.error((Object)"writeBack inventoryBill error!", (Throwable)e);
        }
    }

    protected void _setChanged(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InventoryChangeBillInfo info = (InventoryChangeBillInfo)model;
        info.setBillState(ChangeBillStateEnum.CHANGED);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _setChanging(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InventoryChangeBillInfo info = (InventoryChangeBillInfo)model;
        info.setBillState(ChangeBillStateEnum.CHANGING);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _setChangeState(Context ctx, BOSUuid billID, String changeBillType, int changeState) throws BOSException {
        this.service = InventoryChangeBillFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        boolean allChanged = false;
        boolean allFinished = false;
        if (changeState == 8) {
            allChanged = true;
        }
        if (changeState == 5) {
            allChanged = true;
            allFinished = true;
        }
        try {
            InventoryChangeBillInfo info = this.service.getInventoryChangeBillInfo((IObjectPK)pk, this.getSelector());
            InventoryChangeBillEntryCollection entries = info.getEntrys();
            if (changeBillType.equals("WAREHOUSINGBILL")) {
                for (int i = 0; i < entries.size(); ++i) {
                    ChangeStateEnum entryState = entries.get(i).getChangeState();
                    if (entries.get(i).getBreakEven() > 0) {
                        entries.get(i).setChangeState(ChangeStateEnum.getEnum(changeState));
                    }
                    if (entries.get(i).getBreakEven() >= 0) continue;
                    if (entryState.equals((Object)ChangeStateEnum.UNCHANGE) || entryState.equals((Object)ChangeStateEnum.CHANGING)) {
                        allChanged = false;
                    }
                    if (entryState.equals((Object)ChangeStateEnum.FINISHED)) continue;
                    allFinished = false;
                }
            } else {
                for (int i = 0; i < entries.size(); ++i) {
                    ChangeStateEnum entryState = entries.get(i).getChangeState();
                    if (entries.get(i).getBreakEven() < 0) {
                        entries.get(i).setChangeState(ChangeStateEnum.getEnum(changeState));
                    }
                    if (entries.get(i).getBreakEven() <= 0) continue;
                    if (entryState.equals((Object)ChangeStateEnum.UNCHANGE) || entryState.equals((Object)ChangeStateEnum.CHANGING)) {
                        allChanged = false;
                    }
                    if (entryState.equals((Object)ChangeStateEnum.FINISHED)) continue;
                    allFinished = false;
                }
            }
            if (allFinished) {
                info.setBillState(ChangeBillStateEnum.FINISHED);
                super._update(ctx, (IObjectPK)pk, (IObjectValue)info);
            } else if (allChanged) {
                this._setChanged(ctx, (IObjectPK)pk, (IObjectValue)info);
            } else {
                this._setChanging(ctx, (IObjectPK)pk, (IObjectValue)info);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"setChangeState error!", (Throwable)e);
        }
    }

    protected void _setFinishedState(Context ctx, BOSUuid billID) throws BOSException {
        this.service = InventoryChangeBillFactory.getLocalInstance(ctx);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("operator.*"));
        sic.add(new SelectorItemInfo("warehouse.*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.material.*"));
        return sic;
    }

    protected void setNumberFromCodingRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InventoryChangeBillInfo changeInfo = (InventoryChangeBillInfo)model;
        if (changeInfo.getNumber() == null || "".equals(changeInfo.getNumber())) {
            String orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            String number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)changeInfo, orgId);
            if (number != null) {
                changeInfo.setNumber(number);
            }
        }
    }

    protected boolean isExistRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean flag = false;
        String orgId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        InventoryChangeBillInfo changeInfo = (InventoryChangeBillInfo)model;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)changeInfo, orgId)) {
            flag = true;
        }
        return flag;
    }
}

