/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cpmm.CPMMBizException;
import com.kingdee.eas.cp.cpmm.IOutboundBillEntry;
import com.kingdee.eas.cp.cpmm.IWarehousingBillEntry;
import com.kingdee.eas.cp.cpmm.MaterialsRecordCollection;
import com.kingdee.eas.cp.cpmm.MaterialsRecordFactory;
import com.kingdee.eas.cp.cpmm.MaterialsRecordInfo;
import com.kingdee.eas.cp.cpmm.OutboundBillEntryFactory;
import com.kingdee.eas.cp.cpmm.WarehousingBillEntryFactory;
import com.kingdee.eas.cp.cpmm.app.AbstractMaterialsRecordControllerBean;
import com.kingdee.eas.cp.cpmm.app.MaterialStateEnum;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class MaterialsRecordControllerBean
extends AbstractMaterialsRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.cpmm.app.MaterialsRecordControllerBean");
    IWarehousingBillEntry wService = null;
    IOutboundBillEntry oService = null;

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (this.isExistRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
        }
        this._checkNumberDup(ctx, model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (this.isExistRule(ctx, model)) {
            this.setNumberFromCodingRule(ctx, model);
        }
        this._checkNumberDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (((MaterialsRecordInfo)model).getNumber() != null && !((MaterialsRecordInfo)model).getNumber().equals("")) {
            this._checkNumberDup(ctx, model);
        }
        return super._save(ctx, model);
    }

    protected void _setDisabled(Context ctx, BOSUuid pk) throws BOSException {
        ObjectUuidPK mpk = new ObjectUuidPK(pk);
        try {
            MaterialsRecordInfo info = MaterialsRecordFactory.getLocalInstance(ctx).getMaterialsRecordInfo((IObjectPK)mpk);
            info.setState(MaterialStateEnum.disabled);
            MaterialsRecordFactory.getLocalInstance(ctx).update((IObjectPK)mpk, info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected void _setEnable(Context ctx, BOSUuid pk) throws BOSException {
        ObjectUuidPK mpk = new ObjectUuidPK(pk);
        try {
            MaterialsRecordInfo info = MaterialsRecordFactory.getLocalInstance(ctx).getMaterialsRecordInfo((IObjectPK)mpk);
            info.setState(MaterialStateEnum.enable);
            MaterialsRecordFactory.getLocalInstance(ctx).update((IObjectPK)mpk, info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected void _setVisible(Context ctx, BOSUuid pk, boolean isVisible) throws BOSException {
        ObjectUuidPK mpk = new ObjectUuidPK(pk);
        try {
            MaterialsRecordInfo info = MaterialsRecordFactory.getLocalInstance(ctx).getMaterialsRecordInfo((IObjectPK)mpk);
            info.setIsVisible(isVisible);
            MaterialsRecordFactory.getLocalInstance(ctx).update((IObjectPK)mpk, info);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    private void checkDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.wService = WarehousingBillEntryFactory.getLocalInstance(ctx);
        this.oService = OutboundBillEntryFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("materialsRecord.id", (Object)pk.toString(), CompareType.EQUALS));
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("material.id", (Object)pk.toString(), CompareType.EQUALS));
        if (this.wService.exists(filter) || this.oService.exists(filter2)) {
            throw new CPMMBizException(CPMMBizException.MATERIAL_DEL_ERROR);
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialsRecordInfo info = (MaterialsRecordInfo)model;
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        FilterInfo filter = new FilterInfo();
        String number = info.getNumber().toString();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)number, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (cu != null) {
            filterItem = new FilterItemInfo("CU.id", (Object)cu.getId(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view1 = new EntityViewInfo();
        view1.setFilter(filter);
        MaterialsRecordCollection col = this.getMaterialsRecordCollection(ctx, view1.toString());
        if (col != null && col.size() > 0) {
            number = this._getPropertyAlias(ctx, info, "number") + info.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void setNumberFromCodingRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MaterialsRecordInfo materialsInfo = (MaterialsRecordInfo)model;
        if (materialsInfo.getNumber() == null || "".equals(materialsInfo.getNumber())) {
            CodingRuleInfo codingRuleInfo;
            String companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String number = iCodingRuleManager.getNumber((IObjectValue)materialsInfo, codingRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)materialsInfo, companyID, "modelType"));
            if (number != null) {
                materialsInfo.setNumber(number);
            }
        }
    }

    protected boolean isExistRule(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean flag = false;
        MaterialsRecordInfo materialsInfo = (MaterialsRecordInfo)model;
        String companyID = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist((IObjectValue)materialsInfo, companyID, "modelType")) {
            flag = true;
        }
        return flag;
    }
}

