/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.cpmm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.cpmm.MaterialsTypeInfo;
import com.kingdee.eas.cp.cpmm.app.AbstractMaterialsTypeControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;

public class MaterialsTypeControllerBean
extends AbstractMaterialsTypeControllerBean {
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.updateParent(ctx, model);
        super._update(ctx, pk, model);
    }

    private void updateParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo oldParent = this.getOldParent(ctx, model);
        TreeBaseInfo newParent = this.getNewParent(ctx, model);
        if (!oldParent.getId().toString().equals(newParent.getId().toString())) {
            if (this.isNeedUpdateParent(ctx, model, (IObjectValue)oldParent)) {
                oldParent.setIsLeaf(true);
                this.executeUpdateParent(ctx, (IObjectPK)new ObjectUuidPK(oldParent.getId()), (IObjectValue)oldParent);
            }
            if (newParent != null && newParent.isIsLeaf()) {
                newParent.setIsLeaf(false);
                this.executeUpdateParent(ctx, (IObjectPK)new ObjectUuidPK(newParent.getId()), (IObjectValue)newParent);
            }
        }
    }

    private void executeUpdateParent(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._canUpdate(ctx, pk);
        this.innerUpdate(ctx, pk, model);
    }

    private TreeBaseInfo getOldParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        MaterialsTypeInfo OMTypeInfo = (MaterialsTypeInfo)this.getParentInfo(ctx, (IObjectValue)treeBaseInfo);
        MaterialsTypeInfo parent = OMTypeInfo.getParent();
        parent = this.getParentInfo(ctx, (IObjectValue)parent);
        return parent;
    }

    private boolean isNeedUpdateParent(Context ctx, IObjectValue model, IObjectValue parent) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)((MaterialsTypeInfo)model).getId().toString(), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)((MaterialsTypeInfo)parent).getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        CoreBaseCollection col = this.getCoreBaseCollection(ctx, view);
        return col != null && col.size() == 0;
    }

    private TreeBaseInfo getNewParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        TreeBaseInfo parent = treeBaseInfo.innerGetParent();
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            return null;
        }
        parent = this.getParentInfo(ctx, (IObjectValue)parent);
        treeBaseInfo.innerSetParent(parent);
        return parent;
    }

    private TreeBaseInfo getParentInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        TreeBaseInfo result = (TreeBaseInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()), selector);
        return result;
    }
}

